/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mod;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.ModConfigPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HDConfig
extends ModConfigPanel {
    private static final String TAG_FONT = "hdFont";
    private static final String TAG_ANIMATIONS = "animations";
    private static final String TAG_COMPASS = "fancyCompass";
    private static final String TAG_CLOCK = "fancyClock";
    private static final String TAG_MIPMAP = "mipmap";
    private static final String TAG_MAX_MIPMAP_LEVEL = "maxMipmapLevel";
    private static final String TAG_LOD_BIAS = "lodBias";
    private static final String TAG_ANISOTROPIC_FILTERING = "anisotropicFiltering";
    private static final String TAG_ANTI_ALIASING = "antiAliasing";
    private static final String TAG_GL13 = "useGL13";
    private static final String TAG_SCRATCH_TEXTURE = "useScratchTexture";
    private static final String TAG_DEBUG_BORDER = "debugBorder";
    private JPanel panel;
    private JCheckBox fontCheckBox;
    private JCheckBox animationCheckBox;
    private JCheckBox compassCheckBox;
    private JCheckBox clockCheckBox;
    private JCheckBox mipmapCheckBox;
    private JSpinner mipmapLevelSpinner;
    private JSpinner lodBiasSpinner;
    private JSpinner anisoSpinner;
    private JSpinner aaSpinner;
    private JCheckBox gl13CheckBox;
    private JCheckBox scratchTextureCheckBox;
    private JCheckBox debugBorderCheckBox;

    HDConfig() {
        this.$$$setupUI$$$();
        this.fontCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.set("Extended HD", HDConfig.TAG_FONT, HDConfig.this.fontCheckBox.isSelected());
            }
        });
        this.animationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.set("Extended HD", HDConfig.TAG_ANIMATIONS, HDConfig.this.animationCheckBox.isSelected());
            }
        });
        this.compassCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.set("Extended HD", HDConfig.TAG_COMPASS, HDConfig.this.compassCheckBox.isSelected());
            }
        });
        this.clockCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.set("Extended HD", HDConfig.TAG_CLOCK, HDConfig.this.clockCheckBox.isSelected());
            }
        });
        this.mipmapCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.set("Extended HD", HDConfig.TAG_MIPMAP, HDConfig.this.mipmapCheckBox.isSelected());
            }
        });
        this.gl13CheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.set("Extended HD", HDConfig.TAG_GL13, HDConfig.this.gl13CheckBox.isSelected());
            }
        });
        this.scratchTextureCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.set("Extended HD", HDConfig.TAG_SCRATCH_TEXTURE, HDConfig.this.scratchTextureCheckBox.isSelected());
            }
        });
        this.debugBorderCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.set("Extended HD", HDConfig.TAG_DEBUG_BORDER, HDConfig.this.debugBorderCheckBox.isSelected());
            }
        });
        this.mipmapLevelSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = 4;
                try {
                    value = Integer.parseInt(HDConfig.this.mipmapLevelSpinner.getValue().toString());
                    value = Math.min(Math.max(0, value), 9);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Config.set("Extended HD", HDConfig.TAG_MAX_MIPMAP_LEVEL, value);
                HDConfig.this.mipmapLevelSpinner.setValue(value);
            }
        });
        this.lodBiasSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = 0;
                try {
                    value = Integer.parseInt(HDConfig.this.lodBiasSpinner.getValue().toString());
                    value = Math.min(Math.max(-9, value), 9);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Config.set("Extended HD", HDConfig.TAG_LOD_BIAS, value);
                HDConfig.this.lodBiasSpinner.setValue(value);
            }
        });
        this.anisoSpinner.addChangeListener(new ChangeListener(){
            private int lastValue = Config.getInt("Extended HD", "anisotropicFiltering", 1);

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = 1;
                try {
                    value = Integer.parseInt(HDConfig.this.anisoSpinner.getValue().toString());
                    if (value > this.lastValue) {
                        value = this.lastValue * 2;
                    } else if (value < this.lastValue) {
                        value = this.lastValue / 2;
                    }
                    value = value <= 1 ? 1 : (value <= 2 ? 2 : (value <= 4 ? 4 : (value <= 8 ? 8 : 16)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Config.set("Extended HD", HDConfig.TAG_ANISOTROPIC_FILTERING, value);
                HDConfig.this.anisoSpinner.setValue(value);
                this.lastValue = value;
            }
        });
        this.aaSpinner.addChangeListener(new ChangeListener(){
            private int lastValue = Config.getInt("Extended HD", "antiAliasing", 0);

            @Override
            public void stateChanged(ChangeEvent e) {
                int value = 0;
                try {
                    value = Integer.parseInt(HDConfig.this.aaSpinner.getValue().toString());
                    if (value > this.lastValue) {
                        value = this.lastValue + 2 & 0xFFFFFFFE;
                    } else if (value < this.lastValue) {
                        value = Math.max(this.lastValue - 2, 0) & 0xFFFFFFFE;
                    }
                    value = Math.min(Math.max(0, value), 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Config.set("Extended HD", HDConfig.TAG_ANTI_ALIASING, value);
                HDConfig.this.aaSpinner.setValue(value);
                this.lastValue = value;
            }
        });
    }

    @Override
    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void load() {
        this.fontCheckBox.setSelected(Config.getBoolean("Extended HD", TAG_FONT, true));
        this.animationCheckBox.setSelected(Config.getBoolean("Extended HD", TAG_ANIMATIONS, true));
        this.compassCheckBox.setSelected(Config.getBoolean("Extended HD", TAG_COMPASS, true));
        this.clockCheckBox.setSelected(Config.getBoolean("Extended HD", TAG_CLOCK, true));
        this.mipmapCheckBox.setSelected(Config.getBoolean("Extended HD", TAG_MIPMAP, false));
        this.mipmapLevelSpinner.setValue(Config.getInt("Extended HD", TAG_MAX_MIPMAP_LEVEL, 3));
        this.lodBiasSpinner.setValue(Config.getInt("Extended HD", TAG_LOD_BIAS, 0));
        this.anisoSpinner.setValue(Config.getInt("Extended HD", TAG_ANISOTROPIC_FILTERING, 1));
        this.aaSpinner.setValue(Config.getInt("Extended HD", TAG_ANTI_ALIASING, 0));
        this.gl13CheckBox.setSelected(Config.getBoolean("Extended HD", TAG_GL13, true));
        this.scratchTextureCheckBox.setSelected(Config.getBoolean("Extended HD", TAG_SCRATCH_TEXTURE, true));
        this.debugBorderCheckBox.setSelected(Config.getBoolean("Extended HD", TAG_DEBUG_BORDER, false));
        this.showAdvancedOption(this.gl13CheckBox);
        this.showAdvancedOption(this.scratchTextureCheckBox);
        this.showAdvancedOption(this.debugBorderCheckBox);
    }

    @Override
    public void save() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JSpinner jSpinner;
        JSpinner jSpinner2;
        JSpinner jSpinner3;
        JSpinner jSpinner4;
        JCheckBox jCheckBox8;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(5, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(4, 0, 1, 3, 0, 3, 3, 3, null, null, null, 0, true));
        this.mipmapCheckBox = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Enable mipmaps");
        jPanel2.add((Component)jCheckBox8, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.mipmapLevelSpinner = jSpinner4 = new JSpinner();
        jPanel2.add((Component)jSpinner4, new GridConstraints(0, 3, 1, 1, 8, 1, 1, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Max level:");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Level-of-detail bias");
        jPanel2.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.lodBiasSpinner = jSpinner3 = new JSpinner();
        jPanel2.add((Component)jSpinner3, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Anisotropic filtering");
        ((Component)jLabel3).setVisible(true);
        jPanel2.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.anisoSpinner = jSpinner2 = new JSpinner();
        ((Component)jSpinner2).setVisible(true);
        jPanel2.add((Component)jSpinner2, new GridConstraints(2, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Anti-aliasing");
        ((Component)jLabel4).setVisible(true);
        jPanel2.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.aaSpinner = jSpinner = new JSpinner();
        ((Component)jSpinner).setVisible(true);
        jPanel2.add((Component)jSpinner, new GridConstraints(3, 3, 1, 1, 8, 1, 6, 0, null, null, null));
        this.animationCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Enable custom animations for other textures");
        jPanel.add((Component)jCheckBox7, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.compassCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Enable custom compass texture");
        jPanel.add((Component)jCheckBox6, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.clockCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Enable custom clock texture");
        jPanel.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.gl13CheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Use OpenGL 1.3 if available");
        jPanel3.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.scratchTextureCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Use scratch texture to render compass/clock");
        jPanel3.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.debugBorderCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Visible AA border");
        jPanel3.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.fontCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable HD fonts");
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

