/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mod;

import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;

public class GLSLShader
extends Mod {
    public GLSLShader() {
        this.name = "GLSL Shaders";
        this.author = "daxnitro";
        this.description = "Adds graphical shaders to the game.  Based on daxnitro's mod.";
        this.version = "2.1";
        this.website = "http://daxnitro.wikia.com/wiki/Shaders_2.0";
        this.defaultEnabled = false;
        this.addClassMod(new MinecraftMod());
        this.addClassMod(new GLAllocationMod());
        this.addClassMod(new RenderEngineMod());
        this.addClassMod(new RenderGlobalMod());
        this.addClassMod(new RenderLivingMod());
        this.addClassMod(new EntityRendererMod());
        this.addClassMod(new EntityLivingMod());
        this.addClassMod(new BlockMod());
        this.addClassMod(new BaseMod.IconMod(this));
        this.addClassMod(new GameSettingsMod());
        this.addClassMod(new TessellatorMod());
        this.addClassMod(new RenderBlocksMod());
        this.addClassMod(new EntityPlayerMod());
        this.addClassMod(new EntityPlayerSPMod());
        this.addClassMod(new EntityClientPlayerMPMod());
        this.addClassMod(new InventoryPlayerMod());
        this.addClassMod(new ItemStackMod());
        this.addClassMod(new WorldMod());
        this.addClassMod(new BaseMod.WorldClientMod(this));
        this.addClassMod(new WorldRendererMod());
        this.addClassFile("com.prupe.mcpatcher.glsl.Shaders");
    }

    private class WorldRendererMod
    extends Mod.ClassMod {
        WorldRendererMod() {
            super(GLSLShader.this);
            MethodRef updateRenderer = new MethodRef(this.getDeobfClass(), "updateRenderer", "()V");
            this.addClassSignature(new ClassMod.ConstSignature(this, new MethodRef("org.lwjgl.opengl.GL11", "glNewList", "(II)V")));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(1.000001f)));
                }
            }.setMethod(updateRenderer));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "worldObj", "LWorld;")));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "call Tessellator.setEntity";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyILOAD, BytecodeMatcher.anyALOAD, BinaryRegex.capture(BytecodeMatcher.anyALOAD), BytecodeMatcher.anyILOAD, BytecodeMatcher.anyILOAD, BytecodeMatcher.anyILOAD, this.reference(182, new MethodRef("RenderBlocks", "renderBlockByRenderType", "(LBlock;III)Z")), 128, BytecodeMatcher.anyISTORE);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, new FieldRef("Tessellator", "instance", "LTessellator;")), this.getCaptureGroup(1), this.reference(180, new FieldRef("Block", "blockID", "I")), this.reference(182, new MethodRef("Tessellator", "setEntity", "(I)V")));
                }
            }.setInsertBefore(true).targetMethod(updateRenderer));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "clear Tessellator.setEntity";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177, BinaryRegex.end());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, new FieldRef("Tessellator", "instance", "LTessellator;")), 2, this.reference(182, new MethodRef("Tessellator", "setEntity", "(I)V")));
                }
            }.setInsertBefore(true).targetMethod(updateRenderer));
        }
    }

    private class WorldMod
    extends BaseMod.WorldMod {
        WorldMod() {
            super(GLSLShader.this);
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(12, BytecodeMatcher.anyFLOAD, this.push(Float.valueOf((float)Math.PI)), 106, 13, 106, BytecodeMatcher.anyReference(184), 13, 106, BinaryRegex.or(BinaryRegex.build(this.push(Float.valueOf(0.75f))), BinaryRegex.build(this.push(Float.valueOf(0.25f)))), 98, 102);
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "getStarBrightness", "(F)F")));
            this.addClassSignature(new ClassMod.FixedBytecodeSignature(this, BinaryRegex.begin(), 42, 27, 28, 29, 4, BytecodeMatcher.anyReference(182), 172, BinaryRegex.end()).setMethod(new MethodRef(this.getDeobfClass(), "getBlockLightValue", "(III)I")));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(43, 43, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(181), 43, 43, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(181), 43, 43, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(181));
                }
            }.addXref(1, new FieldRef("Entity", "posX", "D")).addXref(2, new FieldRef("Entity", "lastTickPosX", "D")).addXref(3, new FieldRef("Entity", "posY", "D")).addXref(4, new FieldRef("Entity", "lastTickPosY", "D")).addXref(5, new FieldRef("Entity", "posZ", "D")).addXref(6, new FieldRef("Entity", "lastTickPosZ", "D")));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 35, BytecodeMatcher.captureReference(182), 69, 36, this.push(Float.valueOf((float)Math.PI)), 106, this.push(Float.valueOf(2.0f)), 106, 174, BinaryRegex.end());
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "getCelestialAngleRadians", "(F)F")).addXref(1, new MethodRef(this.getDeobfClass(), "getCelestialAngle", "(F)F")));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getSeed", "()J"), new MethodRef(this.getDeobfClass(), "getWorldTime", "()J")));
        }
    }

    private class ItemStackMod
    extends Mod.ClassMod {
        ItemStackMod() {
            super(GLSLShader.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "id"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Count"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Damage"));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "stackSize", "I"), new FieldRef(this.getDeobfClass(), "animationsToGo", "I"), new FieldRef(this.getDeobfClass(), "itemID", "I")).accessFlag(1, true));
        }
    }

    private class InventoryPlayerMod
    extends Mod.ClassMod {
        InventoryPlayerMod() {
            super(GLSLShader.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "container.inventory"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Slot"));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getCurrentItem", "()LItemStack;")));
        }
    }

    private class EntityClientPlayerMPMod
    extends Mod.ClassMod {
        EntityClientPlayerMPMod() {
            super(GLSLShader.this);
            this.setParentClass("EntityPlayerSP");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(-999.0), this.push(-999.0));
                }
            });
        }
    }

    private class EntityPlayerSPMod
    extends Mod.ClassMod {
        EntityPlayerSPMod() {
            super(GLSLShader.this);
            this.setParentClass("EntityPlayer");
            this.addClassSignature(new ClassMod.OrSignature(this, new ClassMod.ConstSignature(this, "http://s3.amazonaws.com/MinecraftSkins/"), new ClassMod.ConstSignature(this, "http://skins.minecraft.net/MinecraftSkins/")));
            this.addClassSignature(new ClassMod.ConstSignature(this, "portal.trigger"));
        }
    }

    private class EntityPlayerMod
    extends Mod.ClassMod {
        EntityPlayerMod() {
            super(GLSLShader.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "humanoid"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "/mob/char.png"));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "inventory", "LInventoryPlayer;")));
        }
    }

    private class RenderBlocksMod
    extends BaseMod.RenderBlocksMod {
        private final MethodRef[] faceMethods;

        RenderBlocksMod() {
            super(GLSLShader.this);
            this.faceMethods = new MethodRef[6];
            this.setupBlockFace(0, "Bottom", 0, -1, 0);
            this.setupBlockFace(1, "Top", 0, 1, 0);
            this.setupBlockFace(2, "North", 0, 0, -1);
            this.setupBlockFace(3, "South", 0, 0, 1);
            this.setupBlockFace(4, "West", -1, 0, 0);
            this.setupBlockFace(5, "East", 1, 0, 0);
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, this.faceMethods));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "renderBlockByRenderType", "(LBlock;III)Z")));
        }

        private void setupBlockFace(int face, final String direction, final int x, final int y, final int z) {
            this.faceMethods[face] = new MethodRef(this.getDeobfClass(), "render" + direction + "Face", "(LBlock;DDDLIcon;)V");
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "set normal when rendering block " + direction.toLowerCase() + " face";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.reference(178, new FieldRef("Tessellator", "instance", "LTessellator;")), 58, BinaryRegex.capture(BinaryRegex.any()));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(25, this.getCaptureGroup(1), this.push(Float.valueOf(x)), this.push(Float.valueOf(y)), this.push(Float.valueOf(z)), this.reference(182, new MethodRef("Tessellator", "setNormal", "(FFF)V")));
                }
            }.setInsertAfter(true).targetMethod(this.faceMethods[face]));
        }
    }

    private class TessellatorMod
    extends Mod.ClassMod {
        TessellatorMod() {
            super(GLSLShader.this);
            MethodRef reset = new MethodRef(this.getDeobfClass(), "reset", "()V");
            MethodRef draw = new MethodRef(this.getDeobfClass(), "draw", "()I");
            MethodRef addVertex = new MethodRef(this.getDeobfClass(), "addVertex", "(DDD)V");
            final FieldRef drawMode = new FieldRef(this.getDeobfClass(), "drawMode", "I");
            final FieldRef addedVertices = new FieldRef(this.getDeobfClass(), "addedVertices", "I");
            final FieldRef convertQuadsToTriangles = new FieldRef(this.getDeobfClass(), "convertQuadsToTriangles", "Z");
            final FieldRef hasNormals = new FieldRef(this.getDeobfClass(), "hasNormals", "Z");
            final FieldRef rawBuffer = new FieldRef(this.getDeobfClass(), "rawBuffer", "[I");
            final FieldRef rawBufferIndex = new FieldRef(this.getDeobfClass(), "rawBufferIndex", "I");
            final FieldRef shadersBuffer = new FieldRef(this.getDeobfClass(), "shadersBuffer", "Ljava/nio/ByteBuffer;");
            final FieldRef shadersShortBuffer = new FieldRef(this.getDeobfClass(), "shadersShortBuffer", "Ljava/nio/ShortBuffer;");
            final FieldRef shadersData = new FieldRef(this.getDeobfClass(), "shadersData", "[S");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push("Not tesselating!"));
                }
            }.setMethod(draw));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, new MethodRef("java/nio/ByteBuffer", "clear", "()Ljava/nio/Buffer;"))});
                }
            }.setMethod(reset));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 4, BytecodeMatcher.captureReference(181), 35, this.push(Float.valueOf(127.0f)), 106, 139, 145, BytecodeMatcher.anyISTORE, 36, this.push(Float.valueOf(127.0f)), 106, 139, 145, BytecodeMatcher.anyISTORE, 37, this.push(Float.valueOf(127.0f)), 106, 139, 145, BytecodeMatcher.anyISTORE, 42, BinaryRegex.any(0, 30), BytecodeMatcher.captureReference(181));
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "setNormal", "(FFF)V")).addXref(1, hasNormals).addXref(2, new FieldRef(this.getDeobfClass(), "normal", "I")));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 89, BytecodeMatcher.captureReference(180), 4, 96, BytecodeMatcher.anyReference(181), 42, BytecodeMatcher.captureReference(180), this.push(7), 160, BinaryRegex.any(2));
                }
            }.setMethod(addVertex).addXref(1, addedVertices).addXref(2, drawMode));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), 3, 42, BytecodeMatcher.captureReference(180), this.reference(182, new MethodRef("java/nio/IntBuffer", "put", "([III)Ljava/nio/IntBuffer;")));
                }
            }.addXref(1, rawBuffer).addXref(2, rawBufferIndex));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.anyReference(180), this.push(7), 160, BinaryRegex.any(2), BytecodeMatcher.captureReference(178), 153, BinaryRegex.any(2));
                }
            }.addXref(1, convertQuadsToTriangles));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "instance", "LTessellator;")).accessFlag(8, true));
            this.addPatch(new ClassMod.AddFieldPatch((ClassMod)this, new FieldRef(this.getDeobfClass(), "shadersBuffer", "Ljava.nio.ByteBuffer;")));
            this.addPatch(new ClassMod.AddFieldPatch((ClassMod)this, new FieldRef(this.getDeobfClass(), "shadersShortBuffer", "Ljava.nio.ShortBuffer;")));
            this.addPatch(new ClassMod.AddFieldPatch((ClassMod)this, shadersData));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "initialize shadersData";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 5, 188, 9, 89, 3, 2, 86, this.reference(181, shadersData), 42, this.getMethodInfo().getDescriptor().startsWith("(I") ? this.buildCode(27, this.push(8), 108, 7, 104) : this.buildCode(this.push(0x100000)), this.reference(184, new MethodRef("GLAllocation", "createDirectByteBuffer", "(I)Ljava/nio/ByteBuffer;")), this.reference(181, shadersBuffer), 42, 42, this.reference(180, shadersBuffer), this.reference(182, new MethodRef("java/nio/ByteBuffer", "asShortBuffer", "()Ljava/nio/ShortBuffer;")), this.reference(181, shadersShortBuffer));
                }
            }.setInsertBefore(true).matchConstructorOnly(true));
            this.addPatch(new ClassMod.AddMethodPatch(new MethodRef(this.getDeobfClass(), "setEntity", "(I)V")){

                @Override
                public byte[] generateMethod() {
                    return this.buildCode(this.reference(178, new FieldRef("com.prupe.mcpatcher.glsl.Shaders", "entityAttrib", "I")), 155, TessellatorMod.this.branch("A"), 42, this.reference(180, shadersData), 3, 27, 147, 86, TessellatorMod.this.label("A"), 177);
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "clear shadersBuffer";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, shadersBuffer), this.reference(182, new MethodRef("java/nio/ByteBuffer", "clear", "()Ljava/nio/Buffer;")), 87);
                }
            }.targetMethod(reset));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "wrap glDrawArrays";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glDrawArrays", "(III)V"))});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, shadersShortBuffer), this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "glDrawArraysWrapper", "(IIILjava/nio/ShortBuffer;)V")));
                }
            }.targetMethod(draw));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "call Shaders.addVertex";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, drawMode), this.push(7), 160, this.branch("A"), this.reference(178, convertQuadsToTriangles), 153, this.branch("A"), 42, this.reference(180, addedVertices), 4, 96, 7, 112, 154, this.branch("A"), 42, this.reference(180, hasNormals), 153, this.branch("A"), this.getRawBufferCode(6, -18), this.getShaderBufferCode(), this.getRawBufferCode(14, -2), this.getShaderBufferCode(), this.label("A"), this.getShaderBufferCode());
                }

                private byte[] getRawBufferCode(int offset1, int offset2) {
                    return this.buildCode(42, this.reference(180, rawBuffer), 42, this.reference(180, rawBufferIndex), this.push(offset1), 96, 42, this.reference(180, rawBuffer), 42, this.reference(180, rawBufferIndex), this.push(offset2), 96, 46, 79);
                }

                private byte[] getShaderBufferCode() {
                    return this.buildCode(42, this.reference(180, shadersBuffer), 42, this.reference(180, shadersData), 3, 53, this.reference(182, new MethodRef("java/nio/ByteBuffer", "putShort", "(S)Ljava/nio/ByteBuffer;")), 42, this.reference(180, shadersData), 4, 53, this.reference(182, new MethodRef("java/nio/ByteBuffer", "putShort", "(S)Ljava/nio/ByteBuffer;")), 87);
                }
            }.targetMethod(addVertex));
        }
    }

    private class GameSettingsMod
    extends BaseMod.GameSettingsMod {
        GameSettingsMod() {
            super(GLSLShader.this);
            this.mapOption("viewDistance", "renderDistance", "I");
        }
    }

    private class BlockMod
    extends BaseMod.BlockMod {
        BlockMod() {
            super(GLSLShader.this);
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "lightOpacity", "[I"), new FieldRef(this.getDeobfClass(), "lightValue", "[I")).accessFlag(1, true).accessFlag(8, true).accessFlag(16, true));
        }
    }

    private class EntityLivingMod
    extends Mod.ClassMod {
        EntityLivingMod() {
            super(GLSLShader.this);
            this.setParentClass("Entity");
            this.addClassSignature(new ClassMod.ConstSignature(this, "/mob/char.png"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "bubble"));
        }
    }

    private class EntityRendererMod
    extends Mod.ClassMod {
        EntityRendererMod() {
            super(GLSLShader.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "/terrain.png"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "/environment/snow.png"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "ambient.weather.rain"));
            final MethodRef setupCameraTransform = new MethodRef(this.getDeobfClass(), "setupCameraTransform", "(FI)V");
            MethodRef renderWorld = new MethodRef(this.getDeobfClass(), "renderWorld", "(FJ)V");
            final MethodRef renderRainSnow = new MethodRef(this.getDeobfClass(), "renderRainSnow", "(F)V");
            final MethodRef renderHand = new MethodRef(this.getDeobfClass(), "renderHand", "(FI)V");
            final FieldRef fogColorRed = new FieldRef(this.getDeobfClass(), "fogColorRed", "F");
            final FieldRef fogColorGreen = new FieldRef(this.getDeobfClass(), "fogColorGreen", "F");
            final FieldRef fogColorBlue = new FieldRef(this.getDeobfClass(), "fogColorBlue", "F");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(2918), 42, 42, BytecodeMatcher.captureReference(180), 42, BytecodeMatcher.captureReference(180), 42, BytecodeMatcher.captureReference(180), this.push(Float.valueOf(1.0f)), BytecodeMatcher.anyReference(183), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glFog", "(ILjava/nio/FloatBuffer;)V")));
                }
            }.addXref(1, fogColorRed).addXref(2, fogColorGreen).addXref(3, fogColorBlue));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(5889), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glMatrixMode", "(I)V")), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glLoadIdentity", "()V")));
                }
            }.setMethod(setupCameraTransform));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push("/environment/snow.png"));
                }
            }.setMethod(renderRainSnow));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(256), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glClear", "(I)V")), 42, 35, BytecodeMatcher.anyILOAD, BytecodeMatcher.captureReference(183));
                }
            }.setMethod(renderWorld).addXref(1, renderHand));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "mc", "LMinecraft;")));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, renderWorld));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "disableLightmap", "(D)V"), new MethodRef(this.getDeobfClass(), "enableLightmap", "(D)V")));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "call beginRender";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, new FieldRef(EntityRendererMod.this.getDeobfClass(), "mc", "LMinecraft;")), 35, 32, this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "beginRender", "(LMinecraft;FJ)V")));
                }
            }.targetMethod(renderWorld));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "call endRender";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "endRender", "()V"))});
                }
            }.setInsertBefore(true).targetMethod(renderWorld));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "call setClearColor / setCamera";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 35, BytecodeMatcher.anyILOAD, this.reference(183, setupCameraTransform));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, fogColorRed), 42, this.reference(180, fogColorGreen), 42, this.reference(180, fogColorBlue), this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "setClearColor", "(FFF)V")), this.getMatch(), 35, this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "setCamera", "(F)V")));
                }
            }.targetMethod(renderWorld));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "wrap terrain and water rendering";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, new MethodRef("RenderGlobal", "sortAndRender", "(LEntityLiving;ID)I"))});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "sortAndRenderWrapper", "(LRenderGlobal;LEntityLiving;ID)I"))});
                }
            }.targetMethod(renderWorld));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "wrap water rendering";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyALOAD, BinaryRegex.or(BinaryRegex.build(4), BinaryRegex.build(42, BytecodeMatcher.anyReference(180))), 35, 141, this.reference(182, new MethodRef("RenderGlobal", "renderAllRenderLists", "(ID)V")));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "beginWater", "()V")), this.getMatch(), this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "endWater", "()V")));
                }
            }.targetMethod(renderWorld));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "wrap weather rendering";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 35, this.reference(182, renderRainSnow));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "beginWeather", "()V")), this.getMatch(), this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "endWeather", "()V")));
                }
            }.targetMethod(renderWorld));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "wrap hand rendering";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 35, BytecodeMatcher.anyILOAD, this.reference(183, renderHand));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "beginHand", "()V")), this.getMatch(), this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "endHand", "()V")));
                }
            }.targetMethod(renderWorld));
            this.addLightmapPatch("enableLightmap");
            this.addLightmapPatch("disableLightmap");
        }

        private void addLightmapPatch(final String name) {
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "wrap " + name;
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", name, "()V"))});
                }
            }.setInsertBefore(true).targetMethod(new MethodRef(this.getDeobfClass(), name, "(D)V")));
        }
    }

    private class RenderLivingMod
    extends Mod.ClassMod {
        RenderLivingMod() {
            super(GLSLShader.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "deadmau5"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(514), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glDepthFunc", "(I)V")));
                }
            });
            this.addGLWrapper("glEnable");
            this.addGLWrapper("glDisable");
        }

        private void addGLWrapper(final String name) {
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "wrap " + name;
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", name, "(I)V"))});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", name + "Wrapper", "(I)V"))});
                }
            });
        }
    }

    private class RenderGlobalMod
    extends Mod.ClassMod {
        RenderGlobalMod() {
            super(GLSLShader.this);
            MethodRef renderSky = new MethodRef(this.getDeobfClass(), "renderSky", "(F)V");
            final FieldRef worldObj = new FieldRef(this.getDeobfClass(), "worldObj", "LWorldClient;");
            this.addClassSignature(new ClassMod.ConstSignature(this, "smoke"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "/environment/clouds.png"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyFLOAD, this.push(Float.valueOf(0.2f)), 106, this.push(Float.valueOf(0.04f)), 98, BytecodeMatcher.anyFLOAD, this.push(Float.valueOf(0.2f)), 106, this.push(Float.valueOf(0.04f)), 98, BytecodeMatcher.anyFLOAD, this.push(Float.valueOf(0.6f)), 106, this.push(Float.valueOf(0.1f)), 98, this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glColor3f", "(FFF)V")));
                }
            }.setMethod(renderSky));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "sortAndRender", "(LEntityLiving;ID)I")));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "renderAllRenderLists", "(ID)V")));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, worldObj));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "call setCelestialPosition";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, worldObj), 35, this.reference(182, new MethodRef("WorldClient", "getStarBrightness", "(F)F")), BytecodeMatcher.anyFLOAD, 106, BytecodeMatcher.anyFSTORE);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", "setCelestialPosition", "()V"))});
                }
            }.setInsertAfter(true).targetMethod(renderSky));
            this.addGLWrapper("glEnable");
            this.addGLWrapper("glDisable");
        }

        private void addGLWrapper(final String name) {
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "wrap " + name;
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", name, "(I)V"))});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.glsl.Shaders", name + "Wrapper", "(I)V"))});
                }
            });
        }
    }

    private class RenderEngineMod
    extends Mod.ClassMod {
        RenderEngineMod() {
            super(GLSLShader.this);
            MethodRef refreshTextures = new MethodRef(this.getDeobfClass(), "refreshTextures", "()V");
            this.addClassSignature(new ClassMod.ConstSignature(this, new MethodRef("org.lwjgl.opengl.GL11", "glTexSubImage2D", "(IIIIIIIILjava/nio/ByteBuffer;)V")));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push("%clamp%"));
                }
            }.setMethod(refreshTextures));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getTexture", "(Ljava/lang/String;)I")));
        }
    }

    private class GLAllocationMod
    extends Mod.ClassMod {
        protected final MethodRef createDirectByteBuffer;

        public GLAllocationMod() {
            super(GLSLShader.this);
            this.createDirectByteBuffer = new MethodRef(this.getDeobfClass(), "createDirectByteBuffer", "(I)Ljava/nio/ByteBuffer;");
            final MethodRef allocateDirect = new MethodRef("java.nio.ByteBuffer", "allocateDirect", "(I)Ljava/nio/ByteBuffer;");
            MethodRef glDeleteLists = new MethodRef("org.lwjgl.opengl.GL11", "glDeleteLists", "(II)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, glDeleteLists));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, allocateDirect)});
                }
            }.setMethod(this.createDirectByteBuffer));
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod() {
            super(GLSLShader.this);
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.reference(184, new MethodRef("org/lwjgl/input/Keyboard", "getEventKey", "()I")), this.push(63), 160, BinaryRegex.any(2), 42, BytecodeMatcher.anyReference(180), 89, BytecodeMatcher.captureReference(180), 4, 96, BytecodeMatcher.anyReference(181));
                }
            }.addXref(1, new FieldRef("GameSettings", "thirdPersonView", "I")));
            this.mapWorldClient();
            this.mapPlayer();
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "renderEngine", "LRenderEngine;")));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "gameSettings", "LGameSettings;")));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "entityRenderer", "LEntityRenderer;")));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "renderViewEntity", "LEntityLiving;")));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "displayWidth", "I"), new FieldRef(this.getDeobfClass(), "displayHeight", "I")).accessFlag(1, true).accessFlag(8, false).accessFlag(16, false));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getAppDir", "(Ljava/lang/String;)Ljava/io/File;")).accessFlag(1, true).accessFlag(8, true));
        }
    }
}

