/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mod;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassRef;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.InterfaceMethodRef;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.ModConfigPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class CustomColors
extends Mod {
    private static final MethodRef colorizeBlock = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "colorizeBlock", "(LBlock;)I");
    private static final MethodRef colorizeBlock4Int = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "colorizeBlock", "(LBlock;IIII)I");
    private static final MethodRef colorizeBiome1 = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "colorizeBiome", "(IIDD)I");
    private static final MethodRef colorizeBiome2 = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "colorizeBiome", "(II)I");
    private static final MethodRef colorizeBiome3 = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "colorizeBiome", "(IIIII)I");
    private static final MethodRef colorizeBiomeWithBlending = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "colorizeBiomeWithBlending", "(IIIII)I");
    private static final MethodRef colorizeRedstoneWire = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "colorizeRedstoneWire", "(LIBlockAccess;IIII)I");
    private static final MethodRef colorizeStem = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "colorizeStem", "(II)I");
    private static final MethodRef colorizeWater = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "colorizeWater", "(Ljava/lang/Object;II)I");
    private static final MethodRef colorizeWaterBlockGL = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "colorizeWaterBlockGL", "(I)V");
    private static final MethodRef colorizeSpawnerEgg = new MethodRef("com.prupe.mcpatcher.cc.ColorizeItem", "colorizeSpawnerEgg", "(III)I");
    private static final MethodRef colorizeText1 = new MethodRef("com.prupe.mcpatcher.cc.ColorizeWorld", "colorizeText", "(I)I");
    private static final MethodRef colorizeText2 = new MethodRef("com.prupe.mcpatcher.cc.ColorizeWorld", "colorizeText", "(II)I");
    private static final MethodRef colorizeSignText = new MethodRef("com.prupe.mcpatcher.cc.ColorizeWorld", "colorizeSignText", "()I");
    private static final MethodRef colorizeXPOrb = new MethodRef("com.prupe.mcpatcher.cc.ColorizeEntity", "colorizeXPOrb", "(IF)I");
    private static final MethodRef computeFogColor1 = new MethodRef("com.prupe.mcpatcher.cc.ColorizeWorld", "computeFogColor", "(I)Z");
    private static final MethodRef computeFogColor2 = new MethodRef("com.prupe.mcpatcher.cc.ColorizeWorld", "computeFogColor", "(LWorld;F)Z");
    private static final MethodRef computeSkyColor = new MethodRef("com.prupe.mcpatcher.cc.ColorizeWorld", "computeSkyColor", "(LWorld;F)Z");
    private static final MethodRef computeLavaDropColor = new MethodRef("com.prupe.mcpatcher.cc.ColorizeEntity", "computeLavaDropColor", "(I)Z");
    private static final MethodRef computeWaterColor1 = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "computeWaterColor", "(DDD)Z");
    private static final MethodRef computeWaterColor2 = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "computeWaterColor", "()V");
    private static final MethodRef computeMyceliumParticleColor = new MethodRef("com.prupe.mcpatcher.cc.ColorizeEntity", "computeMyceliumParticleColor", "()Z");
    private static final MethodRef computeRedstoneWireColor = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "computeRedstoneWireColor", "(I)Z");
    private static final MethodRef getItemColorFromDamage = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "getItemColorFromDamage", "(III)I");
    private static final MethodRef getWaterBottleColor = new MethodRef("com.prupe.mcpatcher.cc.ColorizeItem", "getWaterBottleColor", "()I");
    private static final MethodRef getLilyPadColor = new MethodRef("com.prupe.mcpatcher.cc.ColorizeBlock", "getLilyPadColor", "()I");
    private static final MethodRef setupBiome = new MethodRef("com.prupe.mcpatcher.cc.ColorizeWorld", "setupBiome", "(LBiomeGenBase;)V");
    private static final MethodRef setupPotion = new MethodRef("com.prupe.mcpatcher.cc.ColorizeItem", "setupPotion", "(LPotion;)V");
    private static final MethodRef setupForFog = new MethodRef("com.prupe.mcpatcher.cc.ColorizeWorld", "setupForFog", "(LEntity;)V");
    private static final MethodRef setupSpawnerEgg = new MethodRef("com.prupe.mcpatcher.cc.ColorizeItem", "setupSpawnerEgg", "(Ljava/lang/String;III)V");
    private static final MethodRef setColorF = new MethodRef("com.prupe.mcpatcher.cc.Colorizer", "setColorF", "(I)V");
    private static final MethodRef drawFancyClouds = new MethodRef("com.prupe.mcpatcher.cc.ColorizeWorld", "drawFancyClouds", "(Z)Z");
    private static final FieldRef setColor = new FieldRef("com.prupe.mcpatcher.cc.Colorizer", "setColor", "[F");
    private static final FieldRef endFogColor = new FieldRef("com.prupe.mcpatcher.cc.ColorizeWorld", "endFogColor", "[F");
    private static final FieldRef endSkyColor = new FieldRef("com.prupe.mcpatcher.cc.ColorizeWorld", "endSkyColor", "I");
    private static final FieldRef netherFogColor = new FieldRef("com.prupe.mcpatcher.cc.ColorizeWorld", "netherFogColor", "[F");
    private static final FieldRef portalColor = new FieldRef("com.prupe.mcpatcher.cc.ColorizeEntity", "portalColor", "[F");
    private static final FieldRef waterColor = new FieldRef("com.prupe.mcpatcher.cc.ColorizeBlock", "waterColor", "[F");
    private static final FieldRef armorColors = new FieldRef("com.prupe.mcpatcher.cc.ColorizeEntity", "armorColors", "[[F");
    private static final FieldRef collarColors = new FieldRef("com.prupe.mcpatcher.cc.ColorizeEntity", "collarColors", "[[F");
    private static final FieldRef undyedLeatherColor = new FieldRef("com.prupe.mcpatcher.cc.ColorizeEntity", "undyedLeatherColor", "I");
    private static final MethodRef getColorFromDamage = new MethodRef("Item", "getColorFromDamage", "(LItemStack;I)I");
    private static final FieldRef fleeceColorTable = new FieldRef("EntitySheep", "fleeceColorTable", "[[F");

    public CustomColors() {
        this.name = "Custom Colors";
        this.author = "MCPatcher";
        this.description = "Gives texture packs control over hardcoded colors in the game.";
        this.version = "1.6";
        this.addDependency("__TexturePackBase");
        this.configPanel = new ConfigPanel();
        this.addClassMod(new BaseMod.MinecraftMod(this).mapWorldClient());
        this.addClassMod(new BaseMod.IBlockAccessMod(this));
        this.addClassMod(new BaseMod.TessellatorMod(this));
        this.addClassMod(new BlockMod());
        this.addClassMod(new BiomeGenBaseMod());
        this.addClassMod(new BiomeGenSwampMod());
        this.addClassMod(new BlockFluidMod());
        this.addClassMod(new ItemMod());
        this.addClassMod(new ItemBlockMod());
        this.addClassMod(new ItemRendererMod());
        this.addClassMod(new PotionMod());
        this.addClassMod(new PotionHelperMod());
        this.addClassMod(new ColorizerFoliageMod());
        this.addClassMod(new BlockLeavesMod());
        this.addClassMod(new WorldMod());
        this.addClassMod(new BaseMod.WorldClientMod(this));
        this.addClassMod(new WorldProviderMod());
        this.addClassMod(new WorldProviderHellMod());
        this.addClassMod(new WorldProviderEndMod());
        this.addClassMod(new WorldChunkManagerMod());
        this.addClassMod(new EntityMod());
        this.addClassMod(new EntityFXMod());
        this.addClassMod(new EntityRainFXMod());
        this.addClassMod(new EntityDropParticleFXMod());
        this.addClassMod(new EntitySplashFXMod());
        this.addClassMod(new EntityBubbleFXMod());
        this.addClassMod(new EntitySuspendFXMod());
        this.addClassMod(new EntityPortalFXMod());
        this.addClassMod(new EntityAuraFXMod());
        this.addClassMod(new BaseMod.EntityLivingMod(this));
        this.addClassMod(new EntityRendererMod());
        this.addClassMod(new BlockLilyPadMod());
        this.addClassMod(new BlockRedstoneWireMod());
        this.addClassMod(new RenderBlocksMod());
        this.addClassMod(new EntityReddustFXMod());
        this.addClassMod(new RenderGlobalMod());
        this.addClassMod(new BlockStemMod());
        this.addClassMod(new MapColorMod());
        this.addClassMod(new ItemDyeMod());
        this.addClassMod(new EntitySheepMod());
        this.addClassMod(new ItemArmorMod());
        this.addClassMod(new RenderWolfMod());
        this.addClassMod(new RecipesDyedArmorMod());
        this.addClassMod(new EntityListMod());
        this.addClassMod(new ItemSpawnerEggMod());
        this.addClassMod(new FontRendererMod());
        this.addClassMod(new TileEntitySignRendererMod());
        this.addClassMod(new RenderXPOrbMod());
        this.addClassFile("com.prupe.mcpatcher.cc.Colorizer");
        this.addClassFile("com.prupe.mcpatcher.cc.Colorizer$1");
        this.addClassFile("com.prupe.mcpatcher.cc.ColorizeWorld");
        this.addClassFile("com.prupe.mcpatcher.cc.ColorizeItem");
        this.addClassFile("com.prupe.mcpatcher.cc.ColorizeEntity");
        this.addClassFile("com.prupe.mcpatcher.cc.ColorizeBlock");
        this.addClassFile("com.prupe.mcpatcher.cc.ColorMap");
        this.addClassFile("com.prupe.mcpatcher.cc.Lightmap");
        this.addClassFile("com.prupe.mcpatcher.cc.BiomeHelper");
    }

    private class RenderXPOrbMod
    extends Mod.ClassMod {
        RenderXPOrbMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/entity/experience_orb.png"));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override xp orb color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.lookBehind(BinaryRegex.build(BinaryRegex.capture(BytecodeMatcher.anyFLOAD), this.push(Float.valueOf(0.0f)), 98, BytecodeMatcher.anyReference(184), BinaryRegex.any(0, 200)), true), BinaryRegex.capture(BytecodeMatcher.anyILOAD), BinaryRegex.lookAhead(BinaryRegex.build(this.push(128), BytecodeMatcher.anyReference(182)), true));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.getCaptureGroup(2), this.getCaptureGroup(1), this.reference(184, colorizeXPOrb));
                }
            });
        }
    }

    private class TileEntitySignRendererMod
    extends Mod.ClassMod {
        TileEntitySignRendererMod() {
            super(CustomColors.this);
            final FieldRef sign = new FieldRef(this.getDeobfClass(), "sign", "LResourceAddress;");
            final MethodRef glDepthMask = new MethodRef("org.lwjgl.opengl.GL11", "glDepthMask", "(Z)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, glDepthMask));
            this.addClassSignature(new BaseMod.ResourceAddressSignature(this, sign, "textures/entity/sign.png"));
            this.addPatch(new ClassMod.BytecodePatch(){
                {
                    super(TileEntitySignRendererMod.this);
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(new Object[]{this.reference(178, sign)});
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "override sign text color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(0), this.reference(184, glDepthMask), this.push(0), BinaryRegex.capture(BytecodeMatcher.anyISTORE));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(0), this.reference(184, glDepthMask), this.reference(184, colorizeSignText), this.getCaptureGroup(1));
                }
            });
        }
    }

    private class FontRendererMod
    extends BaseMod.FontRendererMod {
        FontRendererMod() {
            super(CustomColors.this);
            MethodRef renderString = new MethodRef(this.getDeobfClass(), "renderString", "(Ljava/lang/String;IIIZ)I");
            final MethodRef glColor4f = new MethodRef("org.lwjgl.opengl.GL11", "glColor4f", "(FFFF)V");
            final FieldRef colorCode = new FieldRef(this.getDeobfClass(), "colorCode", "[I");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(32), 188, 10, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, colorCode));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(-16777216), BinaryRegex.any(0, 100), this.reference(184, glColor4f));
                }
            }.setMethod(renderString));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override text color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(21, 4, this.push(-67108864), 126);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(21, 4, this.reference(184, colorizeText1), 54, 4);
                }
            }.setInsertBefore(true).targetMethod(renderString));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override text color codes";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, colorCode), BinaryRegex.capture(BytecodeMatcher.anyILOAD), 46);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.getCaptureGroup(1), this.reference(184, colorizeText2));
                }
            }.setInsertAfter(true));
        }
    }

    private class RecipesDyedArmorMod
    extends Mod.ClassMod {
        RecipesDyedArmorMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(255.0f)));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(21, BinaryRegex.capture(BinaryRegex.any()), 134, 23, BinaryRegex.capture(BinaryRegex.any()), 106, 23, BinaryRegex.capture(BinaryRegex.any()), 110, 139, 54, BinaryRegex.backReference(1), 21, BinaryRegex.capture(BinaryRegex.any()), 134, 23, BinaryRegex.backReference(2), 106, 23, BinaryRegex.backReference(3), 110, 139, 54, BinaryRegex.backReference(4), 21, BinaryRegex.capture(BinaryRegex.any()), 134, 23, BinaryRegex.backReference(2), 106, 23, BinaryRegex.backReference(3), 110, 139, 54, BinaryRegex.backReference(5));
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override armor dye colors";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(178, fleeceColorTable)});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(178, armorColors)});
                }
            });
        }
    }

    private class RenderWolfMod
    extends Mod.ClassMod {
        RenderWolfMod() {
            super(CustomColors.this);
            MethodRef glColor3f = new MethodRef("org.lwjgl.opengl.GL11", "glColor3f", "(FFF)V");
            this.setParentClass("RenderLiving");
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/entity/wolf/wolf_collar.png"));
            this.addClassSignature(new ClassMod.ConstSignature(this, glColor3f));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override wolf collar colors";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(178, fleeceColorTable)});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(178, collarColors)});
                }
            });
        }
    }

    private class EntitySheepMod
    extends Mod.ClassMod {
        EntitySheepMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "mob.sheep.say"));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, fleeceColorTable).accessFlag(1, true).accessFlag(8, true));
        }
    }

    private class ItemArmorMod
    extends Mod.ClassMod {
        private final int DEFAULT_LEATHER_COLOR = 10511680;

        ItemArmorMod() {
            super(CustomColors.this);
            this.DEFAULT_LEATHER_COLOR = 10511680;
            this.addClassSignature(new ClassMod.ConstSignature(this, "display"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "color"));
            this.addClassSignature(new ClassMod.ConstSignature(this, 10511680));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override default leather armor color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(10511680));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(178, undyedLeatherColor)});
                }
            });
        }
    }

    private class ItemDyeMod
    extends Mod.ClassMod {
        ItemDyeMod() {
            super(CustomColors.this);
            FieldRef dyeColorNames = new FieldRef(this.getDeobfClass(), "dyeColorNames", "[Ljava/lang/String;");
            FieldRef dyeColors = new FieldRef(this.getDeobfClass(), "dyeColors", "[I");
            this.setParentClass("Item");
            this.addClassSignature(new ClassMod.ConstSignature(this, "black"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "purple"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "cyan"));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, dyeColorNames).accessFlag(1, true).accessFlag(8, true));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, dyeColors).accessFlag(1, true).accessFlag(8, true));
        }
    }

    private class MapColorMod
    extends Mod.ClassMod {
        MapColorMod() {
            super(CustomColors.this);
            FieldRef mapColorArray = new FieldRef(this.getDeobfClass(), "mapColorArray", "[LMapColor;");
            final FieldRef colorValue = new FieldRef(this.getDeobfClass(), "colorValue", "I");
            FieldRef colorIndex = new FieldRef(this.getDeobfClass(), "colorIndex", "I");
            final FieldRef origColorValue = new FieldRef(this.getDeobfClass(), "origColorValue", "I");
            this.addClassSignature(new ClassMod.ConstSignature(this, 8368696));
            this.addClassSignature(new ClassMod.ConstSignature(this, 16247203));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0xA7A7A7));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0xFF0000));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0xA0A0FF));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, mapColorArray).accessFlag(8, true));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, colorValue, colorIndex).accessFlag(8, false));
            this.addPatch(new ClassMod.AddFieldPatch((ClassMod)this, origColorValue));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(colorValue){

                @Override
                public int getNewFlags(int oldFlags) {
                    return oldFlags & 0xFFFFFFEF;
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "set map origColorValue";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 28, this.reference(181, colorValue));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 28, this.reference(181, origColorValue));
                }
            }.setInsertAfter(true).targetMethod(new MethodRef(this.getDeobfClass(), "<init>", "(II)V")));
        }
    }

    private class ItemSpawnerEggMod
    extends Mod.ClassMod {
        ItemSpawnerEggMod() {
            super(CustomColors.this);
            MethodRef getColorFromDamage2 = new MethodRef(this.getDeobfClass(), getColorFromDamage.getName(), getColorFromDamage.getType());
            MethodRef getItemNameIS = new MethodRef(this.getDeobfClass(), "getItemNameIS", "(LItemStack;)Ljava/lang/String;");
            final MethodRef getItemDamage = new MethodRef("ItemStack", "getItemDamage", "()I");
            MethodRef getEntityString = new MethodRef("EntityList", "getEntityString", "(I)Ljava/lang/String;");
            this.setParentClass("Item");
            this.addClassSignature(new ClassMod.ConstSignature(this, ".name"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "entity."));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(43, BytecodeMatcher.captureReference(182), BytecodeMatcher.captureReference(184), 78, 45);
                }
            }.setMethod(getItemNameIS).addXref(1, getItemDamage).addXref(2, getEntityString));
            this.addClassSignature(new ClassMod.OrSignature(this, new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(16, 64, 27, this.push(2423535), 104, this.push(192), 126, 96);
                }
            }.setMethod(getColorFromDamage), new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(0xFFFFFF), 172);
                }
            }.setMethod(getColorFromDamage)));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override spawner egg color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(172);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, this.reference(182, getItemDamage), 28, this.reference(184, colorizeSpawnerEgg));
                }
            }.setInsertBefore(true).targetMethod(getColorFromDamage2));
        }
    }

    private class EntityListMod
    extends Mod.ClassMod {
        EntityListMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "Skipping Entity with id "));
            MethodRef addMapping = new MethodRef(this.getDeobfClass(), "addMapping", "(Ljava/lang/Class;Ljava/lang/String;III)V");
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, addMapping).accessFlag(8, true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "set up mapping for spawnable entities";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, 28, 29, 21, 4, this.reference(184, setupSpawnerEgg));
                }
            }.targetMethod(addMapping));
        }
    }

    private class RenderGlobalMod
    extends Mod.ClassMod {
        RenderGlobalMod() {
            super(CustomColors.this);
            FieldRef clouds = new FieldRef(this.getDeobfClass(), "clouds", "LResourceAddress;");
            final FieldRef mc = new FieldRef(this.getDeobfClass(), "mc", "LMinecraft;");
            final FieldRef gameSettings = new FieldRef("Minecraft", "gameSettings", "LGameSettings;");
            final FieldRef fancyGraphics = new FieldRef("GameSettings", "fancyGraphics", "Z");
            MethodRef renderClouds = new MethodRef(this.getDeobfClass(), "renderClouds", "(F)V");
            MethodRef renderSky = new MethodRef(this.getDeobfClass(), "renderSky", "(F)V");
            final MethodRef glRotatef = new MethodRef("org.lwjgl.opengl.GL11", "glRotatef", "(FFFF)V");
            this.addClassSignature(new BaseMod.ResourceAddressSignature(this, clouds, "textures/environment/clouds.png"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), BytecodeMatcher.IFEQ_or_IFNE, BinaryRegex.any(2), BinaryRegex.any(0, 100), this.push(32), BytecodeMatcher.anyISTORE, this.push(256), BytecodeMatcher.anyILOAD, 108, BytecodeMatcher.anyISTORE, BinaryRegex.any(1, 50), BytecodeMatcher.captureReference(178));
                }
            }.setMethod(renderClouds).addXref(1, mc).addXref(2, gameSettings).addXref(3, fancyGraphics).addXref(4, clouds));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(90.0f)), this.push(Float.valueOf(1.0f)), this.push(Float.valueOf(0.0f)), this.push(Float.valueOf(0.0f)), this.reference(184, glRotatef));
                }
            }.setMethod(renderSky));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override cloud type";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(42, this.reference(180, mc), this.reference(180, gameSettings), this.reference(180, fancyGraphics))), BinaryRegex.capture(BinaryRegex.build(153, BinaryRegex.any(2))));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.getCaptureGroup(1), this.reference(184, drawFancyClouds), this.getCaptureGroup(2));
                }
            }.targetMethod(renderClouds));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override end sky color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(this.push(0x181818)), BinaryRegex.build(this.push(0x282828))));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(178, endSkyColor)});
                }
            }.targetMethod(renderSky));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override mycelium particle color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.lookBehind(BinaryRegex.build(43, this.push("townaura"), this.reference(182, new MethodRef("java/lang/String", "equals", "(Ljava/lang/Object;)Z")), 153, BinaryRegex.any(2), this.reference(187, new ClassRef("EntityAuraFX")), 89, 42, BytecodeMatcher.anyReference(180), BytecodeMatcher.anyDLOAD, BytecodeMatcher.anyDLOAD, BytecodeMatcher.anyDLOAD, BytecodeMatcher.anyDLOAD, BytecodeMatcher.anyDLOAD, BytecodeMatcher.anyDLOAD, this.reference(183, new MethodRef("EntityAuraFX", "<init>", "(LWorld;DDDDDD)V"))), true));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(182, new MethodRef("EntityAuraFX", "colorize", "()LEntityAuraFX;"))});
                }
            });
        }
    }

    public class BlockStemMod
    extends Mod.ClassMod {
        BlockStemMod() {
            super(CustomColors.this);
            MethodRef getRenderColor = new MethodRef(this.getDeobfClass(), "getRenderColor", "(I)I");
            this.addClassSignature(new ClassMod.FixedBytecodeSignature(this, BinaryRegex.begin(), 27, 16, 32, 104, 61, 17, 0, 255, 27, 16, 8, 104, 100, 62, 27, 7, 104, 54, 4, 28, 16, 16, 120, 29, 16, 8, 120, 128, 21, 4, 128, 172, BinaryRegex.end()).setMethod(getRenderColor));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override pumpkin and melon stem color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(172, BinaryRegex.end());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(27, this.reference(184, colorizeStem));
                }
            }.setInsertBefore(true).targetMethod(getRenderColor));
        }
    }

    private class EntityReddustFXMod
    extends Mod.ClassMod {
        EntityReddustFXMod() {
            super(CustomColors.this);
            final MethodRef random = new MethodRef("java/lang/Math", "random", "()D");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(184, random), this.push(0.2f), 107, 144, this.push(Float.valueOf(0.8f)), 98, BytecodeMatcher.anyFLOAD, 106, BytecodeMatcher.anyFLOAD, 106, BytecodeMatcher.anyReference(181));
                }
            }.matchConstructorOnly(true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override redstone particle color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(1.0f)), 56, 9, this.reference(184, random));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(Float.valueOf(1.0f)), 56, 9, this.push(15), this.reference(184, computeRedstoneWireColor), 153, this.branch("A"), this.reference(178, setColor), this.push(0), 48, 56, 9, this.reference(178, setColor), this.push(1), 48, 56, 10, this.reference(178, setColor), this.push(2), 48, 56, 11, this.label("A"), this.reference(184, random));
                }
            }.matchConstructorOnly(true));
        }
    }

    private class RenderBlocksMod
    extends RedstoneWireClassMod {
        private final FieldRef tessellator;

        RenderBlocksMod() {
            super("override redstone wire color", new MethodRef("RenderBlocks", "renderBlockRedstoneWire", "(LBlock;III)Z"));
            this.tessellator = new FieldRef("Tessellator", "instance", "LTessellator;");
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.1875));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.01));
            MethodRef renderBlockFallingSand = new MethodRef(this.getDeobfClass(), "renderBlockFallingSand", "(LBlock;LWorld;IIII)V");
            MethodRef renderBlockFluids = new MethodRef(this.getDeobfClass(), "renderBlockFluids", "(LBlock;III)Z");
            MethodRef renderBlockCauldron = new MethodRef(this.getDeobfClass(), "renderBlockCauldron", "(LBlockCauldron;III)Z");
            final MethodRef setColorOpaque_F = new MethodRef("Tessellator", "setColorOpaque_F", "(FFF)V");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(43, 42, BytecodeMatcher.captureReference(180), 28, 29, 21, 4, BytecodeMatcher.captureReference(182), 54, 6);
                }
            }.setMethod(renderBlockFluids).addXref(1, new FieldRef(this.getDeobfClass(), "blockAccess", "LIBlockAccess;")).addXref(2, new MethodRef("Block", "colorMultiplier", "(LIBlockAccess;III)I")));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.push(Float.valueOf(0.5f)), 56, 7, 12, 56, 8, this.push(Float.valueOf(0.8f)), 56, 9, this.push(Float.valueOf(0.6f)), 56, 10);
                }
            }.setMethod(renderBlockFallingSand));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, renderBlockCauldron));
            this.addPatch(new TessellatorPatch(){

                @Override
                public String getDescription() {
                    return "colorize cauldron water";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push("water_still"), BytecodeMatcher.anyReference(184), BytecodeMatcher.anyASTORE);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(184, computeWaterColor2), 25, this.tessellatorRegister, this.reference(178, waterColor), this.push(0), 48, this.reference(178, waterColor), this.push(1), 48, this.reference(178, waterColor), this.push(2), 48, this.reference(182, setColorOpaque_F));
                }
            }.setInsertAfter(true).targetMethod(renderBlockCauldron));
            this.addPatch(new TessellatorPatch(){
                private boolean done;

                @Override
                public String getDescription() {
                    return "colorize falling sand and gravel";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(25, this.tessellatorRegister, BinaryRegex.capture(BytecodeMatcher.anyFLOAD), BinaryRegex.capture(BytecodeMatcher.anyFLOAD), 106, BinaryRegex.backReference(1), BinaryRegex.backReference(2), 106, BinaryRegex.backReference(1), BinaryRegex.backReference(2), 106, this.reference(182, setColorOpaque_F));
                }

                @Override
                public byte[] getReplacementBytes() {
                    byte[] extraCode;
                    if (this.done) {
                        extraCode = new byte[]{};
                    } else {
                        this.done = true;
                        extraCode = this.buildCode(43, 29, 21, 4, 21, 5, 3, this.reference(184, colorizeBlock4Int), this.reference(184, setColorF));
                    }
                    return this.buildCode(extraCode, 25, this.tessellatorRegister, this.reference(178, setColor), this.push(0), 48, this.getCaptureGroup(2), 106, this.reference(178, setColor), this.push(1), 48, this.getCaptureGroup(2), 106, this.reference(178, setColor), this.push(2), 48, this.getCaptureGroup(2), 106, this.reference(182, setColorOpaque_F));
                }
            }.targetMethod(renderBlockFallingSand));
            this.addPatch(new TessellatorPatch(){
                private int[] waterRegisters;
                {
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(BinaryRegex.capture(BytecodeMatcher.anyILOAD), this.push(16), 122, this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, BinaryRegex.capture(BytecodeMatcher.anyFSTORE), BinaryRegex.backReference(1), this.push(8), 122, this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, BinaryRegex.capture(BytecodeMatcher.anyFSTORE), BinaryRegex.backReference(1), this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, BinaryRegex.capture(BytecodeMatcher.anyFSTORE));
                        }

                        @Override
                        public boolean afterMatch() {
                            5.access$5002(this, new int[]{BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(2)), BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(3)), BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(4))});
                            Logger.log(3, "water color registers: %d %d %d", waterRegisters[0], waterRegisters[1], waterRegisters[2]);
                            return true;
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "colorize bottom of water block";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(25, this.tessellatorRegister, 23, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.capture(BinaryRegex.any()), 106, 23, BinaryRegex.backReference(1), 23, BinaryRegex.backReference(2), 106, 23, BinaryRegex.backReference(1), 23, BinaryRegex.backReference(2), 106, this.reference(182, setColorOpaque_F));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(25, this.tessellatorRegister, 23, this.getCaptureGroup(1), 23, this.getCaptureGroup(2), 106, 23, this.waterRegisters[0], 106, 23, this.getCaptureGroup(1), 23, this.getCaptureGroup(2), 106, 23, this.waterRegisters[1], 106, 23, this.getCaptureGroup(1), 23, this.getCaptureGroup(2), 106, 23, this.waterRegisters[2], 106, this.reference(182, setColorOpaque_F));
                }

                static /* synthetic */ int[] access$5002(5 x0, int[] x1) {
                    x0.waterRegisters = x1;
                    return x1;
                }
            }.targetMethod(renderBlockFluids));
            this.setupBTW();
        }

        private void setupBTW() {
            final FieldRef blockAccess = new FieldRef(this.getDeobfClass(), "blockAccess", "LIBlockAccess;");
            final MethodRef colorMultiplier = new MethodRef("Block", "colorMultiplier", "(LIBlockAccess;III)I");
            MethodRef renderBlock = new MethodRef(this.getDeobfClass(), "RenderStandardFullBlock", "(LBlock;III)Z");
            MethodRef renderBlockAO = new MethodRef(this.getDeobfClass(), "RenderStandardFullBlockWithAmbientOcclusion", "(LBlock;III)Z");
            MethodRef renderBlockCM = new MethodRef(this.getDeobfClass(), "RenderStandardFullBlockWithColorMultiplier", "(LBlock;III)Z");
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "setup block color multiplier (btw)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, 42, this.reference(180, blockAccess), 28, 29, 21, 4, this.reference(182, colorMultiplier), this.reference(184, setColorF));
                }
            }.targetMethod(renderBlock));
            this.addPatch(new ClassMod.BytecodePatch(){
                private int patchCount;

                @Override
                public String getDescription() {
                    return "use block color multiplier (btw)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(this.push(Float.valueOf(0.5f))), BinaryRegex.build(this.push(Float.valueOf(0.6f))), BinaryRegex.build(this.push(Float.valueOf(0.8f))), BinaryRegex.build(this.push(Float.valueOf(1.0f)))));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, setColor), this.push(this.patchCount++ % 3), 48, 106);
                }
            }.setInsertAfter(true).targetMethod(renderBlockAO, renderBlockCM));
        }

        private abstract class TessellatorPatch
        extends ClassMod.BytecodePatch {
            protected int tessellatorRegister;

            private TessellatorPatch() {
                super(RenderBlocksMod.this);
                this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                    @Override
                    public String getMatchExpression() {
                        return this.buildExpression(this.reference(178, RenderBlocksMod.this.tessellator), BinaryRegex.capture(BytecodeMatcher.anyASTORE));
                    }

                    @Override
                    public boolean afterMatch() {
                        TessellatorPatch.this.tessellatorRegister = BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(1));
                        return true;
                    }
                });
            }
        }
    }

    private class BlockRedstoneWireMod
    extends RedstoneWireClassMod {
        BlockRedstoneWireMod() {
            super("override redstone wire particle color", new MethodRef("BlockRedstoneWire", "randomDisplayTick", "(LWorld;IIILjava/util/Random;)V"));
            this.setParentClass("Block");
            this.addClassSignature(new ClassMod.ConstSignature(this, "reddust"));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override redstone color multiplier";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(0x800000));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, 28, 29, 21, 4, this.push(0x800000), this.reference(184, colorizeRedstoneWire));
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "colorMultiplier", "(LIBlockAccess;III)I")));
        }
    }

    private abstract class RedstoneWireClassMod
    extends Mod.ClassMod {
        RedstoneWireClassMod(final String description, MethodRef method) {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyILOAD, 134, this.push(Float.valueOf(15.0f)), 110, BytecodeMatcher.anyFSTORE, BytecodeMatcher.anyFLOAD, this.push(Float.valueOf(0.6f)), 106, this.push(Float.valueOf(0.4f)), 98, BytecodeMatcher.anyFSTORE);
                }
            }.setMethod(method));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return description;
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(21, BinaryRegex.capture(BinaryRegex.any()), 134, this.push(Float.valueOf(15.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.backReference(2), this.push(Float.valueOf(0.6f)), 106, this.push(Float.valueOf(0.4f)), 98, 56, BinaryRegex.capture(BinaryRegex.any()), BinaryRegex.any(0, 10), 23, BinaryRegex.backReference(2), 23, BinaryRegex.backReference(2), 106, this.push(Float.valueOf(0.7f)), 106, this.push(Float.valueOf(0.5f)), 102, 56, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.backReference(2), 23, BinaryRegex.backReference(2), 106, this.push(Float.valueOf(0.6f)), 106, this.push(Float.valueOf(0.7f)), 102, 56, BinaryRegex.capture(BinaryRegex.any()));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(21, this.getCaptureGroup(1), this.reference(184, computeRedstoneWireColor), 153, this.branch("A"), this.reference(178, setColor), 3, 48, 56, this.getCaptureGroup(3), this.reference(178, setColor), 4, 48, 56, this.getCaptureGroup(4), this.reference(178, setColor), 5, 48, 56, this.getCaptureGroup(5), 167, this.branch("B"), this.label("A"), this.getMatch(), this.label("B"));
                }
            }.targetMethod(method));
        }
    }

    private class EntityRendererMod
    extends Mod.ClassMod {
        EntityRendererMod() {
            super(CustomColors.this);
            MethodRef updateLightmap = new MethodRef(this.getDeobfClass(), "updateLightmap", "(F)V");
            final FieldRef mc = new FieldRef(this.getDeobfClass(), "mc", "LMinecraft;");
            MethodRef updateFogColor = new MethodRef(this.getDeobfClass(), "updateFogColor", "(F)V");
            final FieldRef fogColorRed = new FieldRef(this.getDeobfClass(), "fogColorRed", "F");
            final FieldRef fogColorGreen = new FieldRef(this.getDeobfClass(), "fogColorGreen", "F");
            final FieldRef fogColorBlue = new FieldRef(this.getDeobfClass(), "fogColorBlue", "F");
            final FieldRef lightmapColors = new FieldRef(this.getDeobfClass(), "lightmapColors", "[I");
            final FieldRef lightmapTexture = new FieldRef(this.getDeobfClass(), "lightmapTexture", "LTextureWithData;");
            final FieldRef needLightmapUpdate = new FieldRef(this.getDeobfClass(), "needLightmapUpdate", "Z");
            final FieldRef thePlayer = new FieldRef("Minecraft", "thePlayer", "LEntityClientPlayerMP;");
            final FieldRef nightVision = new FieldRef("Potion", "nightVision", "LPotion;");
            final MethodRef isPotionActive = new MethodRef("EntityClientPlayerMP", "isPotionActive", "(LPotion;)Z");
            final MethodRef getNightVisionStrength1 = new MethodRef(this.getDeobfClass(), "getNightVisionStrength1", "(LEntityPlayer;F)F");
            MethodRef getNightVisionStrength = new MethodRef(this.getDeobfClass(), "getNightVisionStrength", "(F)F");
            final MethodRef reloadTexture = new MethodRef("TextureWithData", "reload", "()V");
            this.addClassSignature(new ClassMod.ConstSignature(this, "ambient.weather.rain"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(44, this.push(Float.valueOf(1.0f)), BytecodeMatcher.captureReference(182), this.push(Float.valueOf(0.95f)), 106, this.push(Float.valueOf(0.05f)), 98, 56, 4, 44, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), 29, 16, 16, 108, 48, 23, 4, 106, 56, 5, BinaryRegex.any(0, 20), 29, 16, 16, 112, 48, 42, BytecodeMatcher.captureReference(180), BinaryRegex.any(0, 200), 44, BytecodeMatcher.captureReference(180), 158, BinaryRegex.any(2), BinaryRegex.any(0, 300), 44, BinaryRegex.backReference(2), BytecodeMatcher.captureReference(180), 4, 160, BinaryRegex.any(2), BinaryRegex.any(0, 200), 42, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), 56, 16, BinaryRegex.any(0, 300), 42, BytecodeMatcher.captureReference(180), BinaryRegex.any(0, 50), 79, BinaryRegex.any(0, 20), 42, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(182), 42, this.push(0), BytecodeMatcher.captureReference(181), 177);
                }
            }.setMethod(updateLightmap).addXref(1, new MethodRef("World", "getSunAngle", "(F)F")).addXref(2, new FieldRef("World", "worldProvider", "LWorldProvider;")).addXref(3, new FieldRef("WorldProvider", "lightBrightnessTable", "[F")).addXref(4, new FieldRef(this.getDeobfClass(), "torchFlickerX", "F")).addXref(5, new FieldRef("World", "lightningFlash", "I")).addXref(6, new FieldRef("WorldProvider", "worldType", "I")).addXref(7, mc).addXref(8, new FieldRef("Minecraft", "gameSettings", "LGameSettings;")).addXref(9, new FieldRef("GameSettings", "gammaSetting", "F")).addXref(10, lightmapColors).addXref(11, lightmapTexture).addXref(12, reloadTexture).addXref(13, needLightmapUpdate));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.02f)), BinaryRegex.capture(BinaryRegex.optional(BinaryRegex.build(BytecodeMatcher.anyFLOAD, 98))), BytecodeMatcher.captureReference(181), 42, this.push(Float.valueOf(0.02f)), BinaryRegex.backReference(1), BytecodeMatcher.captureReference(181), 42, this.push(Float.valueOf(0.2f)), BinaryRegex.backReference(1), BytecodeMatcher.captureReference(181));
                }
            }.setMethod(updateFogColor).addXref(2, fogColorRed).addXref(3, fogColorGreen).addXref(4, fogColorBlue));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BinaryRegex.build(42, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(178), BytecodeMatcher.captureReference(182))), 153, BinaryRegex.any(2), BinaryRegex.capture(BinaryRegex.build(42, 42, BinaryRegex.backReference(2), BinaryRegex.backReference(3), 35, BytecodeMatcher.captureReference(183))), 56, BinaryRegex.any());
                }
            }.setMethod(updateLightmap).addXref(2, mc).addXref(3, thePlayer).addXref(4, nightVision).addXref(5, isPotionActive).addXref(7, getNightVisionStrength1));
            this.addPatch(new ClassMod.AddMethodPatch(getNightVisionStrength){

                @Override
                public byte[] generateMethod() {
                    return this.buildCode(42, this.reference(180, mc), this.reference(180, thePlayer), this.reference(178, nightVision), this.reference(182, isPotionActive), 153, EntityRendererMod.this.branch("A"), 42, 42, this.reference(180, mc), this.reference(180, thePlayer), 35, this.reference(183, getNightVisionStrength1), 174, EntityRendererMod.this.label("A"), this.push(Float.valueOf(0.0f)), 174);
                }
            });
            this.addPatch(new ClassMod.MakeMemberPublicPatch(this, new FieldRef(this.getDeobfClass(), "torchFlickerX", "F")));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override lightmap";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(77);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 44, 42, this.reference(180, lightmapColors), 35, this.reference(184, new MethodRef("com.prupe.mcpatcher.cc.Lightmap", "computeLightmap", "(LEntityRenderer;LWorld;[IF)Z")), 153, this.branch("A"), 42, this.reference(180, lightmapTexture), this.reference(182, reloadTexture), 42, this.push(0), this.reference(181, needLightmapUpdate), 177, this.label("A"));
                }
            }.setInsertAfter(true).targetMethod(updateLightmap));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override fog color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(1.0f)), 23, BinaryRegex.capture(BinaryRegex.any()), 141, this.push(0.25), this.reference(184, new MethodRef("java/lang/Math", "pow", "(DD)D")), 144, 102, 56, BinaryRegex.backReference(1), BinaryRegex.any(0, 100), 42, BytecodeMatcher.anyALOAD, BytecodeMatcher.anyReference(180), 144, this.reference(181, fogColorBlue));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(45, this.reference(184, setupForFog), 44, 35, this.reference(184, computeFogColor2), 153, this.branch("A"), 42, this.reference(178, setColor), 3, 48, this.reference(181, fogColorRed), 42, this.reference(178, setColor), 4, 48, this.reference(181, fogColorGreen), 42, this.reference(178, setColor), 5, 48, this.reference(181, fogColorBlue), this.label("A"));
                }
            }.setInsertBefore(true).targetMethod(updateFogColor));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override underwater ambient color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.02f)), BinaryRegex.capture(BinaryRegex.optional(BinaryRegex.build(BytecodeMatcher.anyFLOAD, 98))), this.reference(181, fogColorRed), 42, this.push(Float.valueOf(0.02f)), BinaryRegex.backReference(1), this.reference(181, fogColorGreen), 42, this.push(Float.valueOf(0.2f)), BinaryRegex.backReference(1), this.reference(181, fogColorBlue));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, new FieldRef("com.prupe.mcpatcher.cc.Colorizer", "COLOR_MAP_UNDERWATER", "I")), this.reference(184, computeFogColor1), 153, this.branch("A"), 42, this.reference(178, setColor), this.push(0), 48, this.getCaptureGroup(1), this.reference(181, fogColorRed), 42, this.reference(178, setColor), this.push(1), 48, this.getCaptureGroup(1), this.reference(181, fogColorGreen), 42, this.reference(178, setColor), this.push(2), 48, this.getCaptureGroup(1), this.reference(181, fogColorBlue), this.label("A"));
                }
            }.setInsertAfter(true).targetMethod(updateFogColor));
        }
    }

    private class BlockLilyPadMod
    extends Mod.ClassMod {
        private static final int MAGIC = 2129968;

        BlockLilyPadMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, 2129968));
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.5f)));
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.015625f)));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override lily pad color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(2129968));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, getLilyPadColor)});
                }
            });
        }
    }

    private class EntityAuraFXMod
    extends Mod.ClassMod {
        EntityAuraFXMod() {
            super(CustomColors.this);
            this.setParentClass("EntityFX");
            final FieldRef particleRed = new FieldRef(this.getDeobfClass(), "particleRed", "F");
            final FieldRef particleGreen = new FieldRef(this.getDeobfClass(), "particleGreen", "F");
            final FieldRef particleBlue = new FieldRef(this.getDeobfClass(), "particleBlue", "F");
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.02f));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.02f)), this.push(Float.valueOf(0.02f)), BytecodeMatcher.anyReference(182));
                }
            }.matchConstructorOnly(true));
            this.addPatch(new ClassMod.AddMethodPatch(new MethodRef(this.getDeobfClass(), "colorize", "()LEntityAuraFX;")){

                @Override
                public byte[] generateMethod() {
                    return this.buildCode(this.reference(184, computeMyceliumParticleColor), 153, EntityAuraFXMod.this.branch("A"), 42, this.reference(178, setColor), 3, 48, this.reference(181, particleRed), 42, this.reference(178, setColor), 4, 48, this.reference(181, particleGreen), 42, this.reference(178, setColor), 5, 48, this.reference(181, particleBlue), EntityAuraFXMod.this.label("A"), 42, 176);
                }
            });
        }
    }

    private class EntityPortalFXMod
    extends Mod.ClassMod {
        EntityPortalFXMod() {
            super(CustomColors.this);
            this.setParentClass("EntityFX");
            final FieldRef particleBlue = new FieldRef(this.getDeobfClass(), "particleBlue", "F");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 89, 180, BinaryRegex.capture(BinaryRegex.any(2)), this.push(Float.valueOf(0.3f)), 106, 181, BinaryRegex.backReference(1), 42, 89, 180, BinaryRegex.capture(BinaryRegex.any(2)), this.push(Float.valueOf(0.9f)), 106, 181, BinaryRegex.backReference(2));
                }
            }.matchConstructorOnly(true));
            this.addPortalPatch(0.9f, 0, "red");
            this.addPortalPatch(0.3f, 1, "green");
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override portal particle color (blue)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(178, portalColor), 5, 48, this.reference(181, particleBlue));
                }
            }.setInsertBefore(true).matchConstructorOnly(true));
        }

        private void addPortalPatch(final float origValue, final int index, final String color) {
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override portal particle color (" + color + ")";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(origValue)));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, portalColor), this.push(index), 48);
                }
            }.matchConstructorOnly(true));
        }
    }

    private class EntitySuspendFXMod
    extends Mod.ClassMod {
        EntitySuspendFXMod() {
            super(CustomColors.this);
            this.setParentClass("EntityFX");
            final FieldRef particleRed = new FieldRef(this.getDeobfClass(), "particleRed", "F");
            final FieldRef particleGreen = new FieldRef(this.getDeobfClass(), "particleGreen", "F");
            final FieldRef particleBlue = new FieldRef(this.getDeobfClass(), "particleBlue", "F");
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.4f)));
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.7f)));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.01f)), this.push(Float.valueOf(0.01f)), BytecodeMatcher.anyReference(182));
                }
            }.matchConstructorOnly(true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override underwater suspend particle color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.4f)), this.reference(181, particleRed), 42, this.push(Float.valueOf(0.4f)), this.reference(181, particleGreen), 42, this.push(Float.valueOf(0.7f)), this.reference(181, particleBlue));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(0x6666B2), this.reference(178, new FieldRef("com.prupe.mcpatcher.cc.Colorizer", "COLOR_MAP_UNDERWATER", "I")), 40, 142, 24, 4, 142, 24, 6, 142, this.reference(184, colorizeBiome3), this.reference(184, setColorF), 42, this.reference(178, setColor), 3, 48, this.reference(181, particleRed), 42, this.reference(178, setColor), 4, 48, this.reference(181, particleGreen), 42, this.reference(178, setColor), 5, 48, this.reference(181, particleBlue));
                }
            });
        }
    }

    private class EntityBubbleFXMod
    extends WaterFXMod {
        EntityBubbleFXMod() {
            this.setParentClass("EntityFX");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(32), BytecodeMatcher.anyReference(182), 42, this.push(Float.valueOf(0.02f)), this.push(Float.valueOf(0.02f)), BytecodeMatcher.anyReference(182));
                }
            }.matchConstructorOnly(true));
            this.addWaterColorPatch("bubble", new float[]{1.0f, 1.0f, 1.0f});
        }
    }

    private class EntitySplashFXMod
    extends WaterFXMod {
        EntitySplashFXMod() {
            this.setParentClass("EntityRainFX");
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.04f)));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 24, 8, BytecodeMatcher.anyReference(181), 42, 24, 10, this.push(0.1), 99, BytecodeMatcher.anyReference(181), 42, 24, 12, BytecodeMatcher.anyReference(181));
                }
            }.matchConstructorOnly(true));
            this.addWaterColorPatch("splash", null);
        }
    }

    private class EntityDropParticleFXMod
    extends WaterFXMod {
        EntityDropParticleFXMod() {
            this.setParentClass("EntityFX");
            final FieldRef particleRed = new FieldRef(this.getDeobfClass(), "particleRed", "F");
            final FieldRef particleGreen = new FieldRef(this.getDeobfClass(), "particleGreen", "F");
            final FieldRef particleBlue = new FieldRef(this.getDeobfClass(), "particleBlue", "F");
            final FieldRef timer = new FieldRef(this.getDeobfClass(), "timer", "I");
            MethodRef onUpdate = new MethodRef(this.getDeobfClass(), "onUpdate", "()V");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.2f)), BytecodeMatcher.anyReference(181), 42, this.push(Float.valueOf(0.3f)), BytecodeMatcher.anyReference(181), 42, this.push(Float.valueOf(1.0f)), BytecodeMatcher.anyReference(181), BinaryRegex.any(0, 30), this.push(40), 42, BytecodeMatcher.captureReference(180), 100);
                }
            }.setMethod(onUpdate).addXref(1, new FieldRef(this.getDeobfClass(), "timer", "I")));
            this.addWaterColorPatch("water drop", new float[]{0.0f, 0.0f, 1.0f}, new float[]{0.2f, 0.3f, 1.0f});
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "remove water drop color update";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.2f)), this.reference(181, particleRed), 42, this.push(Float.valueOf(0.3f)), this.reference(181, particleGreen), 42, this.push(Float.valueOf(1.0f)), this.reference(181, particleBlue));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[0]);
                }
            }.targetMethod(onUpdate));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override lava drop color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(1.0f)), this.reference(181, particleRed), 42, this.push(Float.valueOf(16.0f)), BinaryRegex.any(0, 20), this.reference(181, particleGreen), 42, this.push(Float.valueOf(4.0f)), BinaryRegex.any(0, 20), this.reference(181, particleBlue));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(40), 42, this.reference(180, timer), 100, this.reference(184, computeLavaDropColor), 153, this.branch("A"), 42, this.reference(178, setColor), 3, 48, this.reference(181, particleRed), 42, this.reference(178, setColor), 4, 48, this.reference(181, particleGreen), 42, this.reference(178, setColor), 5, 48, this.reference(181, particleBlue), 167, this.branch("B"), this.label("A"), this.getMatch(), this.label("B"));
                }
            }.targetMethod(onUpdate));
        }
    }

    private class EntityRainFXMod
    extends WaterFXMod {
        EntityRainFXMod() {
            this.setParentClass("EntityFX");
            final MethodRef random = new MethodRef("java/lang/Math", "random", "()D");
            final MethodRef nextInt = new MethodRef("java/util/Random", "nextInt", "(I)I");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.reference(184, random), 144, this.push(Float.valueOf(0.2f)), 106, this.push(Float.valueOf(0.1f)), 98, 141);
                }
            }.matchConstructorOnly(true));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(19), 42, BytecodeMatcher.anyReference(180), this.push(4), this.reference(182, nextInt), 96);
                }
            }.matchConstructorOnly(true));
            this.addWaterColorPatch("rain drop", new float[]{1.0f, 1.0f, 1.0f}, new float[]{0.2f, 0.3f, 1.0f});
        }
    }

    private abstract class WaterFXMod
    extends Mod.ClassMod {
        private WaterFXMod() {
            super(CustomColors.this);
        }

        void addWaterColorPatch(String name, float[] particleColors) {
            this.addWaterColorPatch(name, particleColors, particleColors);
        }

        void addWaterColorPatch(final String name, final float[] origColors, final float[] newColors) {
            final FieldRef particleRed = new FieldRef(this.getDeobfClass(), "particleRed", "F");
            final FieldRef particleGreen = new FieldRef(this.getDeobfClass(), "particleGreen", "F");
            final FieldRef particleBlue = new FieldRef(this.getDeobfClass(), "particleBlue", "F");
            final FieldRef posX = new FieldRef(this.getDeobfClass(), "posX", "D");
            final FieldRef posY = new FieldRef(this.getDeobfClass(), "posY", "D");
            final FieldRef posZ = new FieldRef(this.getDeobfClass(), "posZ", "D");
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override " + name + " color";
                }

                @Override
                public String getMatchExpression() {
                    if (origColors == null) {
                        return this.buildExpression(177);
                    }
                    return this.buildExpression(42, this.push(Float.valueOf(origColors[0])), this.reference(181, particleRed), 42, this.push(Float.valueOf(origColors[1])), this.reference(181, particleGreen), 42, this.push(Float.valueOf(origColors[2])), this.reference(181, particleBlue));
                }

                @Override
                public byte[] getReplacementBytes() {
                    byte[] byArray;
                    Object[] objectArray = new Object[30];
                    objectArray[0] = 42;
                    objectArray[1] = this.reference(180, posX);
                    objectArray[2] = 42;
                    objectArray[3] = this.reference(180, posY);
                    objectArray[4] = 42;
                    objectArray[5] = this.reference(180, posZ);
                    objectArray[6] = this.reference(184, computeWaterColor1);
                    objectArray[7] = 153;
                    objectArray[8] = this.branch("A");
                    objectArray[9] = 42;
                    objectArray[10] = this.reference(178, waterColor);
                    objectArray[11] = 3;
                    objectArray[12] = 48;
                    objectArray[13] = this.reference(181, particleRed);
                    objectArray[14] = 42;
                    objectArray[15] = this.reference(178, waterColor);
                    objectArray[16] = 4;
                    objectArray[17] = 48;
                    objectArray[18] = this.reference(181, particleGreen);
                    objectArray[19] = 42;
                    objectArray[20] = this.reference(178, waterColor);
                    objectArray[21] = 5;
                    objectArray[22] = 48;
                    objectArray[23] = this.reference(181, particleBlue);
                    objectArray[24] = 167;
                    objectArray[25] = this.branch("B");
                    objectArray[26] = this.label("A");
                    objectArray[27] = newColors == null ? new byte[]{} : this.buildCode(42, this.push(Float.valueOf(newColors[0])), this.reference(181, particleRed), 42, this.push(Float.valueOf(newColors[1])), this.reference(181, particleGreen), 42, this.push(Float.valueOf(newColors[2])), this.reference(181, particleBlue));
                    objectArray[28] = this.label("B");
                    if (origColors == null) {
                        byte[] byArray2 = new byte[1];
                        byArray = byArray2;
                        byArray2[0] = -79;
                    } else {
                        byArray = new byte[]{};
                    }
                    objectArray[29] = byArray;
                    return this.buildCode(objectArray);
                }
            }.matchConstructorOnly(true));
        }
    }

    private class EntityFXMod
    extends Mod.ClassMod {
        EntityFXMod() {
            super(CustomColors.this);
            this.setParentClass("Entity");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.2f)), this.push(Float.valueOf(0.2f)), BytecodeMatcher.anyReference(182));
                }
            }.matchConstructorOnly(true));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 42, 42, 12, 90, BytecodeMatcher.captureReference(181), 90, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, new FieldRef(this.getDeobfClass(), "particleBlue", "F")).addXref(2, new FieldRef(this.getDeobfClass(), "particleGreen", "F")).addXref(3, new FieldRef(this.getDeobfClass(), "particleRed", "F")));
        }
    }

    private class EntityMod
    extends Mod.ClassMod {
        EntityMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "tilecrack_"));
            this.addClassSignature(new ClassMod.OrSignature(this, new ClassMod.ConstSignature(this, "random.splash"), new ClassMod.ConstSignature(this, "liquid.splash")));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 42, 39, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181), 42, 42, 41, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181), 42, 42, 24, 5, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181));
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "setPositionAndRotation", "(DDDFF)V")).addXref(1, new FieldRef(this.getDeobfClass(), "posX", "D")).addXref(2, new FieldRef(this.getDeobfClass(), "prevPosX", "D")).addXref(3, new FieldRef(this.getDeobfClass(), "posY", "D")).addXref(4, new FieldRef(this.getDeobfClass(), "prevPosY", "D")).addXref(5, new FieldRef(this.getDeobfClass(), "posZ", "D")).addXref(6, new FieldRef(this.getDeobfClass(), "prevPosZ", "D")));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "worldObj", "LWorld;")));
        }
    }

    private class WorldChunkManagerMod
    extends Mod.ClassMod {
        WorldChunkManagerMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(21, 4, 21, 5, 104, 188, 6, 76);
                }
            });
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), BinaryRegex.optional(BytecodeMatcher.anyReference(184)), 27, 29, 100, 5, 122, 54, 6);
                }
            });
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, new MethodRef(this.getDeobfClass(), "getBiomeGenAt", "(II)LBiomeGenBase;")));
        }
    }

    private class WorldProviderEndMod
    extends Mod.ClassMod {
        WorldProviderEndMod() {
            super(CustomColors.this);
            this.setParentClass("WorldProvider");
            this.addClassSignature(new ClassMod.OrSignature(this, new ClassMod.ConstSignature(this, 0x8080A0), new ClassMod.ConstSignature(this, 0xA080A0)));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyFLOAD, 141, BytecodeMatcher.anyFLOAD, 141, BytecodeMatcher.anyFLOAD, 141);
                }
            });
            MethodRef getFogColor = new MethodRef(this.getDeobfClass(), "getFogColor", "(FF)LVec3D;");
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override end fog color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyFLOAD, 141, BytecodeMatcher.anyFLOAD, 141, BytecodeMatcher.anyFLOAD, 141);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, endFogColor), 3, 48, 141, this.reference(178, endFogColor), 4, 48, 141, this.reference(178, endFogColor), 5, 48, 141);
                }
            }.targetMethod(getFogColor));
        }
    }

    private class WorldProviderHellMod
    extends Mod.ClassMod {
        private static final double MAGIC1 = (double)0.2f;
        private static final double MAGIC2 = (double)0.03f;

        WorldProviderHellMod() {
            super(CustomColors.this);
            this.setParentClass("WorldProvider");
            MethodRef getFogColor = new MethodRef(this.getDeobfClass(), "getFogColor", "(FF)LVec3D;");
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.2f));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.03f));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(0.2f), this.push(0.03f), this.push(0.03f));
                }
            }.setMethod(getFogColor));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override nether fog color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(0.2f), this.push(0.03f), this.push(0.03f));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, netherFogColor), 3, 48, 141, this.reference(178, netherFogColor), 4, 48, 141, this.reference(178, netherFogColor), 5, 48, 141);
                }
            }.targetMethod(getFogColor));
        }
    }

    private class WorldProviderMod
    extends Mod.ClassMod {
        WorldProviderMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.06f)));
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.09f)));
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.91f)));
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.94f)));
            MethodRef getFogColor = new MethodRef(this.getDeobfClass(), "getFogColor", "(FF)LVec3D;");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(23, BinaryRegex.capture(BinaryRegex.any()), 37, this.push(Float.valueOf(0.94f)), 106, this.push(Float.valueOf(0.06f)), 98, 106, 56, BinaryRegex.backReference(1));
                }
            }.setMethod(getFogColor));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override fog color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(0.7529412f)), 56, BinaryRegex.capture(BinaryRegex.any()), this.push(Float.valueOf(0.84705883f)), 56, BinaryRegex.capture(BinaryRegex.any()), this.push(Float.valueOf(1.0f)), 56, BinaryRegex.capture(BinaryRegex.any()));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, new FieldRef("com.prupe.mcpatcher.cc.Colorizer", "COLOR_MAP_FOG0", "I")), this.reference(184, computeFogColor1), 153, this.branch("A"), this.reference(178, setColor), 3, 48, 56, this.getCaptureGroup(1), this.reference(178, setColor), 4, 48, 56, this.getCaptureGroup(2), this.reference(178, setColor), 5, 48, 56, this.getCaptureGroup(3), 167, this.branch("B"), this.label("A"), this.getMatch(), this.label("B"));
                }
            }.targetMethod(getFogColor));
        }
    }

    private class WorldMod
    extends BaseMod.WorldMod {
        WorldMod() {
            super(CustomColors.this);
            this.setInterfaces("IBlockAccess");
            MethodRef getWorldChunkManager = new MethodRef(this.getDeobfClass(), "getWorldChunkManager", "()LWorldChunkManager;");
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getWorldChunkManager));
            this.addPatch(new ClassMod.BytecodePatch(){
                {
                    super(WorldMod.this);
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(23, BinaryRegex.any(), this.push(Float.valueOf(0.3f)), 106, 23, BinaryRegex.any(), this.push(Float.valueOf(0.59f)), 106, 98, 23, BinaryRegex.any(), this.push(Float.valueOf(0.11f)), 106, 98, this.push(Float.valueOf(0.6f)), 106, 56, BinaryRegex.any());
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "override sky color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(21, BinaryRegex.capture(BinaryRegex.any()), this.push(16), 122, this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()), 21, BinaryRegex.backReference(1), this.push(8), 122, this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()), 21, BinaryRegex.backReference(1), this.push(255), 126, 134, this.push(Float.valueOf(255.0f)), 110, 56, BinaryRegex.capture(BinaryRegex.any()));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, this.reference(184, setupForFog), 42, 36, this.reference(184, computeSkyColor), 153, this.branch("A"), this.reference(178, setColor), 3, 48, 56, this.getCaptureGroup(2), this.reference(178, setColor), 4, 48, 56, this.getCaptureGroup(3), this.reference(178, setColor), 5, 48, 56, this.getCaptureGroup(4), 167, this.branch("B"), this.label("A"), this.getMatch(), this.label("B"));
                }
            });
        }
    }

    private class BlockLeavesMod
    extends Mod.ClassMod {
        private final MethodRef colorMultiplier;

        BlockLeavesMod() {
            super(CustomColors.this);
            this.colorMultiplier = new MethodRef(this.getDeobfClass(), "colorMultiplier", "(LIBlockAccess;III)I");
            MethodRef getFoliageColorPine = new MethodRef("ColorizerFoliage", "getFoliageColorPine", "()I");
            MethodRef getFoliageColorBirch = new MethodRef("ColorizerFoliage", "getFoliageColorBirch", "()I");
            MethodRef getFoliageColor = new MethodRef("BiomeGenBase", "getFoliageColor", "()I");
            InterfaceMethodRef getBlockMetadata = new InterfaceMethodRef("IBlockAccess", "getBlockMetadata", "(III)I");
            InterfaceMethodRef getBiomeGenAt = new InterfaceMethodRef("IBlockAccess", "getBiomeGenAt", "(II)LBiomeGenBase;");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 43, 28, 29, 21, 4, BytecodeMatcher.captureReference(185), 54, 5, 21, 5, BinaryRegex.subset(new byte[]{4, 6}, true), 126, 4, 160, BinaryRegex.any(2), BytecodeMatcher.captureReference(184), 172, 21, 5, BinaryRegex.subset(new byte[]{5, 6}, true), 126, 5, 160, BinaryRegex.any(2), BytecodeMatcher.captureReference(184), 172);
                }
            }.setMethod(this.colorMultiplier).addXref(1, getBlockMetadata).addXref(2, getFoliageColorPine).addXref(3, getFoliageColorBirch));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(43, 28, BytecodeMatcher.anyILOAD, 96, 21, 4, BytecodeMatcher.anyILOAD, 96, BytecodeMatcher.captureReference(185), BytecodeMatcher.captureReference(182));
                }
            }.addXref(1, getBiomeGenAt).addXref(2, getFoliageColor));
            this.addFoliagePatch("PINE", "Pine");
            this.addFoliagePatch("BIRCH", "Birch");
        }

        private void addFoliagePatch(final String index, final String name) {
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override biome " + name.toLowerCase() + " foliage color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("ColorizerFoliage", "getFoliageColor" + name, "()I"))});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, new FieldRef("com.prupe.mcpatcher.cc.Colorizer", "COLOR_MAP_" + index, "I")), 28, 29, 21, 4, this.reference(184, colorizeBiomeWithBlending));
                }
            }.setInsertAfter(true).targetMethod(this.colorMultiplier));
        }
    }

    private class ColorizerFoliageMod
    extends Mod.ClassMod {
        ColorizerFoliageMod() {
            super(CustomColors.this);
            this.setupColor("PINE", 0x619961, "Pine");
            this.setupColor("BIRCH", 8431445, "Birch");
            this.setupColor("FOLIAGE", 4764952, "Basic");
        }

        private void setupColor(final String index, final int color, final String name) {
            this.addClassSignature(new ClassMod.ConstSignature(this, color));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override default " + name.toLowerCase() + " foliage color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.push(color), 172, BinaryRegex.end());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(color), this.reference(178, new FieldRef("com.prupe.mcpatcher.cc.Colorizer", "COLOR_MAP_" + index, "I")), this.reference(184, colorizeBiome2), 172);
                }
            });
        }
    }

    private class PotionHelperMod
    extends Mod.ClassMod {
        private static final int MAGIC = 3694022;

        PotionHelperMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "potion.prefix.mundane"));
            this.addClassSignature(new ClassMod.ConstSignature(this, 3694022));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override water bottle color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.push(3694022), 60);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(184, getWaterBottleColor), 60);
                }
            });
        }
    }

    private class PotionMod
    extends Mod.ClassMod {
        PotionMod() {
            super(CustomColors.this);
            FieldRef potionID = new FieldRef(this.getDeobfClass(), "id", "I");
            FieldRef color = new FieldRef(this.getDeobfClass(), "color", "I");
            FieldRef origColor = new FieldRef(this.getDeobfClass(), "origColor", "I");
            FieldRef potionName = new FieldRef(this.getDeobfClass(), "name", "Ljava/lang/String;");
            MethodRef setPotionName = new MethodRef(this.getDeobfClass(), "setPotionName", "(Ljava/lang/String;)LPotion;");
            this.addClassSignature(new ClassMod.ConstSignature(this, "potion.moveSpeed"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "potion.moveSlowdown"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    if (this.getMethodInfo().getDescriptor().startsWith("(Ljava/lang/String;)")) {
                        return this.buildExpression(BinaryRegex.begin(), 42, 43, BytecodeMatcher.captureReference(181), 42, 176, BinaryRegex.end());
                    }
                    return null;
                }
            }.setMethod(setPotionName).addXref(1, potionName));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 27, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, potionID));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 29, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, color));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(this, potionName));
            this.addPatch(new ClassMod.AddFieldPatch((ClassMod)this, origColor));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(color){

                @Override
                public int getNewFlags(int oldFlags) {
                    return super.getNewFlags(oldFlags) & 0xFFFFFFEF;
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "map potions by name";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 176, BinaryRegex.end());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(184, setupPotion));
                }
            }.setInsertBefore(true).targetMethod(setPotionName));
        }
    }

    private class ItemRendererMod
    extends Mod.ClassMod {
        ItemRendererMod() {
            super(CustomColors.this);
            final FieldRef itemID = new FieldRef("ItemStack", "itemID", "I");
            MethodRef renderItem = new MethodRef(this.getDeobfClass(), "renderItem", "(LEntityLiving;LItemStack;I)V");
            final MethodRef glTranslatef = new MethodRef("org.lwjgl.opengl.GL11", "glTranslatef", "(FFF)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/misc/enchanted_item_glint.png"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/map/map_background.png"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(44, BytecodeMatcher.captureReference(180), BinaryRegex.or(BinaryRegex.build(this.push(256)), BinaryRegex.build(50)), BinaryRegex.any(0, 400), this.push(Float.valueOf(-0.9375f)), this.push(Float.valueOf(-0.0625f)), 11, this.reference(184, glTranslatef));
                }
            }.addXref(1, itemID).setMethod(renderItem));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override water block color in third person";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(-0.9375f)), this.push(Float.valueOf(-0.0625f)), 11, this.reference(184, glTranslatef));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(44, 198, this.branch("A"), 44, this.reference(180, itemID), this.reference(184, colorizeWaterBlockGL), this.label("A"));
                }
            }.setInsertAfter(true).targetMethod(renderItem));
        }
    }

    private class ItemBlockMod
    extends Mod.ClassMod {
        ItemBlockMod() {
            super(CustomColors.this);
            final FieldRef blockID = new FieldRef(this.getDeobfClass(), "blockID", "I");
            this.setParentClass("Item");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 27, this.push(256), 96, BytecodeMatcher.anyReference(181));
                }
            }.matchConstructorOnly(true));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, blockID).accessFlag(2, true));
            this.addPatch(new ClassMod.AddMethodPatch(new MethodRef(this.getDeobfClass(), getColorFromDamage.getName(), getColorFromDamage.getType())){

                @Override
                public byte[] generateMethod() {
                    return this.buildCode(42, 43, 28, this.reference(183, getColorFromDamage), 42, this.reference(180, blockID), 28, this.reference(184, getItemColorFromDamage), 172);
                }
            });
        }
    }

    private class ItemMod
    extends BaseMod.ItemMod {
        ItemMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.push(0xFFFFFF), 172, BinaryRegex.end());
                }
            }.setMethod(getColorFromDamage));
        }
    }

    private class BlockFluidMod
    extends Mod.ClassMod {
        BlockFluidMod() {
            super(CustomColors.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "splash"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "liquid.water"));
            MethodRef colorMultiplier = new MethodRef(this.getDeobfClass(), "colorMultiplier", "(LIBlockAccess;III)I");
            final FieldRef waterColorMultiplier = new FieldRef("BiomeGenBase", "waterColorMultiplier", "I");
            final MethodRef getWaterColorMultiplier = new MethodRef("BiomeGenBase", "getWaterColorMultiplier", "()I");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(43, 28, BytecodeMatcher.anyILOAD, 96, 21, 4, BytecodeMatcher.anyILOAD, 96, BytecodeMatcher.anyReference(185), BytecodeMatcher.captureReference(180));
                }
            }.setMethod(colorMultiplier).addXref(1, waterColorMultiplier));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override water color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.reference(185, new InterfaceMethodRef("IBlockAccess", "getBiomeGenAt", "(II)LBiomeGenBase;")), BinaryRegex.or(BinaryRegex.build(new Object[]{this.reference(180, waterColorMultiplier)}), BinaryRegex.build(new Object[]{this.reference(182, getWaterColorMultiplier)})));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, colorizeWater)});
                }
            }.targetMethod(colorMultiplier));
        }
    }

    private class BiomeGenSwampMod
    extends Mod.ClassMod {
        private static final int MAGIC1 = 0xFEFEFE;
        private static final int MAGIC2 = 0x4E0E4E;
        private static final int MAGIC3_A = 14745456;
        private static final int MAGIC3_B = 14745518;

        BiomeGenSwampMod() {
            super(CustomColors.this);
            this.setParentClass("BiomeGenBase");
            this.addClassSignature(new ClassMod.ConstSignature(this, 0xFEFEFE));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0x4E0E4E));
            this.addClassSignature(new ClassMod.OrSignature(this, new ClassMod.ConstSignature(this, 14745456), new ClassMod.ConstSignature(this, 14745518)));
            this.addSwampColorPatch("SWAMP_GRASS", "Grass");
            this.addSwampColorPatch("SWAMP_FOLIAGE", "Foliage");
        }

        private void addSwampColorPatch(final String index, final String name) {
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override swamp " + name.toLowerCase() + " color";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(172);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, new FieldRef("com.prupe.mcpatcher.cc.Colorizer", "COLOR_MAP_" + index, "I")), 39, 41, this.reference(184, colorizeBiome1), 172);
                }
            }.targetMethod(new MethodRef(this.getDeobfClass(), "get" + name + "Color", "()I")));
        }
    }

    private class BiomeGenBaseMod
    extends Mod.ClassMod {
        BiomeGenBaseMod() {
            super(CustomColors.this);
            FieldRef waterColorMultiplier = new FieldRef(this.getDeobfClass(), "waterColorMultiplier", "I");
            FieldRef biomeID = new FieldRef(this.getDeobfClass(), "biomeID", "I");
            FieldRef temperature = new FieldRef(this.getDeobfClass(), "temperature", "F");
            FieldRef rainfall = new FieldRef(this.getDeobfClass(), "rainfall", "F");
            MethodRef getGrassColor = new MethodRef(this.getDeobfClass(), "getGrassColor", "()I");
            MethodRef getFoliageColor = new MethodRef(this.getDeobfClass(), "getFoliageColor", "()I");
            FieldRef color = new FieldRef(this.getDeobfClass(), "color", "I");
            FieldRef biomeName = new FieldRef(this.getDeobfClass(), "biomeName", "Ljava/lang/String;");
            MethodRef setBiomeName = new MethodRef(this.getDeobfClass(), "setBiomeName", "(Ljava/lang/String;)LBiomeGenBase;");
            this.addClassSignature(new ClassMod.ConstSignature(this, "Ocean"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Plains"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Desert"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(0xFFFFFF), BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, waterColorMultiplier));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 27, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, biomeID));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(Float.valueOf(0.5f)), BytecodeMatcher.captureReference(181), 42, this.push(Float.valueOf(0.5f)), BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, temperature).addXref(2, rainfall));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 43, BytecodeMatcher.captureReference(181), 42, 176, BinaryRegex.end());
                }
            }.setMethod(setBiomeName).addXref(1, biomeName));
            MethodRef getTemperaturef = new MethodRef(this.getDeobfClass(), "getTemperaturef", "()F");
            MethodRef getRainfallf = new MethodRef(this.getDeobfClass(), "getRainfallf", "()F");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.captureReference(182), this.push(Float.valueOf(0.0f)), this.push(Float.valueOf(1.0f)), BytecodeMatcher.anyReference(184), 141, 72, 42, BytecodeMatcher.captureReference(182), this.push(Float.valueOf(0.0f)), this.push(Float.valueOf(1.0f)), BytecodeMatcher.anyReference(184), 141, 74, 39, 41, BytecodeMatcher.anyReference(184), 172);
                }
            }.addXref(1, getTemperaturef).addXref(2, getRainfallf));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getGrassColor, getFoliageColor).accessFlag(1, true).accessFlag(8, false).accessFlag(16, false));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, color).accessFlag(1, true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "map biomes by name";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 176, BinaryRegex.end());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(184, setupBiome));
                }
            }.setInsertBefore(true).targetMethod(setBiomeName));
        }
    }

    private class BlockMod
    extends BaseMod.BlockMod {
        BlockMod() {
            super(CustomColors.this);
            MethodRef getRenderColor = new MethodRef(this.getDeobfClass(), "getRenderColor", "(I)I");
            MethodRef colorMultiplier = new MethodRef(this.getDeobfClass(), "colorMultiplier", "(LIBlockAccess;III)I");
            final InterfaceMethodRef getBlockMetadata = new InterfaceMethodRef("IBlockAccess", "getBlockMetadata", "(III)I");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), this.push(0xFFFFFF), 172, BinaryRegex.end());
                }
            }.setMethod(getRenderColor));
            this.addBlockSignature("cauldron");
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override color multiplier for all blocks";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(0xFFFFFF));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 28, 29, 21, 4, 43, 28, 29, 21, 4, this.reference(185, getBlockMetadata), this.reference(184, colorizeBlock4Int));
                }
            }.targetMethod(colorMultiplier));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override default color for all blocks";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(0xFFFFFF));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(184, colorizeBlock));
                }
            }.targetMethod(getRenderColor));
        }
    }

    private class ConfigPanel
    extends ModConfigPanel {
        private JCheckBox waterCheckBox;
        private JCheckBox swampCheckBox;
        private JCheckBox treeCheckBox;
        private JCheckBox potionCheckBox;
        private JCheckBox particleCheckBox;
        private JPanel panel;
        private JCheckBox lightmapCheckBox;
        private JCheckBox redstoneCheckBox;
        private JCheckBox stemCheckBox;
        private JCheckBox otherBlockCheckBox;
        private JCheckBox eggCheckBox;
        private JCheckBox fogCheckBox;
        private JCheckBox cloudsCheckBox;
        private JCheckBox mapCheckBox;
        private JCheckBox dyeCheckBox;
        private JSpinner fogBlendRadiusSpinner;
        private JSpinner blockBlendRadiusSpinner;
        private JCheckBox textCheckBox;
        private JCheckBox xpOrbCheckBox;

        ConfigPanel() {
            this.$$$setupUI$$$();
            this.waterCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "water", ConfigPanel.this.waterCheckBox.isSelected());
                }
            });
            this.swampCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "swamp", ConfigPanel.this.swampCheckBox.isSelected());
                }
            });
            this.treeCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "tree", ConfigPanel.this.treeCheckBox.isSelected());
                }
            });
            this.potionCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "potion", ConfigPanel.this.potionCheckBox.isSelected());
                }
            });
            this.particleCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "particle", ConfigPanel.this.particleCheckBox.isSelected());
                }
            });
            this.lightmapCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "lightmaps", ConfigPanel.this.lightmapCheckBox.isSelected());
                }
            });
            this.cloudsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "clouds", ConfigPanel.this.cloudsCheckBox.isSelected());
                }
            });
            this.redstoneCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "redstone", ConfigPanel.this.redstoneCheckBox.isSelected());
                }
            });
            this.stemCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "stem", ConfigPanel.this.stemCheckBox.isSelected());
                }
            });
            this.eggCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "egg", ConfigPanel.this.eggCheckBox.isSelected());
                }
            });
            this.mapCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "map", ConfigPanel.this.mapCheckBox.isSelected());
                }
            });
            this.dyeCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "dye", ConfigPanel.this.dyeCheckBox.isSelected());
                }
            });
            this.fogCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "fog", ConfigPanel.this.fogCheckBox.isSelected());
                }
            });
            this.otherBlockCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "otherBlocks", ConfigPanel.this.otherBlockCheckBox.isSelected());
                }
            });
            this.textCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "text", ConfigPanel.this.textCheckBox.isSelected());
                }
            });
            this.xpOrbCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Colors", "xporb", ConfigPanel.this.xpOrbCheckBox.isSelected());
                }
            });
            this.fogBlendRadiusSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = 7;
                    try {
                        value = Integer.parseInt(ConfigPanel.this.fogBlendRadiusSpinner.getValue().toString());
                        value = Math.min(Math.max(0, value), 99);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Config.set("Custom Colors", "fogBlendRadius", value);
                    ConfigPanel.this.fogBlendRadiusSpinner.setValue(value);
                }
            });
            this.blockBlendRadiusSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = 1;
                    try {
                        value = Integer.parseInt(ConfigPanel.this.blockBlendRadiusSpinner.getValue().toString());
                        value = Math.min(Math.max(0, value), 99);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    Config.set("Custom Colors", "blockBlendRadius", value);
                    ConfigPanel.this.blockBlendRadiusSpinner.setValue(value);
                }
            });
        }

        @Override
        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public void load() {
            this.waterCheckBox.setSelected(Config.getBoolean("Custom Colors", "water", true));
            this.swampCheckBox.setSelected(Config.getBoolean("Custom Colors", "swamp", true));
            this.treeCheckBox.setSelected(Config.getBoolean("Custom Colors", "tree", true));
            this.potionCheckBox.setSelected(Config.getBoolean("Custom Colors", "potion", true));
            this.particleCheckBox.setSelected(Config.getBoolean("Custom Colors", "particle", true));
            this.lightmapCheckBox.setSelected(Config.getBoolean("Custom Colors", "lightmaps", true));
            this.cloudsCheckBox.setSelected(Config.getBoolean("Custom Colors", "clouds", true));
            this.redstoneCheckBox.setSelected(Config.getBoolean("Custom Colors", "redstone", true));
            this.stemCheckBox.setSelected(Config.getBoolean("Custom Colors", "stem", true));
            this.eggCheckBox.setSelected(Config.getBoolean("Custom Colors", "egg", true));
            this.mapCheckBox.setSelected(Config.getBoolean("Custom Colors", "map", true));
            this.dyeCheckBox.setSelected(Config.getBoolean("Custom Colors", "dye", true));
            this.fogCheckBox.setSelected(Config.getBoolean("Custom Colors", "fog", true));
            this.otherBlockCheckBox.setSelected(Config.getBoolean("Custom Colors", "otherBlocks", true));
            this.textCheckBox.setSelected(Config.getBoolean("Custom Colors", "text", true));
            this.xpOrbCheckBox.setSelected(Config.getBoolean("Custom Colors", "xporb", true));
            this.fogBlendRadiusSpinner.setValue(Config.getInt("Custom Colors", "fogBlendRadius", 7));
            this.blockBlendRadiusSpinner.setValue(Config.getInt("Custom Colors", "blockBlendRadius", 1));
        }

        @Override
        public void save() {
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JSpinner jSpinner;
            JSpinner jSpinner2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JCheckBox jCheckBox6;
            JCheckBox jCheckBox7;
            JCheckBox jCheckBox8;
            JCheckBox jCheckBox9;
            JCheckBox jCheckBox10;
            JCheckBox jCheckBox11;
            JCheckBox jCheckBox12;
            JCheckBox jCheckBox13;
            JCheckBox jCheckBox14;
            JCheckBox jCheckBox15;
            JCheckBox jCheckBox16;
            JPanel jPanel;
            this.panel = jPanel = new JPanel();
            jPanel.setLayout(new GridLayoutManager(16, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.waterCheckBox = jCheckBox16 = new JCheckBox();
            jCheckBox16.setToolTipText("");
            jCheckBox16.setText("Water");
            jPanel.add((Component)jCheckBox16, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.swampCheckBox = jCheckBox15 = new JCheckBox();
            jCheckBox15.setToolTipText("");
            jCheckBox15.setText("Swamp grass and foliage");
            jPanel.add((Component)jCheckBox15, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.potionCheckBox = jCheckBox14 = new JCheckBox();
            jCheckBox14.setToolTipText("");
            jCheckBox14.setText("Potions");
            jPanel.add((Component)jCheckBox14, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.particleCheckBox = jCheckBox13 = new JCheckBox();
            jCheckBox13.setToolTipText("");
            jCheckBox13.setText("Particle effects");
            jPanel.add((Component)jCheckBox13, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.treeCheckBox = jCheckBox12 = new JCheckBox();
            jCheckBox12.setToolTipText("");
            jCheckBox12.setText("Pine and birch trees");
            jPanel.add((Component)jCheckBox12, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.lightmapCheckBox = jCheckBox11 = new JCheckBox();
            jCheckBox11.setToolTipText("");
            jCheckBox11.setText("Lighting");
            jPanel.add((Component)jCheckBox11, new GridConstraints(6, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.redstoneCheckBox = jCheckBox10 = new JCheckBox();
            jCheckBox10.setToolTipText("");
            jCheckBox10.setText("Redstone wiring and particle effects");
            jPanel.add((Component)jCheckBox10, new GridConstraints(8, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Allow texture packs to customize the following colors:");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.stemCheckBox = jCheckBox9 = new JCheckBox();
            jCheckBox9.setText("Pumpkin and melon stems");
            jPanel.add((Component)jCheckBox9, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.eggCheckBox = jCheckBox8 = new JCheckBox();
            jCheckBox8.setText("Creative Mode spawner eggs");
            jPanel.add((Component)jCheckBox8, new GridConstraints(10, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.cloudsCheckBox = jCheckBox7 = new JCheckBox();
            jCheckBox7.setText("Cloud type");
            jPanel.add((Component)jCheckBox7, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.mapCheckBox = jCheckBox6 = new JCheckBox();
            jCheckBox6.setText("Held maps");
            jPanel.add((Component)jCheckBox6, new GridConstraints(11, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.dyeCheckBox = jCheckBox5 = new JCheckBox();
            jCheckBox5.setText("Sheep and dyes");
            jPanel.add((Component)jCheckBox5, new GridConstraints(12, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayoutManager(2, 6, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(15, 0, 1, 1, 0, 3, 3, 3, null, null, null, 0, true));
            this.fogCheckBox = jCheckBox4 = new JCheckBox();
            jCheckBox4.setText("Fog and sky");
            jPanel2.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.otherBlockCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setText("Other blocks");
            jPanel2.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Blend radius:");
            jPanel2.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel3 = new JLabel();
            jLabel3.setText("Blend radius:");
            jPanel2.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel2.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel2.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
            this.fogBlendRadiusSpinner = jSpinner2 = new JSpinner();
            jPanel2.add((Component)jSpinner2, new GridConstraints(0, 3, 1, 1, 8, 1, 6, 0, null, null, null));
            this.blockBlendRadiusSpinner = jSpinner = new JSpinner();
            jPanel2.add((Component)jSpinner, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            jLabel4.setText("blocks");
            jPanel2.add((Component)jLabel4, new GridConstraints(0, 4, 1, 1, 8, 0, 0, 0, null, null, null));
            JLabel jLabel5 = new JLabel();
            jLabel5.setText("blocks");
            jPanel2.add((Component)jLabel5, new GridConstraints(1, 4, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer3 = new Spacer();
            jPanel2.add((Component)spacer3, new GridConstraints(0, 5, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer4 = new Spacer();
            jPanel2.add((Component)spacer4, new GridConstraints(1, 5, 1, 1, 0, 1, 6, 1, null, null, null));
            this.textCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("Text");
            jPanel.add((Component)jCheckBox2, new GridConstraints(13, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.xpOrbCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("XP orbs");
            jPanel.add((Component)jCheckBox, new GridConstraints(14, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

