/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mob;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.WeightedIndex;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.src.ResourceAddress;

class MobRuleList {
    private static final MCLogger logger = MCLogger.getLogger("Random Mobs");
    public static final String ALTERNATIVES_REGEX = "_(eyes|overlay|tame|angry|collar|fur|invulnerable|shooting)\\.properties$";
    private static final Map<ResourceAddress, MobRuleList> allRules = new HashMap<ResourceAddress, MobRuleList>();
    private final ResourceAddress baseSkin;
    private final List<ResourceAddress> allSkins;
    private final int skinCount;
    private final List<MobRuleEntry> entries;

    private MobRuleList(ResourceAddress baseSkin) {
        ResourceAddress skin;
        this.baseSkin = baseSkin;
        String newPath = baseSkin.getPath().replaceFirst("^textures/entity/", "mcpatcher/mob/");
        ResourceAddress newSkin = new ResourceAddress(baseSkin.getNamespace(), newPath);
        this.allSkins = new ArrayList<ResourceAddress>();
        this.allSkins.add(baseSkin);
        int i = 2;
        while (TexturePackAPI.hasResource(skin = TexturePackAPI.transformResourceAddress(newSkin, ".png", String.valueOf(i) + ".png"))) {
            this.allSkins.add(skin);
            ++i;
        }
        this.skinCount = this.allSkins.size();
        if (this.skinCount <= 1) {
            this.entries = null;
            return;
        }
        logger.fine("found %d variations for %s", this.skinCount, baseSkin);
        ResourceAddress filename = TexturePackAPI.transformResourceAddress(newSkin, ".png", ".properties");
        ResourceAddress altFilename = new ResourceAddress(newSkin.getNamespace(), filename.getPath().replaceFirst(ALTERNATIVES_REGEX, ".properties"));
        Properties properties = TexturePackAPI.getProperties(filename);
        if (properties == null && !filename.equals(altFilename) && (properties = TexturePackAPI.getProperties(altFilename)) != null) {
            logger.fine("using %s for %s", altFilename, baseSkin);
        }
        ArrayList<MobRuleEntry> tmpEntries = new ArrayList<MobRuleEntry>();
        if (properties != null) {
            int i2 = 0;
            while (true) {
                MobRuleEntry entry;
                if ((entry = MobRuleEntry.load(properties, i2, this.skinCount)) == null) {
                    if (i2 > 0) {
                        break;
                    }
                } else {
                    logger.fine("  %s", entry.toString());
                    tmpEntries.add(entry);
                }
                ++i2;
            }
        }
        this.entries = tmpEntries.isEmpty() ? null : tmpEntries;
    }

    ResourceAddress getSkin(long key, int i, int j, int k, String biome) {
        if (this.entries == null) {
            int index = (int)(key % (long)this.skinCount);
            if (index < 0) {
                index += this.skinCount;
            }
            return this.allSkins.get(index);
        }
        for (MobRuleEntry entry : this.entries) {
            if (!entry.match(i, j, k, biome)) continue;
            int index = entry.weightedIndex.choose(key);
            return this.allSkins.get(entry.skins[index]);
        }
        return this.baseSkin;
    }

    static MobRuleList get(ResourceAddress texture) {
        MobRuleList list = allRules.get(texture);
        if (list == null) {
            list = new MobRuleList(texture);
            allRules.put(texture, list);
        }
        return list;
    }

    static void clear() {
        allRules.clear();
    }

    private static class MobRuleEntry {
        final int[] skins;
        final WeightedIndex weightedIndex;
        private final Set<String> biomes;
        private final int minHeight;
        private final int maxHeight;

        static MobRuleEntry load(Properties properties, int index, int limit) {
            WeightedIndex chooser;
            int i;
            int[] skins;
            String skinList = properties.getProperty("skins." + index, "").trim().toLowerCase();
            if (skinList.equals("*") || skinList.equals("all") || skinList.equals("any")) {
                skins = new int[limit];
                for (i = 0; i < skins.length; ++i) {
                    skins[i] = i;
                }
            } else {
                skins = MCPatcherUtils.parseIntegerList(skinList, 1, limit);
                if (skins.length <= 0) {
                    return null;
                }
                i = 0;
                while (i < skins.length) {
                    int n = i++;
                    skins[n] = skins[n] - 1;
                }
            }
            if ((chooser = WeightedIndex.create(skins.length, properties.getProperty("weights." + index, ""))) == null) {
                return null;
            }
            HashSet<String> biomes = new HashSet<String>();
            String biomeList = properties.getProperty("biomes." + index, "").trim().toLowerCase();
            if (!biomeList.equals("")) {
                Collections.addAll(biomes, biomeList.split("\\s+"));
            }
            if (biomes.isEmpty()) {
                biomes = null;
            }
            int minHeight = MCPatcherUtils.getIntProperty(properties, "minHeight." + index, -1);
            int maxHeight = MCPatcherUtils.getIntProperty(properties, "maxHeight." + index, Integer.MAX_VALUE);
            if (minHeight < 0 || minHeight > maxHeight) {
                minHeight = -1;
                maxHeight = Integer.MAX_VALUE;
            }
            return new MobRuleEntry(skins, chooser, biomes, minHeight, maxHeight);
        }

        MobRuleEntry(int[] skins, WeightedIndex weightedIndex, HashSet<String> biomes, int minHeight, int maxHeight) {
            this.skins = skins;
            this.weightedIndex = weightedIndex;
            this.biomes = biomes;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
        }

        boolean match(int i, int j, int k, String biome) {
            if (this.biomes != null && !this.biomes.contains(biome)) {
                return false;
            }
            return this.minHeight < 0 || j >= this.minHeight && j <= this.maxHeight;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("skins:");
            for (int i : this.skins) {
                sb.append(' ').append(i + 1);
            }
            if (this.biomes != null) {
                sb.append(", biomes:");
                for (String s : this.biomes) {
                    sb.append(' ').append(s);
                }
            }
            if (this.minHeight >= 0) {
                sb.append(", height: ").append(this.minHeight).append('-').append(this.maxHeight);
            }
            sb.append(", weights: ").append(this.weightedIndex.toString());
            return sb.toString();
        }
    }
}

