/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mob;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.TexturePackChangeHandler;
import com.prupe.mcpatcher.mob.LineRenderer;
import com.prupe.mcpatcher.mob.MobOverlay;
import com.prupe.mcpatcher.mob.MobRuleList;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.ResourceAddress;

public class MobRandomizer {
    private static final MCLogger logger = MCLogger.getLogger("Random Mobs");
    private static final LinkedHashMap<String, ResourceAddress> cache = new LinkedHashMap();

    public static ResourceAddress randomTexture(EntityLiving entity, ResourceAddress texture) {
        if (texture == null || !texture.getPath().endsWith(".png")) {
            return texture;
        }
        String key = texture.toString() + ":" + entity.entityId;
        ResourceAddress newTexture = cache.get(key);
        if (newTexture == null) {
            ExtraInfo info = ExtraInfo.getInfo(entity);
            MobRuleList list = MobRuleList.get(texture);
            newTexture = list.getSkin(info.skin, info.origX, info.origY, info.origZ, info.origBiome);
            cache.put(key, newTexture);
            logger.finer("entity %s using %s (cache: %d)", entity, newTexture, cache.size());
            if (cache.size() > 250) {
                while (cache.size() > 200) {
                    cache.remove(cache.keySet().iterator().next());
                }
            }
        }
        return newTexture;
    }

    public static ResourceAddress randomTexture(Entity entity, ResourceAddress texture) {
        if (entity instanceof EntityLiving) {
            return MobRandomizer.randomTexture((EntityLiving)entity, texture);
        }
        return texture;
    }

    static {
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Random Mobs", 2){

            @Override
            public void beforeChange() {
                cache.clear();
            }

            @Override
            public void afterChange() {
                MobRuleList.clear();
                MobOverlay.reset();
                LineRenderer.reset();
            }
        });
    }

    public static final class ExtraInfo {
        private static final String SKIN_TAG = "randomMobsSkin";
        private static final String ORIG_X_TAG = "origX";
        private static final String ORIG_Y_TAG = "origY";
        private static final String ORIG_Z_TAG = "origZ";
        private static final long MULTIPLIER = 25214903917L;
        private static final long ADDEND = 11L;
        private static final long MASK = 0xFFFFFFFFFFFFL;
        private static Method getBiomeNameAt;
        private static final HashMap<Integer, ExtraInfo> allInfo;
        private static final HashMap<WeakReference<EntityLiving>, ExtraInfo> allRefs;
        private static final ReferenceQueue<EntityLiving> refQueue;
        private final int entityId;
        private final HashSet<WeakReference<EntityLiving>> references;
        private final long skin;
        private final int origX;
        private final int origY;
        private final int origZ;
        private String origBiome;

        ExtraInfo(EntityLiving entity) {
            this(entity, ExtraInfo.getSkinId(entity.entityId), (int)entity.posX, (int)entity.posY, (int)entity.posZ);
        }

        ExtraInfo(EntityLiving entity, long skin, int origX, int origY, int origZ) {
            this.entityId = entity.entityId;
            this.references = new HashSet();
            this.skin = skin;
            this.origX = origX;
            this.origY = origY;
            this.origZ = origZ;
        }

        private void setBiome() {
            if (this.origBiome == null && getBiomeNameAt != null) {
                try {
                    this.origBiome = (String)getBiomeNameAt.invoke(null, this.origX, this.origY, this.origZ);
                }
                catch (Throwable e) {
                    getBiomeNameAt = null;
                    e.printStackTrace();
                }
            }
        }

        public String toString() {
            return String.format("%s{%d, %d, %d, %d, %d, %s}", this.getClass().getSimpleName(), this.entityId, this.skin, this.origX, this.origY, this.origZ, this.origBiome);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void clearUnusedReferences() {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                Reference<EntityLiving> ref;
                while ((ref = refQueue.poll()) != null) {
                    ExtraInfo info = allRefs.get(ref);
                    if (info != null) {
                        info.references.remove(ref);
                        if (info.references.isEmpty()) {
                            logger.finest("removing unused ref %d", info.entityId);
                            allInfo.remove(info.entityId);
                        }
                    }
                    allRefs.remove(ref);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static ExtraInfo getInfo(EntityLiving entity) {
            ExtraInfo info;
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                ExtraInfo.clearUnusedReferences();
                info = allInfo.get(entity.entityId);
                if (info == null) {
                    info = new ExtraInfo(entity);
                    ExtraInfo.putInfo(entity, info);
                }
                boolean found = false;
                for (WeakReference<EntityLiving> ref : info.references) {
                    if (ref.get() != entity) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    WeakReference<EntityLiving> reference = new WeakReference<EntityLiving>(entity, refQueue);
                    info.references.add(reference);
                    allRefs.put(reference, info);
                    logger.finest("added ref #%d for %d (%d entities)", info.references.size(), entity.entityId, allInfo.size());
                }
                info.setBiome();
            }
            return info;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void putInfo(EntityLiving entity, ExtraInfo info) {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                allInfo.put(entity.entityId, info);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void clearInfo() {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                allInfo.clear();
            }
        }

        private static long getSkinId(int entityId) {
            long n = entityId;
            n = n ^ n << 16 ^ n << 32 ^ n << 48;
            n = 25214903917L * n + 11L;
            n = 25214903917L * n + 11L;
            return (n &= 0xFFFFFFFFFFFFL) >> 32 ^ n;
        }

        public static void readFromNBT(EntityLiving entity, NBTTagCompound nbt) {
            long skin = nbt.getLong(SKIN_TAG);
            if (skin != 0L) {
                int x = nbt.getInteger(ORIG_X_TAG);
                int y = nbt.getInteger(ORIG_Y_TAG);
                int z = nbt.getInteger(ORIG_Z_TAG);
                ExtraInfo.putInfo(entity, new ExtraInfo(entity, skin, x, y, z));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void writeToNBT(EntityLiving entity, NBTTagCompound nbt) {
            HashMap<Integer, ExtraInfo> hashMap = allInfo;
            synchronized (hashMap) {
                ExtraInfo info = allInfo.get(entity.entityId);
                if (info != null) {
                    nbt.setLong(SKIN_TAG, info.skin);
                    nbt.setInteger(ORIG_X_TAG, info.origX);
                    nbt.setInteger(ORIG_Y_TAG, info.origY);
                    nbt.setInteger(ORIG_Z_TAG, info.origZ);
                }
            }
        }

        static {
            allInfo = new HashMap();
            allRefs = new HashMap();
            refQueue = new ReferenceQueue();
            try {
                Class<?> biomeHelperClass = Class.forName("com.prupe.mcpatcher.cc.BiomeHelper");
                getBiomeNameAt = biomeHelperClass.getDeclaredMethod("getBiomeNameAt", Integer.TYPE, Integer.TYPE, Integer.TYPE);
                getBiomeNameAt.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (getBiomeNameAt == null) {
                logger.warning("biome integration failed", new Object[0]);
            } else {
                logger.fine("biome integration active", new Object[0]);
            }
        }
    }
}

