/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.TexturePackAPI;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.src.ResourceAddress;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class MipmapHelper {
    private static final MCLogger logger = MCLogger.getLogger("Mipmap");
    private static final ResourceAddress MIPMAP_PROPERTIES = TexturePackAPI.newMCPatcherResourceAddress("mipmap.properties");
    private static final int TEX_FORMAT = 32993;
    private static final int TEX_DATA_TYPE = 33639;
    private static final int MIN_ALPHA = 26;
    private static final int MAX_ALPHA = 229;
    private static final boolean mipmapSupported;
    static final boolean mipmapEnabled;
    static final int maxMipmapLevel;
    private static final boolean useMipmap;
    private static final int mipmapAlignment;
    private static final boolean anisoSupported;
    static final int anisoLevel;
    private static final int anisoMax;
    private static final boolean lodSupported;
    private static final int lodBias;
    private static final Map<String, Reference<BufferedImage>> imagePool;
    private static final Map<Integer, Reference<ByteBuffer>> bufferPool;
    private static final Map<String, Boolean> mipmapType;

    private static void setupTexture(int width, int height, boolean blur, boolean clamp, String textureName) {
        int wrap;
        int mipmaps = MipmapHelper.useMipmapsForTexture(textureName) ? MipmapHelper.getMipmapLevels(width, height, 1) : 0;
        logger.finer("setupTexture(%s) %dx%d %d mipmaps", textureName, width, height, mipmaps);
        int magFilter = blur ? 9729 : 9728;
        int minFilter = mipmaps > 0 ? 9986 : magFilter;
        int n = wrap = clamp ? 10496 : 10497;
        if (mipmaps > 0) {
            GL11.glTexParameteri((int)3553, (int)33085, (int)mipmaps);
            MipmapHelper.checkGLError("%s: set GL_TEXTURE_MAX_LEVEL = %d", textureName, mipmaps);
            if (anisoSupported && anisoLevel > 1) {
                GL11.glTexParameterf((int)3553, (int)34046, (float)anisoLevel);
                MipmapHelper.checkGLError("%s: set GL_TEXTURE_MAX_ANISOTROPY_EXT = %f", textureName, anisoLevel);
            }
            if (lodSupported) {
                GL11.glTexEnvi((int)34048, (int)34049, (int)lodBias);
                MipmapHelper.checkGLError("%s: set GL_TEXTURE_LOD_BIAS_EXT = %d", textureName, lodBias);
            }
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)minFilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wrap);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wrap);
        for (int level = 0; level <= mipmaps; ++level) {
            GL11.glTexImage2D((int)3553, (int)level, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)null);
            MipmapHelper.checkGLError("%s: glTexImage2D %dx%d level %d", textureName, width, height, level);
            width >>= 1;
            height >>= 1;
        }
    }

    public static void setupTexture(int[] rgb, int width, int height, int x, int y, boolean blur, boolean clamp, String textureName) {
        MipmapHelper.setupTexture(width, height, blur, clamp, textureName);
        MipmapHelper.copySubTexture(rgb, width, height, x, y, textureName);
    }

    public static int setupTexture(int glTexture, BufferedImage image, boolean blur, boolean clamp, ResourceAddress textureName) {
        int width = image.getWidth();
        int height = image.getHeight();
        GL11.glBindTexture((int)3553, (int)glTexture);
        logger.finer("setupTexture(%s, %d, %dx%d, %s, %s)", textureName, glTexture, width, height, blur, clamp);
        int[] rgb = new int[width * height];
        image.getRGB(0, 0, width, height, rgb, 0, width);
        MipmapHelper.setupTexture(rgb, width, height, 0, 0, blur, clamp, textureName.getPath());
        return glTexture;
    }

    public static void setupTexture(int glTexture, int width, int height, String textureName) {
        GL11.glBindTexture((int)3553, (int)glTexture);
        logger.finer("setupTexture(tilesheet %s, %d, %dx%d)", textureName, glTexture, width, height);
        MipmapHelper.setupTexture(width, height, false, false, textureName);
    }

    public static void copySubTexture(int[] rgb, int width, int height, int x, int y, String textureName) {
        IntBuffer buffer = MipmapHelper.getPooledBuffer(width * height * 4).asIntBuffer();
        buffer.put(rgb).position(0);
        int mipmaps = MipmapHelper.getMipmapLevelsForCurrentTexture();
        logger.finest("copySubTexture %s %d,%d %dx%d %d mipmaps", textureName, x, y, width, height, mipmaps);
        int level = 0;
        while (width > 0 && height > 0) {
            GL11.glTexSubImage2D((int)3553, (int)level, (int)x, (int)y, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)buffer);
            MipmapHelper.checkGLError("%s: glTexSubImage2D(%d, %d, %d, %d, %d)", textureName, level, x, y, width, height);
            if (level >= mipmaps) break;
            IntBuffer newBuffer = MipmapHelper.getPooledBuffer(width * height).asIntBuffer();
            MipmapHelper.scaleHalf(buffer, width, height, newBuffer, 0);
            buffer = newBuffer;
            ++level;
            x >>= 1;
            y >>= 1;
            width >>= 1;
            height >>= 1;
        }
    }

    static BufferedImage fixTransparency(ResourceAddress name, BufferedImage image) {
        IntBuffer buffer;
        if (image == null) {
            return image;
        }
        long s1 = System.currentTimeMillis();
        image = MipmapHelper.convertToARGB(image);
        int width = image.getWidth();
        int height = image.getHeight();
        IntBuffer scaledBuffer = buffer = MipmapHelper.getImageAsARGBIntBuffer(image);
        block0: while (width % 2 == 0 && height % 2 == 0) {
            for (int i = 0; i < scaledBuffer.limit(); ++i) {
                if (scaledBuffer.get(i) >>> 24 != 0) continue;
                IntBuffer newBuffer = MipmapHelper.getPooledBuffer(width * height).asIntBuffer();
                MipmapHelper.scaleHalf(scaledBuffer, width, height, newBuffer, 8);
                scaledBuffer = newBuffer;
                width >>= 1;
                height >>= 1;
                continue block0;
            }
        }
        long s2 = System.currentTimeMillis();
        if (scaledBuffer != buffer) {
            MipmapHelper.setBackgroundColor(buffer, image.getWidth(), image.getHeight(), scaledBuffer, image.getWidth() / width);
        }
        long s3 = System.currentTimeMillis();
        logger.finer("bg fix (tile %s): scaling %dms, setbg %dms", name, s2 - s1, s3 - s2);
        return image;
    }

    static void reset() {
        mipmapType.clear();
        mipmapType.put("terrain", true);
        mipmapType.put("items", false);
        Properties properties = TexturePackAPI.getProperties(MIPMAP_PROPERTIES);
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
                String key = ((String)entry.getKey()).trim();
                boolean value = Boolean.parseBoolean(((String)entry.getValue()).trim().toLowerCase());
                if (!key.endsWith(".png")) continue;
                mipmapType.put(key, value);
            }
        }
    }

    static boolean useMipmapsForTexture(String texture) {
        if (!useMipmap || texture == null) {
            return false;
        }
        if (mipmapType.containsKey(texture)) {
            return mipmapType.get(texture);
        }
        return !texture.contains("item") && !texture.startsWith("textures/colormap/") && !texture.startsWith("textures/environment/") && !texture.startsWith("textures/font/") && !texture.startsWith("textures/gui/") && !texture.startsWith("textures/map/") && !texture.startsWith("textures/misc/") && !texture.startsWith("mcpatcher/colormap/") && !texture.startsWith("mcpatcher/cit/") && !texture.startsWith("mcpatcher/dial/") && !texture.startsWith("mcpatcher/font/") && !texture.startsWith("mcpatcher/lightmap/") && !texture.startsWith("mcpatcher/sky/");
    }

    static int getMipmapLevelsForCurrentTexture() {
        int filter = GL11.glGetTexParameteri((int)3553, (int)10241);
        if (filter != 9986 && filter != 9984) {
            return 0;
        }
        return Math.min(maxMipmapLevel, GL11.glGetTexParameteri((int)3553, (int)33085));
    }

    private static int gcd(int a, int b) {
        return BigInteger.valueOf(a).gcd(BigInteger.valueOf(b)).intValue();
    }

    private static int getMipmapLevels(int width, int height, int minSize) {
        int mipmap;
        int size = MipmapHelper.gcd(width, height);
        for (mipmap = 0; size >= minSize && (size & 1) == 0 && mipmap < maxMipmapLevel; size >>= 1, ++mipmap) {
        }
        return mipmap;
    }

    private static BufferedImage getPooledImage(int width, int height, int index) {
        BufferedImage image;
        String key = String.format("%dx%d#%d", width, height, index);
        Reference<BufferedImage> ref = imagePool.get(key);
        BufferedImage bufferedImage = image = ref == null ? null : ref.get();
        if (image == null) {
            image = new BufferedImage(width, height, 2);
            imagePool.put(key, new SoftReference<BufferedImage>(image));
        }
        return image;
    }

    private static ByteBuffer getPooledBuffer(int size) {
        ByteBuffer buffer;
        Reference<ByteBuffer> ref = bufferPool.get(size);
        ByteBuffer byteBuffer = buffer = ref == null ? null : ref.get();
        if (buffer == null) {
            buffer = ByteBuffer.allocateDirect(size);
            bufferPool.put(size, new SoftReference<ByteBuffer>(buffer));
        }
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.position(0);
        return buffer;
    }

    private static BufferedImage convertToARGB(BufferedImage image) {
        if (image == null) {
            return null;
        }
        if (image.getType() == 2) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        logger.finest("converting %dx%d image to ARGB", width, height);
        BufferedImage newImage = MipmapHelper.getPooledImage(width, height, 0);
        Graphics2D graphics = newImage.createGraphics();
        Arrays.fill(MipmapHelper.getImageAsARGBIntBuffer(newImage).array(), 0);
        graphics.drawImage((Image)image, 0, 0, null);
        return newImage;
    }

    private static IntBuffer getImageAsARGBIntBuffer(BufferedImage image) {
        DataBuffer buffer = image.getRaster().getDataBuffer();
        if (buffer instanceof DataBufferInt) {
            return IntBuffer.wrap(((DataBufferInt)buffer).getData());
        }
        if (buffer instanceof DataBufferByte) {
            return ByteBuffer.wrap(((DataBufferByte)buffer).getData()).order(ByteOrder.BIG_ENDIAN).asIntBuffer();
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        return IntBuffer.wrap(pixels);
    }

    private static void setBackgroundColor(IntBuffer buffer, int width, int height, IntBuffer scaledBuffer, int scale) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                int k = width * j + i;
                int pixel = buffer.get(k);
                if ((pixel & 0xFF000000) != 0) continue;
                pixel = scaledBuffer.get(j / scale * (width / scale) + i / scale);
                buffer.put(k, pixel & 0xFFFFFF);
            }
        }
    }

    static void scaleHalf(IntBuffer in, int w, int h, IntBuffer out, int rotate) {
        for (int i = 0; i < w / 2; ++i) {
            for (int j = 0; j < h / 2; ++j) {
                int k = w * 2 * j + 2 * i;
                int pixel00 = in.get(k);
                int pixel01 = in.get(k + 1);
                int pixel10 = in.get(k + w);
                int pixel11 = in.get(k + w + 1);
                if (rotate != 0) {
                    pixel00 = Integer.rotateLeft(pixel00, rotate);
                    pixel01 = Integer.rotateLeft(pixel01, rotate);
                    pixel10 = Integer.rotateLeft(pixel10, rotate);
                    pixel11 = Integer.rotateLeft(pixel11, rotate);
                }
                int pixel = MipmapHelper.average4RGBA(pixel00, pixel01, pixel10, pixel11);
                if (rotate != 0) {
                    pixel = Integer.rotateRight(pixel, rotate);
                }
                out.put(w / 2 * j + i, pixel);
            }
        }
    }

    private static int average4RGBA(int pixel00, int pixel01, int pixel10, int pixel11) {
        int a00 = pixel00 & 0xFF;
        int a01 = pixel01 & 0xFF;
        int a10 = pixel10 & 0xFF;
        int a11 = pixel11 & 0xFF;
        switch (a00 << 24 | a01 << 16 | a10 << 8 | a11) {
            case -16777216: {
                return pixel00;
            }
            case 0xFF0000: {
                return pixel01;
            }
            case 65280: {
                return pixel10;
            }
            case 255: {
                return pixel11;
            }
            case -65536: {
                return MipmapHelper.average2RGBA(pixel00, pixel01);
            }
            case -16711936: {
                return MipmapHelper.average2RGBA(pixel00, pixel10);
            }
            case -16776961: {
                return MipmapHelper.average2RGBA(pixel00, pixel11);
            }
            case 0xFFFF00: {
                return MipmapHelper.average2RGBA(pixel01, pixel10);
            }
            case 0xFF00FF: {
                return MipmapHelper.average2RGBA(pixel01, pixel11);
            }
            case 65535: {
                return MipmapHelper.average2RGBA(pixel10, pixel11);
            }
            case -1: 
            case 0: {
                return MipmapHelper.average2RGBA(MipmapHelper.average2RGBA(pixel00, pixel11), MipmapHelper.average2RGBA(pixel01, pixel10));
            }
        }
        int a = a00 + a01 + a10 + a11;
        int pixel = a >> 2;
        for (int i = 8; i < 32; i += 8) {
            int average = (a00 * (pixel00 >> i & 0xFF) + a01 * (pixel01 >> i & 0xFF) + a10 * (pixel10 >> i & 0xFF) + a11 * (pixel11 >> i & 0xFF)) / a;
            pixel |= average << i;
        }
        return pixel;
    }

    private static int average2RGBA(int a, int b) {
        return ((a & 0xFEFEFEFE) >>> 1) + ((b & 0xFEFEFEFE) >>> 1) | a & b & 0x1010101;
    }

    private static void checkGLError(String format, Object ... params) {
        int error = GL11.glGetError();
        if (error != 0) {
            String message = GLU.gluErrorString((int)error) + ": " + String.format(format, params);
            new RuntimeException(message).printStackTrace();
        }
    }

    static {
        mipmapEnabled = Config.getBoolean("Extended HD", "mipmap", false);
        maxMipmapLevel = Config.getInt("Extended HD", "maxMipmapLevel", 3);
        mipmapAlignment = (1 << Config.getInt("Extended HD", "mipmapAlignment", 3)) - 1;
        imagePool = new HashMap<String, Reference<BufferedImage>>();
        bufferPool = new HashMap<Integer, Reference<ByteBuffer>>();
        mipmapType = new HashMap<String, Boolean>();
        mipmapSupported = GLContext.getCapabilities().OpenGL12;
        useMipmap = mipmapSupported && mipmapEnabled && maxMipmapLevel > 0;
        anisoSupported = GLContext.getCapabilities().GL_EXT_texture_filter_anisotropic;
        if (anisoSupported) {
            anisoMax = (int)GL11.glGetFloat((int)34047);
            MipmapHelper.checkGLError("glGetFloat(GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT)", new Object[0]);
            anisoLevel = Math.max(Math.min(Config.getInt("Extended HD", "anisotropicFiltering", 1), anisoMax), 1);
        } else {
            anisoLevel = 1;
            anisoMax = 1;
        }
        lodSupported = GLContext.getCapabilities().GL_EXT_texture_lod_bias;
        lodBias = lodSupported ? Config.getInt("Extended HD", "lodBias", 0) : 0;
        logger.config("mipmap: supported=%s, enabled=%s, level=%d", mipmapSupported, mipmapEnabled, maxMipmapLevel);
        logger.config("anisotropic: supported=%s, level=%d, max=%d", anisoSupported, anisoLevel, anisoMax);
        logger.config("lod bias: supported=%s, bias=%d", lodSupported, lodBias);
    }
}

