/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.BlendMethod;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.InputHandler;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.hd.MipmapHelper;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.imageio.ImageIO;
import net.minecraft.src.Icon;
import net.minecraft.src.ResourceAddress;
import net.minecraft.src.TextureClock;
import net.minecraft.src.TextureCompass;
import net.minecraft.src.TextureStitched;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.GLU;

public class FancyDial {
    private static final MCLogger logger = MCLogger.getLogger("Custom Animations", "Animation");
    private static final ResourceAddress ITEMS_PNG = new ResourceAddress("textures/atlas/items.png");
    private static final double ANGLE_UNSET = Double.MAX_VALUE;
    private static final boolean fboSupported = GLContext.getCapabilities().GL_EXT_framebuffer_object;
    private static final boolean gl13Supported = GLContext.getCapabilities().OpenGL13;
    private static final boolean enableCompass = Config.getBoolean("Extended HD", "fancyCompass", true);
    private static final boolean enableClock = Config.getBoolean("Extended HD", "fancyClock", true);
    private static final boolean useGL13 = Config.getBoolean("Extended HD", "useGL13", true);
    private static final boolean useScratchTexture = Config.getBoolean("Extended HD", "useScratchTexture", true);
    private static final int glAttributes;
    private static boolean initialized;
    private static boolean inUpdateAll;
    private static final int drawList;
    private static final Field subTexturesField;
    private static final Map<TextureStitched, ResourceAddress> setupInfo;
    private static final Map<TextureStitched, FancyDial> instances;
    private final TextureStitched icon;
    private final String name;
    private final int x0;
    private final int y0;
    private final int width;
    private final int height;
    private final boolean needExtraUpdate;
    private final int itemsTexture;
    private int scratchTexture;
    private final ByteBuffer scratchTextureBuffer;
    private int frameBuffer;
    private int outputFrames;
    private boolean ok;
    private double lastAngle = Double.MAX_VALUE;
    private boolean skipPostRender;
    private final List<Layer> layers = new ArrayList<Layer>();
    private InputHandler keyboard;
    private static final float STEP = 0.01f;
    private float scaleXDelta;
    private float scaleYDelta;
    private float offsetXDelta;
    private float offsetYDelta;

    public static void setup(TextureStitched icon) {
        ResourceAddress resource;
        if (!fboSupported) {
            return;
        }
        String name = icon.getIconName();
        if ("compass".equals(icon.getIconName())) {
            if (!enableCompass) {
                return;
            }
        } else if ("clock".equals(icon.getIconName())) {
            if (!enableClock) {
                return;
            }
        } else {
            logger.warning("ignoring custom animation for %s not compass or clock", icon.getIconName());
            return;
        }
        if (TexturePackAPI.hasResource(resource = TexturePackAPI.newMCPatcherResourceAddress("dial/" + name + ".properties"))) {
            logger.fine("found custom %s (%s)", name, resource);
            setupInfo.put(icon, resource);
        }
    }

    public static boolean update(TextureStitched icon) {
        if (!initialized) {
            logger.finer("deferring %s update until initialization finishes", icon.getIconName());
            return false;
        }
        FancyDial instance = instances.get(icon);
        if (instance == null && (instance = FancyDial.getInstance(icon)) == null) {
            return false;
        }
        return instance.render();
    }

    static void updateAll() {
        if (!initialized) {
            logger.finer("deferring %s update until initialization finishes", FancyDial.class.getSimpleName());
            return;
        }
        if (!setupInfo.isEmpty()) {
            ArrayList<TextureStitched> keys = new ArrayList<TextureStitched>();
            keys.addAll(setupInfo.keySet());
            for (TextureStitched icon : keys) {
                FancyDial.getInstance(icon);
            }
        }
        inUpdateAll = true;
        for (FancyDial instance : instances.values()) {
            if (instance == null || !instance.needExtraUpdate) continue;
            instance.icon.updateAnimation();
        }
        inUpdateAll = false;
    }

    static void postUpdateAll() {
        if (!initialized) {
            return;
        }
        for (FancyDial instance : instances.values()) {
            if (instance == null) continue;
            instance.postRender();
        }
    }

    static void refresh() {
        logger.finer("FancyDial.refresh", new Object[0]);
        for (FancyDial instance : instances.values()) {
            if (instance == null) continue;
            instance.finish();
        }
        instances.clear();
        initialized = true;
    }

    private static FancyDial getInstance(TextureStitched icon) {
        ResourceAddress resource = setupInfo.get(icon);
        Properties properties = TexturePackAPI.getProperties(resource);
        setupInfo.remove(icon);
        if (properties == null) {
            return null;
        }
        try {
            FancyDial instance = new FancyDial(icon, resource, properties);
            if (instance.ok) {
                instances.put(icon, instance);
                return instance;
            }
            instance.finish();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    private FancyDial(TextureStitched icon, ResourceAddress resource, Properties properties) {
        int targetTexture;
        this.icon = icon;
        this.name = icon.getIconName();
        this.x0 = icon.getX0();
        this.y0 = icon.getY0();
        this.width = icon.getWidth();
        this.height = icon.getHeight();
        boolean bl = this.needExtraUpdate = !FancyDial.hasAnimation((Icon)icon);
        if (this.needExtraUpdate) {
            logger.fine("%s needs direct .update() call", icon.getIconName());
        }
        TexturePackAPI.bindTexture(ITEMS_PNG);
        this.itemsTexture = GL11.glGetInteger((int)32873);
        if (useScratchTexture) {
            BufferedImage image = new BufferedImage(this.width, this.height, 2);
            this.scratchTexture = GL11.glGenTextures();
            MipmapHelper.setupTexture(this.scratchTexture, image, false, false, TexturePackAPI.transformResourceAddress(resource, ".properties", "_scratch"));
            targetTexture = this.scratchTexture;
            this.scratchTextureBuffer = ByteBuffer.allocateDirect(4 * this.width * this.height);
            logger.fine("rendering %s to %dx%d scratch texture %d", this.name, this.width, this.height, this.scratchTexture);
        } else {
            this.scratchTexture = -1;
            this.scratchTextureBuffer = null;
            logger.fine("rendering %s directly to %s", this.name, ITEMS_PNG);
            targetTexture = this.itemsTexture;
        }
        if (this.itemsTexture < 0) {
            logger.severe("could not get items texture", new Object[0]);
            return;
        }
        logger.fine("setting up %s", this);
        boolean debug = false;
        int i = 0;
        while (true) {
            Layer layer;
            if ((layer = this.newLayer(resource, properties, "." + i)) == null) {
                if (i > 0) {
                    break;
                }
            } else {
                this.layers.add(layer);
                debug |= layer.debug;
                logger.fine("  new %s", layer);
            }
            ++i;
        }
        this.keyboard = new InputHandler(this.name, debug);
        if (this.layers.size() < 2) {
            logger.error("custom %s needs at least two layers defined", this.name);
            return;
        }
        this.outputFrames = MCPatcherUtils.getIntProperty(properties, "outputFrames", 0);
        this.frameBuffer = EXTFramebufferObject.glGenFramebuffersEXT();
        if (this.frameBuffer < 0) {
            logger.severe("could not get framebuffer object", new Object[0]);
            return;
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)targetTexture, (int)0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        int glError = GL11.glGetError();
        if (glError != 0) {
            logger.severe("%s during %s setup", GLU.gluErrorString((int)glError), this.name);
            return;
        }
        this.ok = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean render() {
        if (!this.ok) {
            return false;
        }
        boolean changed = true;
        if (!this.keyboard.isEnabled()) {
            changed = false;
        } else if (this.keyboard.isKeyPressed(80)) {
            this.scaleYDelta -= 0.01f;
        } else if (this.keyboard.isKeyPressed(72)) {
            this.scaleYDelta += 0.01f;
        } else if (this.keyboard.isKeyPressed(75)) {
            this.scaleXDelta -= 0.01f;
        } else if (this.keyboard.isKeyPressed(77)) {
            this.scaleXDelta += 0.01f;
        } else if (this.keyboard.isKeyPressed(208)) {
            this.offsetYDelta += 0.01f;
        } else if (this.keyboard.isKeyPressed(200)) {
            this.offsetYDelta -= 0.01f;
        } else if (this.keyboard.isKeyPressed(203)) {
            this.offsetXDelta -= 0.01f;
        } else if (this.keyboard.isKeyPressed(205)) {
            this.offsetXDelta += 0.01f;
        } else if (this.keyboard.isKeyPressed(55)) {
            this.offsetYDelta = 0.0f;
            this.offsetXDelta = 0.0f;
            this.scaleYDelta = 0.0f;
            this.scaleXDelta = 0.0f;
        } else {
            changed = false;
        }
        if (changed) {
            logger.info("", new Object[0]);
            logger.info("scaleX  %+f", Float.valueOf(this.scaleXDelta));
            logger.info("scaleY  %+f", Float.valueOf(this.scaleYDelta));
            logger.info("offsetX %+f", Float.valueOf(this.offsetXDelta));
            logger.info("offsetY %+f", Float.valueOf(this.offsetYDelta));
            this.lastAngle = Double.MAX_VALUE;
        }
        if (this.outputFrames > 0) {
            try {
                BufferedImage image = new BufferedImage(this.width, this.outputFrames * this.height, 2);
                ByteBuffer byteBuffer = this.scratchTextureBuffer == null ? ByteBuffer.allocateDirect(4 * this.width * this.height) : this.scratchTextureBuffer;
                IntBuffer intBuffer = byteBuffer.asIntBuffer();
                int[] argb = new int[this.width * this.height];
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
                File path = MCPatcherUtils.getMinecraftPath("custom_" + this.name + ".png");
                logger.info("generating %d %s frames", this.outputFrames, this.name);
                for (int i = 0; i < this.outputFrames; ++i) {
                    this.render((double)i * (360.0 / (double)this.outputFrames), false);
                    if (this.scratchTexture < 0) {
                        byteBuffer.position(0);
                        GL11.glReadPixels((int)this.x0, (int)this.y0, (int)this.width, (int)this.height, (int)6408, (int)5121, (ByteBuffer)byteBuffer);
                    }
                    intBuffer.position(0);
                    for (int j = 0; j < argb.length; ++j) {
                        argb[j] = Integer.rotateRight(intBuffer.get(j), 8);
                    }
                    image.setRGB(0, i * this.height, this.width, this.height, argb, 0, this.width);
                }
                ImageIO.write((RenderedImage)image, "png", path);
                logger.info("wrote %dx%d %s", image.getWidth(), image.getHeight(), path.getPath());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            finally {
                EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
            }
            this.outputFrames = 0;
        }
        return this.render(FancyDial.getAngle((Icon)this.icon), true);
    }

    private boolean render(double angle, boolean bindFB) {
        if (angle == this.lastAngle) {
            this.skipPostRender = true;
            return true;
        }
        this.skipPostRender = false;
        this.lastAngle = angle;
        GL11.glPushAttrib((int)glAttributes);
        if (this.scratchTexture >= 0) {
            GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
        } else {
            GL11.glViewport((int)this.x0, (int)this.y0, (int)this.width, (int)this.height);
            GL11.glEnable((int)3089);
            GL11.glScissor((int)this.x0, (int)this.y0, (int)this.width, (int)this.height);
        }
        if (bindFB) {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.frameBuffer);
        }
        boolean lightmapEnabled = false;
        if (GLContext.getCapabilities().OpenGL13) {
            GL13.glActiveTexture((int)33985);
            lightmapEnabled = GL11.glIsEnabled((int)3553);
            if (lightmapEnabled) {
                GL11.glDisable((int)3553);
            }
            GL13.glActiveTexture((int)33984);
        }
        GL11.glEnable((int)3553);
        GL11.glDisable((int)2929);
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        if (gl13Supported && useGL13) {
            GL11.glDisable((int)32925);
        }
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        for (Layer layer : this.layers) {
            layer.blendMethod.applyBlending();
            GL11.glPushMatrix();
            TexturePackAPI.bindTexture(layer.textureName);
            float offsetX = layer.offsetX;
            float offsetY = layer.offsetY;
            float scaleX = layer.scaleX;
            float scaleY = layer.scaleY;
            if (layer.debug) {
                offsetX += this.offsetXDelta;
                offsetY += this.offsetYDelta;
                scaleX += this.scaleXDelta;
                scaleY += this.scaleYDelta;
            }
            GL11.glTranslatef((float)offsetX, (float)offsetY, (float)0.0f);
            GL11.glScalef((float)scaleX, (float)scaleY, (float)1.0f);
            float layerAngle = (float)(angle * (double)layer.rotationMultiplier + (double)layer.rotationOffset);
            GL11.glRotatef((float)layerAngle, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glCallList((int)drawList);
            GL11.glPopMatrix();
        }
        if (bindFB) {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        }
        GL11.glPopAttrib();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        if (lightmapEnabled) {
            GL13.glActiveTexture((int)33985);
            GL11.glEnable((int)3553);
            GL13.glActiveTexture((int)33984);
        }
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int glError = GL11.glGetError();
        if (glError != 0) {
            logger.severe("%s during %s update", GLU.gluErrorString((int)glError), this.icon.getIconName());
            this.ok = false;
        } else if (!inUpdateAll) {
            this.postRender();
        }
        return this.ok;
    }

    private void postRender() {
        if (this.ok && !this.skipPostRender && this.scratchTexture >= 0) {
            TexturePackAPI.bindTexture(this.scratchTexture);
            this.scratchTextureBuffer.position(0);
            GL11.glGetTexImage((int)3553, (int)0, (int)6408, (int)5121, (ByteBuffer)this.scratchTextureBuffer);
            this.scratchTextureBuffer.position(0);
            TexturePackAPI.bindTexture(this.itemsTexture);
            GL11.glTexSubImage2D((int)3553, (int)0, (int)this.x0, (int)this.y0, (int)this.width, (int)this.height, (int)6408, (int)5121, (ByteBuffer)this.scratchTextureBuffer);
        }
    }

    private static void drawBox() {
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)-1.0f, (float)-1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)-1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)-1.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
    }

    private void finish() {
        if (this.frameBuffer >= 0) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.frameBuffer);
            this.frameBuffer = -1;
        }
        if (this.scratchTexture >= 0) {
            TexturePackAPI.deleteTexture(this.scratchTexture);
            this.scratchTexture = -1;
        }
        this.layers.clear();
        this.ok = false;
    }

    public String toString() {
        return String.format("FancyDial{%s, %dx%d @ %d,%d}", this.name, this.width, this.height, this.x0, this.y0);
    }

    protected void finalize() throws Throwable {
        this.finish();
        super.finalize();
    }

    private static boolean hasAnimation(Icon icon) {
        if (icon instanceof TextureStitched && subTexturesField != null) {
            try {
                List list = (List)subTexturesField.get(icon);
                return list != null && list.size() > 1;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static double getAngle(Icon icon) {
        if (icon instanceof TextureCompass) {
            return ((TextureCompass)icon).currentAngle * 180.0 / Math.PI;
        }
        if (icon instanceof TextureClock) {
            return ((TextureClock)icon).currentAngle * 360.0;
        }
        return 0.0;
    }

    Layer newLayer(ResourceAddress resource, Properties properties, String suffix) {
        String textureName = MCPatcherUtils.getStringProperty(properties, "source" + suffix, "");
        if (textureName.isEmpty()) {
            return null;
        }
        ResourceAddress textureResource = TexturePackAPI.parseResourceAddress(resource, textureName);
        if (textureResource == null) {
            return null;
        }
        if (!TexturePackAPI.hasResource(textureResource)) {
            logger.error("%s: could not read %s", resource, textureResource);
            return null;
        }
        float scaleX = MCPatcherUtils.getFloatProperty(properties, "scaleX" + suffix, 1.0f);
        float scaleY = MCPatcherUtils.getFloatProperty(properties, "scaleY" + suffix, 1.0f);
        float offsetX = MCPatcherUtils.getFloatProperty(properties, "offsetX" + suffix, 0.0f);
        float offsetY = MCPatcherUtils.getFloatProperty(properties, "offsetY" + suffix, 0.0f);
        float angleMultiplier = MCPatcherUtils.getFloatProperty(properties, "rotationSpeed" + suffix, 0.0f);
        float angleOffset = MCPatcherUtils.getFloatProperty(properties, "rotationOffset" + suffix, 0.0f);
        String blend = MCPatcherUtils.getStringProperty(properties, "blend" + suffix, "alpha");
        BlendMethod blendMethod = BlendMethod.parse(blend);
        if (blendMethod == null) {
            logger.error("%s: unknown blend method %s", resource, blend);
            return null;
        }
        boolean debug = MCPatcherUtils.getBooleanProperty(properties, "debug" + suffix, false);
        return new Layer(textureResource, scaleX, scaleY, offsetX, offsetY, angleMultiplier, angleOffset, blendMethod, debug);
    }

    static {
        drawList = GL11.glGenLists((int)1);
        setupInfo = new WeakHashMap<TextureStitched, ResourceAddress>();
        instances = new WeakHashMap<TextureStitched, FancyDial>();
        logger.config("fbo: supported=%s", fboSupported);
        logger.config("GL13: supported=%s, enabled=%s", gl13Supported, useGL13);
        int bits = 527702;
        if (gl13Supported && useGL13) {
            bits |= 0x20000000;
        }
        glAttributes = bits;
        Field field = null;
        try {
            for (Field f : TextureStitched.class.getDeclaredFields()) {
                if (!List.class.isAssignableFrom(f.getType())) continue;
                f.setAccessible(true);
                field = f;
                break;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        subTexturesField = field;
        GL11.glNewList((int)drawList, (int)4864);
        FancyDial.drawBox();
        GL11.glEndList();
    }

    private class Layer {
        final ResourceAddress textureName;
        final float scaleX;
        final float scaleY;
        final float offsetX;
        final float offsetY;
        final float rotationMultiplier;
        final float rotationOffset;
        final BlendMethod blendMethod;
        final boolean debug;

        Layer(ResourceAddress textureName, float scaleX, float scaleY, float offsetX, float offsetY, float rotationMultiplier, float rotationOffset, BlendMethod blendMethod, boolean debug) {
            this.textureName = textureName;
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.rotationMultiplier = rotationMultiplier;
            this.rotationOffset = rotationOffset;
            this.blendMethod = blendMethod;
            this.debug = debug;
        }

        public String toString() {
            return String.format("Layer{%s %f %f %+f %+f x%f}", this.textureName, Float.valueOf(this.scaleX), Float.valueOf(this.scaleY), Float.valueOf(this.offsetX), Float.valueOf(this.offsetY), Float.valueOf(this.rotationMultiplier));
        }
    }
}

