/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.hd.AAHelper;
import net.minecraft.src.TextureStitched;

public class BorderedTexture
extends TextureStitched {
    private static final MCLogger logger = MCLogger.getLogger("Mipmap");
    private float minU;
    private float maxU;
    private float minV;
    private float maxV;
    private float scaledWidth;
    private float scaledHeight;
    private int tilesheetWidth;
    private int tilesheetHeight;
    private int x0;
    private int y0;
    private String tilesheet;
    int border;

    public static TextureStitched create(String tilesheet, String name) {
        if (AAHelper.useAAForTexture(tilesheet)) {
            return new BorderedTexture(tilesheet, name);
        }
        return new TextureStitched(name);
    }

    private BorderedTexture(String tilesheet, String name) {
        super(name);
        this.tilesheet = tilesheet;
    }

    public void init(int tilesheetWidth, int tilesheetHeight, int x0, int y0, boolean flipped) {
        super.init(tilesheetWidth, tilesheetHeight, x0, y0, flipped);
        this.tilesheetWidth = tilesheetWidth;
        this.tilesheetHeight = tilesheetHeight;
        this.x0 = x0;
        this.y0 = y0;
        this.setBorderWidth(this.border);
    }

    public float getMinU() {
        return this.minU;
    }

    public float getMaxU() {
        return this.maxU;
    }

    public float getInterpolatedU(double u) {
        return this.border > 0 ? this.minU + (float)u * this.scaledWidth : super.getInterpolatedU(u);
    }

    public float getMinV() {
        return this.minV;
    }

    public float getMaxV() {
        return this.maxV;
    }

    public float getInterpolatedV(double v) {
        return this.border > 0 ? this.minV + (float)v * this.scaledHeight : super.getInterpolatedV(v);
    }

    public void copy(TextureStitched stitched) {
        if (stitched instanceof BorderedTexture) {
            BorderedTexture bordered = (BorderedTexture)stitched;
            this.tilesheetWidth = bordered.tilesheetWidth;
            this.tilesheetHeight = bordered.tilesheetHeight;
            this.x0 = bordered.x0;
            this.y0 = bordered.y0;
            this.tilesheet = bordered.tilesheet;
            this.border = bordered.border;
        }
    }

    void setBorderWidth(int border) {
        this.border = border;
        int width = this.getWidth();
        int height = this.getHeight();
        if (width <= 0 || height <= 0) {
            this.y0 = 0;
            this.x0 = 0;
            this.maxV = 0.0f;
            this.minV = 0.0f;
            this.maxU = 0.0f;
            this.minU = 0.0f;
            this.scaledHeight = 0.0f;
            this.scaledWidth = 0.0f;
            return;
        }
        logger.finer("setBorderWidth(%s, %s, %d): %dx%d -> %dx%d", this.tilesheet, this.getIconName(), border, width - 2 * border, height - 2 * border, width, height);
        if (border > 0) {
            this.x0 += border;
            this.y0 += border;
            this.minU = (float)this.x0 / (float)this.tilesheetWidth;
            this.maxU = (float)(this.x0 + (width -= 2 * border)) / (float)this.tilesheetWidth;
            this.minV = (float)this.y0 / (float)this.tilesheetHeight;
            this.maxV = (float)(this.y0 + (height -= 2 * border)) / (float)this.tilesheetHeight;
        } else {
            this.minU = super.getMinU();
            this.maxU = super.getMaxU();
            this.minV = super.getMinV();
            this.maxV = super.getMaxV();
        }
        this.scaledWidth = (this.maxU - this.minU) / 16.0f;
        this.scaledHeight = (this.maxV - this.minV) / 16.0f;
    }
}

