/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.glsl;

import com.prupe.mcpatcher.TexturePackAPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.ResourceAddress;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexProgram;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL20;
import org.lwjgl.util.glu.GLU;

public class Shaders {
    private static boolean isInitialized = false;
    private static int renderWidth = 0;
    private static int renderHeight = 0;
    private static Minecraft mc = null;
    private static float[] sunPosition = new float[3];
    private static float[] moonPosition = new float[3];
    private static final float[] clearColor = new float[3];
    private static boolean lightmapEnabled = false;
    private static boolean fogEnabled = true;
    public static int entityAttrib = -1;
    private static FloatBuffer previousProjection = null;
    private static FloatBuffer projection = null;
    private static FloatBuffer projectionInverse = null;
    private static FloatBuffer previousModelView = null;
    private static FloatBuffer modelView = null;
    private static FloatBuffer modelViewInverse = null;
    private static final double[] previousCameraPosition = new double[3];
    private static final double[] cameraPosition = new double[3];
    private static int shadowPassInterval = 0;
    private static int shadowMapWidth = 1024;
    private static int shadowMapHeight = 1024;
    private static float shadowMapFOV = 25.0f;
    private static float shadowMapHalfPlane = 30.0f;
    private static boolean shadowMapIsOrtho = true;
    private static int shadowPassCounter = 0;
    private static int preShadowPassThirdPersonView;
    private static boolean isShadowPass;
    private static int sfb;
    private static int sfbColorTexture;
    private static int sfbDepthTexture;
    private static int sfbRenderBuffer;
    private static int sfbDepthBuffer;
    private static FloatBuffer shadowProjection;
    private static FloatBuffer shadowProjectionInverse;
    private static FloatBuffer shadowModelView;
    private static FloatBuffer shadowModelViewInverse;
    private static int colorAttachments;
    private static IntBuffer dfbDrawBuffers;
    private static IntBuffer dfbTextures;
    private static IntBuffer dfbRenderBuffers;
    private static int dfb;
    private static int dfbDepthBuffer;
    public static int activeProgram;
    public static final int ProgramNone = 0;
    public static final int ProgramBasic = 1;
    public static final int ProgramTextured = 2;
    public static final int ProgramTexturedLit = 3;
    public static final int ProgramTerrain = 4;
    public static final int ProgramWater = 5;
    public static final int ProgramHand = 6;
    public static final int ProgramWeather = 7;
    public static final int ProgramComposite = 8;
    public static final int ProgramFinal = 9;
    public static final int ProgramCount = 10;
    private static final String[] programNames;
    private static final int[] programBackups;
    private static final int[] programs;

    private Shaders() {
    }

    public static void init() {
        int i;
        int maxDrawBuffers = GL11.glGetInteger((int)34852);
        System.out.println("GL_MAX_DRAW_BUFFERS = " + maxDrawBuffers);
        colorAttachments = 4;
        for (i = 0; i < 10; ++i) {
            Shaders.programs[i] = programNames[i].equals("") ? 0 : Shaders.setupProgram("shaders/" + programNames[i] + ".vsh", "shaders/" + programNames[i] + ".fsh");
        }
        if (colorAttachments > maxDrawBuffers) {
            System.out.println("Not enough draw buffers!");
        }
        for (i = 0; i < 10; ++i) {
            int n = i;
            while (programs[i] == 0 && n != programBackups[n]) {
                Shaders.programs[i] = programs[programBackups[n]];
                n = programBackups[n];
            }
        }
        dfbDrawBuffers = BufferUtils.createIntBuffer((int)colorAttachments);
        for (i = 0; i < colorAttachments; ++i) {
            dfbDrawBuffers.put(i, 36064 + i);
        }
        dfbTextures = BufferUtils.createIntBuffer((int)colorAttachments);
        dfbRenderBuffers = BufferUtils.createIntBuffer((int)colorAttachments);
        Shaders.resize();
        Shaders.setupShadowMap();
        isInitialized = true;
    }

    public static void destroy() {
        for (int i = 0; i < 10; ++i) {
            if (programs[i] == 0) continue;
            ARBShaderObjects.glDeleteObjectARB((int)programs[i]);
            Shaders.programs[i] = 0;
        }
    }

    public static void glEnableWrapper(int cap) {
        GL11.glEnable((int)cap);
        if (cap == 3553) {
            if (activeProgram == 1) {
                Shaders.useProgram(lightmapEnabled ? 3 : 2);
            }
        } else if (cap == 2912) {
            fogEnabled = true;
            Shaders.setProgramUniform1i("fogMode", GL11.glGetInteger((int)2917));
        }
    }

    public static void glDisableWrapper(int cap) {
        GL11.glDisable((int)cap);
        if (cap == 3553) {
            if (activeProgram == 2 || activeProgram == 3) {
                Shaders.useProgram(1);
            }
        } else if (cap == 2912) {
            fogEnabled = false;
            Shaders.setProgramUniform1i("fogMode", 0);
        }
    }

    public static void enableLightmap() {
        lightmapEnabled = true;
        if (activeProgram == 2) {
            Shaders.useProgram(3);
        }
    }

    public static void disableLightmap() {
        lightmapEnabled = false;
        if (activeProgram == 3) {
            Shaders.useProgram(2);
        }
    }

    public static void setClearColor(float red, float green, float blue) {
        Shaders.clearColor[0] = red;
        Shaders.clearColor[1] = green;
        Shaders.clearColor[2] = blue;
        if (isShadowPass) {
            GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
            GL11.glClear((int)16640);
            return;
        }
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16640);
        GL20.glDrawBuffers((int)36064);
        GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
        GL11.glClear((int)16640);
        GL20.glDrawBuffers((int)36065);
        GL11.glClearColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glClear((int)16640);
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
    }

    public static void setCamera(float f) {
        EntityLiving viewEntity = Shaders.mc.renderViewEntity;
        double x = viewEntity.lastTickPosX + (viewEntity.posX - viewEntity.lastTickPosX) * (double)f;
        double y = viewEntity.lastTickPosY + (viewEntity.posY - viewEntity.lastTickPosY) * (double)f;
        double z = viewEntity.lastTickPosZ + (viewEntity.posZ - viewEntity.lastTickPosZ) * (double)f;
        if (isShadowPass) {
            GL11.glViewport((int)0, (int)0, (int)shadowMapWidth, (int)shadowMapHeight);
            GL11.glMatrixMode((int)5889);
            GL11.glLoadIdentity();
            if (shadowMapIsOrtho) {
                GL11.glOrtho((double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)(-shadowMapHalfPlane), (double)shadowMapHalfPlane, (double)0.05f, (double)256.0);
            } else {
                GLU.gluPerspective((float)shadowMapFOV, (float)((float)shadowMapWidth / (float)shadowMapHeight), (float)0.05f, (float)256.0f);
            }
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-100.0f);
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            float angle = -Shaders.mc.theWorld.getCelestialAngle(f) * 360.0f;
            if ((double)angle < -90.0 && (double)angle > -270.0) {
                GL11.glRotatef((float)(angle + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            } else {
                GL11.glRotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (shadowMapIsOrtho) {
                GL11.glTranslatef((float)((float)x % 5.0f), (float)((float)y % 5.0f), (float)((float)z % 5.0f));
            }
            shadowProjection = BufferUtils.createFloatBuffer((int)16);
            GL11.glGetFloat((int)2983, (FloatBuffer)shadowProjection);
            shadowProjectionInverse = Shaders.invertMat4x(shadowProjection);
            shadowModelView = BufferUtils.createFloatBuffer((int)16);
            GL11.glGetFloat((int)2982, (FloatBuffer)shadowModelView);
            shadowModelViewInverse = Shaders.invertMat4x(shadowModelView);
            return;
        }
        previousProjection = projection;
        projection = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2983, (FloatBuffer)projection);
        projectionInverse = Shaders.invertMat4x(projection);
        previousModelView = modelView;
        modelView = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        modelViewInverse = Shaders.invertMat4x(modelView);
        Shaders.previousCameraPosition[0] = cameraPosition[0];
        Shaders.previousCameraPosition[1] = cameraPosition[1];
        Shaders.previousCameraPosition[2] = cameraPosition[2];
        Shaders.cameraPosition[0] = x;
        Shaders.cameraPosition[1] = y;
        Shaders.cameraPosition[2] = z;
    }

    public static void beginRender(Minecraft minecraft, float f, long l) {
        if (isShadowPass) {
            return;
        }
        mc = minecraft;
        if (!isInitialized) {
            Shaders.init();
        }
        if (Shaders.mc.displayWidth != renderWidth || Shaders.mc.displayHeight != renderHeight) {
            Shaders.resize();
        }
        if (shadowPassInterval > 0 && --shadowPassCounter <= 0) {
            preShadowPassThirdPersonView = Shaders.mc.gameSettings.thirdPersonView;
            Shaders.mc.gameSettings.thirdPersonView = 1;
            isShadowPass = true;
            shadowPassCounter = shadowPassInterval;
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
            Shaders.useProgram(0);
            Shaders.mc.entityRenderer.renderWorld(f, l);
            GL11.glFlush();
            isShadowPass = false;
            Shaders.mc.gameSettings.thirdPersonView = preShadowPassThirdPersonView;
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void endRender() {
        if (isShadowPass) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)1.0, (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        Shaders.useProgram(8);
        GL20.glDrawBuffers((IntBuffer)dfbDrawBuffers);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(0));
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(1));
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(2));
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(3));
        if (colorAttachments >= 5) {
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(4));
            if (colorAttachments >= 6) {
                GL13.glActiveTexture((int)33989);
                GL11.glBindTexture((int)3553, (int)dfbTextures.get(5));
                if (colorAttachments >= 7) {
                    GL13.glActiveTexture((int)33990);
                    GL11.glBindTexture((int)3553, (int)dfbTextures.get(6));
                }
            }
        }
        if (shadowPassInterval > 0) {
            GL13.glActiveTexture((int)33991);
            GL11.glBindTexture((int)3553, (int)sfbDepthTexture);
        }
        GL13.glActiveTexture((int)33984);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        Shaders.useProgram(9);
        GL11.glClearColor((float)clearColor[0], (float)clearColor[1], (float)clearColor[2], (float)1.0f);
        GL11.glClear((int)16640);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(0));
        GL13.glActiveTexture((int)33985);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(1));
        GL13.glActiveTexture((int)33986);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(2));
        GL13.glActiveTexture((int)33987);
        GL11.glBindTexture((int)3553, (int)dfbTextures.get(3));
        if (colorAttachments >= 5) {
            GL13.glActiveTexture((int)33988);
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(4));
            if (colorAttachments >= 6) {
                GL13.glActiveTexture((int)33989);
                GL11.glBindTexture((int)3553, (int)dfbTextures.get(5));
                if (colorAttachments >= 7) {
                    GL13.glActiveTexture((int)33990);
                    GL11.glBindTexture((int)3553, (int)dfbTextures.get(6));
                }
            }
        }
        if (shadowPassInterval > 0) {
            GL13.glActiveTexture((int)33991);
            GL11.glBindTexture((int)3553, (int)sfbDepthTexture);
        }
        GL13.glActiveTexture((int)33984);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)0.0f);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glEnd();
        GL11.glEnable((int)3042);
        GL11.glPopMatrix();
        Shaders.useProgram(0);
    }

    public static void beginTerrain() {
        Shaders.useProgram(4);
        GL13.glActiveTexture((int)33986);
        TexturePackAPI.bindTexture(new ResourceAddress("terrain_nh.png"));
        GL13.glActiveTexture((int)33987);
        TexturePackAPI.bindTexture(new ResourceAddress("/terrain_s.png"));
        GL13.glActiveTexture((int)33984);
    }

    public static void endTerrain() {
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void beginWater() {
        Shaders.useProgram(5);
        GL13.glActiveTexture((int)33986);
        TexturePackAPI.bindTexture(new ResourceAddress("terrain_nh.png"));
        GL13.glActiveTexture((int)33987);
        TexturePackAPI.bindTexture(new ResourceAddress("terrain_s.png"));
        GL13.glActiveTexture((int)33984);
    }

    public static void endWater() {
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    public static void beginHand() {
        GL11.glEnable((int)3042);
        Shaders.useProgram(6);
    }

    public static void endHand() {
        GL11.glDisable((int)3042);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
        if (isShadowPass) {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
        }
    }

    public static void beginWeather() {
        GL11.glEnable((int)3042);
        Shaders.useProgram(7);
        if (isShadowPass) {
            EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        }
    }

    public static void endWeather() {
        GL11.glDisable((int)3042);
        Shaders.useProgram(lightmapEnabled ? 3 : 2);
    }

    private static void resize() {
        renderWidth = Shaders.mc.displayWidth;
        renderHeight = Shaders.mc.displayHeight;
        Shaders.setupFrameBuffer();
    }

    private static void setupShadowMap() {
        Shaders.setupShadowFrameBuffer();
    }

    private static int setupProgram(String vShaderPath, String fShaderPath) {
        int program = ARBShaderObjects.glCreateProgramObjectARB();
        int vShader = 0;
        int fShader = 0;
        if (program != 0) {
            vShader = Shaders.createVertShader(vShaderPath);
            fShader = Shaders.createFragShader(fShaderPath);
        }
        if (vShader != 0 || fShader != 0) {
            if (vShader != 0) {
                ARBShaderObjects.glAttachObjectARB((int)program, (int)vShader);
            }
            if (fShader != 0) {
                ARBShaderObjects.glAttachObjectARB((int)program, (int)fShader);
            }
            if (entityAttrib >= 0) {
                ARBVertexShader.glBindAttribLocationARB((int)program, (int)entityAttrib, (CharSequence)"mc_Entity");
            }
            ARBShaderObjects.glLinkProgramARB((int)program);
            ARBShaderObjects.glValidateProgramARB((int)program);
            Shaders.printLogInfo(program);
        } else if (program != 0) {
            ARBShaderObjects.glDeleteObjectARB((int)program);
            program = 0;
        }
        return program;
    }

    public static void useProgram(int program) {
        if (activeProgram == program) {
            return;
        }
        if (isShadowPass) {
            activeProgram = 0;
            ARBShaderObjects.glUseProgramObjectARB((int)programs[0]);
            return;
        }
        activeProgram = program;
        ARBShaderObjects.glUseProgramObjectARB((int)programs[program]);
        if (programs[program] == 0) {
            activeProgram = 0;
            return;
        }
        if (program == 2) {
            Shaders.setProgramUniform1i("texture", 0);
        } else if (program == 3 || program == 6 || program == 7) {
            Shaders.setProgramUniform1i("texture", 0);
            Shaders.setProgramUniform1i("lightmap", 1);
        } else if (program == 4 || program == 5) {
            Shaders.setProgramUniform1i("texture", 0);
            Shaders.setProgramUniform1i("lightmap", 1);
            Shaders.setProgramUniform1i("normals", 2);
            Shaders.setProgramUniform1i("specular", 3);
        } else if (program == 8 || program == 9) {
            Shaders.setProgramUniform1i("gcolor", 0);
            Shaders.setProgramUniform1i("gdepth", 1);
            Shaders.setProgramUniform1i("gnormal", 2);
            Shaders.setProgramUniform1i("composite", 3);
            Shaders.setProgramUniform1i("gaux1", 4);
            Shaders.setProgramUniform1i("gaux2", 5);
            Shaders.setProgramUniform1i("gaux3", 6);
            Shaders.setProgramUniform1i("shadow", 7);
            Shaders.setProgramUniformMatrix4ARB("gbufferPreviousProjection", false, previousProjection);
            Shaders.setProgramUniformMatrix4ARB("gbufferProjection", false, projection);
            Shaders.setProgramUniformMatrix4ARB("gbufferProjectionInverse", false, projectionInverse);
            Shaders.setProgramUniformMatrix4ARB("gbufferPreviousModelView", false, previousModelView);
            if (shadowPassInterval > 0) {
                Shaders.setProgramUniformMatrix4ARB("shadowProjection", false, shadowProjection);
                Shaders.setProgramUniformMatrix4ARB("shadowProjectionInverse", false, shadowProjectionInverse);
                Shaders.setProgramUniformMatrix4ARB("shadowModelView", false, shadowModelView);
                Shaders.setProgramUniformMatrix4ARB("shadowModelViewInverse", false, shadowModelViewInverse);
            }
        }
        ItemStack stack = Shaders.mc.thePlayer.inventory.getCurrentItem();
        Shaders.setProgramUniform1i("heldItemId", stack == null ? -1 : stack.itemID);
        Shaders.setProgramUniform1i("heldBlockLightValue", stack == null || stack.itemID >= 256 ? 0 : Block.lightValue[stack.itemID]);
        Shaders.setProgramUniform1i("fogMode", fogEnabled ? GL11.glGetInteger((int)2917) : 0);
        Shaders.setProgramUniform1i("worldTime", (int)(Shaders.mc.theWorld.getWorldTime() % 24000L));
        Shaders.setProgramUniform1f("aspectRatio", (float)renderWidth / (float)renderHeight);
        Shaders.setProgramUniform1f("viewWidth", renderWidth);
        Shaders.setProgramUniform1f("viewHeight", renderHeight);
        Shaders.setProgramUniform1f("near", 0.05f);
        Shaders.setProgramUniform1f("far", 256 >> Shaders.mc.gameSettings.renderDistance);
        Shaders.setProgramUniform3f("sunPosition", sunPosition[0], sunPosition[1], sunPosition[2]);
        Shaders.setProgramUniform3f("moonPosition", moonPosition[0], moonPosition[1], moonPosition[2]);
        Shaders.setProgramUniform3f("previousCameraPosition", (float)previousCameraPosition[0], (float)previousCameraPosition[1], (float)previousCameraPosition[2]);
        Shaders.setProgramUniform3f("cameraPosition", (float)cameraPosition[0], (float)cameraPosition[1], (float)cameraPosition[2]);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelView", false, modelView);
        Shaders.setProgramUniformMatrix4ARB("gbufferModelViewInverse", false, modelViewInverse);
    }

    public static void setProgramUniform1i(String name, int x) {
        if (activeProgram == 0) {
            return;
        }
        int uniform = ARBShaderObjects.glGetUniformLocationARB((int)programs[activeProgram], (CharSequence)name);
        ARBShaderObjects.glUniform1iARB((int)uniform, (int)x);
    }

    public static void setProgramUniform1f(String name, float x) {
        if (activeProgram == 0) {
            return;
        }
        int uniform = ARBShaderObjects.glGetUniformLocationARB((int)programs[activeProgram], (CharSequence)name);
        ARBShaderObjects.glUniform1fARB((int)uniform, (float)x);
    }

    public static void setProgramUniform3f(String name, float x, float y, float z) {
        if (activeProgram == 0) {
            return;
        }
        int uniform = ARBShaderObjects.glGetUniformLocationARB((int)programs[activeProgram], (CharSequence)name);
        ARBShaderObjects.glUniform3fARB((int)uniform, (float)x, (float)y, (float)z);
    }

    public static void setProgramUniformMatrix4ARB(String name, boolean transpose, FloatBuffer matrix) {
        if (activeProgram == 0 || matrix == null) {
            return;
        }
        int uniform = GL20.glGetUniformLocation((int)programs[activeProgram], (CharSequence)name);
        ARBShaderObjects.glUniformMatrix4ARB((int)uniform, (boolean)transpose, (FloatBuffer)matrix);
    }

    public static void setCelestialPosition() {
        FloatBuffer modelView = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)modelView);
        float[] mv = new float[16];
        modelView.get(mv, 0, 16);
        float[] sunPos = Shaders.multiplyMat4xVec4(mv, new float[]{0.0f, 100.0f, 0.0f, 0.0f});
        sunPosition = sunPos;
        float[] moonPos = Shaders.multiplyMat4xVec4(mv, new float[]{0.0f, -100.0f, 0.0f, 0.0f});
        moonPosition = moonPos;
    }

    public static void glDrawArraysWrapper(int mode, int first, int count, ShortBuffer shortBuffer) {
        if (entityAttrib >= 0) {
            ARBVertexProgram.glEnableVertexAttribArrayARB((int)entityAttrib);
            ARBVertexProgram.glVertexAttribPointerARB((int)entityAttrib, (int)2, (boolean)false, (boolean)false, (int)4, (ShortBuffer)((ShortBuffer)shortBuffer.position(0)));
        }
        GL11.glDrawArrays((int)mode, (int)first, (int)count);
        if (entityAttrib >= 0) {
            ARBVertexProgram.glDisableVertexAttribArrayARB((int)entityAttrib);
        }
    }

    public static int sortAndRenderWrapper(RenderGlobal renderGlobal, EntityLiving entityLiving, int i, double d) {
        if (i == 0) {
            Shaders.beginTerrain();
        } else if (i == 1) {
            Shaders.beginWater();
        }
        int result = renderGlobal.sortAndRender(entityLiving, i, d);
        if (i == 0) {
            Shaders.endTerrain();
        } else if (i == 1) {
            Shaders.endWater();
        }
        return result;
    }

    private static float[] multiplyMat4xVec4(float[] ta, float[] tb) {
        float[] mout = new float[]{ta[0] * tb[0] + ta[4] * tb[1] + ta[8] * tb[2] + ta[12] * tb[3], ta[1] * tb[0] + ta[5] * tb[1] + ta[9] * tb[2] + ta[13] * tb[3], ta[2] * tb[0] + ta[6] * tb[1] + ta[10] * tb[2] + ta[14] * tb[3], ta[3] * tb[0] + ta[7] * tb[1] + ta[11] * tb[2] + ta[15] * tb[3]};
        return mout;
    }

    private static FloatBuffer invertMat4x(FloatBuffer matin) {
        int i;
        float[] m = new float[16];
        float[] inv = new float[16];
        for (i = 0; i < 16; ++i) {
            m[i] = matin.get(i);
        }
        inv[0] = m[5] * m[10] * m[15] - m[5] * m[11] * m[14] - m[9] * m[6] * m[15] + m[9] * m[7] * m[14] + m[13] * m[6] * m[11] - m[13] * m[7] * m[10];
        inv[4] = -m[4] * m[10] * m[15] + m[4] * m[11] * m[14] + m[8] * m[6] * m[15] - m[8] * m[7] * m[14] - m[12] * m[6] * m[11] + m[12] * m[7] * m[10];
        inv[8] = m[4] * m[9] * m[15] - m[4] * m[11] * m[13] - m[8] * m[5] * m[15] + m[8] * m[7] * m[13] + m[12] * m[5] * m[11] - m[12] * m[7] * m[9];
        inv[12] = -m[4] * m[9] * m[14] + m[4] * m[10] * m[13] + m[8] * m[5] * m[14] - m[8] * m[6] * m[13] - m[12] * m[5] * m[10] + m[12] * m[6] * m[9];
        inv[1] = -m[1] * m[10] * m[15] + m[1] * m[11] * m[14] + m[9] * m[2] * m[15] - m[9] * m[3] * m[14] - m[13] * m[2] * m[11] + m[13] * m[3] * m[10];
        inv[5] = m[0] * m[10] * m[15] - m[0] * m[11] * m[14] - m[8] * m[2] * m[15] + m[8] * m[3] * m[14] + m[12] * m[2] * m[11] - m[12] * m[3] * m[10];
        inv[9] = -m[0] * m[9] * m[15] + m[0] * m[11] * m[13] + m[8] * m[1] * m[15] - m[8] * m[3] * m[13] - m[12] * m[1] * m[11] + m[12] * m[3] * m[9];
        inv[13] = m[0] * m[9] * m[14] - m[0] * m[10] * m[13] - m[8] * m[1] * m[14] + m[8] * m[2] * m[13] + m[12] * m[1] * m[10] - m[12] * m[2] * m[9];
        inv[2] = m[1] * m[6] * m[15] - m[1] * m[7] * m[14] - m[5] * m[2] * m[15] + m[5] * m[3] * m[14] + m[13] * m[2] * m[7] - m[13] * m[3] * m[6];
        inv[6] = -m[0] * m[6] * m[15] + m[0] * m[7] * m[14] + m[4] * m[2] * m[15] - m[4] * m[3] * m[14] - m[12] * m[2] * m[7] + m[12] * m[3] * m[6];
        inv[10] = m[0] * m[5] * m[15] - m[0] * m[7] * m[13] - m[4] * m[1] * m[15] + m[4] * m[3] * m[13] + m[12] * m[1] * m[7] - m[12] * m[3] * m[5];
        inv[14] = -m[0] * m[5] * m[14] + m[0] * m[6] * m[13] + m[4] * m[1] * m[14] - m[4] * m[2] * m[13] - m[12] * m[1] * m[6] + m[12] * m[2] * m[5];
        inv[3] = -m[1] * m[6] * m[11] + m[1] * m[7] * m[10] + m[5] * m[2] * m[11] - m[5] * m[3] * m[10] - m[9] * m[2] * m[7] + m[9] * m[3] * m[6];
        inv[7] = m[0] * m[6] * m[11] - m[0] * m[7] * m[10] - m[4] * m[2] * m[11] + m[4] * m[3] * m[10] + m[8] * m[2] * m[7] - m[8] * m[3] * m[6];
        inv[11] = -m[0] * m[5] * m[11] + m[0] * m[7] * m[9] + m[4] * m[1] * m[11] - m[4] * m[3] * m[9] - m[8] * m[1] * m[7] + m[8] * m[3] * m[5];
        inv[15] = m[0] * m[5] * m[10] - m[0] * m[6] * m[9] - m[4] * m[1] * m[10] + m[4] * m[2] * m[9] + m[8] * m[1] * m[6] - m[8] * m[2] * m[5];
        float det = m[0] * inv[0] + m[1] * inv[4] + m[2] * inv[8] + m[3] * inv[12];
        FloatBuffer invout = BufferUtils.createFloatBuffer((int)16);
        if ((double)det == 0.0) {
            return invout;
        }
        for (i = 0; i < 16; ++i) {
            invout.put(i, inv[i] / det);
        }
        return invout;
    }

    private static int createVertShader(String filename) {
        BufferedReader reader;
        int vertShader = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        if (vertShader == 0) {
            return 0;
        }
        String vertexCode = "";
        try {
            reader = new BufferedReader(new InputStreamReader(Shaders.class.getResourceAsStream(filename)));
        }
        catch (Exception e) {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
            }
            catch (Exception e2) {
                System.out.println("Couldn't open " + filename + "!");
                ARBShaderObjects.glDeleteObjectARB((int)vertShader);
                return 0;
            }
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                vertexCode = vertexCode + line + "\n";
                if (!line.matches("attribute [_a-zA-Z0-9]+ mc_Entity.*")) continue;
                entityAttrib = 10;
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't read " + filename + "!");
            ARBShaderObjects.glDeleteObjectARB((int)vertShader);
            return 0;
        }
        ARBShaderObjects.glShaderSourceARB((int)vertShader, (CharSequence)vertexCode);
        ARBShaderObjects.glCompileShaderARB((int)vertShader);
        Shaders.printLogInfo(vertShader);
        return vertShader;
    }

    private static int createFragShader(String filename) {
        BufferedReader reader;
        int fragShader = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
        if (fragShader == 0) {
            return 0;
        }
        String fragCode = "";
        try {
            reader = new BufferedReader(new InputStreamReader(Shaders.class.getResourceAsStream(filename)));
        }
        catch (Exception e) {
            try {
                reader = new BufferedReader(new FileReader(new File(filename)));
            }
            catch (Exception e2) {
                System.out.println("Couldn't open " + filename + "!");
                ARBShaderObjects.glDeleteObjectARB((int)fragShader);
                return 0;
            }
        }
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String[] parts;
                fragCode = fragCode + line + "\n";
                if (colorAttachments < 5 && line.matches("uniform [ _a-zA-Z0-9]+ gaux1;.*")) {
                    colorAttachments = 5;
                    continue;
                }
                if (colorAttachments < 6 && line.matches("uniform [ _a-zA-Z0-9]+ gaux2;.*")) {
                    colorAttachments = 6;
                    continue;
                }
                if (colorAttachments < 7 && line.matches("uniform [ _a-zA-Z0-9]+ gaux3;.*")) {
                    colorAttachments = 7;
                    continue;
                }
                if (colorAttachments < 8 && line.matches("uniform [ _a-zA-Z0-9]+ shadow;.*")) {
                    shadowPassInterval = 1;
                    colorAttachments = 8;
                    continue;
                }
                if (line.matches("/\\* SHADOWRES:[0-9]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map resolution: " + parts[2]);
                    shadowMapWidth = shadowMapHeight = Integer.parseInt(parts[2]);
                    continue;
                }
                if (line.matches("/\\* SHADOWFOV:[0-9\\.]+ \\*/.*")) {
                    parts = line.split("(:| )", 4);
                    System.out.println("Shadow map field of view: " + parts[2]);
                    shadowMapFOV = Float.parseFloat(parts[2]);
                    shadowMapIsOrtho = false;
                    continue;
                }
                if (!line.matches("/\\* SHADOWHPL:[0-9\\.]+ \\*/.*")) continue;
                parts = line.split("(:| )", 4);
                System.out.println("Shadow map half-plane: " + parts[2]);
                shadowMapHalfPlane = Float.parseFloat(parts[2]);
                shadowMapIsOrtho = true;
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't read " + filename + "!");
            ARBShaderObjects.glDeleteObjectARB((int)fragShader);
            return 0;
        }
        ARBShaderObjects.glShaderSourceARB((int)fragShader, (CharSequence)fragCode);
        ARBShaderObjects.glCompileShaderARB((int)fragShader);
        Shaders.printLogInfo(fragShader);
        return fragShader;
    }

    private static boolean printLogInfo(int obj) {
        IntBuffer iVal = BufferUtils.createIntBuffer((int)1);
        ARBShaderObjects.glGetObjectParameterARB((int)obj, (int)35716, (IntBuffer)iVal);
        int length = iVal.get();
        if (length > 1) {
            ByteBuffer infoLog = BufferUtils.createByteBuffer((int)length);
            iVal.flip();
            ARBShaderObjects.glGetInfoLogARB((int)obj, (IntBuffer)iVal, (ByteBuffer)infoLog);
            byte[] infoBytes = new byte[length];
            infoLog.get(infoBytes);
            String out = new String(infoBytes);
            System.out.println("Info log:\n" + out);
            return false;
        }
        return true;
    }

    private static void setupFrameBuffer() {
        Shaders.setupRenderTextures();
        if (dfb != 0) {
            EXTFramebufferObject.glDeleteFramebuffersEXT((int)dfb);
            EXTFramebufferObject.glDeleteRenderbuffersEXT((IntBuffer)dfbRenderBuffers);
        }
        dfb = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)dfb);
        EXTFramebufferObject.glGenRenderbuffersEXT((IntBuffer)dfbRenderBuffers);
        for (int i = 0; i < colorAttachments; ++i) {
            EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)dfbRenderBuffers.get(i));
            if (i == 1) {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)34837, (int)renderWidth, (int)renderHeight);
            } else {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)6408, (int)renderWidth, (int)renderHeight);
            }
            EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)dfbDrawBuffers.get(i), (int)36161, (int)dfbRenderBuffers.get(i));
            EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)dfbDrawBuffers.get(i), (int)3553, (int)dfbTextures.get(i), (int)0);
        }
        EXTFramebufferObject.glDeleteRenderbuffersEXT((int)dfbDepthBuffer);
        dfbDepthBuffer = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)dfbDepthBuffer);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)6402, (int)renderWidth, (int)renderHeight);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)dfbDepthBuffer);
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            System.out.println("Failed creating framebuffer! (Status " + status + ")");
        }
    }

    private static void setupShadowFrameBuffer() {
        if (shadowPassInterval <= 0) {
            return;
        }
        Shaders.setupShadowRenderTexture();
        EXTFramebufferObject.glDeleteFramebuffersEXT((int)sfb);
        sfb = EXTFramebufferObject.glGenFramebuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)sfb);
        GL11.glDrawBuffer((int)0);
        GL11.glReadBuffer((int)0);
        EXTFramebufferObject.glDeleteRenderbuffersEXT((int)sfbDepthBuffer);
        sfbDepthBuffer = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)sfbDepthBuffer);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)6402, (int)shadowMapWidth, (int)shadowMapHeight);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)sfbDepthBuffer);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36096, (int)3553, (int)sfbDepthTexture, (int)0);
        int status = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        if (status != 36053) {
            System.out.println("Failed creating shadow framebuffer! (Status " + status + ")");
        }
    }

    private static void setupRenderTextures() {
        GL11.glDeleteTextures((IntBuffer)dfbTextures);
        GL11.glGenTextures((IntBuffer)dfbTextures);
        for (int i = 0; i < colorAttachments; ++i) {
            ByteBuffer buffer;
            GL11.glBindTexture((int)3553, (int)dfbTextures.get(i));
            GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            if (i == 1) {
                buffer = ByteBuffer.allocateDirect(renderWidth * renderHeight * 4 * 4);
                GL11.glTexImage2D((int)3553, (int)0, (int)34837, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5126, (ByteBuffer)buffer);
                continue;
            }
            buffer = ByteBuffer.allocateDirect(renderWidth * renderHeight * 4);
            GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)renderWidth, (int)renderHeight, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
        }
    }

    private static void setupShadowRenderTexture() {
        if (shadowPassInterval <= 0) {
            return;
        }
        GL11.glDeleteTextures((int)sfbDepthTexture);
        sfbDepthTexture = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)sfbDepthTexture);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10496.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10496.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        ByteBuffer buffer = ByteBuffer.allocateDirect(shadowMapWidth * shadowMapHeight * 4);
        GL11.glTexImage2D((int)3553, (int)0, (int)6402, (int)shadowMapWidth, (int)shadowMapHeight, (int)0, (int)6402, (int)5126, (ByteBuffer)buffer);
    }

    static {
        isShadowPass = false;
        sfb = 0;
        sfbColorTexture = 0;
        sfbDepthTexture = 0;
        sfbRenderBuffer = 0;
        sfbDepthBuffer = 0;
        shadowProjection = null;
        shadowProjectionInverse = null;
        shadowModelView = null;
        shadowModelViewInverse = null;
        colorAttachments = 0;
        dfbDrawBuffers = null;
        dfbTextures = null;
        dfbRenderBuffers = null;
        dfb = 0;
        dfbDepthBuffer = 0;
        activeProgram = 0;
        programNames = new String[]{"", "gbuffers_basic", "gbuffers_textured", "gbuffers_textured_lit", "gbuffers_terrain", "gbuffers_water", "gbuffers_hand", "gbuffers_weather", "composite", "final"};
        programBackups = new int[]{0, 0, 1, 2, 3, 4, 3, 3, 0, 0};
        programs = new int[10];
    }
}

