/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.BlendMethod;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.TexturePackChangeHandler;
import com.prupe.mcpatcher.ctm.RenderPassAPI;
import java.util.Arrays;
import java.util.Properties;
import net.minecraft.src.Block;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityRenderer;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.RenderGlobal;
import net.minecraft.src.ResourceAddress;
import org.lwjgl.opengl.GL11;

public class RenderPass {
    private static final MCLogger logger = MCLogger.getLogger("Better Glass");
    private static final ResourceAddress RENDERPASS_PROPERTIES = TexturePackAPI.newMCPatcherResourceAddress("renderpass.properties");
    private static final int[] baseRenderPass = new int[Block.blocksList.length];
    private static final int[] extraRenderPass = new int[Block.blocksList.length];
    private static BlendMethod blendMethod;
    private static boolean enableLightmap;
    private static int renderPass;
    private static int maxRenderPass;
    private static boolean ambientOcclusion;

    public static void start(int pass) {
        RenderPass.finish();
        renderPass = pass;
    }

    public static void finish() {
        renderPass = -1;
    }

    public static boolean skipAllRenderPasses(boolean[] skipRenderPass) {
        for (boolean b : skipRenderPass) {
            if (b) continue;
            return false;
        }
        return true;
    }

    public static int getBlockRenderPass(Block block) {
        if (renderPass <= 2) {
            return baseRenderPass[block.blockID];
        }
        return extraRenderPass[block.blockID];
    }

    public static boolean canRenderInPass(Block block, int pass, boolean renderThis) {
        if (baseRenderPass[block.blockID] < 2 && extraRenderPass[block.blockID] < 2) {
            return renderThis;
        }
        return pass == RenderPass.getBlockRenderPass(block);
    }

    public static boolean shouldSideBeRendered(Block block, IBlockAccess blockAccess, int i, int j, int k, int face) {
        if (block.shouldSideBeRendered(blockAccess, i, j, k, face)) {
            return true;
        }
        return extraRenderPass[blockAccess.getBlockId(i, j, k)] >= 0 && extraRenderPass[block.blockID] < 0;
    }

    public static boolean setAmbientOcclusion(boolean ambientOcclusion) {
        RenderPass.ambientOcclusion = ambientOcclusion;
        return ambientOcclusion;
    }

    public static float getAOBaseMultiplier(float multiplier) {
        return renderPass > 2 && !enableLightmap ? 1.0f : multiplier;
    }

    public static void doRenderPass(RenderGlobal renderer, EntityLiving camera, int pass, double partialTick) {
        if (pass > maxRenderPass) {
            return;
        }
        switch (pass) {
            case 2: {
                GL11.glDisable((int)2884);
                renderer.sortAndRender(camera, pass, partialTick);
                GL11.glEnable((int)2884);
                break;
            }
            case 3: {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPolygonOffset((float)-2.0f, (float)-2.0f);
                GL11.glEnable((int)32823);
                GL11.glEnable((int)2884);
                if (ambientOcclusion) {
                    GL11.glShadeModel((int)7425);
                }
                blendMethod.applyBlending();
                renderer.sortAndRender(camera, pass, partialTick);
                GL11.glPolygonOffset((float)0.0f, (float)0.0f);
                GL11.glDisable((int)32823);
                GL11.glDisable((int)3042);
                GL11.glShadeModel((int)7424);
                break;
            }
        }
    }

    public static void enableDisableLightmap(EntityRenderer renderer, double partialTick, int pass) {
        if (enableLightmap || pass != 3) {
            renderer.enableLightmap(partialTick);
        } else {
            renderer.disableLightmap(partialTick);
        }
    }

    static {
        renderPass = -1;
        maxRenderPass = 1;
        RenderPassAPI.instance = new RenderPassAPI(){

            @Override
            boolean skipDefaultRendering(Block block) {
                return renderPass > 1;
            }

            @Override
            boolean skipThisRenderPass(Block block, int pass) {
                if (pass < 0) {
                    pass = block.getRenderBlockPass();
                }
                return pass != renderPass;
            }

            @Override
            void clear() {
                maxRenderPass = 1;
                Arrays.fill(baseRenderPass, -1);
                Arrays.fill(extraRenderPass, -1);
                for (int i = 0; i < Block.blocksList.length; ++i) {
                    Block block = Block.blocksList[i];
                    if (block == null) continue;
                    baseRenderPass[i] = block.getRenderBlockPass();
                }
            }

            @Override
            void setRenderPassForBlock(Block block, int pass) {
                if (pass < 0) {
                    return;
                }
                if (pass <= 2) {
                    baseRenderPass[block.blockID] = pass;
                } else {
                    extraRenderPass[block.blockID] = pass;
                }
                maxRenderPass = Math.max(maxRenderPass, pass);
            }

            @Override
            void finish() {
                RenderPass.finish();
            }
        };
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Better Glass", 4){

            @Override
            public void beforeChange() {
                blendMethod = BlendMethod.ALPHA;
                enableLightmap = true;
            }

            @Override
            public void afterChange() {
                Properties properties = TexturePackAPI.getProperties(RENDERPASS_PROPERTIES);
                if (properties != null) {
                    String method = properties.getProperty("blend.3", "alpha").trim().toLowerCase();
                    blendMethod = BlendMethod.parse(method);
                    if (blendMethod == null) {
                        logger.error("%s: unknown blend method '%s'", RENDERPASS_PROPERTIES, method);
                        blendMethod = BlendMethod.ALPHA;
                    }
                    enableLightmap = MCPatcherUtils.getBooleanProperty(properties, "enableLightmap.3", !blendMethod.isColorBased());
                }
            }
        });
    }
}

