/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.converter;

import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.UserInterface;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;

public abstract class TexturePackConverter {
    public static final String MCPATCHER_CONVERT_PREFIX = "mcpatcher-converted-";
    protected final File input;
    protected File output;
    protected ZipFile inZip;
    protected final List<ZipEntry> inEntries = new ArrayList<ZipEntry>();
    private ZipOutputStream outZip;
    private final Map<String, ByteArrayOutputStream> outData = new HashMap<String, ByteArrayOutputStream>();
    private final List<String> messages = new ArrayList<String>();

    protected TexturePackConverter(File input) {
        this.input = input;
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public File getOutputFile() {
        return this.output;
    }

    protected abstract void convertImpl(UserInterface var1) throws Exception;

    public abstract String getOutputMessage();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean convert(UserInterface ui) {
        if (this.input.equals(this.output)) {
            this.addMessage(2, "ERROR: Input and output files are the same", new Object[0]);
            return false;
        }
        try {
            this.preConvert(ui);
            this.convertImpl(ui);
            this.postConvert(ui);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.addMessage(2, "ERROR: %s", e);
            MCPatcherUtils.close(this.outZip);
            if (this.output.isFile()) {
                this.addMessage(0, "deleting %s", this.output.getPath());
                this.output.delete();
            }
            boolean bl = false;
            return bl;
        }
        finally {
            MCPatcherUtils.close(this.inZip);
            MCPatcherUtils.close(this.outZip);
        }
        return true;
    }

    private void preConvert(UserInterface ui) throws IOException {
        this.messages.clear();
        this.addMessage(0, "", new Object[0]);
        this.addMessage(0, "Converting texture pack", new Object[0]);
        ui.setStatusText("Reading %s...", this.input.getName());
        this.inZip = new ZipFile(this.input);
        this.inEntries.clear();
        for (ZipEntry zipEntry : Collections.list(this.inZip.entries())) {
            if (zipEntry.isDirectory()) continue;
            this.inEntries.add(zipEntry);
        }
        Collections.sort(this.inEntries, new Comparator<ZipEntry>(){

            @Override
            public int compare(ZipEntry o1, ZipEntry o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.addMessage(0, "  input:  %s", this.input.getPath());
        this.addMessage(0, "    %d bytes", this.input.length());
        this.addMessage(0, "    %d files", this.inEntries.size());
        this.addMessage(0, "  output: %s", this.output.getPath());
    }

    private void postConvert(UserInterface ui) throws IOException {
        MCPatcherUtils.close(this.inZip);
        this.inZip = null;
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.outData.keySet());
        Iterator i$ = names.iterator();
        while (i$.hasNext()) {
            String name;
            String s = name = (String)i$.next();
            while (!s.equals("")) {
                s = s.replaceFirst("[^/]+$", "");
                this.addDirectory(s);
                s = s.replaceFirst("/$", "");
            }
        }
        this.removeEntry("");
        ArrayList<Map.Entry<String, ByteArrayOutputStream>> outEntries = new ArrayList<Map.Entry<String, ByteArrayOutputStream>>();
        ui.setStatusText("Writing %s...", this.output.getName());
        this.addMessage(0, "", new Object[0]);
        this.addMessage(0, "Writing %s", this.output.getName());
        outEntries.addAll(this.outData.entrySet());
        Collections.sort(outEntries, new Comparator<Map.Entry<String, ByteArrayOutputStream>>(){

            @Override
            public int compare(Map.Entry<String, ByteArrayOutputStream> o1, Map.Entry<String, ByteArrayOutputStream> o2) {
                return o1.getKey().compareTo(o2.getKey());
            }
        });
        this.outZip = new ZipOutputStream(new FileOutputStream(this.output));
        int total = outEntries.size();
        int progress = 0;
        int numOutFiles = 0;
        for (Map.Entry entry : outEntries) {
            ui.updateProgress(progress++, total);
            String name = (String)entry.getKey();
            ByteArrayOutputStream data = (ByteArrayOutputStream)entry.getValue();
            this.outZip.putNextEntry(new ZipEntry(name));
            this.addMessage(0, "  %s", name);
            if (data == null) continue;
            this.outZip.write(data.toByteArray());
            this.outZip.closeEntry();
            ++numOutFiles;
        }
        this.outZip.close();
        this.outZip = null;
        ui.setStatusText("", new Object[0]);
        this.addMessage(0, "", new Object[0]);
        this.addMessage(0, "Conversion finished", new Object[0]);
        this.addMessage(0, "  input:  %s", this.input.getPath());
        this.addMessage(0, "    %d bytes", this.input.length());
        this.addMessage(0, "    %d files", this.inEntries.size());
        this.addMessage(0, "  output: %s", this.output.getPath());
        this.addMessage(0, "    %d bytes", this.output.length());
        this.addMessage(0, "    %d files", numOutFiles);
    }

    protected static String getEntryName(String name) {
        return name.replaceFirst("^/", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getProperties(String name) {
        ZipEntry entry = this.inZip.getEntry(TexturePackConverter.getEntryName(name));
        if (entry != null) {
            Properties properties;
            InputStream inputStream = null;
            try {
                inputStream = this.inZip.getInputStream(entry);
                Properties properties2 = new Properties();
                properties2.load(inputStream);
                properties = properties2;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(inputStream);
                    throw throwable;
                }
                MCPatcherUtils.close(inputStream);
            }
            MCPatcherUtils.close(inputStream);
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage getImage(String name) {
        ZipEntry entry = this.inZip.getEntry(TexturePackConverter.getEntryName(name));
        if (entry != null) {
            BufferedImage bufferedImage;
            InputStream inputStream = null;
            try {
                inputStream = this.inZip.getInputStream(entry);
                bufferedImage = ImageIO.read(inputStream);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(inputStream);
                    throw throwable;
                }
                MCPatcherUtils.close(inputStream);
            }
            MCPatcherUtils.close(inputStream);
            return bufferedImage;
        }
        return null;
    }

    protected void copyEntry(ZipEntry in) {
        this.copyEntry(in, in.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyEntry(ZipEntry in, String outName) {
        InputStream inputStream = null;
        OutputStream outputStream = this.getOutputStream(outName);
        try {
            int count;
            inputStream = this.inZip.getInputStream(in);
            byte[] buffer = new byte[1024];
            while ((count = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                MCPatcherUtils.close(inputStream);
                MCPatcherUtils.close(outputStream);
                throw throwable;
            }
            MCPatcherUtils.close(inputStream);
            MCPatcherUtils.close(outputStream);
        }
        MCPatcherUtils.close(inputStream);
        MCPatcherUtils.close(outputStream);
    }

    protected void addDirectory(String name) {
        this.outData.put(TexturePackConverter.getEntryName(name), null);
    }

    protected void removeEntry(String name) {
        this.outData.remove(TexturePackConverter.getEntryName(name));
    }

    protected boolean hasEntry(String name) {
        return this.outData.containsKey(TexturePackConverter.getEntryName(name));
    }

    protected void addEntry(String name, Properties properties) {
        this.addEntry(name, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEntry(String name, Properties properties, String comment) {
        OutputStream outputStream = this.getOutputStream(name);
        try {
            properties.store(outputStream, comment);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            MCPatcherUtils.close(outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEntry(String name, BufferedImage image) {
        OutputStream outputStream = this.getOutputStream(name);
        try {
            ImageIO.write((RenderedImage)image, "png", outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            MCPatcherUtils.close(outputStream);
        }
    }

    protected OutputStream getOutputStream(String name) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.outData.put(TexturePackConverter.getEntryName(name), outputStream);
        return outputStream;
    }

    protected void addMessage(int level, String format, Object ... params) {
        String message = String.format(format, params);
        Logger.log(0, "%s", message);
        if (level > 0) {
            this.messages.add(message);
        }
    }
}

