/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.TileLoader;
import com.prupe.mcpatcher.cit.OverrideBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.src.Icon;
import net.minecraft.src.ResourceAddress;

final class ItemOverride
extends OverrideBase {
    private static final int ITEM_ID_COMPASS = 345;
    private static final int ITEM_ID_CLOCK = 347;
    private Icon icon;
    private final Map<Icon, Icon> iconMap;

    ItemOverride(ResourceAddress propertiesName, Properties properties) {
        super(propertiesName, properties);
        if (this.itemsIDs == null) {
            this.error("no matching items specified", new Object[0]);
        }
        this.iconMap = this.alternateTextures == null ? null : new HashMap();
    }

    @Override
    String getType() {
        return "item";
    }

    Icon getReplacementIcon(Icon origIcon) {
        Icon newIcon;
        if (this.iconMap != null && (newIcon = this.iconMap.get(origIcon)) != null) {
            return newIcon;
        }
        return this.icon;
    }

    void preload(TileLoader tileLoader) {
        String special = null;
        if (this.itemsIDs != null) {
            if (this.itemsIDs.get(345)) {
                special = "compass";
            } else if (this.itemsIDs.get(347)) {
                special = "clock";
            }
        }
        tileLoader.preloadTile(this.textureName, false, special);
        if (this.alternateTextures != null) {
            for (Map.Entry entry : this.alternateTextures.entrySet()) {
                tileLoader.preloadTile((ResourceAddress)entry.getValue(), false, special);
            }
        }
    }

    void registerIcon(TileLoader tileLoader) {
        this.icon = tileLoader.getIcon(this.textureName.getPath());
        if (this.alternateTextures != null) {
            for (Map.Entry entry : this.alternateTextures.entrySet()) {
                Icon from = tileLoader.getIcon((String)entry.getKey());
                Icon to = tileLoader.getIcon(((ResourceAddress)entry.getValue()).getPath());
                if (from == null || to == null) continue;
                this.iconMap.put(from, to);
            }
        }
    }
}

