/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.cit.CITUtils;
import com.prupe.mcpatcher.cit.Enchantment;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import net.minecraft.src.ItemStack;

final class EnchantmentList {
    private static final MCLogger logger = MCLogger.getLogger("Custom Item Textures", "CIT");
    private static final float PI = (float)Math.PI;
    private static LayerMethod applyMethod;
    private static int limit;
    private static float fade;
    private final List<Layer> layers = new ArrayList<Layer>();

    static void setProperties(Properties properties) {
        applyMethod = new Average();
        limit = 99;
        fade = 0.5f;
        if (properties != null) {
            String value = MCPatcherUtils.getStringProperty(properties, "method", "average").toLowerCase();
            if (value.equals("layered")) {
                applyMethod = new Layered();
            } else if (value.equals("cycle")) {
                applyMethod = new Cycle();
            } else if (!value.equals("average")) {
                logger.warning("%s: unknown enchantment layering method '%s'", "cit.properties", value);
            }
            limit = Math.max(MCPatcherUtils.getIntProperty(properties, "cap", limit), 0);
            fade = Math.max(MCPatcherUtils.getFloatProperty(properties, "fade", fade), 0.0f);
        }
    }

    EnchantmentList(Enchantment[][] enchantments, ItemStack itemStack) {
        BitSet layersPresent = new BitSet();
        HashMap<Integer, Layer> tmpLayers = new HashMap<Integer, Layer>();
        int itemID = itemStack.itemID;
        int[] enchantmentLevels = CITUtils.getEnchantmentLevels(itemID, itemStack.stackTagCompound);
        boolean hasEffect = itemStack.hasEffect();
        if (itemID >= 0 && itemID < enchantments.length && enchantments[itemID] != null) {
            for (Enchantment enchantment : enchantments[itemID]) {
                if (!enchantment.match(itemStack, enchantmentLevels, hasEffect)) continue;
                int level = Math.max(enchantment.lastEnchantmentLevel, 1);
                int layer = enchantment.layer;
                if (layersPresent.get(layer)) continue;
                Layer newLayer = new Layer(enchantment, level);
                tmpLayers.put(layer, newLayer);
                layersPresent.set(layer);
            }
        }
        if (layersPresent.isEmpty()) {
            return;
        }
        while (layersPresent.cardinality() > limit) {
            int layer = layersPresent.nextSetBit(0);
            layersPresent.clear(layer);
            tmpLayers.remove(layer);
        }
        int i = layersPresent.nextSetBit(0);
        while (i >= 0) {
            this.layers.add((Layer)tmpLayers.get(i));
            i = layersPresent.nextSetBit(i + 1);
        }
        applyMethod.computeIntensities(this);
    }

    boolean isEmpty() {
        return this.layers.isEmpty();
    }

    int size() {
        return this.layers.size();
    }

    Enchantment getEnchantment(int index) {
        return this.layers.get((int)index).enchantment;
    }

    float getIntensity(int index) {
        return this.layers.get((int)index).intensity;
    }

    private static final class Cycle
    extends LayerMethod {
        private Cycle() {
        }

        @Override
        void computeIntensities(EnchantmentList enchantments) {
            float total = 0.0f;
            for (Layer layer : enchantments.layers) {
                total += layer.getEffectiveDuration();
            }
            float timestamp = (float)((double)System.currentTimeMillis() / 1000.0 % (double)total);
            for (Layer layer : enchantments.layers) {
                if (timestamp <= 0.0f) break;
                float duration = layer.getEffectiveDuration();
                if (timestamp < duration) {
                    float denominator = (float)Math.sin((float)Math.PI * fade / duration);
                    layer.intensity = (float)(Math.sin((float)Math.PI * timestamp / duration) / (double)(denominator == 0.0f ? 1.0f : denominator));
                }
                timestamp -= duration;
            }
        }
    }

    private static final class Layered
    extends LayerMethod {
        private Layered() {
        }

        @Override
        void computeIntensities(EnchantmentList enchantments) {
            int max = 0;
            for (Layer layer : enchantments.layers) {
                Math.max(max, layer.level);
            }
            this.scaleIntensities(enchantments, max);
        }
    }

    private static final class Average
    extends LayerMethod {
        private Average() {
        }

        @Override
        void computeIntensities(EnchantmentList enchantments) {
            int total = 0;
            for (Layer layer : enchantments.layers) {
                total += layer.level;
            }
            this.scaleIntensities(enchantments, total);
        }
    }

    private static abstract class LayerMethod {
        private LayerMethod() {
        }

        abstract void computeIntensities(EnchantmentList var1);

        protected void scaleIntensities(EnchantmentList enchantments, int denominator) {
            if (denominator > 0) {
                for (Layer layer : enchantments.layers) {
                    layer.intensity = (float)layer.level / (float)denominator;
                }
            } else {
                for (Layer layer : enchantments.layers) {
                    layer.intensity = layer.level > 0 ? 1.0f : 0.0f;
                }
            }
        }
    }

    private static final class Layer {
        final Enchantment enchantment;
        final int level;
        float intensity;

        Layer(Enchantment enchantment, int level) {
            this.enchantment = enchantment;
            this.level = level;
        }

        float getEffectiveDuration() {
            return this.enchantment.duration + 2.0f * fade;
        }
    }
}

