/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.BlendMethod;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.cit.OverrideBase;
import java.util.Properties;
import net.minecraft.src.ItemRenderer;
import net.minecraft.src.ResourceAddress;
import net.minecraft.src.Tessellator;
import org.lwjgl.opengl.GL11;

final class Enchantment
extends OverrideBase {
    private static final float ITEM_2D_THICKNESS = 0.0625f;
    final int layer;
    private final BlendMethod blendMethod;
    private final float rotation;
    private final float speed;
    final float duration;

    static void beginOuter2D() {
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)516);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2896);
        GL11.glMatrixMode((int)5890);
    }

    static void endOuter2D() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthFunc((int)515);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glMatrixMode((int)5888);
    }

    static void beginOuter3D() {
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)514);
        GL11.glDisable((int)2896);
        GL11.glMatrixMode((int)5890);
    }

    static void endOuter3D() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthFunc((int)515);
        GL11.glEnable((int)2896);
        GL11.glMatrixMode((int)5888);
    }

    Enchantment(ResourceAddress propertiesName, Properties properties) {
        super(propertiesName, properties);
        if (!this.error && this.textureName == null) {
            this.error("no source texture specified", new Object[0]);
        }
        this.layer = MCPatcherUtils.getIntProperty(properties, "layer", 0);
        String value = MCPatcherUtils.getStringProperty(properties, "blend", "add");
        this.blendMethod = BlendMethod.parse(value);
        if (this.blendMethod == null) {
            this.error("unknown blend type %s", value);
        }
        this.rotation = MCPatcherUtils.getFloatProperty(properties, "rotation", 0.0f);
        this.speed = MCPatcherUtils.getFloatProperty(properties, "speed", 0.0f);
        this.duration = MCPatcherUtils.getFloatProperty(properties, "duration", 1.0f);
    }

    @Override
    String getType() {
        return "enchantment";
    }

    void render2D(Tessellator tessellator, float intensity, float x0, float y0, float x1, float y1, float z) {
        if (intensity <= 0.0f) {
            return;
        }
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        this.begin(intensity);
        tessellator.startDrawingQuads();
        tessellator.addVertexWithUV((double)x0, (double)y0, (double)z, 0.0, 0.0);
        tessellator.addVertexWithUV((double)x0, (double)y1, (double)z, 0.0, 1.0);
        tessellator.addVertexWithUV((double)x1, (double)y1, (double)z, 1.0, 1.0);
        tessellator.addVertexWithUV((double)x1, (double)y0, (double)z, 1.0, 0.0);
        tessellator.draw();
        this.end();
    }

    void render3D(Tessellator tessellator, float intensity, int width, int height) {
        if (intensity <= 0.0f) {
            return;
        }
        if (intensity > 1.0f) {
            intensity = 1.0f;
        }
        this.begin(intensity);
        ItemRenderer.renderItemIn2D((Tessellator)tessellator, (float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f, (int)width, (int)height, (float)0.0625f);
        this.end();
    }

    void beginArmor(float intensity) {
        GL11.glEnable((int)3042);
        GL11.glDepthFunc((int)514);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2896);
        GL11.glMatrixMode((int)5890);
        this.begin(intensity);
        GL11.glMatrixMode((int)5888);
    }

    void endArmor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glDepthFunc((int)515);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glMatrixMode((int)5890);
        this.end();
        GL11.glLoadIdentity();
        GL11.glMatrixMode((int)5888);
    }

    private void begin(float intensity) {
        TexturePackAPI.bindTexture(this.textureName);
        this.blendMethod.applyBlending();
        this.blendMethod.applyFade(intensity);
        GL11.glPushMatrix();
        if (this.speed != 0.0f) {
            float offset = (float)(System.currentTimeMillis() % 3000L) / 3000.0f * 8.0f;
            GL11.glTranslatef((float)(offset * this.speed), (float)0.0f, (float)0.0f);
        }
        GL11.glRotatef((float)this.rotation, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    private void end() {
        GL11.glPopMatrix();
    }
}

