/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.cit.OverrideBase;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.src.ResourceAddress;

final class ArmorOverride
extends OverrideBase {
    private final Map<ResourceAddress, ResourceAddress> armorMap;

    ArmorOverride(ResourceAddress propertiesName, Properties properties) {
        super(propertiesName, properties);
        if (this.itemsIDs == null) {
            this.error("no matching items specified", new Object[0]);
        }
        if (this.textureName == null && this.alternateTextures == null) {
            this.error("no replacement textures specified", new Object[0]);
        }
        if (this.alternateTextures == null) {
            this.armorMap = null;
        } else {
            this.armorMap = new HashMap<ResourceAddress, ResourceAddress>();
            for (Map.Entry entry : this.alternateTextures.entrySet()) {
                String key = (String)entry.getKey();
                ResourceAddress value = (ResourceAddress)entry.getValue();
                if (!key.endsWith(".png")) {
                    key = key + ".png";
                }
                this.armorMap.put(TexturePackAPI.parseResourceAddress(propertiesName, key), value);
            }
        }
    }

    @Override
    String getType() {
        return "armor";
    }

    ResourceAddress getReplacementTexture(ResourceAddress origResource) {
        ResourceAddress newResource;
        if (this.armorMap != null && (newResource = this.armorMap.get(origResource)) != null) {
            return newResource;
        }
        return this.textureName;
    }
}

