/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.cc.Colorizer;
import java.util.Properties;
import java.util.Random;
import net.minecraft.src.EntitySheep;
import net.minecraft.src.ItemDye;
import net.minecraft.src.ResourceAddress;

public class ColorizeEntity {
    private static final ResourceAddress LAVA_DROP_COLORS = TexturePackAPI.newMCPatcherResourceAddress("colormap/lavadrop.png");
    private static final ResourceAddress MYCELIUM_COLORS = TexturePackAPI.newMCPatcherResourceAddress("colormap/myceliumparticle.png");
    private static final ResourceAddress XPORB_COLORS = TexturePackAPI.newMCPatcherResourceAddress("colormap/xporb.png");
    static float[] waterBaseColor;
    private static float[] lavaDropColors;
    public static float[] portalColor;
    private static final Random random;
    private static int[] myceliumColors;
    private static int[] xpOrbColors;
    private static final int[] origDyeColors;
    private static final float[][] origFleeceColors;
    public static final float[][] armorColors;
    public static int undyedLeatherColor;
    public static final float[][] collarColors;

    static void reset() {
        waterBaseColor = new float[]{0.2f, 0.3f, 1.0f};
        portalColor = new float[]{1.0f, 0.3f, 0.9f};
        lavaDropColors = null;
        System.arraycopy(origDyeColors, 0, ItemDye.dyeColors, 0, origDyeColors.length);
        for (int i = 0; i < origFleeceColors.length; ++i) {
            EntitySheep.fleeceColorTable[i] = (float[])origFleeceColors[i].clone();
            ColorizeEntity.armorColors[i] = (float[])origFleeceColors[i].clone();
            ColorizeEntity.collarColors[i] = (float[])origFleeceColors[i].clone();
        }
        undyedLeatherColor = 10511680;
        myceliumColors = null;
        xpOrbColors = null;
    }

    static void reloadParticleColors(Properties properties) {
        Colorizer.loadFloatColor("drop.water", waterBaseColor);
        Colorizer.loadFloatColor("particle.water", waterBaseColor);
        Colorizer.loadFloatColor("particle.portal", portalColor);
        int[] rgb = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(LAVA_DROP_COLORS));
        if (rgb != null) {
            lavaDropColors = new float[3 * rgb.length];
            for (int i = 0; i < rgb.length; ++i) {
                Colorizer.intToFloat3(rgb[i], lavaDropColors, 3 * i);
            }
        }
        myceliumColors = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(MYCELIUM_COLORS));
    }

    static void reloadDyeColors(Properties properties) {
        int i;
        for (i = 0; i < ItemDye.dyeColors.length; ++i) {
            Colorizer.loadIntColor("dye." + Colorizer.getStringKey(ItemDye.dyeColorNames, i), ItemDye.dyeColors, i);
        }
        for (i = 0; i < EntitySheep.fleeceColorTable.length; ++i) {
            String key = Colorizer.getStringKey(ItemDye.dyeColorNames, EntitySheep.fleeceColorTable.length - 1 - i);
            Colorizer.loadFloatColor("sheep." + key, EntitySheep.fleeceColorTable[i]);
            Colorizer.loadFloatColor("armor." + key, armorColors[i]);
            Colorizer.loadFloatColor("collar." + key, collarColors[i]);
        }
        undyedLeatherColor = Colorizer.loadIntColor("armor.default", undyedLeatherColor);
    }

    static void reloadXPOrbColors(Properties properties) {
        xpOrbColors = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(XPORB_COLORS));
    }

    public static int colorizeXPOrb(int origColor, float timer) {
        if (xpOrbColors == null || xpOrbColors.length == 0) {
            return origColor;
        }
        return xpOrbColors[(int)((Math.sin((double)timer / 4.0) + 1.0) * (double)(xpOrbColors.length - 1) / 2.0)];
    }

    public static boolean computeLavaDropColor(int age) {
        if (lavaDropColors == null) {
            return false;
        }
        int offset = 3 * Math.max(Math.min(lavaDropColors.length / 3 - 1, age - 20), 0);
        System.arraycopy(lavaDropColors, offset, Colorizer.setColor, 0, 3);
        return true;
    }

    public static boolean computeMyceliumParticleColor() {
        if (myceliumColors == null) {
            return false;
        }
        Colorizer.setColorF(myceliumColors[random.nextInt(myceliumColors.length)]);
        return true;
    }

    static {
        portalColor = new float[]{1.0f, 0.3f, 0.9f};
        random = new Random();
        origDyeColors = (int[])ItemDye.dyeColors.clone();
        origFleeceColors = new float[EntitySheep.fleeceColorTable.length][];
        armorColors = new float[EntitySheep.fleeceColorTable.length][];
        collarColors = new float[EntitySheep.fleeceColorTable.length][];
        try {
            for (int i = 0; i < EntitySheep.fleeceColorTable.length; ++i) {
                ColorizeEntity.origFleeceColors[i] = (float[])EntitySheep.fleeceColorTable[i].clone();
                ColorizeEntity.armorColors[i] = (float[])EntitySheep.fleeceColorTable[i].clone();
                ColorizeEntity.collarColors[i] = (float[])EntitySheep.fleeceColorTable[i].clone();
            }
            ColorizeEntity.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

