/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.cc.BiomeHelper;
import com.prupe.mcpatcher.cc.ColorMap;
import com.prupe.mcpatcher.cc.ColorizeEntity;
import com.prupe.mcpatcher.cc.Colorizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.ResourceAddress;
import org.lwjgl.opengl.GL11;

public class ColorizeBlock {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    private static final ResourceAddress REDSTONE_COLORS = TexturePackAPI.newMCPatcherResourceAddress("colormap/redstone.png");
    private static final ResourceAddress STEM_COLORS = TexturePackAPI.newMCPatcherResourceAddress("colormap/stem.png");
    private static final ResourceAddress SWAMPGRASSCOLOR = TexturePackAPI.newMCPatcherResourceAddress("colormap/swampgrass.png");
    private static final ResourceAddress SWAMPFOLIAGECOLOR = TexturePackAPI.newMCPatcherResourceAddress("colormap/swampfoliage.png");
    private static final ResourceAddress PINECOLOR = TexturePackAPI.newMCPatcherResourceAddress("colormap/pine.png");
    private static final ResourceAddress BIRCHCOLOR = TexturePackAPI.newMCPatcherResourceAddress("colormap/birch.png");
    private static final ResourceAddress FOLIAGECOLOR = TexturePackAPI.newMCPatcherResourceAddress("colormap/foliage.png");
    private static final ResourceAddress WATERCOLOR = TexturePackAPI.newMCPatcherResourceAddress("colormap/water.png");
    private static final ResourceAddress UNDERWATERCOLOR = TexturePackAPI.newMCPatcherResourceAddress("colormap/underwater.png");
    private static final ResourceAddress FOGCOLOR0 = TexturePackAPI.newMCPatcherResourceAddress("colormap/fog0.png");
    private static final ResourceAddress SKYCOLOR0 = TexturePackAPI.newMCPatcherResourceAddress("colormap/sky0.png");
    private static final String PALETTE_BLOCK_KEY = "palette.block.";
    private static final ColorMap[] blockColorMaps = new ColorMap[Block.blocksList.length];
    private static final Map<Float, ColorMap> blockMetaColorMaps = new HashMap<Float, ColorMap>();
    private static int lilypadColor;
    private static float[][] redstoneColor;
    private static int[] stemColors;
    private static final int blockBlendRadius;
    private static final float blockBlendScale;
    public static float[] waterColor;

    static void reset() {
        Colorizer.fixedColorMaps[0] = new ColorMap(0x4E4E4E);
        Colorizer.fixedColorMaps[1] = new ColorMap(0x4E4E4E);
        Colorizer.fixedColorMaps[2] = new ColorMap(0x619961);
        Colorizer.fixedColorMaps[3] = new ColorMap(8431445);
        Colorizer.fixedColorMaps[4] = new ColorMap(4764952);
        Colorizer.fixedColorMaps[5] = new ColorMap(0xFFFFFF);
        Colorizer.fixedColorMaps[6] = new ColorMap(329011);
        Colorizer.fixedColorMaps[7] = new ColorMap(12638463);
        Colorizer.fixedColorMaps[8] = new ColorMap(0xFFFFFF);
        Arrays.fill(blockColorMaps, null);
        blockMetaColorMaps.clear();
        lilypadColor = 2129968;
        waterColor = new float[]{0.2f, 0.3f, 1.0f};
        redstoneColor = null;
        stemColors = null;
    }

    static void reloadColorMaps(Properties properties) {
        Colorizer.fixedColorMaps[0].loadColorMap(Colorizer.useSwampColors, SWAMPGRASSCOLOR);
        Colorizer.fixedColorMaps[1].loadColorMap(Colorizer.useSwampColors, SWAMPFOLIAGECOLOR);
        Colorizer.fixedColorMaps[2].loadColorMap(Colorizer.useTreeColors, PINECOLOR);
        Colorizer.fixedColorMaps[3].loadColorMap(Colorizer.useTreeColors, BIRCHCOLOR);
        Colorizer.fixedColorMaps[4].loadColorMap(Colorizer.useTreeColors, FOLIAGECOLOR);
        Colorizer.fixedColorMaps[4].clear();
        Colorizer.fixedColorMaps[5].loadColorMap(Colorizer.useWaterColors, WATERCOLOR);
        Colorizer.fixedColorMaps[6].loadColorMap(Colorizer.useWaterColors, UNDERWATERCOLOR);
        Colorizer.fixedColorMaps[7].loadColorMap(Colorizer.useFogColors, FOGCOLOR0);
        Colorizer.fixedColorMaps[8].loadColorMap(Colorizer.useFogColors, SKYCOLOR0);
    }

    static void reloadSwampColors(Properties properties) {
        int[] temp = new int[]{lilypadColor};
        Colorizer.loadIntColor("lilypad", temp, 0);
        lilypadColor = temp[0];
    }

    static void reloadBlockColors(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ResourceAddress address;
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(PALETTE_BLOCK_KEY) || (address = TexturePackAPI.parseResourceAddress(Colorizer.COLOR_PROPERTIES, key.substring(PALETTE_BLOCK_KEY.length()).trim())) == null) continue;
            ColorMap colorMap = new ColorMap(0xFFFFFF);
            colorMap.loadColorMap(true, address);
            if (!colorMap.isCustom()) continue;
            block7: for (String idString : value.split("\\s+")) {
                String[] tokens = idString.split(":");
                int[] tokensInt = new int[tokens.length];
                try {
                    for (int i = 0; i < tokens.length; ++i) {
                        tokensInt[i] = Integer.parseInt(tokens[i]);
                    }
                }
                catch (NumberFormatException e) {
                    continue;
                }
                switch (tokensInt.length) {
                    case 1: {
                        if (tokensInt[0] < 0 || tokensInt[0] >= blockColorMaps.length) continue block7;
                        ColorizeBlock.blockColorMaps[tokensInt[0]] = colorMap;
                        break;
                    }
                    case 2: {
                        blockMetaColorMaps.put(Float.valueOf(ColorMap.getBlockMetaKey(tokensInt[0], tokensInt[1])), colorMap);
                        break;
                    }
                    default: {
                        continue block7;
                    }
                }
                logger.finer("using %s for block %s, default color %06x", key, idString, colorMap.colorize());
            }
        }
    }

    static void reloadRedstoneColors(Properties properties) {
        int[] rgb = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(REDSTONE_COLORS));
        if (rgb != null && rgb.length >= 16) {
            redstoneColor = new float[16][];
            for (int i = 0; i < 16; ++i) {
                float[] f = new float[3];
                Colorizer.intToFloat3(rgb[i], f);
                ColorizeBlock.redstoneColor[i] = f;
            }
        }
    }

    static void reloadStemColors(Properties properties) {
        int[] rgb = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(STEM_COLORS));
        if (rgb != null && rgb.length >= 8) {
            stemColors = rgb;
        }
    }

    public static int colorizeBiome(int defaultColor, int index, double temperature, double rainfall) {
        return Colorizer.fixedColorMaps[index].colorize(defaultColor, temperature, rainfall);
    }

    public static int colorizeBiome(int defaultColor, int index) {
        return Colorizer.fixedColorMaps[index].colorize(defaultColor);
    }

    public static int colorizeBiome(int defaultColor, int index, int i, int j, int k) {
        return Colorizer.fixedColorMaps[index].colorize(defaultColor, i, j, k);
    }

    public static int colorizeBiomeWithBlending(int defaultColor, int index, int i, int j, int k) {
        return ColorizeBlock.colorizeWithBlending(Colorizer.fixedColorMaps[index], defaultColor, i, j, k);
    }

    public static int colorizeWater(Object dummy, int i, int k) {
        return Colorizer.fixedColorMaps[5].colorize(BiomeHelper.getWaterColorMultiplier(i, 64, k), i, 64, k);
    }

    public static int colorizeBlock(Block block, int i, int j, int k, int metadata) {
        ColorMap colorMap = null;
        if (!blockMetaColorMaps.isEmpty()) {
            colorMap = blockMetaColorMaps.get(Float.valueOf(ColorMap.getBlockMetaKey(block.blockID, metadata)));
        }
        if (colorMap == null && block.blockID >= 0 && block.blockID < blockColorMaps.length) {
            colorMap = blockColorMaps[block.blockID];
        }
        return ColorizeBlock.colorizeWithBlending(colorMap, 0xFFFFFF, i, j, k);
    }

    private static int colorizeWithBlending(ColorMap colorMap, int defaultColor, int i, int j, int k) {
        if (colorMap == null || !colorMap.isCustom() || blockBlendRadius <= 0) {
            return defaultColor;
        }
        float[] sum = new float[3];
        float[] sample = new float[3];
        for (int di = -blockBlendRadius; di <= blockBlendRadius; ++di) {
            for (int dk = -blockBlendRadius; dk <= blockBlendRadius; ++dk) {
                int rgb = colorMap.colorize(defaultColor, i + di, j, k + dk);
                Colorizer.intToFloat3(rgb, sample);
                sum[0] = sum[0] + sample[0];
                sum[1] = sum[1] + sample[1];
                sum[2] = sum[2] + sample[2];
            }
        }
        sum[0] = sum[0] * blockBlendScale;
        sum[1] = sum[1] * blockBlendScale;
        sum[2] = sum[2] * blockBlendScale;
        return Colorizer.float3ToInt(sum);
    }

    public static int colorizeBlock(Block block) {
        ColorMap colorMap = blockColorMaps[block.blockID];
        if (colorMap == null) {
            return 0xFFFFFF;
        }
        return colorMap.colorize(0xFFFFFF);
    }

    public static int colorizeStem(int defaultColor, int blockMetadata) {
        if (stemColors == null) {
            return defaultColor;
        }
        return stemColors[blockMetadata & 7];
    }

    public static int getLilyPadColor() {
        return lilypadColor;
    }

    public static int getItemColorFromDamage(int defaultColor, int blockID, int damage) {
        if (blockID == 8 || blockID == 9) {
            return ColorizeBlock.colorizeBiome(defaultColor, 5);
        }
        return defaultColor;
    }

    public static boolean computeRedstoneWireColor(int current) {
        if (redstoneColor == null) {
            return false;
        }
        System.arraycopy(redstoneColor[Math.max(Math.min(current, 15), 0)], 0, Colorizer.setColor, 0, 3);
        return true;
    }

    public static int colorizeRedstoneWire(IBlockAccess blockAccess, int i, int j, int k, int defaultColor) {
        if (redstoneColor == null) {
            return defaultColor;
        }
        int metadata = Math.max(Math.min(blockAccess.getBlockMetadata(i, j, k), 15), 0);
        return Colorizer.float3ToInt(redstoneColor[metadata]);
    }

    public static boolean computeWaterColor(double x, double y, double z) {
        if (Colorizer.useParticleColors && Colorizer.fixedColorMaps[5].isCustom()) {
            int rgb = ColorizeBlock.colorizeBiome(0xFFFFFF, 5, (int)x, (int)y, (int)z);
            float[] multiplier = new float[3];
            Colorizer.intToFloat3(rgb, multiplier);
            for (int i = 0; i < 3; ++i) {
                ColorizeBlock.waterColor[i] = multiplier[i] * ColorizeEntity.waterBaseColor[i];
            }
            return true;
        }
        return false;
    }

    public static void computeWaterColor() {
        int rgb = ColorizeBlock.colorizeBiome(0xFFFFFF, 5);
        Colorizer.intToFloat3(rgb, waterColor);
    }

    public static void colorizeWaterBlockGL(int blockID) {
        if (blockID == 8 || blockID == 9) {
            ColorizeBlock.computeWaterColor();
            GL11.glColor4f((float)waterColor[0], (float)waterColor[1], (float)waterColor[2], (float)1.0f);
        }
    }

    static {
        blockBlendRadius = Config.getInt("Custom Colors", "blockBlendRadius", 1);
        blockBlendScale = (float)Math.pow(2 * blockBlendRadius + 1, -2.0);
        try {
            ColorizeBlock.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

