/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.cc.BiomeHelper;
import com.prupe.mcpatcher.cc.Colorizer;
import net.minecraft.src.ResourceAddress;

final class ColorMap {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    private static final int COLORMAP_SIZE = 256;
    private static final float COLORMAP_SCALE = 255.0f;
    private int[] map;
    private int mapDefault;

    static int getX(double temperature, double rainfall) {
        return (int)(255.0 * (1.0 - Colorizer.clamp(temperature)));
    }

    static int getY(double temperature, double rainfall) {
        return (int)(255.0 * (1.0 - Colorizer.clamp(rainfall) * Colorizer.clamp(temperature)));
    }

    static float getBlockMetaKey(int blockID, int metadata) {
        return (float)blockID + (float)(metadata & 0xFF) / 256.0f;
    }

    ColorMap(int defaultColor) {
        this.mapDefault = defaultColor;
    }

    void loadColorMap(boolean useCustom, ResourceAddress resource) {
        if (!useCustom) {
            return;
        }
        this.map = MCPatcherUtils.getImageRGB(TexturePackAPI.getImage(resource));
        if (this.map == null) {
            return;
        }
        if (this.map.length != 65536) {
            logger.error("%s must be %dx%d", resource, 256, 256);
            this.map = null;
            return;
        }
        this.mapDefault = this.colorize(0xFFFFFF, 0.5, 1.0);
        logger.fine("using %s, default color %06x", resource, this.mapDefault);
    }

    boolean isCustom() {
        return this.map != null;
    }

    void clear() {
        this.map = null;
    }

    int colorize() {
        return this.mapDefault;
    }

    int colorize(int defaultColor) {
        return this.map == null ? defaultColor : this.mapDefault;
    }

    int colorize(int defaultColor, double temperature, double rainfall) {
        if (this.map == null) {
            return defaultColor;
        }
        return this.map[256 * ColorMap.getY(temperature, rainfall) + ColorMap.getX(temperature, rainfall)];
    }

    int colorize(int defaultColor, int i, int j, int k) {
        return this.colorize(defaultColor, BiomeHelper.getTemperature(i, j, k), BiomeHelper.getRainfall(i, j, k));
    }
}

