/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import java.lang.reflect.Method;
import net.minecraft.src.BiomeGenBase;

class BiomeHelper {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    private static Method getWaterColorMultiplier;
    private static BiomeGenBase lastBiome;
    private static int lastI;
    private static int lastK;

    BiomeHelper() {
    }

    static String getBiomeNameAt(int i, int j, int k) {
        BiomeGenBase biome = BiomeHelper.getBiomeGenAt(i, j, k);
        if (biome == null) {
            return "";
        }
        String biomeName = biome.biomeName;
        if (biomeName == null) {
            return "";
        }
        return biomeName.toLowerCase().replace(" ", "");
    }

    static BiomeGenBase getBiomeGenAt(int i, int j, int k) {
        if (lastBiome == null || i != lastI || k != lastK) {
            lastI = i;
            lastK = k;
            lastBiome = MCPatcherUtils.getMinecraft().theWorld.getBiomeGenAt(i, k);
        }
        return lastBiome;
    }

    static float getTemperature(int i, int j, int k) {
        return BiomeHelper.getBiomeGenAt(i, j, k).getTemperaturef();
    }

    static float getRainfall(int i, int j, int k) {
        return BiomeHelper.getBiomeGenAt(i, j, k).getRainfallf();
    }

    static int getWaterColorMultiplier(int i, int j, int k) {
        BiomeGenBase biome = BiomeHelper.getBiomeGenAt(i, j, k);
        if (getWaterColorMultiplier != null) {
            try {
                return (Integer)getWaterColorMultiplier.invoke((Object)biome, new Object[0]);
            }
            catch (Throwable e) {
                e.printStackTrace();
                getWaterColorMultiplier = null;
            }
        }
        return biome.waterColorMultiplier;
    }

    static {
        try {
            getWaterColorMultiplier = BiomeGenBase.class.getDeclaredMethod("getWaterColorMultiplier", new Class[0]);
            getWaterColorMultiplier.setAccessible(true);
            logger.config("forge getWaterColorMultiplier detected", new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

