/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.MainForm;
import com.prupe.mcpatcher.MinecraftInstallation;
import com.prupe.mcpatcher.ModList;
import java.io.File;
import java.util.ArrayList;

public abstract class UserInterface {
    abstract boolean shouldExit();

    void show() {
    }

    File chooseMinecraftDir(File enteredMCDir) {
        return null;
    }

    boolean locateMinecraftDir(String enteredMCDir) {
        ArrayList<File> mcDirs = new ArrayList<File>();
        if (enteredMCDir == null) {
            mcDirs.add(MCPatcherUtils.getDefaultGameDir());
            mcDirs.add(new File("."));
            mcDirs.add(new File(".."));
        } else {
            mcDirs.add(new File(enteredMCDir).getAbsoluteFile());
        }
        for (File dir : mcDirs) {
            if (!MCPatcherUtils.setGameDir(dir)) continue;
            return true;
        }
        File minecraftDir = (File)mcDirs.get(0);
        do {
            if ((minecraftDir = this.chooseMinecraftDir(minecraftDir)) != null) continue;
            return false;
        } while (!MCPatcherUtils.setGameDir(minecraftDir) && !MCPatcherUtils.setGameDir(minecraftDir.getParentFile()));
        return true;
    }

    boolean go() {
        File defaultMinecraft = MinecraftInstallation.getJarPathForVersion(Config.instance.getConfigValue("selectedProfile"));
        if (defaultMinecraft == null || !defaultMinecraft.isFile()) {
            defaultMinecraft = MinecraftInstallation.getDefaultJarPath();
        }
        if (defaultMinecraft == null || !defaultMinecraft.isFile()) {
            this.showCorruptJarError(defaultMinecraft);
            this.setBusy(false);
            return false;
        }
        if (MCPatcher.setMinecraft(defaultMinecraft, true)) {
            this.updateModList();
            return true;
        }
        this.showCorruptJarError(defaultMinecraft);
        this.setBusy(false);
        return false;
    }

    public void updateProgress(int value, int max) {
    }

    void setModList(ModList modList) {
    }

    void updateModList() {
    }

    public void setStatusText(String format, Object ... params) {
    }

    public void setBusy(boolean busy) {
    }

    void showBetaWarning() {
    }

    void showCorruptJarError(File defaultMinecraft) {
        Logger.log(0, "ERROR: %s missing or corrupt", defaultMinecraft.getPath());
    }

    static class CLI
    extends UserInterface {
        CLI() {
        }

        @Override
        boolean shouldExit() {
            return true;
        }

        @Override
        boolean go() {
            if (!super.go()) {
                return false;
            }
            boolean ok = false;
            try {
                MCPatcher.getApplicableMods();
                System.out.println();
                System.out.println("#### Class map:");
                MCPatcher.showClassMaps(System.out);
                if (MCPatcher.patch()) {
                    ok = true;
                }
                System.out.println();
                System.out.println("#### Patch summary:");
                MCPatcher.showPatchResults(System.out);
            }
            catch (Throwable e) {
                Logger.log(e);
            }
            return ok;
        }
    }

    static class GUI
    extends UserInterface {
        private final MainForm mainForm = new MainForm();

        GUI() {
        }

        @Override
        boolean shouldExit() {
            return false;
        }

        @Override
        void show() {
            this.mainForm.show();
        }

        @Override
        File chooseMinecraftDir(File enteredMCDir) {
            return this.mainForm.chooseMinecraftDir(enteredMCDir);
        }

        @Override
        public void updateProgress(int value, int max) {
            this.mainForm.updateProgress(value, max);
        }

        @Override
        void setModList(ModList modList) {
            this.mainForm.setModList(modList);
        }

        @Override
        void updateModList() {
            this.mainForm.updateModList();
        }

        @Override
        public void setStatusText(String format, Object ... params) {
            this.mainForm.setStatusText(format, params);
        }

        @Override
        public void setBusy(boolean busy) {
            this.mainForm.setBusy(busy);
        }

        @Override
        void showBetaWarning() {
            this.mainForm.showBetaWarning();
        }

        @Override
        void showCorruptJarError(File defaultMinecraft) {
            super.showCorruptJarError(defaultMinecraft);
            this.mainForm.showCorruptJarError(defaultMinecraft);
        }
    }
}

