/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.ClassMap;
import com.prupe.mcpatcher.ClassPatch;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.ModConfigPanel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Mod {
    protected String name = "";
    protected String author = "";
    protected String website = "";
    protected String version = "";
    protected String description = "";
    protected boolean defaultEnabled = true;
    protected ModConfigPanel configPanel = null;
    final List<com.prupe.mcpatcher.ClassMod> classMods = new ArrayList<com.prupe.mcpatcher.ClassMod>();
    final List<String> filesToAdd = new ArrayList<String>();
    final ClassMap classMap = new ClassMap();
    private final List<String> errors = new ArrayList<String>();
    private boolean enabled;
    boolean internal;
    boolean experimental;
    File customJar;
    final List<Dependency> dependencies = new ArrayList<Dependency>();
    final Map<String, String> filesAdded = new HashMap<String, String>();

    public Mod() {
        this.addDependency("__Base");
    }

    public String getName() {
        return this.name;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String[] getLoggingCategories() {
        return new String[]{this.getName()};
    }

    public void close() {
    }

    public ClassMap getClassMap() {
        return this.classMap;
    }

    public static MinecraftVersion getMinecraftVersion() {
        return MCPatcher.minecraft == null ? null : MCPatcher.minecraft.getVersion();
    }

    void resetCounts() {
        this.filesAdded.clear();
        for (com.prupe.mcpatcher.ClassMod classMod : this.getClassMods()) {
            for (ClassPatch classPatch : classMod.patches) {
                classPatch.numMatches.clear();
            }
        }
    }

    List<com.prupe.mcpatcher.ClassMod> getClassMods() {
        return this.classMods;
    }

    boolean okToApply() {
        return this.errors.size() == 0 && this.getErrors().size() == 0;
    }

    public final void addError(String error) {
        this.errors.add(error);
    }

    public Mod clearPatches() {
        for (com.prupe.mcpatcher.ClassMod classMod : this.classMods) {
            classMod.patches.clear();
        }
        this.filesToAdd.clear();
        return this;
    }

    public void addClassMod(com.prupe.mcpatcher.ClassMod classMod) {
        this.classMods.add(classMod);
    }

    public void addFile(String filename) {
        this.filesToAdd.add(filename);
    }

    public void addClassFile(String className) {
        this.addFile(ClassMap.classNameToFilename(className));
    }

    ArrayList<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>(this.errors);
        for (com.prupe.mcpatcher.ClassMod classMod : this.classMods) {
            if (classMod.okToApply()) continue;
            for (String s : classMod.errors) {
                errors.add(String.format("%s: %s", classMod.getDeobfClass(), s));
            }
        }
        return errors;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    void loadOptions() {
        if (this.configPanel != null) {
            this.configPanel.load();
        }
    }

    public InputStream openFile(String name) throws IOException {
        InputStream inputStream = null;
        URL url = this.getClass().getResource(name);
        if (url != null) {
            url = new URL(url.toString().replaceAll("!(?=.*!)", "%21"));
            inputStream = url.openStream();
        }
        if (inputStream == null) {
            Logger.log(0, "WARNING: openStream failed, retrying with getResourceAsStream", new Object[0]);
            inputStream = this.getClass().getResourceAsStream(name);
        }
        if (inputStream == null) {
            Logger.log(0, "WARNING: getResourceAsStream failed, retrying with getContextClassLoader", new Object[0]);
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        }
        if (inputStream == null) {
            Logger.log(0, "WARNING: getContextClassLoader failed, giving up", new Object[0]);
        }
        return inputStream;
    }

    public void addDependency(String name) {
        this.dependencies.add(new Dependency(name, true));
    }

    public void addConflict(String name) {
        this.dependencies.add(new Dependency(name, false));
    }

    public void clearDependencies() {
        this.dependencies.clear();
    }

    public class ClassMod
    extends com.prupe.mcpatcher.ClassMod {
        public ClassMod() {
            super(Mod.this);
        }
    }

    class Dependency {
        final String name;
        final boolean required;

        Dependency(String name, boolean required) {
            this.name = name;
            this.required = required;
        }
    }
}

