/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.MinecraftInstallation;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class MinecraftInstallationV2
extends MinecraftInstallation {
    static final String MCPATCHER_SUFFIX = "-mcpatcher";
    private static final String ORIGINAL_SUFFIX = "-original";
    private static final String NATIVES_SUFFIX = "-natives";
    private static final String NATIVES_TYPE;
    private static final String BASE_URL = "http://s3.amazonaws.com/Minecraft.Download/versions/";
    private final File versionsDir;
    private final File librariesDir;

    MinecraftInstallationV2(File baseDir) {
        super(baseDir);
        this.versionsDir = new File(baseDir, "versions");
        this.librariesDir = new File(baseDir, "libraries");
    }

    @Override
    boolean isPresent() {
        return this.versionsDir.isDirectory() && this.librariesDir.isDirectory();
    }

    @Override
    boolean canHaveThisFile(File file) {
        try {
            return file.getParentFile().getParentFile().getName().equals("versions");
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    boolean prefersThisVersion(MinecraftVersion version) {
        return version.compareTo("1.5.2") > 0;
    }

    @Override
    File getDefaultJarPathImpl() {
        MinecraftVersion version = this.getCurrentVersion();
        if (version == null) {
            return null;
        }
        String v = version.getVersionString();
        return new File(new File(this.versionsDir, v), v + ".jar");
    }

    @Override
    File getPatchedInstallation(MinecraftVersion version) {
        return new File(this.versionsDir, version.getVersionString() + MCPATCHER_SUFFIX);
    }

    @Override
    boolean deletePatchedInstallation(MinecraftVersion version) {
        String v;
        File dir = this.getPatchedInstallation(version);
        File natives = new File(dir, (v = version.getVersionString() + MCPATCHER_SUFFIX) + NATIVES_SUFFIX);
        File[] files = natives.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.isFile()) continue;
                f.delete();
            }
        }
        natives.delete();
        new File(dir, v + ".jar").delete();
        new File(dir, v + ".json").delete();
        return dir.delete();
    }

    private MinecraftVersion getCurrentVersion() {
        File[] versions = this.versionsDir.listFiles();
        if (versions != null) {
            ArrayList<MinecraftVersion> availableVersions = new ArrayList<MinecraftVersion>();
            for (File d : versions) {
                MinecraftVersion version;
                if (d.getName().endsWith(MCPATCHER_SUFFIX) || (version = MinecraftVersion.parseShortVersion(d.getName())) == null) continue;
                File jar = new File(d, d.getName() + ".jar");
                File json = new File(d, d.getName() + ".json");
                if (!jar.isFile() || !json.isFile()) continue;
                availableVersions.add(version);
            }
            if (!availableVersions.isEmpty()) {
                Collections.sort(availableVersions, new Comparator<MinecraftVersion>(){

                    @Override
                    public int compare(MinecraftVersion o1, MinecraftVersion o2) {
                        return o2.compareTo(o1);
                    }
                });
                return (MinecraftVersion)availableVersions.get(0);
            }
        }
        return null;
    }

    @Override
    MinecraftVersion getVersionFromFilename(File file) {
        String versionString = file.getName().replaceFirst("(-mcpatcher|-original)*\\.jar$", "");
        return MinecraftVersion.parseShortVersion(versionString);
    }

    @Override
    File getJarPathForVersionImpl(MinecraftVersion version) {
        String v = version.getVersionString();
        return new File(new File(this.versionsDir, v), v + ".jar");
    }

    @Override
    MinecraftInstallation.MinecraftJar openMinecraftJarImpl(File file) throws IOException {
        return new MinecraftJarV2(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createVersionDirectory(File oldDir, File newDir) throws IOException {
        String oldVersion = oldDir.getName();
        String newVersion = newDir.getName();
        newDir.mkdirs();
        File oldJSON = new File(oldDir, oldVersion + ".json");
        File newJSON = new File(newDir, newVersion + ".json");
        BufferedReader reader = null;
        PrintWriter writer = null;
        if (oldJSON.isFile() && !newJSON.isFile()) {
            try {
                String line;
                reader = new BufferedReader(new FileReader(oldJSON));
                writer = new PrintWriter(new FileWriter(newJSON));
                while ((line = reader.readLine()) != null) {
                    if (line.contains("\"id\":")) {
                        line = line.replace(oldVersion, newVersion);
                    }
                    writer.println(line);
                }
            }
            catch (Throwable throwable) {
                MCPatcherUtils.close(reader);
                MCPatcherUtils.close(writer);
                throw throwable;
            }
            MCPatcherUtils.close(reader);
            MCPatcherUtils.close(writer);
        }
        oldDir = new File(oldDir, oldVersion + NATIVES_SUFFIX);
        newDir = new File(newDir, newVersion + NATIVES_SUFFIX);
        File[] natives = oldDir.listFiles();
        if (natives != null) {
            newDir.mkdirs();
            for (File f : natives) {
                Util.copyFile(f, new File(newDir, f.getName()));
            }
        }
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        NATIVES_TYPE = os.contains("linux") || os.contains("unix") ? "linux" : (os.contains("win") ? "windows" : (os.contains("mac") || os.contains("osx") ? "macosx" : (os.contains("solaris") || os.contains("sunos") ? "solaris" : "unknown")));
    }

    class MinecraftJarV2
    extends MinecraftInstallation.MinecraftJar {
        MinecraftJarV2(File file) throws IOException {
            File tmp;
            super(MinecraftInstallationV2.this);
            MinecraftVersion version = MinecraftInstallationV2.this.getVersionFromFilename(file);
            this.info = new MinecraftInstallation.Info(file, version);
            if (!this.info.isOk()) {
                throw this.info.exception;
            }
            this.outputFile = this.getOutputJarPath(version);
            this.origFile = this.getInputJarPath(version);
            if (!this.origFile.equals(file)) {
                this.info = new MinecraftInstallation.Info(this.origFile, version);
                if (!this.info.isOk()) {
                    throw this.info.exception;
                }
            }
            if (this.info.result == 3 && (tmp = new File(this.origFile.getParent(), this.origFile.getName().replaceFirst("\\.jar$", "-original.jar"))).isFile()) {
                Util.copyFile(tmp, this.origFile);
                this.info = new MinecraftInstallation.Info(this.origFile, version);
                if (!this.info.isOk()) {
                    throw this.info.exception;
                }
                tmp.delete();
            }
            this.fetchJSON(version.getVersionString(), new File(this.getInputJarDirectory(), version.getVersionString() + ".json"));
            MinecraftInstallationV2.this.createVersionDirectory(this.origFile.getParentFile(), this.outputFile.getParentFile());
        }

        @Override
        File getInputJarDirectory() {
            return new File(MinecraftInstallationV2.this.versionsDir, this.getVersion().getVersionString());
        }

        @Override
        File getOutputJarDirectory() {
            return new File(MinecraftInstallationV2.this.versionsDir, this.getVersion().getVersionString() + MinecraftInstallationV2.MCPATCHER_SUFFIX);
        }

        @Override
        File getInputJarPath(MinecraftVersion version) {
            return new File(this.getInputJarDirectory(), version.getVersionString() + ".jar");
        }

        @Override
        File getOutputJarPath(MinecraftVersion version) {
            return new File(this.getOutputJarDirectory(), version.getVersionString() + MinecraftInstallationV2.MCPATCHER_SUFFIX + ".jar");
        }

        @Override
        File getNativesDirectory() {
            return new File(this.getOutputJarDirectory(), this.getOutputJarDirectory().getName() + MinecraftInstallationV2.NATIVES_SUFFIX);
        }

        @Override
        void addToClassPath(List<File> classPath) {
            if (!this.getClassPathFromJSON(classPath) && MinecraftInstallationV2.this.librariesDir.isDirectory()) {
                this.addAllToClassPath(MinecraftInstallationV2.this.librariesDir, classPath);
            }
        }

        @Override
        void addGameParams(List<String> params) {
            if (this.getVersion().compareTo("13w23a") >= 0) {
                params.add("--version");
                params.add(this.getVersion().getVersionString() + MinecraftInstallationV2.MCPATCHER_SUFFIX);
            }
            params.add("--assetsDir");
            params.add(new File(MinecraftInstallationV2.this.baseDir, "assets").getPath());
            params.add("--workDir");
            params.add(MinecraftInstallationV2.this.baseDir.getPath());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean fetchJSON(String version, File json) {
            boolean success;
            block7: {
                if (json.isFile() && json.length() > 0L) {
                    return true;
                }
                InputStream input = null;
                FileOutputStream output = null;
                success = false;
                try {
                    URL url = new URL(MinecraftInstallationV2.BASE_URL + version + "/" + version + ".json");
                    Logger.log(0, "Downloading %s...", url);
                    input = url.openStream();
                    output = new FileOutputStream(json);
                    Util.copyStream(input, output);
                    success = true;
                    MCPatcherUtils.close(input);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break block7;
                }
                finally {
                    MCPatcherUtils.close(input);
                    MCPatcherUtils.close(output);
                }
                MCPatcherUtils.close(output);
            }
            if (!success) {
                json.delete();
            }
            return success && json.isFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean getClassPathFromJSON(List<File> classPath) {
            BufferedReader reader = null;
            try {
                String line;
                File json = new File(this.getOutputJarDirectory(), this.getVersion().getVersionString() + MinecraftInstallationV2.MCPATCHER_SUFFIX + ".json");
                if (!json.isFile()) {
                    Logger.log(0, "WARNING: %s not found", json);
                    boolean bl = false;
                    MCPatcherUtils.close(reader);
                    return bl;
                }
                reader = new BufferedReader(new FileReader(json));
                boolean foundLibs = false;
                while ((line = reader.readLine()) != null) {
                    File jar;
                    String[] tokens = line.split("[ \t:\",]+");
                    if (tokens.length >= 2 && tokens[1].equals("libraries")) {
                        foundLibs = true;
                        continue;
                    }
                    if (!foundLibs || tokens.length < 5 || !tokens[1].equals("name")) continue;
                    String packageDir = tokens[2].replace('.', '/');
                    String library = tokens[3];
                    String version = tokens[4];
                    File parent = new File(new File(new File(MinecraftInstallationV2.this.librariesDir, packageDir), library), version);
                    if (library.endsWith("-platform")) {
                        jar = new File(parent, library + '-' + version + "-natives-" + NATIVES_TYPE + ".jar");
                        if (jar.isFile()) {
                            this.unpackNatives(jar, this.getNativesDirectory());
                            continue;
                        }
                        Logger.log(0, "WARNING: %s not found", jar);
                        continue;
                    }
                    jar = new File(parent, library + '-' + version + ".jar");
                    if (jar.isFile()) {
                        classPath.add(jar);
                        continue;
                    }
                    Logger.log(0, "WARNING: %s not found", jar);
                }
                MCPatcherUtils.close(reader);
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                MCPatcherUtils.close(reader);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unpackNatives(File jar, File natives) {
            natives.mkdirs();
            ZipFile zip = null;
            InputStream is = null;
            FileOutputStream os = null;
            try {
                zip = new ZipFile(jar);
                for (ZipEntry zipEntry : Collections.list(zip.entries())) {
                    File dest;
                    String name = zipEntry.getName();
                    if (MinecraftInstallation.isGarbageFile(name) || (dest = new File(natives, name)).isFile() && dest.length() == zipEntry.getSize()) continue;
                    is = zip.getInputStream(zipEntry);
                    os = new FileOutputStream(dest);
                    Util.copyStream(is, os);
                    MCPatcherUtils.close(is);
                    MCPatcherUtils.close(os);
                    is = null;
                    os = null;
                }
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(zip);
                    MCPatcherUtils.close(is);
                    MCPatcherUtils.close(os);
                    throw throwable;
                }
                MCPatcherUtils.close(zip);
                MCPatcherUtils.close(is);
                MCPatcherUtils.close(os);
            }
            MCPatcherUtils.close(zip);
            MCPatcherUtils.close(is);
            MCPatcherUtils.close(os);
        }

        private void addAllToClassPath(File dir, List<File> classPath) {
            File[] files = dir.listFiles();
            if (files != null) {
                File nativesDirectory = this.getNativesDirectory();
                for (File f : files) {
                    if (f.isFile() && f.getName().endsWith(".jar")) {
                        if (f.getName().contains("-natives-" + NATIVES_TYPE)) {
                            if (nativesDirectory.isDirectory()) continue;
                            this.unpackNatives(f, nativesDirectory);
                            continue;
                        }
                        classPath.add(f);
                        continue;
                    }
                    if (!f.isDirectory()) continue;
                    this.addAllToClassPath(f, classPath);
                }
            }
        }
    }
}

