/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

public class BinaryRegex {
    private static final String BYTE_REGEX = " \\p{XDigit}{2}";
    private static final String BYTE_FORMAT = " %02x";
    static final int BYTE_LEN = 3;
    private static final String HEX_DIGIT_S = "0123456789abcdef";
    private static final char[] HEX_DIGIT = "0123456789abcdef".toCharArray();

    private BinaryRegex() {
    }

    public static String build(Object ... objects) {
        StringBuilder sb = new StringBuilder();
        return BinaryRegex.build1(sb, objects) ? sb.toString() : null;
    }

    private static boolean build1(StringBuilder sb, Object[] objects) {
        for (Object o : objects) {
            if (o == null) {
                return false;
            }
            if (o instanceof Byte) {
                sb.append(BinaryRegex.literal((Byte)o));
                continue;
            }
            if (o instanceof byte[]) {
                sb.append(BinaryRegex.literal((byte[])o));
                continue;
            }
            if (o instanceof Integer) {
                sb.append(BinaryRegex.literal((Integer)o));
                continue;
            }
            if (o instanceof int[]) {
                sb.append(BinaryRegex.literal((int[])o));
                continue;
            }
            if (o instanceof String) {
                sb.append((String)o);
                continue;
            }
            if (o instanceof Character) {
                sb.append(BinaryRegex.literal(((Character)o).charValue()));
                continue;
            }
            if (o instanceof Object[]) {
                return BinaryRegex.build1(sb, (Object[])o);
            }
            throw new IllegalArgumentException("unknown binary regex type: " + o.getClass().getSimpleName() + " " + o);
        }
        return true;
    }

    public static String literal(byte[] b) {
        return b == null ? null : BinaryRegex.binToStr(b);
    }

    public static String literal(byte b) {
        return BinaryRegex.literal(new byte[]{b});
    }

    public static String literal(int[] i) {
        byte[] b = new byte[i.length];
        for (int j = 0; j < b.length; ++j) {
            b[j] = (byte)i[j];
        }
        return BinaryRegex.literal(b);
    }

    public static String literal(int i) {
        return BinaryRegex.literal((byte)i);
    }

    public static String begin() {
        return "^";
    }

    public static String end() {
        return "$";
    }

    public static String optional(String regex) {
        return regex == null ? "" : String.format("(?:%s)?", regex);
    }

    public static String any() {
        return BYTE_REGEX;
    }

    public static String any(int count) {
        return BinaryRegex.repeat(BYTE_REGEX, count);
    }

    public static String any(int min, int max) {
        return BinaryRegex.repeat(BYTE_REGEX, min, max);
    }

    public static String repeat(String regex, int count) {
        if (regex != null) {
            return String.format("(?:%s){%d}", regex, count);
        }
        if (count > 0) {
            return null;
        }
        return "";
    }

    public static String repeat(String regex, int min, int max) {
        if (regex != null) {
            return String.format("(?:%s){%d,%d}", regex, min, max);
        }
        if (min > 0) {
            return null;
        }
        return "";
    }

    public static String nonGreedy(String regex) {
        if (regex == null) {
            return null;
        }
        if ("*+?}".contains(regex.substring(regex.length() - 1))) {
            return regex + "?";
        }
        return regex;
    }

    public static String subset(byte[] byteList, boolean positive) {
        int[] intList;
        if (byteList == null) {
            intList = null;
        } else {
            intList = new int[byteList.length];
            for (int i = 0; i < byteList.length; ++i) {
                intList[i] = byteList[i];
            }
        }
        return BinaryRegex.subset(intList, positive);
    }

    public static String subset(int[] intList, boolean positive) {
        int i;
        boolean[] allowed = new boolean[256];
        for (i = 0; i < allowed.length; ++i) {
            allowed[i] = !positive;
        }
        if (intList != null) {
            for (i = 0; i < intList.length; ++i) {
                allowed[intList[i] & 0xFF] = positive;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(?:");
        boolean first = true;
        for (i = 0; i < allowed.length; ++i) {
            if (!allowed[i]) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append(String.format(BYTE_FORMAT, i));
        }
        sb.append(")");
        return sb.toString();
    }

    public static String or(String ... regexes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(?:");
        boolean first = true;
        for (String regex : regexes) {
            if (regex == null) continue;
            if (first) {
                first = false;
            } else {
                sb.append("|");
            }
            sb.append(regex);
        }
        sb.append(")");
        return first ? null : sb.toString();
    }

    public static String capture(String regex) {
        return regex == null ? null : "(" + regex + ")";
    }

    public static String backReference(int group) {
        return "\\" + group;
    }

    public static String lookAhead(String regex, boolean positive) {
        if (regex != null) {
            return String.format("(?%s%s)", positive ? "=" : "!", regex);
        }
        if (positive) {
            return null;
        }
        return "";
    }

    public static String lookBehind(String regex, boolean positive) {
        if (regex != null) {
            return String.format("(?<%s%s)", positive ? "=" : "!", regex);
        }
        if (positive) {
            return null;
        }
        return "";
    }

    static String binToStr(byte[] b) {
        int l = b.length;
        StringBuilder sb = new StringBuilder(3 * l);
        for (byte b1 : b) {
            sb.append(' ');
            sb.append(HEX_DIGIT[b1 >> 4 & 0xF]);
            sb.append(HEX_DIGIT[b1 & 0xF]);
        }
        return sb.toString();
    }

    static byte[] strToBin(String s) {
        int l = s.length();
        byte[] b = new byte[l / 3];
        int i = 0;
        for (int j = 0; j < l; j += 3) {
            b[i] = (byte)(HEX_DIGIT_S.indexOf(s.charAt(j + 1)) << 4 | HEX_DIGIT_S.indexOf(s.charAt(j + 2)));
            ++i;
        }
        return b;
    }
}

