/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.sky;

import com.prupe.mcpatcher.BlendMethod;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.TexturePackChangeHandler;
import com.prupe.mcpatcher.sky.FireworksHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.src.ResourceAddress;
import net.minecraft.src.Tessellator;
import net.minecraft.src.World;
import net.minecraft.src.WorldClient;
import org.lwjgl.opengl.GL11;

public class SkyRenderer {
    private static final MCLogger logger = MCLogger.getLogger("Better Skies");
    private static final boolean enable = Config.getBoolean("Better Skies", "skybox", true);
    private static double worldTime;
    private static float celestialAngle;
    private static float rainStrength;
    private static final HashMap<Integer, WorldEntry> worldSkies;
    private static WorldEntry currentWorld;
    public static boolean active;

    public static void setup(World world, float partialTick, float celestialAngle) {
        if (TexturePackAPI.isDefaultTexturePack()) {
            active = false;
        } else {
            int worldType = MCPatcherUtils.getMinecraft().theWorld.worldProvider.worldType;
            WorldEntry newEntry = SkyRenderer.getWorldEntry(worldType);
            if (newEntry != currentWorld && currentWorld != null) {
                currentWorld.unloadTextures();
            }
            if (active = (currentWorld = newEntry).active()) {
                worldTime = (float)world.getWorldTime() + partialTick;
                rainStrength = 1.0f - world.getRainStrength(partialTick);
                SkyRenderer.celestialAngle = celestialAngle;
            }
        }
    }

    public static void renderAll() {
        if (active) {
            currentWorld.renderAll(Tessellator.instance);
        }
    }

    public static ResourceAddress setupCelestialObject(ResourceAddress defaultTexture) {
        if (active) {
            Layer.clearBlendingMethod();
            Layer layer = currentWorld.getCelestialObject(defaultTexture);
            if (layer != null) {
                layer.setBlendingMethod(rainStrength);
                return layer.texture;
            }
        }
        return defaultTexture;
    }

    private static WorldEntry getWorldEntry(int worldType) {
        WorldEntry entry = worldSkies.get(worldType);
        if (entry == null) {
            entry = new WorldEntry(worldType);
            worldSkies.put(worldType, entry);
        }
        return entry;
    }

    static {
        worldSkies = new HashMap();
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Better Skies", 2){

            @Override
            public void beforeChange() {
                worldSkies.clear();
            }

            @Override
            public void afterChange() {
                WorldClient world;
                if (enable && (world = MCPatcherUtils.getMinecraft().theWorld) != null) {
                    SkyRenderer.getWorldEntry(world.worldProvider.worldType);
                }
                FireworksHelper.reload();
            }
        });
    }

    private static class Layer {
        private static final int SECS_PER_DAY = 86400;
        private static final int TICKS_PER_DAY = 24000;
        private static final double TOD_OFFSET = -0.25;
        private static final double SKY_DISTANCE = 100.0;
        private final ResourceAddress propertiesName;
        private final Properties properties;
        private ResourceAddress texture;
        private boolean fade;
        private boolean rotate;
        private float[] axis;
        private float speed;
        private BlendMethod blendMethod;
        private double a;
        private double b;
        private double c;
        boolean valid;
        float brightness;

        static Layer create(ResourceAddress resource) {
            Properties properties = TexturePackAPI.getProperties(resource);
            if (properties == null) {
                return null;
            }
            return new Layer(resource, properties);
        }

        Layer(ResourceAddress propertiesName, Properties properties) {
            this.propertiesName = propertiesName;
            this.properties = properties;
            this.valid = true;
            this.valid = this.readTexture() && this.readRotation() & this.readBlendingMethod() && this.readFadeTimers();
        }

        private boolean readTexture() {
            this.texture = TexturePackAPI.parseResourceAddress(this.propertiesName, this.properties.getProperty("source", this.propertiesName.getPath().replaceFirst("\\.properties$", ".png")));
            if (TexturePackAPI.hasResource(this.texture)) {
                return true;
            }
            return this.addError("source texture %s not found", this.texture);
        }

        private boolean readRotation() {
            this.rotate = MCPatcherUtils.getBooleanProperty(this.properties, "rotate", true);
            if (this.rotate) {
                try {
                    this.speed = Float.parseFloat(this.properties.getProperty("speed", "1.0"));
                }
                catch (NumberFormatException e) {
                    return this.addError("invalid rotation speed", new Object[0]);
                }
                String value = this.properties.getProperty("axis", "0.0 0.0 1.0").trim().toLowerCase();
                String[] tokens = value.split("\\s+");
                if (tokens.length == 3) {
                    float z;
                    float y;
                    float x;
                    try {
                        x = Float.parseFloat(tokens[0]);
                        y = Float.parseFloat(tokens[1]);
                        z = Float.parseFloat(tokens[2]);
                    }
                    catch (NumberFormatException e) {
                        return this.addError("invalid rotation axis", new Object[0]);
                    }
                    if (x * x + y * y + z * z == 0.0f) {
                        return this.addError("rotation axis cannot be 0", new Object[0]);
                    }
                    this.axis = new float[]{z, y, -x};
                } else {
                    return this.addError("invalid rotate value %s", value);
                }
            }
            return true;
        }

        private boolean readBlendingMethod() {
            String value = this.properties.getProperty("blend", "add");
            this.blendMethod = BlendMethod.parse(value);
            if (this.blendMethod == null) {
                return this.addError("unknown blend method %s", value);
            }
            return true;
        }

        private boolean readFadeTimers() {
            int endFadeIn;
            this.fade = Boolean.parseBoolean(this.properties.getProperty("fade", "true"));
            if (!this.fade) {
                return true;
            }
            int startFadeIn = this.parseTime(this.properties, "startFadeIn");
            int endFadeOut = this.parseTime(this.properties, "endFadeOut");
            if (!this.valid) {
                return false;
            }
            for (endFadeIn = this.parseTime(this.properties, "endFadeIn"); endFadeIn <= startFadeIn; endFadeIn += 86400) {
            }
            while (endFadeOut <= endFadeIn) {
                endFadeOut += 86400;
            }
            if (endFadeOut - startFadeIn >= 86400) {
                return this.addError("fade times must fall within a 24 hour period", new Object[0]);
            }
            int startFadeOut = startFadeIn + endFadeOut - endFadeIn;
            double s0 = Layer.normalize(startFadeIn, 86400, -0.25);
            double s1 = Layer.normalize(endFadeIn, 86400, -0.25);
            double e0 = Layer.normalize(startFadeOut, 86400, -0.25);
            double e1 = Layer.normalize(endFadeOut, 86400, -0.25);
            double det = Math.cos(s0) * Math.sin(s1) + Math.cos(e1) * Math.sin(s0) + Math.cos(s1) * Math.sin(e1) - Math.cos(s0) * Math.sin(e1) - Math.cos(s1) * Math.sin(s0) - Math.cos(e1) * Math.sin(s1);
            if (det == 0.0) {
                return this.addError("determinant is 0", new Object[0]);
            }
            this.a = (Math.sin(e1) - Math.sin(s0)) / det;
            this.b = (Math.cos(s0) - Math.cos(e1)) / det;
            this.c = (Math.cos(e1) * Math.sin(s0) - Math.cos(s0) * Math.sin(e1)) / det;
            logger.finer("%s: y = %f cos x + %f sin x + %f", this.propertiesName, this.a, this.b, this.c);
            logger.finer("  at %f: %f", s0, this.f(s0));
            logger.finer("  at %f: %f", s1, this.f(s1));
            logger.finer("  at %f: %f", e0, this.f(e0));
            logger.finer("  at %f: %f", e1, this.f(e1));
            return true;
        }

        private boolean addError(String format, Object ... params) {
            logger.error("" + this.propertiesName + ": " + format, params);
            this.valid = false;
            return false;
        }

        private int parseTime(Properties properties, String key) {
            String s = properties.getProperty(key, "").trim();
            if ("".equals(s)) {
                this.addError("missing value for %s", key);
                return -1;
            }
            String[] t = s.split(":");
            if (t.length >= 2) {
                try {
                    int hh = Integer.parseInt(t[0].trim());
                    int mm = Integer.parseInt(t[1].trim());
                    int ss = t.length >= 3 ? Integer.parseInt(t[2].trim()) : 0;
                    return (3600 * hh + 60 * mm + ss) % 86400;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            this.addError("invalid %s time %s", key, s);
            return -1;
        }

        private static double normalize(double time, int period, double offset) {
            return Math.PI * 2 * (time / (double)period + offset);
        }

        private double f(double x) {
            return this.a * Math.cos(x) + this.b * Math.sin(x) + this.c;
        }

        boolean prepare() {
            this.brightness = rainStrength;
            if (this.fade) {
                double x = Layer.normalize(worldTime, 24000, 0.0);
                this.brightness *= (float)this.f(x);
            }
            if (this.brightness <= 0.0f) {
                return false;
            }
            if (this.brightness > 1.0f) {
                this.brightness = 1.0f;
            }
            return true;
        }

        boolean render(Tessellator tessellator) {
            TexturePackAPI.bindTexture(this.texture);
            this.setBlendingMethod(this.brightness);
            GL11.glPushMatrix();
            if (this.rotate) {
                GL11.glRotatef((float)(celestialAngle * 360.0f * this.speed), (float)this.axis[0], (float)this.axis[1], (float)this.axis[2]);
            }
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 4);
            GL11.glPushMatrix();
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Layer.drawTile(tessellator, 1);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            Layer.drawTile(tessellator, 0);
            GL11.glPopMatrix();
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 5);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 2);
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            Layer.drawTile(tessellator, 3);
            GL11.glPopMatrix();
            return true;
        }

        private static void drawTile(Tessellator tessellator, int tile) {
            double tileX = (double)(tile % 3) / 3.0;
            double tileY = (double)(tile / 3) / 2.0;
            tessellator.startDrawingQuads();
            tessellator.addVertexWithUV(-100.0, -100.0, -100.0, tileX, tileY);
            tessellator.addVertexWithUV(-100.0, -100.0, 100.0, tileX, tileY + 0.5);
            tessellator.addVertexWithUV(100.0, -100.0, 100.0, tileX + 0.3333333333333333, tileY + 0.5);
            tessellator.addVertexWithUV(100.0, -100.0, -100.0, tileX + 0.3333333333333333, tileY);
            tessellator.draw();
        }

        void setBlendingMethod(float brightness) {
            this.blendMethod.applyFade(brightness);
            this.blendMethod.applyAlphaTest();
            this.blendMethod.applyBlending();
            GL11.glEnable((int)3553);
        }

        static void clearBlendingMethod() {
            GL11.glDisable((int)3008);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)rainStrength);
        }
    }

    private static class WorldEntry {
        private final int worldType;
        private final List<Layer> skies = new ArrayList<Layer>();
        private final Map<ResourceAddress, Layer> objects = new HashMap<ResourceAddress, Layer>();
        private final Set<ResourceAddress> textures = new HashSet<ResourceAddress>();

        WorldEntry(int worldType) {
            this.worldType = worldType;
            this.loadSkies();
            this.loadCelestialObject("sun");
            this.loadCelestialObject("moon_phases");
        }

        private void loadSkies() {
            int i = -1;
            while (true) {
                String path;
                ResourceAddress resource;
                Layer layer;
                if ((layer = Layer.create(resource = TexturePackAPI.newMCPatcherResourceAddress(path = "sky/world" + this.worldType + "/sky" + (i < 0 ? "" : String.valueOf(i)) + ".properties"))) == null) {
                    if (i > 0) {
                        break;
                    }
                } else if (layer.valid) {
                    logger.fine("loaded %s", resource);
                    this.skies.add(layer);
                    this.textures.add(layer.texture);
                }
                ++i;
            }
        }

        private void loadCelestialObject(String objName) {
            ResourceAddress textureName = new ResourceAddress("textures/environment/" + objName + ".png");
            ResourceAddress resource = TexturePackAPI.newMCPatcherResourceAddress("sky/world0/" + objName + ".properties");
            Properties properties = TexturePackAPI.getProperties(resource);
            if (properties != null) {
                properties.setProperty("fade", "false");
                properties.setProperty("rotate", "true");
                Layer layer = new Layer(resource, properties);
                if (layer.valid) {
                    logger.fine("using %s (%s) for the %s", resource, layer.texture, objName);
                    this.objects.put(textureName, layer);
                }
            }
        }

        boolean active() {
            return !this.skies.isEmpty() || !this.objects.isEmpty();
        }

        void renderAll(Tessellator tessellator) {
            HashSet<ResourceAddress> texturesNeeded = new HashSet<ResourceAddress>();
            for (Layer layer : this.skies) {
                if (!layer.prepare()) continue;
                texturesNeeded.add(layer.texture);
            }
            HashSet<ResourceAddress> texturesToUnload = new HashSet<ResourceAddress>();
            texturesToUnload.addAll(this.textures);
            texturesToUnload.removeAll(texturesNeeded);
            for (ResourceAddress resource : texturesToUnload) {
                TexturePackAPI.unloadTexture(resource);
            }
            for (Layer layer : this.skies) {
                if (!(layer.brightness > 0.0f)) continue;
                layer.render(tessellator);
                Layer.clearBlendingMethod();
            }
        }

        Layer getCelestialObject(ResourceAddress defaultTexture) {
            return this.objects.get(defaultTexture);
        }

        void unloadTextures() {
            for (Layer layer : this.skies) {
                TexturePackAPI.unloadTexture(layer.texture);
            }
        }
    }
}

