/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.sky;

import com.prupe.mcpatcher.BlendMethod;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import java.util.Properties;
import net.minecraft.src.EntityFX;
import net.minecraft.src.EntityFireworkOverlayFX;
import net.minecraft.src.EntityFireworkSparkFX;
import net.minecraft.src.ResourceAddress;
import org.lwjgl.opengl.GL11;

public class FireworksHelper {
    private static final int LIT_LAYER = 3;
    private static final int EXTRA_LAYER = 4;
    private static final ResourceAddress PARTICLE_PROPERTIES = TexturePackAPI.newMCPatcherResourceAddress("particle.properties");
    private static final MCLogger logger = MCLogger.getLogger("Better Skies");
    private static final boolean enable = Config.getBoolean("Better Skies", "brightenFireworks", true);
    private static BlendMethod blendMethod;

    public static int getFXLayer(EntityFX entity) {
        if (enable && (entity instanceof EntityFireworkSparkFX || entity instanceof EntityFireworkOverlayFX)) {
            return 4;
        }
        return entity.getFXLayer();
    }

    public static boolean skipThisLayer(boolean skip, int layer) {
        return skip || layer == 3 || !enable && layer > 3;
    }

    public static void setParticleBlendMethod(int layer) {
        if (enable && layer == 4 && blendMethod != null) {
            blendMethod.applyBlending();
        } else {
            GL11.glBlendFunc((int)770, (int)771);
        }
    }

    static void reload() {
        Properties properties = TexturePackAPI.getProperties(PARTICLE_PROPERTIES);
        String blend = MCPatcherUtils.getStringProperty(properties, "blend.4", "add");
        blendMethod = BlendMethod.parse(blend);
        if (blendMethod == null) {
            logger.error("%s: unknown blend method %s", PARTICLE_PROPERTIES, blend);
        } else if (enable) {
            logger.config("using %s blending for fireworks particles", blendMethod);
        } else {
            logger.config("using default blending for fireworks particles", new Object[0]);
        }
    }
}

