/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mod;

import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;

public class RandomMobs
extends Mod {
    private static final String EXTRA_INFO_CLASS = "com.prupe.mcpatcher.mob.MobRandomizer$ExtraInfo";
    private static final MethodRef glEnable = new MethodRef("org.lwjgl.opengl.GL11", "glEnable", "(I)V");
    private static final MethodRef glDisable = new MethodRef("org.lwjgl.opengl.GL11", "glDisable", "(I)V");

    public RandomMobs() {
        this.name = "Random Mobs";
        this.author = "Balthichou";
        this.description = "Randomize mob skins if texture pack supports it. Based on Balthichou's mod.";
        this.website = "http://www.minecraftforum.net/topic/244172-";
        this.version = "1.6";
        this.addDependency("__TexturePackBase");
        this.addClassMod(new BaseMod.ResourceAddressMod(this));
        this.addClassMod(new BaseMod.NBTTagCompoundMod(this));
        this.addClassMod(new BaseMod.TessellatorMod(this));
        this.addClassMod(new EntityMod());
        this.addClassMod(new EntityLivingMod());
        this.addClassMod(new RenderMod());
        this.addClassMod(new RenderLivingMod());
        this.addClassMod(new RenderLivingSubMod());
        this.addClassMod(new RenderMiscMod("Spider", "textures/entity/spider_eyes.png"));
        this.addClassMod(new RenderMiscMod("Enderman", "textures/entity/enderman/enderman_eyes.png"));
        this.addClassMod(new RenderMiscMod("Sheep", "textures/entity/sheep/sheep_fur.png"));
        this.addClassMod(new RenderMiscMod("Wolf", "textures/entity/wolf/wolf_collar.png"));
        this.addClassMod(new RenderSnowmanMod());
        this.addClassMod(new RenderMooshroomMod());
        this.addClassMod(new RenderFishMod());
        this.addClassMod(new RenderLeashMod());
        this.addClassFile("com.prupe.mcpatcher.mob.MobRandomizer");
        this.addClassFile("com.prupe.mcpatcher.mob.MobRandomizer$1");
        this.addClassFile(EXTRA_INFO_CLASS);
        this.addClassFile("com.prupe.mcpatcher.mob.MobRuleList");
        this.addClassFile("com.prupe.mcpatcher.mob.MobRuleList$MobRuleEntry");
        this.addClassFile("com.prupe.mcpatcher.mob.MobOverlay");
        this.addClassFile("com.prupe.mcpatcher.mob.LineRenderer");
    }

    private class RenderLeashMod
    extends RenderLineMod {
        RenderLeashMod() {
            super("leash", 1);
            this.setParentClass("RenderLiving");
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.01745329238474369));
            this.addClassSignature(new ClassMod.ConstSignature(this, 1.5707963267948966));
        }

        @Override
        MethodRef getRenderMethod() {
            return new MethodRef(this.getDeobfClass(), "renderLeash", "(LEntityLivingSub;DDDFF)V");
        }
    }

    private class RenderFishMod
    extends RenderLineMod {
        RenderFishMod() {
            super("fishing line", 0);
            this.setParentClass("Render");
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/particle/particles.png"));
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf((float)Math.PI)));
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(180.0f)));
        }

        @Override
        MethodRef getRenderMethod() {
            return new MethodRef(this.getDeobfClass(), "renderFishingLine", "(LEntityFishHook;DDDFF)V");
        }
    }

    private abstract class RenderLineMod
    extends Mod.ClassMod {
        RenderLineMod(final String desc, final int type) {
            super(RandomMobs.this);
            MethodRef renderMethod = this.getRenderMethod();
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BytecodeMatcher.anyFLOAD), BinaryRegex.backReference(1), 106, BinaryRegex.backReference(1), 98);
                }
            }.setMethod(renderMethod));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override " + desc + " rendering";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.lookBehind(BinaryRegex.build(24, BinaryRegex.any(), 24, BinaryRegex.any(), 103, BinaryRegex.optional(BinaryRegex.build(144, 141)), 57, BinaryRegex.capture(BinaryRegex.any()), 24, BinaryRegex.any(), 24, BinaryRegex.any(), 103, BinaryRegex.optional(BinaryRegex.build(144, 141)), 57, BinaryRegex.capture(BinaryRegex.any()), 24, BinaryRegex.any(), 24, BinaryRegex.any(), 103, BinaryRegex.optional(BinaryRegex.build(144, 141)), 57, BinaryRegex.capture(BinaryRegex.any())), true), this.push(3553), this.reference(184, glDisable), BinaryRegex.any(0, 1000), this.push(3553), this.reference(184, glEnable));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(type), 40, 24, 4, 24, 6, 24, this.getCaptureGroup(1), 24, this.getCaptureGroup(2), 24, this.getCaptureGroup(3), this.reference(184, new MethodRef("com.prupe.mcpatcher.mob.LineRenderer", "renderLine", "(IDDDDDD)Z")), 154, this.branch("A"), this.getMatch(), this.label("A"));
                }
            }.targetMethod(renderMethod));
        }

        abstract MethodRef getRenderMethod();
    }

    private class RenderMooshroomMod
    extends Mod.ClassMod {
        RenderMooshroomMod() {
            super(RandomMobs.this);
            this.setParentClass("RenderLivingSub");
            final FieldRef renderBlocks = new FieldRef(this.getDeobfClass(), "renderBlocks", "LRenderBlocks;");
            final FieldRef mushroomRed = new FieldRef("Block", "mushroomRed", "LBlockFlower;");
            final FieldRef blocksAtlas = new FieldRef("TextureMap", "blocks", "LResourceAddress;");
            MethodRef renderEquippedItems = new MethodRef(this.getDeobfClass(), "renderEquippedItems1", "(LEntityMooshroom;F)V");
            MethodRef loadTexture = new MethodRef(this.getDeobfClass(), "loadTexture", "(LResourceAddress;)V");
            final MethodRef glPushMatrix = new MethodRef("org.lwjgl.opengl.GL11", "glPushMatrix", "()V");
            final MethodRef renderBlockAsItem = new MethodRef("RenderBlocks", "renderBlockAsItem", "(LBlock;IF)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/entity/cow/mooshroom.png"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(178), BytecodeMatcher.captureReference(182), this.push(2884), this.reference(184, glEnable), this.reference(184, glPushMatrix), BinaryRegex.any(0, 100), 42, BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(178), this.push(0), this.push(Float.valueOf(1.0f)), BytecodeMatcher.captureReference(182));
                }
            }.setMethod(renderEquippedItems).addXref(1, blocksAtlas).addXref(2, loadTexture).addXref(3, renderBlocks).addXref(4, mushroomRed).addXref(5, renderBlockAsItem));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "set up custom mooshroom overlay";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(178, blocksAtlas)});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, this.getMatch(), this.reference(184, new MethodRef("com.prupe.mcpatcher.mob.MobOverlay", "setupMooshroom", "(LEntityLiving;LResourceAddress;)LResourceAddress;")));
                }
            }.targetMethod(renderEquippedItems));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "render mooshroom overlay";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, renderBlocks), this.reference(178, mushroomRed), this.push(0), this.push(Float.valueOf(1.0f)), this.reference(182, renderBlockAsItem));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(184, new MethodRef("com.prupe.mcpatcher.mob.MobOverlay", "renderMooshroomOverlay", "()Z")), 154, this.branch("A"), this.getMatch(), this.label("A"));
                }
            }.targetMethod(renderEquippedItems));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "finish mooshroom overlay";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.mob.MobOverlay", "finishMooshroom", "()V"))});
                }
            }.setInsertBefore(true).targetMethod(renderEquippedItems));
        }
    }

    private class RenderSnowmanMod
    extends Mod.ClassMod {
        RenderSnowmanMod() {
            super(RandomMobs.this);
            this.setParentClass("RenderLivingSub");
            MethodRef renderEquippedItems = new MethodRef(this.getDeobfClass(), "renderEquippedItems1", "(LEntitySnowman;F)V");
            final MethodRef loadTexture = new MethodRef(this.getDeobfClass(), "loadTexture", "(LResourceAddress;)V");
            final MethodRef glTranslatef = new MethodRef("org.lwjgl.opengl.GL11", "glTranslatef", "(FFF)V");
            final FieldRef snowmanOverlayTexture = new FieldRef("com.prupe.mcpatcher.mob.MobOverlay", "snowmanOverlayTexture", "LResourceAddress;");
            final MethodRef setupSnowman = new MethodRef("com.prupe.mcpatcher.mob.MobOverlay", "setupSnowman", "(LEntityLiving;)Z");
            final MethodRef renderSnowmanOverlay = new MethodRef("com.prupe.mcpatcher.mob.MobOverlay", "renderSnowmanOverlay", "()V");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(0.625f)), BytecodeMatcher.anyFSTORE, this.push(Float.valueOf(0.0f)), this.push(Float.valueOf(-0.34375f)), this.push(Float.valueOf(0.0f)), this.reference(184, glTranslatef));
                }
            }.setMethod(renderEquippedItems));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "render snowman overlay";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.anyReference(180), BytecodeMatcher.anyReference(180), 43, 45, 3, BytecodeMatcher.anyReference(182));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, this.reference(184, setupSnowman), 153, this.branch("A"), 42, this.reference(178, snowmanOverlayTexture), this.reference(182, loadTexture), this.reference(184, renderSnowmanOverlay), 167, this.branch("B"), this.label("A"), this.getMatch(), this.label("B"));
                }
            }.targetMethod(renderEquippedItems));
        }
    }

    private class RenderMiscMod
    extends Mod.ClassMod {
        private final String mob;

        RenderMiscMod(String mob, final String texture) {
            super(RandomMobs.this);
            this.mob = mob;
            final FieldRef miscSkin = new FieldRef(this.getDeobfClass(), mob.toLowerCase() + "MiscSkin", "LResourceAddress;");
            final MethodRef randomTexture = new MethodRef("com.prupe.mcpatcher.mob.MobRandomizer", "randomTexture", "(LEntityLiving;LResourceAddress;)LResourceAddress;");
            this.addClassSignature(new BaseMod.ResourceAddressSignature(this, miscSkin, texture));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "randomize " + texture;
                }

                @Override
                public String getMatchExpression() {
                    if ((this.getMethodInfo().getAccessFlags() & 8) == 0 && this.getMethodInfo().getDescriptor().startsWith("(L")) {
                        return this.buildExpression(new Object[]{this.reference(178, miscSkin)});
                    }
                    return null;
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, this.getMatch(), this.reference(184, randomTexture));
                }
            });
        }

        @Override
        public String getDeobfClass() {
            return "Render" + this.mob;
        }
    }

    private class RenderLivingSubMod
    extends Mod.ClassMod {
        RenderLivingSubMod() {
            super(RandomMobs.this);
            this.setParentClass("RenderLiving");
            this.addClassSignature(new ClassMod.ConstSignature(this, 1.6));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.5));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.7));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.25));
        }
    }

    private class RenderLivingMod
    extends Mod.ClassMod {
        RenderLivingMod() {
            super(RandomMobs.this);
            this.setParentClass("Render");
            MethodRef doRenderLiving = new MethodRef(this.getDeobfClass(), "doRenderLiving", "(LEntityLiving;DDDFF)V");
            final MethodRef glTranslatef = new MethodRef("org.lwjgl.opengl.GL11", "glTranslatef", "(FFF)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(180.0f)));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(11, this.push(Float.valueOf(-24.0f)), BytecodeMatcher.anyFLOAD, 106, this.push(Float.valueOf(0.0078125f)), 102, 11, this.reference(184, glTranslatef));
                }
            }.setMethod(doRenderLiving));
        }
    }

    private class RenderMod
    extends Mod.ClassMod {
        RenderMod() {
            super(RandomMobs.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/misc/shadow.png"));
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.45f)));
            MethodRef loadTexture = new MethodRef(this.getDeobfClass(), "loadTexture", "(LResourceAddress;)V");
            final MethodRef getEntityTexture = new MethodRef(this.getDeobfClass(), "getEntityTexture", "(LEntity;)LResourceAddress;");
            final MethodRef randomTexture = new MethodRef("com.prupe.mcpatcher.mob.MobRandomizer", "randomTexture", "(LEntity;LResourceAddress;)LResourceAddress;");
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, loadTexture).accessFlag(4, true).accessFlag(8, false));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getEntityTexture).accessFlag(4, true).accessFlag(8, false));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "replace mob texture";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 43, this.reference(182, getEntityTexture));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, this.getMatch(), this.reference(184, randomTexture));
                }
            });
        }
    }

    private class EntityLivingMod
    extends BaseMod.EntityLivingMod {
        EntityLivingMod() {
            super(RandomMobs.this);
            MethodRef getEntityTexture = new MethodRef(this.getDeobfClass(), "getEntityTexture", "()Ljava/lang/String;");
            MethodRef writeToNBT = new MethodRef(this.getDeobfClass(), "writeToNBT", "(LNBTTagCompound;)V");
            MethodRef readFromNBT = new MethodRef(this.getDeobfClass(), "readFromNBT", "(LNBTTagCompound;)V");
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getEntityTexture));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, writeToNBT, readFromNBT).accessFlag(1, true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "write skin to nbt";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 43, this.reference(184, new MethodRef(RandomMobs.EXTRA_INFO_CLASS, "writeToNBT", "(LEntityLiving;LNBTTagCompound;)V")));
                }
            }.targetMethod(writeToNBT));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "read skin from nbt";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 43, this.reference(184, new MethodRef(RandomMobs.EXTRA_INFO_CLASS, "readFromNBT", "(LEntityLiving;LNBTTagCompound;)V")));
                }
            }.targetMethod(readFromNBT));
        }
    }

    private class EntityMod
    extends Mod.ClassMod {
        EntityMod() {
            super(RandomMobs.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "Pos"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Motion"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Rotation"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 42, 39, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181), 42, 42, 41, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181), 42, 42, 24, 5, 93, BytecodeMatcher.captureReference(181), BytecodeMatcher.captureReference(181));
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "setPositionAndRotation", "(DDDFF)V")).addXref(1, new FieldRef(this.getDeobfClass(), "posX", "D")).addXref(2, new FieldRef(this.getDeobfClass(), "prevPosX", "D")).addXref(3, new FieldRef(this.getDeobfClass(), "posY", "D")).addXref(4, new FieldRef(this.getDeobfClass(), "prevPosY", "D")).addXref(5, new FieldRef(this.getDeobfClass(), "posZ", "D")).addXref(6, new FieldRef(this.getDeobfClass(), "prevPosZ", "D")));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "entityId", "I")).accessFlag(1, true).accessFlag(8, false));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, new FieldRef(this.getDeobfClass(), "nextEntityID", "I")).accessFlag(2, true).accessFlag(8, true));
        }
    }
}

