/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mod;

import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.JavaRef;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;

public class HDFont
extends Mod {
    public HDFont() {
        this.name = "HD Font";
        this.author = "MCPatcher";
        this.description = "Provides support for higher resolution fonts.";
        this.version = "1.6";
        this.addDependency("__TexturePackBase");
        HDFont.setupMod(this);
    }

    static void setupMod(Mod mod) {
        mod.addClassMod(new FontRendererMod(mod));
        mod.addClassFile("com.prupe.mcpatcher.hd.FontUtils");
        mod.addClassFile("com.prupe.mcpatcher.hd.FontUtils$1");
    }

    private static class FontRendererMod
    extends BaseMod.FontRendererMod {
        FontRendererMod(Mod mod) {
            super(mod);
            final FieldRef fontResource = new FieldRef(this.getDeobfClass(), "fontResource", "LResourceAddress;");
            final FieldRef charWidth = new FieldRef(this.getDeobfClass(), "charWidth", "[I");
            FieldRef fontHeight = new FieldRef(this.getDeobfClass(), "fontHeight", "I");
            final FieldRef charWidthf = new FieldRef(this.getDeobfClass(), "charWidthf", "[F");
            FieldRef defaultFont = new FieldRef(this.getDeobfClass(), "defaultFont", "LResourceAddress;");
            FieldRef hdFont = new FieldRef(this.getDeobfClass(), "hdFont", "LResourceAddress;");
            FieldRef isHD = new FieldRef(this.getDeobfClass(), "isHD", "Z");
            MethodRef readFontData = new MethodRef(this.getDeobfClass(), "readFontData", "()V");
            MethodRef getStringWidth = new MethodRef(this.getDeobfClass(), "getStringWidth", "(Ljava/lang/String;)I");
            MethodRef getCharWidth = new MethodRef(this.getDeobfClass(), "getCharWidth", "(C)I");
            MethodRef computeCharWidths = new MethodRef(this.getDeobfClass(), "computeCharWidths", "()V");
            final MethodRef getImageWidth = new MethodRef("java/awt/image/BufferedImage", "getWidth", "()I");
            final MethodRef getFontName = new MethodRef("com.prupe.mcpatcher.hd.FontUtils", "getFontName", "(LFontRenderer;LResourceAddress;)LResourceAddress;");
            final MethodRef computeCharWidthsf = new MethodRef("com.prupe.mcpatcher.hd.FontUtils", "computeCharWidthsf", "(LFontRenderer;LResourceAddress;Ljava/awt/image/BufferedImage;[I[I)[F");
            final MethodRef getCharWidthf = new MethodRef("com.prupe.mcpatcher.hd.FontUtils", "getCharWidthf", "(LFontRenderer;[II)F");
            final MethodRef getStringWidthf = new MethodRef("com.prupe.mcpatcher.hd.FontUtils", "getStringWidthf", "(LFontRenderer;Ljava/lang/String;)F");
            final FieldRef enableFont = new FieldRef("com.prupe.mcpatcher.hd.FontUtils", "enable", "Z");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(9), BytecodeMatcher.captureReference(181), BinaryRegex.any(0, 100), 42, 44, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, fontHeight).addXref(2, fontResource));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.anyReference(183), 42, BytecodeMatcher.anyReference(183));
                }
            }.setMethod(readFontData));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, getImageWidth)});
                }
            }.setMethod(computeCharWidths));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getStringWidth));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getCharWidth));
            this.addPatch(new ClassMod.AddFieldPatch((ClassMod)this, charWidthf));
            this.addPatch(new ClassMod.AddFieldPatch((ClassMod)this, defaultFont));
            this.addPatch(new ClassMod.AddFieldPatch((ClassMod)this, hdFont));
            this.addPatch(new ClassMod.AddFieldPatch((ClassMod)this, isHD));
            this.addPatch(new ClassMod.MakeMemberPublicPatch((JavaRef)fontResource){

                @Override
                public int getNewFlags(int oldFlags) {
                    return oldFlags & 0xFFFFFFEF;
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override font name";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 42, 42, this.reference(180, fontResource), this.reference(184, getFontName), this.reference(181, fontResource));
                }
            }.targetMethod(readFontData));
            this.addPatch(new ClassMod.BytecodePatch(){
                private int imageRegister;
                private int rgbRegister;
                {
                    super(FontRendererMod.this);
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(BinaryRegex.capture(BytecodeMatcher.anyALOAD), this.reference(182, getImageWidth), BinaryRegex.any(0, 10), BytecodeMatcher.anyILOAD, BytecodeMatcher.anyILOAD, 104, 188, 10, BinaryRegex.capture(BytecodeMatcher.anyASTORE));
                        }

                        @Override
                        public boolean afterMatch() {
                            imageRegister = BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(1));
                            rgbRegister = BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(2));
                            return true;
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "FontUtils.computeCharWidthsf on init";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 42, 42, this.reference(180, fontResource), 25, this.imageRegister, 25, this.rgbRegister, 42, this.reference(180, charWidth), this.reference(184, computeCharWidthsf), this.reference(181, charWidthf));
                }
            }.setInsertBefore(true).targetMethod(computeCharWidths));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "use charWidthf instead of charWidth";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, charWidth), BinaryRegex.capture(BinaryRegex.any(1, 4)), 46, 134, 174);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 42, this.reference(180, charWidth), this.getCaptureGroup(1), this.reference(184, getCharWidthf), 174);
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override getStringWidth";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, enableFont), 153, this.branch("A"), 42, 43, this.reference(184, getStringWidthf), 139, 172, this.label("A"));
                }
            }.targetMethod(getStringWidth));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "4.0f -> charWidthf[32]";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(4.0f)), 174);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, charWidthf), this.push(32), 48, 174);
                }
            });
            this.setupUnicode();
        }

        private void setupUnicode() {
            MethodRef getUnicodePage = new MethodRef(this.getDeobfClass(), "getUnicodePage", "(I)LResourceAddress;");
            final MethodRef getUnicodePage1 = new MethodRef("com.prupe.mcpatcher.hd.FontUtils", "getUnicodePage", "(LResourceAddress;)LResourceAddress;");
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getUnicodePage));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override unicode font name";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(176);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, getUnicodePage1)});
                }
            }.setInsertBefore(true).targetMethod(getUnicodePage));
        }
    }
}

