/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mod;

import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.BytecodePatch;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassRef;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.InterfaceMethodRef;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.mod.HDConfig;
import com.prupe.mcpatcher.mod.HDFont;

public class ExtendedHD
extends Mod {
    private static final MethodRef copySubTexture1 = new MethodRef("TextureUtils", "copySubTexture1", "([IIIIIZZ)V");
    private static final MethodRef copySubTexture2 = new MethodRef("TextureUtils", "copySubTexture2", "(Ljava/awt/image/BufferedImage;IIZZ)V");
    private static final MethodRef setupTexture1 = new MethodRef("TextureUtils", "setupTexture1", "(ILjava/awt/image/BufferedImage;ZZ)I");
    private static final MethodRef setupTexture2 = new MethodRef("TextureUtils", "setupTexture2", "(III)V");
    private static final MethodRef setupTextureMipmaps1 = new MethodRef("com.prupe.mcpatcher.hd.MipmapHelper", "setupTexture", "(ILjava/awt/image/BufferedImage;ZZLResourceAddress;)I");
    private static final MethodRef setupTextureMipmaps2 = new MethodRef("com.prupe.mcpatcher.hd.MipmapHelper", "setupTexture", "(IIILjava/lang/String;)V");
    private static final MethodRef copySubTextureMipmaps = new MethodRef("com.prupe.mcpatcher.hd.MipmapHelper", "copySubTexture", "([IIIIILjava/lang/String;)V");
    private static final MethodRef imageRead = new MethodRef("javax/imageio/ImageIO", "read", "(Ljava/io/InputStream;)Ljava/awt/image/BufferedImage;");

    public ExtendedHD() {
        this.name = "Extended HD";
        this.author = "MCPatcher";
        this.description = "Provides support for custom animations, HD fonts, mipmapping, and other graphical features.";
        this.version = "3.1";
        this.configPanel = new HDConfig();
        this.addDependency("__TexturePackBase");
        if (ExtendedHD.getMinecraftVersion().compareTo("13w24b") < 0) {
            this.addError("Requires Minecraft 1.6 or newer");
            return;
        }
        this.addClassMod(new MinecraftMod());
        this.addClassMod(new BaseMod.ResourceAddressMod(this));
        this.addClassMod(new BaseMod.IResourceMod(this));
        this.addClassMod(new BaseMod.IconMod(this));
        this.addClassMod(new BaseMod.ITextureMod(this));
        this.addClassMod(new BaseMod.TextureBaseMod(this));
        this.addClassMod(new BaseMod.TextureMod(this));
        this.addClassMod(new TextureUtilsMod());
        this.addClassMod(new TextureManagerMod());
        this.addClassMod(new TextureMapMod());
        this.addClassMod(new TextureStitchedMod());
        this.addClassMod(new TextureNamedMod());
        this.addClassMod(new TextureCompassMod());
        this.addClassMod(new TextureClockMod());
        this.addClassMod(new StreamedResourceMod());
        HDFont.setupMod(this);
        this.addClassFile("com.prupe.mcpatcher.hd.CustomAnimation");
        this.addClassFile("com.prupe.mcpatcher.hd.CustomAnimation$1");
        this.addClassFile("com.prupe.mcpatcher.hd.MipmapHelper");
        this.addClassFile("com.prupe.mcpatcher.hd.AAHelper");
        this.addClassFile("com.prupe.mcpatcher.hd.BorderedTexture");
        this.addClassFile("com.prupe.mcpatcher.hd.FancyDial");
        this.addClassFile("com.prupe.mcpatcher.hd.FancyDial$Layer");
        this.getClassMap().addInheritance("TextureStitched", "com.prupe.mcpatcher.hd.BorderedTexture");
    }

    @Override
    public String[] getLoggingCategories() {
        return new String[]{"Custom Animations", "Mipmap", "HD Font"};
    }

    private class StreamedResourceMod
    extends Mod.ClassMod {
        StreamedResourceMod() {
            super(ExtendedHD.this);
            this.setInterfaces("IResource");
            this.addClassSignature(new ClassMod.ConstSignature(this, new ClassRef("java/io/BufferedReader")));
            this.addClassSignature(new ClassMod.ConstSignature(this, new ClassRef("java/io/InputStreamReader")));
            this.addClassSignature(new ClassMod.ConstSignature(this, new MethodRef("com/google/gson/JsonElement", "getAsJsonObject", "()Lcom/google/gson/JsonObject;")));
            this.addClassSignature(new ClassMod.ConstSignature(this, "pack.mcmeta").negate(true));
        }
    }

    private class TextureClockMod
    extends TextureDialMod {
        TextureClockMod() {
            super("clock");
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.8));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.5));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 89, BinaryRegex.capture(BinaryRegex.build(180, BinaryRegex.capture(BinaryRegex.any(2)))), 42, BytecodeMatcher.anyReference(180), 99, 181, BinaryRegex.backReference(2));
                }
            }.setMethod(this.update).addXref(1, this.currentAngle));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(this, this.currentAngle));
        }

        @Override
        protected MethodRef getUpdateMethod() {
            return new MethodRef(this.getDeobfClass(), "updateAnimation", "()V");
        }
    }

    private class TextureCompassMod
    extends TextureDialMod {
        TextureCompassMod() {
            super("compass");
            this.addClassSignature(new ClassMod.ConstSignature(this, 180.0));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), this.push(Math.PI * 2), 111, this.push(1.0), 99);
                }
            }.setMethod(this.update).addXref(1, this.currentAngle));
        }

        @Override
        protected MethodRef getUpdateMethod() {
            return new MethodRef(this.getDeobfClass(), "updateNeedle", "(LWorld;DDDZZ)V");
        }
    }

    private abstract class TextureDialMod
    extends Mod.ClassMod {
        protected final FieldRef currentAngle;
        protected final MethodRef update;

        TextureDialMod(final String name) {
            super(ExtendedHD.this);
            this.currentAngle = new FieldRef(this.getDeobfClass(), "currentAngle", "D");
            this.update = this.getUpdateMethod();
            this.setParentClass("TextureStitched");
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "setup custom " + name;
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(184, new MethodRef("com.prupe.mcpatcher.hd.FancyDial", "setup", "(LTextureStitched;)V")));
                }
            }.setInsertBefore(true).matchConstructorOnly(true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "render custom " + name;
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, TextureDialMod.this.currentAngle), BinaryRegex.optional(BinaryRegex.build(this.push(Math.PI * 2), 111)), this.push(1.0), 99);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(184, new MethodRef("com.prupe.mcpatcher.hd.FancyDial", "update", "(LTextureStitched;)Z")), 153, this.branch("A"), 177, this.label("A"));
                }
            }.setInsertBefore(true).targetMethod(this.update));
        }

        protected abstract MethodRef getUpdateMethod();
    }

    private class TextureNamedMod
    extends BaseMod.TextureNamedMod {
        TextureNamedMod() {
            super(ExtendedHD.this);
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "generate mipmaps";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, setupTexture1)});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, TextureNamedMod.this.textureName), this.reference(184, setupTextureMipmaps1));
                }
            });
        }
    }

    private static class TextureMipmapPatch
    extends BytecodePatch {
        private final FieldRef textureNameField;

        TextureMipmapPatch(ClassMod classMod, FieldRef textureNameField) {
            super(classMod);
            this.textureNameField = textureNameField;
        }

        @Override
        public String getDescription() {
            return "generate mipmaps";
        }

        @Override
        public String getMatchExpression() {
            return this.buildExpression(new Object[]{this.reference(184, copySubTexture1)});
        }

        @Override
        public byte[] getReplacementBytes() {
            return this.buildCode(87, 87, 42, this.reference(180, this.textureNameField), this.reference(184, copySubTextureMipmaps));
        }
    }

    private class TextureStitchedMod
    extends BaseMod.TextureStitchedMod {
        TextureStitchedMod() {
            super(ExtendedHD.this);
            MethodRef constructor = new MethodRef(this.getDeobfClass(), "<init>", "(Ljava/lang/String;)V");
            MethodRef init = new MethodRef(this.getDeobfClass(), "init", "(IIIIZ)V");
            MethodRef copy = new MethodRef(this.getDeobfClass(), "copy", "(LTextureStitched;)V");
            MethodRef updateAnimation = new MethodRef(this.getDeobfClass(), "updateAnimation", "()V");
            MethodRef loadResource = new MethodRef(this.getDeobfClass(), "loadResource", "(LIResource;)V");
            final MethodRef addBorder = new MethodRef("com.prupe.mcpatcher.hd.AAHelper", "addBorder", "(LTextureStitched;LIResource;Ljava/awt/image/BufferedImage;)Ljava/awt/image/BufferedImage;");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(1), 96, BinaryRegex.any(1, 6), 112);
                }
            }.setMethod(updateAnimation));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, init));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, copy));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, loadResource));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(this, constructor));
            this.addPatch(new TextureMipmapPatch(this, this.textureName));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "add tile border for aa";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyALOAD, this.reference(184, imageRead));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 43, this.getMatch(), this.reference(184, addBorder));
                }
            }.targetMethod(loadResource));
        }
    }

    private class TextureMapMod
    extends BaseMod.TextureMapMod {
        TextureMapMod() {
            super(ExtendedHD.this);
            final ClassRef textureStitched = new ClassRef("TextureStitched");
            final MethodRef textureStitchedConstructor = new MethodRef("TextureStitched", "<init>", "(Ljava/lang/String;)V");
            final MethodRef createTextureStitched = new MethodRef("com.prupe.mcpatcher.hd.BorderedTexture", "create", "(Ljava/lang/String;Ljava/lang/String;)LTextureStitched;");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.capture(BytecodeMatcher.anyALOAD), this.push(0), BytecodeMatcher.captureReference(182), BinaryRegex.backReference(1), BytecodeMatcher.anyReference(182), BinaryRegex.backReference(1), BytecodeMatcher.anyReference(182), BinaryRegex.backReference(1), BytecodeMatcher.captureReference(182), BinaryRegex.backReference(1), BytecodeMatcher.captureReference(182), this.push(0), this.push(0), BytecodeMatcher.anyReference(184));
                }
            }.addXref(2, new MethodRef("TextureStitched", "getFrameRGB", "(I)[I")).addXref(3, new MethodRef("TextureStitched", "getX0", "()I")).addXref(4, new MethodRef("TextureStitched", "getY0", "()I")));
            this.addPatch(new TextureMipmapPatch(this, this.basePath));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "enable mipmapping for tilesheets";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, setupTexture2)});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, TextureMapMod.this.basePath), this.reference(184, setupTextureMipmaps2));
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override texture coordinates for aa";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.reference(187, textureStitched), 89, 43, this.reference(183, textureStitchedConstructor));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, TextureMapMod.this.basePath), 43, this.reference(184, createTextureStitched));
                }
            });
        }
    }

    private class TextureManagerMod
    extends Mod.ClassMod {
        TextureManagerMod() {
            super(ExtendedHD.this);
            MethodRef updateAnimations = new MethodRef(this.getDeobfClass(), "updateAnimations", "()V");
            FieldRef animations = new FieldRef(this.getDeobfClass(), "animations", "Ljava/util/List;");
            final InterfaceMethodRef listIterator = new InterfaceMethodRef("java/util/List", "iterator", "()Ljava/util/Iterator;");
            this.addClassSignature(new ClassMod.ConstSignature(this, "dynamic/%s_%d"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), this.reference(185, listIterator), 76);
                }
            }.setMethod(updateAnimations).addXref(1, animations));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "update custom animations";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.hd.CustomAnimation", "updateAll", "()V"))});
                }
            }.setInsertBefore(true).targetMethod(updateAnimations));
        }
    }

    private class TextureUtilsMod
    extends BaseMod.TextureUtilsMod {
        TextureUtilsMod() {
            super(ExtendedHD.this);
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, copySubTexture1));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, copySubTexture2));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, setupTexture1));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, setupTexture2));
        }
    }

    private class MinecraftMod
    extends BaseMod.MinecraftMod {
        MinecraftMod() {
            super(ExtendedHD.this);
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "enable anti-aliasing";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(184, new MethodRef("org/lwjgl/opengl/Display", "create", "(Lorg/lwjgl/opengl/PixelFormat;)V"))});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.hd.AAHelper", "setupPixelFormat", "(Lorg/lwjgl/opengl/PixelFormat;)Lorg/lwjgl/opengl/PixelFormat;"))});
                }
            }.setInsertBefore(true));
        }
    }
}

