/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mod;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BaseTexturePackMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.BytecodePatch;
import com.prupe.mcpatcher.BytecodeSignature;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassRef;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.ModConfigPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CustomItemTextures
extends Mod {
    private static final String GLINT_PNG = "textures/misc/enchanted_item_glint.png";
    private static final FieldRef itemsList = new FieldRef("Item", "itemsList", "[LItem;");
    private static final MethodRef glDepthFunc = new MethodRef("org.lwjgl.opengl.GL11", "glDepthFunc", "(I)V");
    private static final MethodRef getEntityItem = new MethodRef("EntityItem", "getEntityItem", "()LItemStack;");
    private static final MethodRef hasEffect = new MethodRef("ItemStack", "hasEffect", "()Z");
    private static final MethodRef getIconFromDamageForRenderPass = new MethodRef("Item", "getIconFromDamageForRenderPass", "(II)LIcon;");
    private static final MethodRef getItem = new MethodRef("ItemStack", "getItem", "()LItem;");
    private static final MethodRef getCITIcon = new MethodRef("com.prupe.mcpatcher.cit.CITUtils", "getIcon", "(LIcon;LItemStack;I)LIcon;");

    public CustomItemTextures() {
        this.name = "Custom Item Textures";
        this.author = "MCPatcher";
        this.description = "Enables support for custom item textures, enchantments, and armor.";
        this.version = "0.5";
        this.configPanel = new ConfigPanel();
        this.addDependency("__TexturePackBase");
        this.addDependency("__TilesheetBase");
        this.addClassMod(new BaseMod.ResourceAddressMod(this));
        this.addClassMod(new BaseMod.TessellatorMod(this));
        this.addClassMod(new BaseMod.NBTTagCompoundMod(this).mapGetTagList());
        this.addClassMod(new BaseMod.NBTTagListMod(this));
        this.addClassMod(new BaseMod.IconMod(this));
        this.addClassMod(new ItemMod());
        this.addClassMod(new ItemArmorMod());
        this.addClassMod(new ItemStackMod());
        this.addClassMod(new EntityItemMod());
        this.addClassMod(new ItemRendererMod());
        this.addClassMod(new RenderItemMod());
        this.addClassMod(new RenderLivingMod());
        this.addClassMod(new RenderBipedMod());
        this.addClassMod(new RenderPlayerMod());
        this.addClassMod(new RenderSnowballMod());
        this.addClassMod(new BaseMod.EntityLivingMod(this));
        this.addClassMod(new BaseMod.EntityLivingSubMod(this));
        this.addClassMod(new EntityPlayerMod());
        this.addClassMod(new PotionMod());
        this.addClassMod(new PotionHelperMod());
        this.addClassFile("com.prupe.mcpatcher.cit.CITUtils");
        this.addClassFile("com.prupe.mcpatcher.cit.CITUtils$1");
        this.addClassFile("com.prupe.mcpatcher.cit.OverrideBase");
        this.addClassFile("com.prupe.mcpatcher.cit.ItemOverride");
        this.addClassFile("com.prupe.mcpatcher.cit.Enchantment");
        this.addClassFile("com.prupe.mcpatcher.cit.EnchantmentList");
        this.addClassFile("com.prupe.mcpatcher.cit.EnchantmentList$Layer");
        this.addClassFile("com.prupe.mcpatcher.cit.EnchantmentList$LayerMethod");
        this.addClassFile("com.prupe.mcpatcher.cit.EnchantmentList$Average");
        this.addClassFile("com.prupe.mcpatcher.cit.EnchantmentList$Layered");
        this.addClassFile("com.prupe.mcpatcher.cit.EnchantmentList$Cycle");
        this.addClassFile("com.prupe.mcpatcher.cit.ArmorOverride");
        this.addClassFile("com.prupe.mcpatcher.cit.PotionReplacer");
        BaseTexturePackMod.earlyInitialize(2, "com.prupe.mcpatcher.cit.CITUtils", "init");
    }

    private void addGlintSignature(Mod.ClassMod classMod, MethodRef method) {
        this.addGlintSignature(classMod, method, BinaryRegex.build(42));
    }

    private void addGlintSignature(Mod.ClassMod classMod, MethodRef method, final String opcode) {
        FieldRef glint = new FieldRef(classMod.getDeobfClass(), "glint", "LResourceAddress;");
        classMod.addClassSignature(new BaseMod.ResourceAddressSignature(classMod, glint, GLINT_PNG));
        classMod.addClassSignature(new BytecodeSignature(classMod){

            @Override
            public String getMatchExpression() {
                return this.buildExpression(opcode, BinaryRegex.any(0, 10), BytecodeMatcher.captureReference(178), BytecodeMatcher.anyReference(182));
            }

            @Override
            public boolean afterMatchPre() {
                int index = (this.getCaptureGroup(1)[1] & 0xFF) << 8 | this.getCaptureGroup(1)[2] & 0xFF;
                String cl1 = this.getMethodInfo().getConstPool().getFieldrefClassName(index);
                String cl2 = this.getClassFile().getName();
                return cl1.equals(cl2);
            }
        }.setMethod(method).addXref(1, glint));
    }

    private class PotionHelperMod
    extends Mod.ClassMod {
        PotionHelperMod() {
            super(CustomItemTextures.this);
            MethodRef getMundaneName = new MethodRef(this.getDeobfClass(), "getMundaneName", "(I)Ljava/lang/String;");
            this.addClassSignature(new ClassMod.ConstSignature(this, "potion.prefix.mundane"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "potion.prefix.uninteresting"));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getMundaneName).accessFlag(1, true).accessFlag(8, true));
        }
    }

    private class PotionMod
    extends Mod.ClassMod {
        PotionMod() {
            super(CustomItemTextures.this);
            FieldRef potionTypes = new FieldRef(this.getDeobfClass(), "potionTypes", "[LPotion;");
            MethodRef getName = new MethodRef(this.getDeobfClass(), "getName", "()Ljava/lang/String;");
            this.addClassSignature(new ClassMod.ConstSignature(this, "potion.moveSpeed"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "potion.moveSlowdown"));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, potionTypes).accessFlag(1, true).accessFlag(8, true));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getName).accessFlag(1, true).accessFlag(8, false));
        }
    }

    private class ItemStackRenderPassPatch
    extends BytecodePatch {
        private final String desc;

        ItemStackRenderPassPatch(Mod.ClassMod classMod, String desc) {
            super(classMod);
            this.desc = desc;
            this.setInsertAfter(true);
        }

        @Override
        public String getDescription() {
            return "handle items with multiple render passes (" + this.desc + ")";
        }

        @Override
        public String getMatchExpression() {
            return this.buildExpression(BinaryRegex.capture(BytecodeMatcher.anyALOAD), this.reference(182, getItem), BinaryRegex.backReference(1), BytecodeMatcher.anyReference(182), BinaryRegex.capture(BytecodeMatcher.anyILOAD), this.reference(182, getIconFromDamageForRenderPass));
        }

        @Override
        public byte[] getReplacementBytes() {
            return this.buildCode(this.getCaptureGroup(1), this.getCaptureGroup(2), this.reference(184, getCITIcon));
        }
    }

    private class EntityPlayerMod
    extends Mod.ClassMod {
        EntityPlayerMod() {
            super(CustomItemTextures.this);
            MethodRef getCurrentArmor = new MethodRef(this.getDeobfClass(), "getCurrentArmor", "(I)LItemStack;");
            this.setParentClass("EntityLiving");
            this.addClassSignature(new ClassMod.ConstSignature(this, "random.eat"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.anyReference(180), 27, BytecodeMatcher.anyReference(182), 176, BinaryRegex.end());
                }
            }.setMethod(getCurrentArmor));
            this.addPatch(new ItemStackRenderPassPatch(this, "player held"));
        }
    }

    private class RenderSnowballMod
    extends Mod.ClassMod {
        RenderSnowballMod() {
            super(CustomItemTextures.this);
            this.setParentClass("Render");
            MethodRef doRender = new MethodRef(this.getDeobfClass(), "doRender", "(LEntity;DDDFF)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, "bottle_splash"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "overlay"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(43, BytecodeMatcher.captureReference(192), BytecodeMatcher.captureReference(182));
                }
            }.setMethod(doRender).addXref(1, new ClassRef("EntityPotion")).addXref(2, new MethodRef("EntityPotion", "getPotionDamage", "()I")));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override potion entity texture";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), BinaryRegex.capture(BinaryRegex.build(42, BinaryRegex.nonGreedy(BinaryRegex.any(0, 20)))), BinaryRegex.capture(BytecodeMatcher.anyASTORE));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.getCaptureGroup(1), 43, this.reference(184, new MethodRef("com.prupe.mcpatcher.cit.CITUtils", "getEntityIcon", "(LIcon;LEntity;)LIcon;")), this.getCaptureGroup(2));
                }
            }.targetMethod(doRender));
        }
    }

    private abstract class RenderArmorMod
    extends Mod.ClassMod {
        protected final MethodRef getArmorTexture2;
        protected final MethodRef getArmorTexture3;

        RenderArmorMod() {
            super(CustomItemTextures.this);
            this.getArmorTexture2 = new MethodRef("RenderBiped", "getArmorTexture2", "(LItemArmor;I)LResourceAddress;");
            this.getArmorTexture3 = new MethodRef("RenderBiped", "getArmorTexture3", "(LItemArmor;ILjava/lang/String;)LResourceAddress;");
            MethodRef renderArmor = new MethodRef(this.getDeobfClass(), "renderArmor", "(L" + this.getEntityClass() + ";IF)V");
            final MethodRef getArmorTexture = new MethodRef("com.prupe.mcpatcher.cit.CITUtils", "getArmorTexture", "(LResourceAddress;LEntityLiving;LItemStack;)LResourceAddress;");
            final BytecodeSignature signature = new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 43, BinaryRegex.optional(BinaryRegex.build(BytecodeMatcher.anyReference(180))), this.push(3), 28, 100, BytecodeMatcher.anyReference(182), BinaryRegex.capture(BytecodeMatcher.anyASTORE));
                }
            }.setMethod(renderArmor);
            this.addClassSignature(signature);
            this.addPatch(new ClassMod.BytecodePatch(){
                private int armorRegister;
                {
                    super(RenderArmorMod.this);
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return signature.getMatchExpression();
                        }

                        @Override
                        public boolean afterMatch() {
                            armorRegister = BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(1));
                            return true;
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "override armor texture";
                }

                @Override
                public boolean filterMethod() {
                    return this.getMethodInfo().getDescriptor().matches("\\(L[a-z]+;IF\\)[IV]");
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(new Object[]{this.reference(184, RenderArmorMod.this.getArmorTexture2)}), BinaryRegex.build(new Object[]{this.reference(184, RenderArmorMod.this.getArmorTexture3)})));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, 25, this.armorRegister, this.reference(184, getArmorTexture));
                }
            }.setInsertAfter(true));
        }

        abstract String getEntityClass();
    }

    private class RenderPlayerMod
    extends RenderArmorMod {
        RenderPlayerMod() {
            this.setParentClass("RenderLiving");
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/entity/steve.png"));
        }

        @Override
        String getEntityClass() {
            return "EntityPlayer";
        }
    }

    private class RenderBipedMod
    extends RenderArmorMod {
        RenderBipedMod() {
            this.setParentClass("RenderLivingSub");
            MethodRef loadTextureForPass = new MethodRef(this.getDeobfClass(), "loadTextureForPass", "(LEntityLivingSub;IF)V");
            MethodRef getCurrentArmor = new MethodRef("EntityLivingSub", "getCurrentArmor", "(I)LItemStack;");
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/models/armor/%s_layer_%d%s.png"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(43, this.push(3), 28, 100, BytecodeMatcher.captureReference(182));
                }
            }.setMethod(loadTextureForPass).addXref(1, getCurrentArmor));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, this.getArmorTexture2).accessFlag(8, true));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, this.getArmorTexture3).accessFlag(8, true));
        }

        @Override
        String getEntityClass() {
            return "EntityLivingSub";
        }
    }

    private class RenderLivingMod
    extends Mod.ClassMod {
        RenderLivingMod() {
            super(CustomItemTextures.this);
            MethodRef doRenderLiving = new MethodRef(this.getDeobfClass(), "doRenderLiving", "(LEntityLiving;DDDFF)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, "deadmau5"));
            CustomItemTextures.this.addGlintSignature(this, doRenderLiving);
            this.addPatch(new ClassMod.BytecodePatch(){
                private int passRegister;
                private byte[] renderModelCode;
                {
                    super(RenderLivingMod.this);
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(42, 43, BinaryRegex.capture(BytecodeMatcher.anyILOAD), BytecodeMatcher.anyFLOAD, BytecodeMatcher.anyReference(182), BytecodeMatcher.anyISTORE);
                        }

                        @Override
                        public boolean afterMatch() {
                            passRegister = BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(1));
                            return true;
                        }
                    });
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(42, BytecodeMatcher.anyReference(180), 43, BytecodeMatcher.anyFLOAD, BytecodeMatcher.anyFLOAD, BytecodeMatcher.anyFLOAD, BytecodeMatcher.anyFLOAD, BytecodeMatcher.anyFLOAD, 102, BytecodeMatcher.anyFLOAD, BytecodeMatcher.anyFLOAD, BytecodeMatcher.anyReference(182));
                        }

                        @Override
                        public boolean afterMatch() {
                            1.access$1502(this, this.getMatch());
                            return true;
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "render item enchantment (armor)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyILOAD, this.push(15), 126, this.push(15), 160, BinaryRegex.any(2), BinaryRegex.nonGreedy(BinaryRegex.any(0, 400)), this.push(515), this.reference(184, glDepthFunc));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, 21, this.passRegister, this.reference(184, new MethodRef("com.prupe.mcpatcher.cit.CITUtils", "setupArmorEnchantments", "(LEntityLiving;I)Z")), 153, this.branch("A"), this.label("B"), this.reference(184, new MethodRef("com.prupe.mcpatcher.cit.CITUtils", "preRenderArmorEnchantment", "()Z")), 153, this.branch("C"), this.renderModelCode, this.reference(184, new MethodRef("com.prupe.mcpatcher.cit.CITUtils", "postRenderArmorEnchantment", "()V")), 167, this.branch("B"), this.label("A"), this.getMatch(), this.label("C"));
                }

                static /* synthetic */ byte[] access$1502(1 x0, byte[] x1) {
                    x0.renderModelCode = x1;
                    return x1;
                }
            }.targetMethod(doRenderLiving));
        }
    }

    private class RenderItemMod
    extends Mod.ClassMod {
        RenderItemMod() {
            super(CustomItemTextures.this);
            final FieldRef zLevel = new FieldRef(this.getDeobfClass(), "zLevel", "F");
            MethodRef renderDroppedItem = new MethodRef(this.getDeobfClass(), "renderDroppedItem", "(LEntityItem;LIcon;IFFFF)V");
            MethodRef renderItemAndEffectIntoGUI = new MethodRef(this.getDeobfClass(), "renderItemAndEffectIntoGUI", "(LFontRenderer;LTextureManager;LItemStack;II)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, "missingno"));
            CustomItemTextures.this.addGlintSignature(this, renderDroppedItem);
            CustomItemTextures.this.addGlintSignature(this, renderItemAndEffectIntoGUI, BinaryRegex.build(44));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, zLevel).accessFlag(8, false));
            this.addPatch(new ClassMod.BytecodePatch(){
                private int itemStackRegister;
                {
                    super(RenderItemMod.this);
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(BytecodeMatcher.anyALOAD, this.reference(182, getEntityItem), BinaryRegex.capture(BytecodeMatcher.anyASTORE));
                        }

                        @Override
                        public boolean afterMatch() {
                            itemStackRegister = BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(1));
                            return true;
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "render item enchantment (dropped)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(25, this.itemStackRegister, this.reference(182, hasEffect), 153, BinaryRegex.any(2), BinaryRegex.nonGreedy(BinaryRegex.any(0, 400)), this.push(515), this.reference(184, glDepthFunc));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(25, this.itemStackRegister, this.reference(184, new MethodRef("com.prupe.mcpatcher.cit.CITUtils", "renderEnchantmentDropped", "(LItemStack;)Z")), 154, this.branch("A"), this.getMatch(), this.label("A"));
                }
            }.targetMethod(renderDroppedItem));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "render item enchantment (gui)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(45, this.reference(182, hasEffect), 153, BinaryRegex.any(2), BinaryRegex.nonGreedy(BinaryRegex.any(0, 400)), this.push(515), this.reference(184, glDepthFunc));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(45, 21, 4, 21, 5, 42, this.reference(180, zLevel), this.reference(184, new MethodRef("com.prupe.mcpatcher.cit.CITUtils", "renderEnchantmentGUI", "(LItemStack;IIF)Z")), 154, this.branch("A"), this.getMatch(), this.label("A"));
                }
            }.targetMethod(renderItemAndEffectIntoGUI));
            this.addPatch(new ItemStackRenderPassPatch(this, "other"));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "handle items with multiple render passes (gui)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.reference(178, itemsList), BytecodeMatcher.anyILOAD, 50, BytecodeMatcher.anyILOAD, BinaryRegex.capture(BytecodeMatcher.anyILOAD), this.reference(182, getIconFromDamageForRenderPass));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(45, this.getCaptureGroup(1), this.reference(184, getCITIcon));
                }
            }.setInsertAfter(true));
        }
    }

    private class ItemRendererMod
    extends Mod.ClassMod {
        ItemRendererMod() {
            super(CustomItemTextures.this);
            MethodRef renderItem = new MethodRef(this.getDeobfClass(), "renderItem", "(LEntityLiving;LItemStack;I)V");
            MethodRef renderItemIn2D = new MethodRef(this.getDeobfClass(), "renderItemIn2D", "(LTessellator;FFFFIIF)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/map/map_background.png"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/misc/underwater.png"));
            CustomItemTextures.this.addGlintSignature(this, renderItem, BytecodeMatcher.anyALOAD);
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.optional(BinaryRegex.build(44, 198, BinaryRegex.any(2))), 44, BytecodeMatcher.captureReference(182), 153, BinaryRegex.any(2), 29, 154, BinaryRegex.any(2));
                }
            }.setMethod(renderItem).addXref(1, hasEffect));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, renderItemIn2D).accessFlag(8, true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "render item enchantment (held)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.optional(BinaryRegex.build(44, 198, BinaryRegex.any(2))), 44, this.reference(182, hasEffect), 153, BinaryRegex.any(2), 29, 154, BinaryRegex.any(2), BinaryRegex.nonGreedy(BinaryRegex.any(0, 400)), this.push(515), this.reference(184, glDepthFunc));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(44, 29, this.reference(184, new MethodRef("com.prupe.mcpatcher.cit.CITUtils", "renderEnchantmentHeld", "(LItemStack;I)Z")), 154, this.branch("A"), this.getMatch(), this.label("A"));
                }
            }.targetMethod(renderItem));
        }
    }

    private class EntityItemMod
    extends Mod.ClassMod {
        EntityItemMod() {
            super(CustomItemTextures.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "Health"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Age"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Item"));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getEntityItem));
        }
    }

    private class ItemStackMod
    extends Mod.ClassMod {
        ItemStackMod() {
            super(CustomItemTextures.this);
            FieldRef stackSize = new FieldRef(this.getDeobfClass(), "stackSize", "I");
            FieldRef itemID = new FieldRef(this.getDeobfClass(), "itemID", "I");
            FieldRef itemDamage = new FieldRef(this.getDeobfClass(), "itemDamage", "I");
            FieldRef stackTagCompound = new FieldRef(this.getDeobfClass(), "stackTagCompound", "LNBTTagCompound;");
            MethodRef getItemDamage = new MethodRef(this.getDeobfClass(), "getItemDamage", "()I");
            this.addClassSignature(new ClassMod.ConstSignature(this, "id"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Count"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "Damage"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 27, BytecodeMatcher.captureReference(181), 42, 28, BytecodeMatcher.captureReference(181), 42, 29, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).setMethod(new MethodRef(this.getDeobfClass(), "<init>", "(III)V")).addXref(1, itemID).addXref(2, stackSize).addXref(3, itemDamage));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.captureReference(180), 172, BinaryRegex.end());
                }
            }.setMethod(getItemDamage).addXref(1, itemDamage));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, stackTagCompound));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getItem));
        }
    }

    private class ItemArmorMod
    extends Mod.ClassMod {
        ItemArmorMod() {
            super(CustomItemTextures.this);
            this.addClassSignature(new ClassMod.ConstSignature(this, "leather_helmet_overlay"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "empty_armor_slot_helmet"));
        }
    }

    private class ItemMod
    extends BaseMod.ItemMod {
        ItemMod() {
            super(CustomItemTextures.this);
            MethodRef getIconIndex = new MethodRef(this.getDeobfClass(), "getIconIndex", "(LItemStack;)LIcon;");
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getIconIndex));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override item texture";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(176);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(43, this.push(0), this.reference(184, getCITIcon));
                }
            }.setInsertBefore(true).targetMethod(getIconIndex));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, getIconFromDamageForRenderPass));
        }
    }

    private class ConfigPanel
    extends ModConfigPanel {
        private JPanel panel;
        private JCheckBox itemsCheckBox;
        private JCheckBox enchantmentCheckBox;
        private JCheckBox armorCheckBox;

        private ConfigPanel() {
            this.$$$setupUI$$$();
        }

        @Override
        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public void load() {
            this.itemsCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Item Textures", "items", ConfigPanel.this.itemsCheckBox.isSelected());
                }
            });
            this.enchantmentCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Item Textures", "enchantments", ConfigPanel.this.enchantmentCheckBox.isSelected());
                }
            });
            this.armorCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Custom Item Textures", "armor", ConfigPanel.this.armorCheckBox.isSelected());
                }
            });
        }

        @Override
        public void save() {
            this.itemsCheckBox.setSelected(Config.getBoolean("Custom Item Textures", "items", true));
            this.enchantmentCheckBox.setSelected(Config.getBoolean("Custom Item Textures", "enchantments", true));
            this.armorCheckBox.setSelected(Config.getBoolean("Custom Item Textures", "armor", true));
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JPanel jPanel;
            this.panel = jPanel = new JPanel();
            jPanel.setLayout(new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.itemsCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setText("Items");
            jPanel.add((Component)jCheckBox3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Apply replacement textures to:");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.enchantmentCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("Item enchantments");
            jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.armorCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("Worn armor");
            jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

