/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mod;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BaseTexturePackMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.InterfaceMethodRef;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.ModConfigPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ConnectedTextures
extends Mod {
    private final MethodRef startCTM = new MethodRef("com.prupe.mcpatcher.ctm.CTMUtils", "start", "()V");
    private final MethodRef finishCTM = new MethodRef("com.prupe.mcpatcher.ctm.CTMUtils", "finish", "()V");

    public ConnectedTextures() {
        this.name = "Connected Textures";
        this.author = "MCPatcher";
        this.description = "Enables support for connected, randomized, and other custom terrain textures.";
        this.version = "2.4";
        this.addDependency("__TexturePackBase");
        this.addDependency("__TilesheetBase");
        this.configPanel = new ConfigPanel();
        this.addClassMod(new BaseMod.IBlockAccessMod(this));
        this.addClassMod(new BaseMod.TessellatorMod(this));
        this.addClassMod(new BaseMod.IconMod(this));
        this.addClassMod(new BaseMod.ResourceAddressMod(this));
        this.addClassMod(new BlockMod());
        this.addClassMod(new RenderBlocksMod());
        this.addClassMod(new WorldRendererMod());
        this.addClassFile("com.prupe.mcpatcher.ctm.CTMUtils");
        this.addClassFile("com.prupe.mcpatcher.ctm.CTMUtils$1");
        this.addClassFile("com.prupe.mcpatcher.ctm.CTMUtils$2");
        this.addClassFile("com.prupe.mcpatcher.ctm.CTMUtils$3");
        this.addClassFile("com.prupe.mcpatcher.ctm.CTMUtils$TileOverrideIterator");
        this.addClassFile("com.prupe.mcpatcher.ctm.ITileOverride");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverride");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl$CTM");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl$Random1");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl$Fixed");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl$Horizontal");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl$HorizontalVertical");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl$Vertical");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl$VerticalHorizontal");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl$Top");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl$Repeat");
        this.addClassFile("com.prupe.mcpatcher.ctm.TileOverrideImpl$BetterGrass");
        this.addClassFile("com.prupe.mcpatcher.ctm.GlassPaneRenderer");
        this.addClassFile("com.prupe.mcpatcher.ctm.RenderPassAPI");
        BaseTexturePackMod.earlyInitialize(2, "com.prupe.mcpatcher.ctm.CTMUtils", "reset");
    }

    private class WorldRendererMod
    extends Mod.ClassMod {
        WorldRendererMod() {
            super(ConnectedTextures.this);
            MethodRef updateRenderer = new MethodRef(this.getDeobfClass(), "updateRenderer", "()V");
            this.addClassSignature(new ClassMod.ConstSignature(this, new MethodRef("org.lwjgl.opengl.GL11", "glNewList", "(II)V")));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(1.000001f)));
                }
            }.setMethod(updateRenderer));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "pre render world";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, ConnectedTextures.this.startCTM)});
                }
            }.targetMethod(updateRenderer));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "post render world";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, ConnectedTextures.this.finishCTM)});
                }
            }.setInsertBefore(true).targetMethod(updateRenderer));
        }
    }

    private class RenderBlocksMod
    extends BaseMod.RenderBlocksMod {
        private final MethodRef[] faceMethods;
        private final FieldRef overrideBlockTexture;
        private final FieldRef blockAccess;
        private final FieldRef fancyGrass;
        private final FieldRef instance;
        private final MethodRef renderBlockByRenderType;
        private final MethodRef renderStandardBlock;
        private final MethodRef renderStandardBlockWithColorMultiplier;
        private final MethodRef hasOverrideTexture;
        private final MethodRef drawCrossedSquares;
        private final MethodRef renderBlockPane;
        private final MethodRef renderBlockBrewingStand;
        private final MethodRef addVertexWithUV;
        private final MethodRef setColorOpaque_F;
        private final MethodRef renderBlockAsItem;
        private final MethodRef renderBlockAsItemVanilla;
        private final MethodRef getIconBySideAndMetadata;
        private final MethodRef getIconBySide;
        private final InterfaceMethodRef getMinU;
        private final InterfaceMethodRef getMinV;
        private final InterfaceMethodRef getInterpolatedU;
        private final MethodRef getRenderType;
        private final MethodRef getTile;
        private final MethodRef getTileNoFace;
        private final MethodRef getTileBySideAndMetadata;
        private final MethodRef getTileBySide;
        private final MethodRef getTessellator;

        RenderBlocksMod() {
            super(ConnectedTextures.this);
            this.faceMethods = new MethodRef[6];
            this.overrideBlockTexture = new FieldRef(this.getDeobfClass(), "overrideBlockTexture", "LIcon;");
            this.blockAccess = new FieldRef(this.getDeobfClass(), "blockAccess", "LIBlockAccess;");
            this.fancyGrass = new FieldRef(this.getDeobfClass(), "fancyGrass", "Z");
            this.instance = new FieldRef("Tessellator", "instance", "LTessellator;");
            this.renderBlockByRenderType = new MethodRef(this.getDeobfClass(), "renderBlockByRenderType", "(LBlock;III)Z");
            this.renderStandardBlock = new MethodRef(this.getDeobfClass(), "renderStandardBlock", "(LBlock;III)Z");
            this.renderStandardBlockWithColorMultiplier = new MethodRef(this.getDeobfClass(), "renderStandardBlockWithColorMultiplier", "(LBlock;IIIFFF)Z");
            this.hasOverrideTexture = new MethodRef(this.getDeobfClass(), "hasOverrideTexture", "()Z");
            this.drawCrossedSquares = new MethodRef(this.getDeobfClass(), "drawCrossedSquares", "(LBlock;IDDDF)V");
            this.renderBlockPane = new MethodRef(this.getDeobfClass(), "renderBlockPane", "(LBlockPane;III)Z");
            this.renderBlockBrewingStand = new MethodRef(this.getDeobfClass(), "renderBlockBrewingStand", "(LBlockBrewingStand;III)Z");
            this.addVertexWithUV = new MethodRef("Tessellator", "addVertexWithUV", "(DDDDD)V");
            this.setColorOpaque_F = new MethodRef("Tessellator", "setColorOpaque_F", "(FFF)V");
            this.renderBlockAsItem = new MethodRef(this.getDeobfClass(), "renderBlockAsItem", "(LBlock;IF)V");
            this.renderBlockAsItemVanilla = new MethodRef(this.getDeobfClass(), "renderBlockAsItemVanilla", "(LBlock;IF)V");
            this.getIconBySideAndMetadata = new MethodRef(this.getDeobfClass(), "getIconBySideAndMetadata", "(LBlock;II)LIcon;");
            this.getIconBySide = new MethodRef(this.getDeobfClass(), "getIconBySide", "(LBlock;I)LIcon;");
            this.getMinU = new InterfaceMethodRef("Icon", "getMinU", "()F");
            this.getMinV = new InterfaceMethodRef("Icon", "getMinV", "()F");
            this.getInterpolatedU = new InterfaceMethodRef("Icon", "getInterpolatedU", "(D)F");
            this.getRenderType = new MethodRef("Block", "getRenderType", "()I");
            this.getTile = new MethodRef("com.prupe.mcpatcher.ctm.CTMUtils", "getTile", "(LRenderBlocks;LBlock;IIIILIcon;LTessellator;)LIcon;");
            this.getTileNoFace = new MethodRef("com.prupe.mcpatcher.ctm.CTMUtils", "getTile", "(LRenderBlocks;LBlock;IIILIcon;LTessellator;)LIcon;");
            this.getTileBySideAndMetadata = new MethodRef("com.prupe.mcpatcher.ctm.CTMUtils", "getTile", "(LRenderBlocks;LBlock;IILTessellator;)LIcon;");
            this.getTileBySide = new MethodRef("com.prupe.mcpatcher.ctm.CTMUtils", "getTile", "(LRenderBlocks;LBlock;ILTessellator;)LIcon;");
            this.getTessellator = new MethodRef("com.prupe.mcpatcher.TessellatorUtils", "getTessellator", "(LTessellator;LIcon;)LTessellator;");
            this.mapRenderTypeMethod(0, this.renderStandardBlock);
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.captureReference(180), BinaryRegex.or(BinaryRegex.build(198, BinaryRegex.any(2), this.push(1)), BinaryRegex.build(199, BinaryRegex.any(2), this.push(0))));
                }
            }.setMethod(this.hasOverrideTexture).addXref(1, this.overrideBlockTexture));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(43, BytecodeMatcher.captureReference(182), 54, 5);
                }
            }.setMethod(this.renderBlockByRenderType).addXref(1, this.getRenderType));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, this.overrideBlockTexture));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, this.blockAccess));
            this.setupFastGrass();
            this.setupStandardBlocks();
            this.setupNonStandardBlocks();
            this.setupGlassPanes();
            this.setupHeldBlocks();
        }

        private void mapRenderTypeMethod(final int type, MethodRef renderMethod) {
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(21, 5, type == 0 ? BinaryRegex.build(154) : BinaryRegex.build(this.push(type), 160), BinaryRegex.any(2), 42, 43, BinaryRegex.optional(BytecodeMatcher.anyReference(192)), 28, 29, 21, 4, BinaryRegex.capture(BinaryRegex.build(BinaryRegex.subset(new int[]{182, 183}, true), BinaryRegex.any(2))));
                }
            }.setMethod(this.renderBlockByRenderType).addXref(1, renderMethod));
        }

        private void setupFastGrass() {
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(Float.valueOf(0.5f)), BytecodeMatcher.anyFSTORE, this.push(Float.valueOf(1.0f)), BytecodeMatcher.anyFSTORE, this.push(Float.valueOf(0.8f)), BytecodeMatcher.anyFSTORE, this.push(Float.valueOf(0.6f)), BytecodeMatcher.anyFSTORE);
                }
            }.setMethod(this.renderStandardBlockWithColorMultiplier));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, this.fancyGrass).accessFlag(8, true));
            this.addPatch(new ClassMod.BytecodePatch(){
                private int face;

                @Override
                public String getDescription() {
                    return "apply color multiplier to side grass texture (non-AO, fast graphics)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(25, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.capture(BinaryRegex.any()), this.reference(182, RenderBlocksMod.this.setColorOpaque_F));
                }

                @Override
                public byte[] getReplacementBytes() {
                    if (this.face++ < 2) {
                        return null;
                    }
                    return this.buildCode(42, this.reference(180, RenderBlocksMod.this.blockAccess), 43, 28, 29, 21, 4, this.push(this.face - 1), this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.CTMUtils", "isBetterGrass", "(LIBlockAccess;LBlock;IIII)Z")), 153, this.branch("A"), 25, this.getCaptureGroup(1), 23, this.getCaptureGroup(2), 23, 5, 106, 23, this.getCaptureGroup(3), 23, 6, 106, 23, this.getCaptureGroup(4), 23, 7, 106, this.reference(182, RenderBlocksMod.this.setColorOpaque_F), 167, this.branch("B"), this.label("A"), this.getMatch(), this.label("B"));
                }
            }.targetMethod(this.renderStandardBlockWithColorMultiplier));
            if (Mod.getMinecraftVersion().compareTo("1.5.1") >= 0 && !Mod.getMinecraftVersion().getVersionString().matches("2\\.0_(blue|purple)")) {
                this.setupFastGrassPost151();
            } else {
                this.setupFastGrassPre151();
            }
        }

        private void setupFastGrassPre151() {
            this.addPatch(new ClassMod.BytecodePatch(){
                private final int[] faces;
                private boolean matched;
                {
                    this.faces = new int[6];
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(this.push(1), BinaryRegex.capture(BytecodeMatcher.anyISTORE), this.push(1), BinaryRegex.capture(BytecodeMatcher.anyISTORE), this.push(1), BinaryRegex.capture(BytecodeMatcher.anyISTORE), this.push(1), BinaryRegex.capture(BytecodeMatcher.anyISTORE), this.push(1), BinaryRegex.capture(BytecodeMatcher.anyISTORE), this.push(1), BinaryRegex.capture(BytecodeMatcher.anyISTORE));
                        }

                        @Override
                        public boolean afterMatch() {
                            for (int i = 0; i < faces.length; ++i) {
                                (this).faces[i] = BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(i + 1));
                            }
                            return true;
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "apply color multiplier to side grass texture (AO, fast graphics)";
                }

                @Override
                public String getMatchExpression() {
                    String istore = BinaryRegex.build(54, BinaryRegex.subset(this.faces, true));
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.repeat(BinaryRegex.build(this.push(0), istore), 5), BinaryRegex.build(this.push(0), BinaryRegex.repeat(BinaryRegex.build(89, istore), 4), istore)));
                }

                @Override
                public byte[] getReplacementBytes() {
                    if (this.matched) {
                        return null;
                    }
                    this.matched = true;
                    return this.buildCode(this.reference(178, RenderBlocksMod.this.fancyGrass), 153, this.branch("A"), this.getMatch(), 167, this.branch("B"), this.label("A"), this.getCodeForFace(5), this.getCodeForFace(4), this.getCodeForFace(3), this.getCodeForFace(2), this.push(0), 54, this.faces[0], this.label("B"));
                }

                private byte[] getCodeForFace(int face) {
                    return this.buildCode(42, this.reference(180, RenderBlocksMod.this.blockAccess), 43, 28, 29, 21, 4, this.push(face), this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.CTMUtils", "isBetterGrass", "(LIBlockAccess;LBlock;IIII)Z")), 54, this.faces[face]);
                }
            }.targetMethod(this.renderStandardBlockWithAmbientOcclusion));
        }

        private void setupFastGrassPost151() {
            this.addPatch(new ClassMod.BytecodePatch(){
                private int flagRegister;
                private int face;
                {
                    final MethodRef stringEquals = new MethodRef("java/lang/String", "equals", "(Ljava/lang/Object;)Z");
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(this.push("grass_top"), this.reference(182, stringEquals), BytecodeMatcher.IFEQ_or_IFNE, BinaryRegex.any(2), BinaryRegex.nonGreedy(BinaryRegex.any(0, 8)), this.push(0), BinaryRegex.capture(BytecodeMatcher.anyISTORE));
                        }

                        @Override
                        public boolean afterMatch() {
                            flagRegister = BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(1));
                            return true;
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "apply color multiplier to side grass texture (AO, fast graphics, post-1.5.1)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(21, this.flagRegister);
                }

                @Override
                public byte[] getReplacementBytes() {
                    switch (this.face) {
                        case 0: {
                            ++this.face;
                            return null;
                        }
                        case 1: {
                            ++this.face;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            break;
                        }
                        default: {
                            return null;
                        }
                    }
                    return this.buildCode(154, this.branch("A"), this.reference(178, RenderBlocksMod.this.fancyGrass), 154, this.branch("B"), 42, this.reference(180, RenderBlocksMod.this.blockAccess), 43, 28, 29, 21, 4, this.push(this.face++), this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.CTMUtils", "isBetterGrass", "(LIBlockAccess;LBlock;IIII)Z")), 167, this.branch("C"), this.label("A"), this.push(1), 167, this.branch("C"), this.label("B"), this.push(0), this.label("C"));
                }
            }.setInsertAfter(true).targetMethod(this.renderStandardBlockWithAmbientOcclusion));
        }

        private void setupStandardBlocks() {
            this.setupBlockFace(0, "Bottom", "Bottom");
            this.setupBlockFace(1, "Top", "Top");
            this.setupBlockFace(2, "North", "East");
            this.setupBlockFace(3, "South", "West");
            this.setupBlockFace(4, "West", "North");
            this.setupBlockFace(5, "East", "South");
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, this.faceMethods));
        }

        private void setupBlockFace(final int face, final String direction, String altDirection) {
            MethodRef altMethod = new MethodRef(this.getDeobfClass(), "RenderFull" + altDirection + "Face", "(LBlock;DDDLIcon;)V");
            this.faceMethods[face] = new MethodRef(this.getDeobfClass(), "render" + direction + "Face", "(LBlock;DDDLIcon;)V");
            this.addPatch(new RenderBlocksPatch(){

                @Override
                protected int getIconRegister() {
                    return 8;
                }

                @Override
                public String getMatchExpression() {
                    if (this.isAlternateMethod()) {
                        return this.buildExpression(this.reference(178, RenderBlocksMod.this.instance), BytecodeMatcher.anyASTORE);
                    }
                    return super.getMatchExpression();
                }

                @Override
                protected String getTextureType() {
                    return direction.toLowerCase() + " face";
                }

                @Override
                protected byte[] getCTMUtilsArgs() {
                    return this.buildCode(40, 142, 24, 4, 142, 24, 6, 142, this.push(face));
                }

                @Override
                protected MethodRef getCTMUtilsMethod() {
                    return RenderBlocksMod.this.getTile;
                }

                private boolean isAlternateMethod() {
                    return this.getMethodInfo().getName().startsWith("RenderFull");
                }
            }.targetMethod(this.faceMethods[face], altMethod));
        }

        private void setupNonStandardBlocks() {
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, this.drawCrossedSquares));
            this.mapRenderTypeMethod(25, this.renderBlockBrewingStand);
            this.addPatch(new RenderBlocksPatch(){
                {
                    this.setInsertBefore(true);
                    this.skipMethod(RenderBlocksMod.this.renderBlockPane);
                }

                @Override
                public boolean filterMethod() {
                    return this.getMethodInfo().getDescriptor().matches("\\(L[a-z]+;III.*[IVZ]");
                }

                @Override
                protected String getTextureType() {
                    return "other blocks";
                }

                @Override
                public String getMatchExpression() {
                    InterfaceMethodRef method = this.getMethodInfo().getDescriptor().equals(this.map(RenderBlocksMod.this.renderBlockBrewingStand).getType()) ? RenderBlocksMod.this.getMinV : RenderBlocksMod.this.getMinU;
                    return this.buildExpression(BinaryRegex.capture(BytecodeMatcher.anyALOAD), this.reference(185, method), 141, BytecodeMatcher.anyDSTORE);
                }

                @Override
                protected byte[] getCTMUtilsArgs() {
                    return this.buildCode(28, 29, 21, 4);
                }

                @Override
                protected MethodRef getCTMUtilsMethod() {
                    return RenderBlocksMod.this.getTileNoFace;
                }
            });
            this.addPatch(new RenderBlocksPatch(){

                @Override
                protected String getTextureType() {
                    return "crossed squares";
                }

                @Override
                protected byte[] getCTMUtilsArgs() {
                    return this.buildCode(41, 142, 24, 5, 142, 24, 7, 142);
                }

                @Override
                protected MethodRef getCTMUtilsMethod() {
                    return RenderBlocksMod.this.getTileNoFace;
                }
            }.targetMethod(this.drawCrossedSquares));
        }

        private void setupGlassPanes() {
            this.mapRenderTypeMethod(18, this.renderBlockPane);
            this.addPatch(new ClassMod.BytecodePatch(){
                private int iconRegister;
                {
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(25, BinaryRegex.capture(BinaryRegex.any()), this.reference(185, RenderBlocksMod.this.getMinU));
                        }

                        @Override
                        public boolean afterMatch() {
                            iconRegister = this.getCaptureGroup(1)[0] & 0xFF;
                            return true;
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "override texture (glass pane)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(43, 42, this.reference(180, RenderBlocksMod.this.blockAccess), 28, this.push(1), 96, 29, 21, 4, BytecodeMatcher.anyReference(185), BytecodeMatcher.anyReference(182), 54, BinaryRegex.capture(BinaryRegex.any()));
                }

                @Override
                public byte[] getReplacementBytes() {
                    int reg = this.getCaptureGroup(1)[0] & 0xFF;
                    Logger.log(5, "glass side connect flags (%d %d %d %d)", reg - 3, reg - 2, reg - 1, reg);
                    return this.buildCode(42, 43, 25, this.iconRegister, 28, 29, 21, 4, 21, reg - 3, 21, reg - 2, 21, reg - 1, 21, reg, this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.GlassPaneRenderer", "render", "(LRenderBlocks;LBlock;LIcon;IIIZZZZ)V")));
                }
            }.setInsertAfter(true).targetMethod(this.renderBlockPane));
            this.addPatch(new ClassMod.BytecodePatch(){
                private int[] sideUVRegisters;
                {
                    this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                        @Override
                        public String getMatchExpression() {
                            return this.buildExpression(25, BinaryRegex.any(), this.push(7.0), this.reference(185, RenderBlocksMod.this.getInterpolatedU), 141, 57, BinaryRegex.capture(BinaryRegex.any()));
                        }

                        @Override
                        public boolean afterMatch() {
                            int reg = this.getCaptureGroup(1)[0] & 0xFF;
                            12.access$2402(this, new int[]{reg, reg + 2, reg + 4, reg + 6, reg + 8});
                            Logger.log(3, "glass side texture uv registers (%d %d %d %d %d)", reg, reg + 2, reg + 4, reg + 6, reg + 8);
                            return true;
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "disable default rendering (glass pane faces)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.repeat(BinaryRegex.build(25, BinaryRegex.any(), BinaryRegex.nonGreedy(BinaryRegex.any(0, 15)), 24, BinaryRegex.subset(this.sideUVRegisters, false), 24, BinaryRegex.subset(this.sideUVRegisters, false), this.reference(182, RenderBlocksMod.this.addVertexWithUV)), 8));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, new FieldRef("com.prupe.mcpatcher.ctm.GlassPaneRenderer", "active", "Z")), 154, this.branch("A"), this.getMatch(), this.label("A"));
                }

                static /* synthetic */ int[] access$2402(12 x0, int[] x1) {
                    x0.sideUVRegisters = x1;
                    return x1;
                }
            }.targetMethod(this.renderBlockPane));
        }

        private void setupHeldBlocks() {
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, this.renderBlockAsItem));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, this.getIconBySideAndMetadata));
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, this.getIconBySide));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "setup held items (finish)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(177);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, ConnectedTextures.this.finishCTM)});
                }
            }.setInsertBefore(true).targetMethod(this.renderBlockAsItem, this.renderBlockAsItemVanilla));
            this.setupHeldBlocks(this.getIconBySide, this.getTileBySide, "held blocks");
            this.setupHeldBlocks(this.getIconBySideAndMetadata, this.getTileBySideAndMetadata, "held blocks with metadata");
        }

        private void setupHeldBlocks(final MethodRef from, final MethodRef to, final String name) {
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override texture (" + name + ")";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, from)});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(184, ConnectedTextures.this.startCTM), 25, 4, this.reference(184, to));
                }
            }.targetMethod(this.renderBlockAsItem, this.renderBlockAsItemVanilla));
        }

        private abstract class RenderBlocksPatch
        extends ClassMod.BytecodePatch {
            protected int tessellatorRegister;
            protected int iconRegister;

            private RenderBlocksPatch() {
                super(RenderBlocksMod.this);
                this.addPreMatchSignature(new ClassMod.BytecodeSignature(){

                    @Override
                    public String getMatchExpression() {
                        return this.buildExpression(this.reference(178, RenderBlocksMod.this.instance), BinaryRegex.capture(BytecodeMatcher.anyASTORE));
                    }

                    @Override
                    public boolean afterMatch() {
                        RenderBlocksPatch.this.tessellatorRegister = BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(1));
                        return true;
                    }
                });
                this.setInsertAfter(true);
            }

            @Override
            public String getDescription() {
                return "override texture (" + this.getTextureType() + ")";
            }

            @Override
            public String getMatchExpression() {
                return this.buildExpression(42, BinaryRegex.or(BinaryRegex.build(this.reference(182, RenderBlocksMod.this.hasOverrideTexture), 153, BinaryRegex.any(2)), BinaryRegex.build(this.reference(180, RenderBlocksMod.this.overrideBlockTexture), 198, BinaryRegex.any(2))), 42, this.reference(180, RenderBlocksMod.this.overrideBlockTexture), BinaryRegex.capture(BytecodeMatcher.anyASTORE));
            }

            @Override
            public byte[] getReplacementBytes() {
                this.iconRegister = this.getIconRegister();
                byte[] returnCode = this.getMethodInfo().getDescriptor().endsWith("V") ? new byte[]{-79} : new byte[]{3, -84};
                return this.buildCode(42, 43, this.getCTMUtilsArgs(), BytecodeMatcher.registerLoadStore(25, this.iconRegister), BytecodeMatcher.registerLoadStore(25, this.tessellatorRegister), this.reference(184, this.getCTMUtilsMethod()), BytecodeMatcher.registerLoadStore(58, this.iconRegister), BytecodeMatcher.registerLoadStore(25, this.iconRegister), 199, this.branch("A"), returnCode, this.label("A"), BytecodeMatcher.registerLoadStore(25, this.tessellatorRegister), BytecodeMatcher.registerLoadStore(25, this.iconRegister), this.reference(184, RenderBlocksMod.this.getTessellator), BytecodeMatcher.registerLoadStore(58, this.tessellatorRegister));
            }

            protected int getIconRegister() {
                return BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(1));
            }

            protected abstract String getTextureType();

            protected abstract byte[] getCTMUtilsArgs();

            protected abstract MethodRef getCTMUtilsMethod();
        }
    }

    private class BlockMod
    extends BaseMod.BlockMod {
        BlockMod() {
            super(ConnectedTextures.this);
            FieldRef blockMaterial = new FieldRef(this.getDeobfClass(), "blockMaterial", "LMaterial;");
            MethodRef getBlockIcon = new MethodRef(this.getDeobfClass(), "getBlockIcon", "(LIBlockAccess;IIII)LIcon;");
            InterfaceMethodRef getBlockMetadata = new InterfaceMethodRef("IBlockAccess", "getBlockMetadata", "(III)I");
            MethodRef getBlockIconFromSideAndMetadata = new MethodRef(this.getDeobfClass(), "getBlockIconFromSideAndMetadata", "(II)LIcon;");
            MethodRef getShortName = new MethodRef(this.getDeobfClass(), "getShortName", "()Ljava/lang/String;");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 21, 5, 43, 28, 29, 21, 4, BytecodeMatcher.captureReference(185), BytecodeMatcher.captureReference(182), 176, BinaryRegex.end());
                }
            }.setMethod(getBlockIcon).addXref(1, getBlockMetadata).addXref(2, getBlockIconFromSideAndMetadata));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(" is already occupied by "));
                }
            }.matchConstructorOnly(true).setMethod(new MethodRef(this.getDeobfClass(), "<init>", "(ILMaterial;)V")));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push("tile."));
                }
            }.setMethod(getShortName));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, blockMaterial).accessFlag(1, true));
            this.addPatch(new ClassMod.MakeMemberPublicPatch(this, getShortName));
        }
    }

    private class ConfigPanel
    extends ModConfigPanel {
        private JPanel panel;
        private JCheckBox glassPaneCheckBox;
        private JCheckBox grassCheckBox;
        private JCheckBox standardCheckBox;
        private JCheckBox nonStandardCheckBox;
        private JCheckBox debugCheckBox;
        private JComboBox splitComboBox;

        public ConfigPanel() {
            this.$$$setupUI$$$();
            this.standardCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Connected Textures", "standard", ConfigPanel.this.standardCheckBox.isSelected());
                }
            });
            this.nonStandardCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Connected Textures", "nonStandard", ConfigPanel.this.nonStandardCheckBox.isSelected());
                }
            });
            this.glassPaneCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Connected Textures", "glassPane", ConfigPanel.this.glassPaneCheckBox.isSelected());
                }
            });
            this.grassCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Connected Textures", "grass", ConfigPanel.this.grassCheckBox.isSelected());
                }
            });
            this.debugCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Connected Textures", "debugTextures", ConfigPanel.this.debugCheckBox.isSelected());
                }
            });
            this.splitComboBox.addItem("Never");
            this.splitComboBox.addItem("As needed");
            this.splitComboBox.addItem("Always");
            this.splitComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Connected Textures", "splitTextures", ConfigPanel.this.splitComboBox.getSelectedIndex());
                }
            });
        }

        @Override
        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public void load() {
            this.standardCheckBox.setSelected(Config.getBoolean("Connected Textures", "standard", true));
            this.nonStandardCheckBox.setSelected(Config.getBoolean("Connected Textures", "nonStandard", true));
            this.glassPaneCheckBox.setSelected(Config.getBoolean("Connected Textures", "glassPane", true));
            this.grassCheckBox.setSelected(Config.getBoolean("Connected Textures", "grass", false));
            this.debugCheckBox.setSelected(Config.getBoolean("Connected Textures", "debugTextures", false));
            this.showAdvancedOption(this.debugCheckBox);
            switch (Config.getInt("Connected Textures", "splitTextures", 1)) {
                case 0: {
                    this.splitComboBox.setSelectedIndex(0);
                    break;
                }
                default: {
                    this.splitComboBox.setSelectedIndex(1);
                    break;
                }
                case 2: {
                    this.splitComboBox.setSelectedIndex(2);
                }
            }
        }

        @Override
        public void save() {
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JComboBox jComboBox;
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JCheckBox jCheckBox3;
            JCheckBox jCheckBox4;
            JCheckBox jCheckBox5;
            JPanel jPanel;
            this.panel = jPanel = new JPanel();
            jPanel.setLayout(new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.glassPaneCheckBox = jCheckBox5 = new JCheckBox();
            jCheckBox5.setText("Glass panes");
            jPanel.add((Component)jCheckBox5, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Apply replacement textures to:");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.standardCheckBox = jCheckBox4 = new JCheckBox();
            jCheckBox4.setToolTipText("Standard 6-sixed blocks");
            jCheckBox4.setText("Standard blocks");
            jPanel.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.nonStandardCheckBox = jCheckBox3 = new JCheckBox();
            jCheckBox3.setToolTipText("Covers most other block types (flowers, grass, etc.)");
            jCheckBox3.setText("Non-standard blocks");
            jPanel.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.grassCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("Grass block sides (Better Grass)");
            jPanel.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.debugCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setToolTipText("Show name of texture being rendered");
            jCheckBox.setText("Show CTM texture names");
            jPanel.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(6, 0, 1, 1, 0, 3, 3, 3, null, null, null));
            JLabel jLabel2 = new JLabel();
            jLabel2.setText("Create multiple tilesheets");
            jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.splitComboBox = jComboBox = new JComboBox();
            jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

