/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mod;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassRef;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.InterfaceMethodRef;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.ModConfigPanel;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BetterSkies
extends Mod {
    public BetterSkies() {
        this.name = "Better Skies";
        this.author = "MCPatcher";
        this.description = "Adds support for custom skyboxes.";
        this.version = "1.5";
        this.configPanel = new ConfigPanel();
        this.addDependency("__TexturePackBase");
        this.addClassMod(new BaseMod.MinecraftMod(this).mapWorldClient());
        this.addClassMod(new BaseMod.ResourceAddressMod(this));
        this.addClassMod(new WorldMod());
        this.addClassMod(new BaseMod.WorldClientMod(this));
        this.addClassMod(new RenderGlobalMod());
        this.addClassMod(new EffectRendererMod());
        this.addClassMod(new EntityFireworkSparkFXMod());
        this.addClassMod(new EntityFireworkOverlayFXMod());
        this.addClassFile("com.prupe.mcpatcher.sky.SkyRenderer");
        this.addClassFile("com.prupe.mcpatcher.sky.SkyRenderer$1");
        this.addClassFile("com.prupe.mcpatcher.sky.SkyRenderer$WorldEntry");
        this.addClassFile("com.prupe.mcpatcher.sky.SkyRenderer$Layer");
        this.addClassFile("com.prupe.mcpatcher.sky.FireworksHelper");
    }

    private class EntityFireworkOverlayFXMod
    extends Mod.ClassMod {
        EntityFireworkOverlayFXMod() {
            super(BetterSkies.this);
            this.setParentClass("EntityFX");
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(7.1f)));
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.6f)));
        }
    }

    private class EntityFireworkSparkFXMod
    extends Mod.ClassMod {
        EntityFireworkSparkFXMod() {
            super(BetterSkies.this);
            this.setParentClass("EntityFX");
            this.addClassSignature(new ClassMod.ConstSignature(this, Float.valueOf(0.75f)));
            this.addClassSignature(new ClassMod.ConstSignature(this, 0.91f));
        }
    }

    private class EffectRendererMod
    extends Mod.ClassMod {
        private static final int ORIG_LAYERS = 4;
        private static final int EXTRA_LAYERS = 1;
        private int layerRegister;

        EffectRendererMod() {
            super(BetterSkies.this);
            final ClassRef list = new ClassRef("java/util/List");
            final FieldRef fxLayers = new FieldRef(this.getDeobfClass(), "fxLayers", "[Ljava/util/List;");
            MethodRef renderParticles = new MethodRef(this.getDeobfClass(), "renderParticles", "(LEntity;F)V");
            MethodRef addEffect = new MethodRef(this.getDeobfClass(), "addEffect", "(LEntityFX;)V");
            final MethodRef getFXLayer = new MethodRef("EntityFX", "getFXLayer", "()I");
            final MethodRef glBlendFunc = new MethodRef("org.lwjgl.opengl.GL11", "glBlendFunc", "(II)V");
            final MethodRef glAlphaFunc = new MethodRef("org/lwjgl/opengl/GL11", "glAlphaFunc", "(IF)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/particle/particles.png"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(4), this.reference(189, list), BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, fxLayers));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(516), this.push(Float.valueOf(0.003921569f)), this.reference(184, glAlphaFunc));
                }
            }.setMethod(renderParticles));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 43, BytecodeMatcher.captureReference(182), 61);
                }
            }.setMethod(addEffect).addXref(1, getFXLayer));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return String.format("increase fx layers from %d to %d", 4, 5);
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(this.push(4)), BinaryRegex.build(this.push(3))), BinaryRegex.lookAhead(BinaryRegex.or(BinaryRegex.build(new Object[]{this.reference(189, list)}), BinaryRegex.build(BytecodeMatcher.IF_ICMPLT_or_IF_ICMPGE, BinaryRegex.any(2))), true));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(5));
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override entity fx layer";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, getFXLayer)});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.sky.FireworksHelper", "getFXLayer", "(LEntityFX;)I"))});
                }
            }.targetMethod(addEffect));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "render extra fx layers";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, fxLayers), 21, BinaryRegex.capture(BinaryRegex.any()), 50, this.reference(185, new InterfaceMethodRef("java/util/List", "isEmpty", "()Z")));
                }

                @Override
                public byte[] getReplacementBytes() {
                    EffectRendererMod.this.layerRegister = this.getCaptureGroup(1)[0] & 0xFF;
                    return this.buildCode(21, EffectRendererMod.this.layerRegister, this.reference(184, new MethodRef("com.prupe.mcpatcher.sky.FireworksHelper", "skipThisLayer", "(ZI)Z")));
                }
            }.setInsertAfter(true).targetMethod(renderParticles));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override particle blending method";
                }

                @Override
                public String getMatchExpression() {
                    if (EffectRendererMod.this.layerRegister > 0) {
                        return this.buildExpression(this.push(770), this.push(771), this.reference(184, glBlendFunc));
                    }
                    return null;
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(21, EffectRendererMod.this.layerRegister, this.reference(184, new MethodRef("com.prupe.mcpatcher.sky.FireworksHelper", "setParticleBlendMethod", "(I)V")));
                }
            }.targetMethod(renderParticles));
        }
    }

    private class RenderGlobalMod
    extends Mod.ClassMod {
        private final MethodRef renderSky;

        RenderGlobalMod() {
            super(BetterSkies.this);
            this.renderSky = new MethodRef(this.getDeobfClass(), "renderSky", "(F)V");
            final MethodRef getCelestialAngle = new MethodRef("WorldClient", "getCelestialAngle", "(F)F");
            MethodRef getRainStrength = new MethodRef("World", "getRainStrength", "(F)F");
            MethodRef startDrawingQuads = new MethodRef("Tessellator", "startDrawingQuads", "()V");
            MethodRef setColorOpaque_I = new MethodRef("Tessellator", "setColorOpaque_I", "(I)V");
            MethodRef addVertexWithUV = new MethodRef("Tessellator", "addVertexWithUV", "(DDDDD)V");
            MethodRef draw = new MethodRef("Tessellator", "draw", "()I");
            final MethodRef glRotatef = new MethodRef("org.lwjgl.opengl.GL11", "glRotatef", "(FFFF)V");
            final MethodRef glCallList = new MethodRef("org.lwjgl.opengl.GL11", "glCallList", "(I)V");
            FieldRef tessellator = new FieldRef("Tessellator", "instance", "LTessellator;");
            FieldRef mc = new FieldRef(this.getDeobfClass(), "mc", "LMinecraft;");
            FieldRef worldProvider = new FieldRef("World", "worldProvider", "LWorldProvider;");
            FieldRef worldType = new FieldRef("WorldProvider", "worldType", "I");
            final FieldRef worldObj = new FieldRef(this.getDeobfClass(), "worldObj", "LWorldClient;");
            FieldRef glSkyList = new FieldRef(this.getDeobfClass(), "glSkyList", "I");
            FieldRef glSkyList2 = new FieldRef(this.getDeobfClass(), "glSkyList2", "I");
            final FieldRef glStarList = new FieldRef(this.getDeobfClass(), "glStarList", "I");
            final FieldRef active = new FieldRef("com.prupe.mcpatcher.sky.SkyRenderer", "active", "Z");
            this.addClassSignature(new ClassMod.ConstSignature(this, "smoke"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/environment/clouds.png"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), BinaryRegex.any(3), BytecodeMatcher.captureReference(180), BytecodeMatcher.captureReference(180), 4, BinaryRegex.any(0, 100), BytecodeMatcher.captureReference(178), BytecodeMatcher.anyASTORE, BinaryRegex.any(0, 1000), this.push(Float.valueOf(1.0f)), 42, BytecodeMatcher.captureReference(180), 35, BytecodeMatcher.captureReference(182), 102, BinaryRegex.or(BinaryRegex.build(BytecodeMatcher.anyFSTORE), BinaryRegex.build(141, BytecodeMatcher.anyDSTORE)), BinaryRegex.any(0, 500), 42, BinaryRegex.backReference(5), 35, BytecodeMatcher.captureReference(182), this.push(Float.valueOf(360.0f)), 106, this.push(Float.valueOf(1.0f)), this.push(Float.valueOf(0.0f)), this.push(Float.valueOf(0.0f)), this.reference(184, glRotatef));
                }
            }.setMethod(this.renderSky).addXref(1, mc).addXref(2, worldProvider).addXref(3, worldType).addXref(4, tessellator).addXref(5, worldObj).addXref(6, getRainStrength).addXref(7, getCelestialAngle));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), this.reference(184, glCallList), BinaryRegex.nonGreedy(BinaryRegex.any(0, 1000)), 42, BytecodeMatcher.captureReference(180), this.reference(184, glCallList), BinaryRegex.nonGreedy(BinaryRegex.any(0, 1000)), 42, BytecodeMatcher.captureReference(180), this.reference(184, glCallList));
                }
            }.setMethod(this.renderSky).addXref(1, glSkyList).addXref(2, glStarList).addXref(3, glSkyList2));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(44, BytecodeMatcher.captureReference(182), 44, BytecodeMatcher.anyLDC, BytecodeMatcher.captureReference(182), 44, this.push(-100.0), this.push(-100.0), this.push(-100.0), this.push(0.0), this.push(0.0), BytecodeMatcher.captureReference(182), 44, this.push(-100.0), this.push(-100.0), this.push(100.0), this.push(0.0), this.push(16.0), BinaryRegex.backReference(3), 44, this.push(100.0), this.push(-100.0), this.push(100.0), this.push(16.0), this.push(16.0), BinaryRegex.backReference(3), 44, this.push(100.0), this.push(-100.0), this.push(-100.0), this.push(16.0), this.push(0.0), BinaryRegex.backReference(3), 44, BytecodeMatcher.captureReference(182), 87);
                }
            }.addXref(1, startDrawingQuads).addXref(2, setColorOpaque_I).addXref(3, addVertexWithUV).addXref(4, draw));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "setup for sky rendering";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin());
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, worldObj), 35, 42, this.reference(180, worldObj), 35, this.reference(182, getCelestialAngle), this.reference(184, new MethodRef("com.prupe.mcpatcher.sky.SkyRenderer", "setup", "(LWorld;FF)V")));
                }
            }.targetMethod(this.renderSky));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "render custom sky";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, worldObj), 35, this.reference(182, getCelestialAngle), this.push(Float.valueOf(360.0f)), 106, this.push(Float.valueOf(1.0f)), this.push(Float.valueOf(0.0f)), this.push(Float.valueOf(0.0f)), this.reference(184, glRotatef));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.sky.SkyRenderer", "renderAll", "()V"))});
                }
            }.setInsertBefore(true).targetMethod(this.renderSky));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "disable default stars";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(23, BinaryRegex.capture(BinaryRegex.any()), 23, BinaryRegex.backReference(1), 23, BinaryRegex.backReference(1), 23, BinaryRegex.backReference(1), this.reference(184, new MethodRef("org.lwjgl.opengl.GL11", "glColor4f", "(FFFF)V")), 42, this.reference(180, glStarList), this.reference(184, glCallList));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.reference(178, active), 154, this.branch("A"), this.getMatch(), this.label("A"));
                }
            }.targetMethod(this.renderSky));
            this.addCelestialObjectPatch("sun", "sun.png");
            this.addCelestialObjectPatch("moon", "moon_phases.png");
        }

        private void addCelestialObjectPatch(final String objName, String textureName) {
            final FieldRef textureField = new FieldRef(this.getDeobfClass(), objName, "LResourceAddress;");
            this.addClassSignature(new BaseMod.ResourceAddressSignature(this, textureField, "textures/environment/" + textureName));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override " + objName + " texture";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(178, textureField)});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.sky.SkyRenderer", "setupCelestialObject", "(LResourceAddress;)LResourceAddress;"))});
                }
            }.setInsertAfter(true).targetMethod(this.renderSky));
        }
    }

    private class WorldMod
    extends BaseMod.WorldMod {
        WorldMod() {
            super(BetterSkies.this);
            MethodRef getWorldTime = new MethodRef(this.getDeobfClass(), "getWorldTime", "()J");
            this.addMemberMapper(new ClassMod.MethodMapper((ClassMod)this, null, null, getWorldTime));
        }
    }

    private static class ConfigPanel
    extends ModConfigPanel {
        private JPanel panel;
        private JCheckBox skyCheckBox;
        private JCheckBox fireworksCheckBox;

        ConfigPanel() {
            this.$$$setupUI$$$();
            this.skyCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Better Skies", "skybox", ConfigPanel.this.skyCheckBox.isSelected());
                }
            });
            this.fireworksCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.set("Better Skies", "brightenFireworks", ConfigPanel.this.fireworksCheckBox.isSelected());
                }
            });
        }

        @Override
        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public void load() {
            this.skyCheckBox.setSelected(Config.getBoolean("Better Skies", "skybox", true));
            this.fireworksCheckBox.setSelected(Config.getBoolean("Better Skies", "brightenFireworks", true));
        }

        @Override
        public void save() {
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JPanel jPanel;
            this.panel = jPanel = new JPanel();
            jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.fireworksCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setText("Brighten fireworks particles");
            jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.skyCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("Enable custom skyboxes");
            jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

