/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.mod;

import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;

public class BetterGlass
extends Mod {
    private static final int EXTRA_PASSES = 2;
    private static final MethodRef glEnable = new MethodRef("org.lwjgl.opengl.GL11", "glEnable", "(I)V");
    private static final MethodRef glDisable = new MethodRef("org.lwjgl.opengl.GL11", "glDisable", "(I)V");
    private static final MethodRef glDepthMask = new MethodRef("org.lwjgl.opengl.GL11", "glDepthMask", "(Z)V");
    private static final MethodRef glShadeModel = new MethodRef("org.lwjgl.opengl.GL11", "glShadeModel", "(I)V");
    private static final MethodRef glCallList = new MethodRef("org.lwjgl.opengl.GL11", "glCallList", "(I)V");
    private static final MethodRef glAlphaFunc = new MethodRef("org.lwjgl.opengl.GL11", "glAlphaFunc", "(IF)V");
    private static final MethodRef getRenderBlockPass = new MethodRef("Block", "getRenderBlockPass", "()I");
    private static final MethodRef enableLightmap = new MethodRef("EntityRenderer", "enableLightmap", "(D)V");
    private static final MethodRef disableLightmap = new MethodRef("EntityRenderer", "disableLightmap", "(D)V");

    public BetterGlass() {
        this.name = "Better Glass";
        this.author = "MCPatcher";
        this.description = "Enables partial transparency for glass blocks.";
        this.version = "2.2";
        this.addDependency("__TexturePackBase");
        this.addDependency("Connected Textures");
        this.addClassMod(new BaseMod.MinecraftMod(this));
        this.addClassMod(new BaseMod.ResourceAddressMod(this));
        this.addClassMod(new BaseMod.BlockMod(this));
        this.addClassMod(new BaseMod.IBlockAccessMod(this));
        this.addClassMod(new WorldRendererMod());
        this.addClassMod(new EntityRendererMod());
        this.addClassMod(new RenderGlobalMod());
        this.addClassMod(new RenderBlocksMod());
        this.addClassFile("com.prupe.mcpatcher.ctm.RenderPass");
        this.addClassFile("com.prupe.mcpatcher.ctm.RenderPass$1");
        this.addClassFile("com.prupe.mcpatcher.ctm.RenderPass$2");
    }

    private class RenderBlocksMod
    extends BaseMod.RenderBlocksMod {
        RenderBlocksMod() {
            super(BetterGlass.this);
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "override AO block brightness for extra render passes";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(this.push(Float.valueOf(0.5f))), BinaryRegex.build(this.push(Float.valueOf(0.6f))), BinaryRegex.build(this.push(Float.valueOf(0.8f)))));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.RenderPass", "getAOBaseMultiplier", "(F)F"))});
                }
            }.setInsertAfter(true).targetMethod(this.renderStandardBlockWithAmbientOcclusion));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "render all sides of adjacent blocks";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, RenderBlocksMod.this.shouldSideBeRendered)});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.RenderPass", "shouldSideBeRendered", "(LBlock;LIBlockAccess;IIII)Z"))});
                }
            });
        }
    }

    private class RenderGlobalMod
    extends Mod.ClassMod {
        RenderGlobalMod() {
            super(BetterGlass.this);
            FieldRef glRenderListBase = new FieldRef(this.getDeobfClass(), "glRenderListBase", "I");
            MethodRef loadRenderers = new MethodRef(this.getDeobfClass(), "loadRenderers", "()V");
            MethodRef renderAllRenderLists = new MethodRef(this.getDeobfClass(), "renderAllRenderLists", "(ID)V");
            final MethodRef generateDisplayLists = new MethodRef("GLAllocation", "generateDisplayLists", "(I)I");
            this.addClassSignature(new ClassMod.ConstSignature(this, "smoke"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/environment/clouds.png"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(3), 104, BytecodeMatcher.captureReference(184), BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, generateDisplayLists).addXref(2, glRenderListBase));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyILOAD, this.push(16), 108, this.push(1), 96);
                }
            }.setMethod(loadRenderers));
            this.addClassSignature(new ClassMod.OrSignature(this, new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.anyReference(180), 58, BinaryRegex.capture(BinaryRegex.any()), 25, BinaryRegex.backReference(1), 190, BinaryRegex.build(54, BinaryRegex.any()));
                }
            }.setMethod(renderAllRenderLists), new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(0), 54, BinaryRegex.capture(BinaryRegex.any()), 21, BinaryRegex.backReference(1), 42, BytecodeMatcher.captureReference(180), 190, BytecodeMatcher.IF_ICMPGE_or_IF_ICMPLT, BinaryRegex.any(2), 42, BinaryRegex.backReference(2), 21, BinaryRegex.backReference(1), 50);
                }
            }.setMethod(renderAllRenderLists)));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "increase gl render lists per chunk from 3 to 5 (init)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(3), BinaryRegex.lookAhead(BinaryRegex.build(104, this.reference(184, generateDisplayLists)), true));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(this.push(5));
                }
            }.matchConstructorOnly(true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "increase gl render lists per chunk from 3 to 5 (loop)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(132, BinaryRegex.capture(BinaryRegex.any()), 3);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(132, this.getCaptureGroup(1), 5);
                }
            }.targetMethod(loadRenderers));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "set up lightmap for extra render passes";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.lookBehind(BinaryRegex.build(42, BytecodeMatcher.anyReference(180), BytecodeMatcher.anyReference(180), 40), true), this.reference(182, enableLightmap));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(27, this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.RenderPass", "enableDisableLightmap", "(LEntityRenderer;DI)V")));
                }
            }.targetMethod(renderAllRenderLists));
        }
    }

    private class EntityRendererMod
    extends Mod.ClassMod {
        EntityRendererMod() {
            super(BetterGlass.this);
            MethodRef renderWorld = new MethodRef(this.getDeobfClass(), "renderWorld", "(FJ)V");
            final MethodRef renderRainSnow = new MethodRef(this.getDeobfClass(), "renderRainSnow", "(F)V");
            final MethodRef sortAndRender = new MethodRef("RenderGlobal", "sortAndRender", "(LEntityLiving;ID)I");
            final MethodRef doRenderPass = new MethodRef("com.prupe.mcpatcher.ctm.RenderPass", "doRenderPass", "(LRenderGlobal;LEntityLiving;ID)V");
            this.addClassSignature(new ClassMod.ConstSignature(this, "textures/environment/snow.png"));
            this.addClassSignature(new ClassMod.ConstSignature(this, "ambient.weather.rain"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(25, 5, 25, 4, this.push(1), 35, 141, BytecodeMatcher.captureReference(182), 54, BinaryRegex.any());
                }
            }.setMethod(renderWorld).addXref(1, sortAndRender));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(3553), this.reference(184, glDisable));
                }
            }.setMethod(disableLightmap));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(3553), this.reference(184, glEnable));
                }
            }.setMethod(enableLightmap));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(516), this.push(Float.valueOf(0.01f)), this.reference(184, glAlphaFunc));
                }
            }.setMethod(renderRainSnow));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "set gl shade model";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(153, BinaryRegex.any(2), this.push(7425), this.reference(184, glShadeModel));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.RenderPass", "setAmbientOcclusion", "(Z)Z"))});
                }
            }.setInsertBefore(true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "do extra render pass 2";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(25, 5, 25, 4, this.push(0), 35, 141, this.reference(182, sortAndRender), 87);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(25, 5, 25, 4, this.push(2), 35, 141, this.reference(184, doRenderPass));
                }
            }.setInsertAfter(true));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "do extra render pass 3";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(1), this.reference(184, glDepthMask), this.push(2884), this.reference(184, glEnable), this.push(3042), this.reference(184, glDisable));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, 35, this.reference(182, renderRainSnow), 25, 5, 25, 4, this.push(3), 35, 141, this.reference(184, doRenderPass));
                }
            }.setInsertBefore(true).targetMethod(renderWorld));
        }
    }

    private class WorldRendererMod
    extends Mod.ClassMod {
        private int loopRegister;

        WorldRendererMod() {
            super(BetterGlass.this);
            MethodRef updateRenderer = new MethodRef(this.getDeobfClass(), "updateRenderer", "()V");
            final FieldRef glRenderList = new FieldRef(this.getDeobfClass(), "glRenderList", "I");
            final FieldRef skipRenderPass = new FieldRef(this.getDeobfClass(), "skipRenderPass", "[Z");
            final MethodRef startPass = new MethodRef("com.prupe.mcpatcher.ctm.RenderPass", "start", "(I)V");
            final MethodRef canRenderInPass1 = new MethodRef("forge/ForgeHooksClient", "canRenderInPass", "(LBlock;I)Z");
            final MethodRef canRenderInPass2 = new MethodRef("Block", "canRenderInPass", "(I)Z");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.anyALOAD, BytecodeMatcher.captureReference(182), 54, BinaryRegex.capture(BinaryRegex.any()), BinaryRegex.any(0, 30), 21, BinaryRegex.backReference(2), 21, BinaryRegex.any(), 159, BinaryRegex.any(2), this.push(1), 54, BinaryRegex.any());
                }
            }.setMethod(updateRenderer).addXref(1, getRenderBlockPass));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), this.push(2), 96, this.reference(184, glCallList));
                }
            }.addXref(1, glRenderList));
            this.addMemberMapper(new ClassMod.FieldMapper((ClassMod)this, skipRenderPass));
            this.addPatch(new RenderPassPatch("init"){

                @Override
                protected String getPrefix() {
                    return this.buildExpression(42);
                }

                @Override
                protected String getSuffix() {
                    return this.buildExpression(188, 4, this.reference(181, skipRenderPass));
                }
            }.matchConstructorOnly(true));
            this.addPatch(new RenderPassPatch("loop"){

                @Override
                protected String getPrefix() {
                    return this.buildExpression(BytecodeMatcher.anyILOAD);
                }

                @Override
                protected String getSuffix() {
                    return this.buildExpression(BytecodeMatcher.IF_ICMPLT_or_IF_ICMPGE, BinaryRegex.any(2));
                }
            });
            this.addPatch(new RenderPassPatch("occlusion"){

                @Override
                protected String getPrefix() {
                    return this.buildExpression(42, this.reference(180, glRenderList));
                }

                @Override
                protected String getSuffix() {
                    return this.buildExpression(96);
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "pre render pass";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(0), 54, BinaryRegex.capture(BinaryRegex.any()), this.push(0), 54, BinaryRegex.any(), this.push(0), 54, BinaryRegex.any());
                }

                @Override
                public byte[] getReplacementBytes() {
                    WorldRendererMod.this.loopRegister = (this.getCaptureGroup(1)[0] & 0xFF) - 1;
                    Logger.log(3, "loop register %d", WorldRendererMod.this.loopRegister);
                    return this.buildCode(21, WorldRendererMod.this.loopRegister, this.reference(184, startPass));
                }
            }.setInsertAfter(true).targetMethod(updateRenderer));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "prevent early loop exit";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(21, WorldRendererMod.this.loopRegister + 1, 154, BinaryRegex.any(2), 167, BinaryRegex.any(2));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[0]);
                }
            }.targetMethod(updateRenderer));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "increase render passes from 2 to 4 (&&)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.reference(180, skipRenderPass), this.push(0), 51, 153, BinaryRegex.any(2), 42, this.reference(180, skipRenderPass), this.push(1), 51, 153, BinaryRegex.any(2), this.push(1), BinaryRegex.or(BinaryRegex.build(172), BinaryRegex.build(167, BinaryRegex.any(2))), this.push(0), 172);
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(42, this.reference(180, skipRenderPass), this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.RenderPass", "skipAllRenderPasses", "([Z)Z")), 172);
                }
            });
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "set up extra render pass";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(182, getRenderBlockPass)});
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(new Object[]{this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.RenderPass", "getBlockRenderPass", "(LBlock;)I"))});
                }
            }.targetMethod(updateRenderer));
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "set up extra render pass (forge)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.or(BinaryRegex.build(new Object[]{this.reference(184, canRenderInPass1)}), BinaryRegex.build(new Object[]{this.reference(182, canRenderInPass2)})));
                }

                @Override
                public byte[] getReplacementBytes() {
                    return this.buildCode(92, this.getMatch(), this.reference(184, new MethodRef("com.prupe.mcpatcher.ctm.RenderPass", "canRenderInPass", "(LBlock;IZ)Z")));
                }
            }.targetMethod(updateRenderer));
        }

        private abstract class RenderPassPatch
        extends ClassMod.BytecodePatch {
            private final String tag;

            RenderPassPatch(String tag) {
                super(WorldRendererMod.this);
                this.tag = tag;
            }

            @Override
            public String getDescription() {
                return "increase render passes from 2 to 4 (" + this.tag + ")";
            }

            @Override
            public final String getMatchExpression() {
                return this.buildExpression(BinaryRegex.lookBehind(this.getPrefix(), true), this.push(2), BinaryRegex.lookAhead(this.getSuffix(), true));
            }

            @Override
            public final byte[] getReplacementBytes() {
                return this.buildCode(this.push(4));
            }

            protected abstract String getPrefix();

            protected abstract String getSuffix();
        }
    }
}

