/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.TexturePackChangeHandler;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.src.FontRenderer;
import net.minecraft.src.ResourceAddress;

public class FontUtils {
    private static final MCLogger logger = MCLogger.getLogger("HD Font");
    public static final boolean enable = Config.getBoolean("Extended HD", "hdFont", true);
    private static final int ROWS = 16;
    private static final int COLS = 16;
    public static final char[] AVERAGE_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123467890".toCharArray();
    public static final int[] SPACERS = new int[]{33721342, 0x2808080, 0xDFFFFFF};
    private static final boolean showLines = false;
    private static final Set<FontRenderer> allRenderers = new HashSet<FontRenderer>();

    public static ResourceAddress getFontName(FontRenderer fontRenderer, ResourceAddress font) {
        if (fontRenderer.defaultFont == null) {
            fontRenderer.defaultFont = font;
        }
        if (fontRenderer.hdFont == null) {
            String namespace = fontRenderer.defaultFont.getNamespace();
            String name = fontRenderer.defaultFont.getPath().replaceAll(".*/", "");
            fontRenderer.hdFont = new ResourceAddress(namespace, "mcpatcher/font/" + name);
        }
        if (enable && TexturePackAPI.hasResource(fontRenderer.hdFont)) {
            logger.fine("using %s instead of %s", fontRenderer.hdFont, fontRenderer.defaultFont);
            fontRenderer.isHD = true;
            return fontRenderer.hdFont;
        }
        logger.fine("using default %s", fontRenderer.defaultFont);
        fontRenderer.isHD = false;
        return fontRenderer.defaultFont;
    }

    public static float[] computeCharWidthsf(FontRenderer fontRenderer, ResourceAddress filename, BufferedImage image, int[] rgb, int[] charWidth) {
        int ch;
        float[] charWidthf = new float[charWidth.length];
        if (!fontRenderer.isHD) {
            for (int i = 0; i < charWidth.length; ++i) {
                charWidthf[i] = charWidth[i];
            }
            return charWidthf;
        }
        allRenderers.add(fontRenderer);
        int width = image.getWidth();
        int height = image.getHeight();
        int colWidth = width / 16;
        int rowHeight = height / 16;
        block3: for (ch = 0; ch < charWidth.length; ++ch) {
            int row = ch / 16;
            int col = ch % 16;
            for (int colIdx = colWidth - 1; colIdx >= 0; --colIdx) {
                int x = col * colWidth + colIdx;
                for (int rowIdx = 0; rowIdx < rowHeight; ++rowIdx) {
                    int y = row * rowHeight + rowIdx;
                    int pixel = rgb[x + y * width];
                    if (!FontUtils.isOpaque(pixel)) continue;
                    if (FontUtils.printThis(ch)) {
                        logger.finer("'%c' pixel (%d, %d) = %08x, colIdx = %d", Character.valueOf((char)ch), x, y, pixel, colIdx);
                    }
                    charWidthf[ch] = 128.0f * (float)(colIdx + 1) / (float)width + 1.0f;
                    continue block3;
                }
            }
        }
        for (ch = 0; ch < charWidthf.length; ++ch) {
            if (charWidthf[ch] <= 0.0f) {
                charWidthf[ch] = 2.0f;
                continue;
            }
            if (!(charWidthf[ch] >= 7.99f)) continue;
            charWidthf[ch] = 7.99f;
        }
        boolean[] isOverride = new boolean[charWidth.length];
        try {
            FontUtils.getCharWidthOverrides(filename, charWidthf, isOverride);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!isOverride[32]) {
            charWidthf[32] = FontUtils.defaultSpaceWidth(charWidthf);
        }
        for (int ch2 = 0; ch2 < charWidth.length; ++ch2) {
            charWidth[ch2] = Math.round(charWidthf[ch2]);
            if (!FontUtils.printThis(ch2)) continue;
            logger.finer("charWidth['%c'] = %f", Character.valueOf((char)ch2), Float.valueOf(charWidthf[ch2]));
        }
        return charWidthf;
    }

    private static float getCharWidthf(FontRenderer fontRenderer, char ch) {
        float width = fontRenderer.getCharWidth(ch);
        if (width < 0.0f || fontRenderer.charWidthf == null || ch >= fontRenderer.charWidthf.length || ch < '\u0000') {
            return width;
        }
        return fontRenderer.charWidthf[ch];
    }

    public static float getCharWidthf(FontRenderer fontRenderer, int[] charWidth, int ch) {
        return fontRenderer.isHD ? fontRenderer.charWidthf[ch] * (float)fontRenderer.fontHeight / 8.0f : (float)charWidth[ch];
    }

    public static float getStringWidthf(FontRenderer fontRenderer, String s) {
        float totalWidth = 0.0f;
        if (s != null) {
            boolean isLink = false;
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                float cWidth = FontUtils.getCharWidthf(fontRenderer, c);
                if (cWidth < 0.0f && i < s.length() - 1) {
                    if ((c = s.charAt(++i)) == 'l' || c == 'L') {
                        isLink = true;
                    } else if (c == 'r' || c == 'R') {
                        isLink = false;
                    }
                    cWidth = 0.0f;
                }
                totalWidth += cWidth;
                if (!isLink) continue;
                totalWidth += 1.0f;
            }
        }
        return totalWidth;
    }

    public static ResourceAddress getUnicodePage(ResourceAddress resource) {
        ResourceAddress newResource;
        if (enable && resource != null && TexturePackAPI.hasResource(newResource = new ResourceAddress(resource.getNamespace(), resource.getPath().replaceFirst("^textures/", "mcpatcher/")))) {
            logger.fine("using %s instead of %s", newResource, resource);
            return newResource;
        }
        return resource;
    }

    private static boolean isOpaque(int pixel) {
        for (int i : SPACERS) {
            if (pixel != i) continue;
            return false;
        }
        return (pixel >> 24 & 0xF0) > 0;
    }

    private static boolean printThis(int ch) {
        return "ABCDEF abcdef".indexOf(ch) >= 0;
    }

    private static float defaultSpaceWidth(float[] charWidthf) {
        if (TexturePackAPI.isDefaultTexturePack()) {
            return 4.0f;
        }
        float sum = 0.0f;
        int n = 0;
        for (char ch : AVERAGE_CHARS) {
            if (!(charWidthf[ch] > 0.0f)) continue;
            sum += charWidthf[ch];
            ++n;
        }
        if (n > 0) {
            return sum / (float)n * 7.0f / 12.0f;
        }
        return 4.0f;
    }

    private static void getCharWidthOverrides(ResourceAddress font, float[] charWidthf, boolean[] isOverride) {
        ResourceAddress textFile = TexturePackAPI.transformResourceAddress(font, ".png", ".properties");
        Properties props = TexturePackAPI.getProperties(textFile);
        if (props == null) {
            return;
        }
        logger.fine("reading character widths from %s", textFile);
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (!key.matches("^width\\.\\d+$") || value.equals("")) continue;
            try {
                int ch = Integer.parseInt(key.substring(6));
                float width = Float.parseFloat(value);
                if (ch < 0 || ch >= charWidthf.length) continue;
                logger.finer("setting charWidthf[%d] to %f", ch, Float.valueOf(width));
                charWidthf[ch] = width;
                isOverride[ch] = true;
            }
            catch (NumberFormatException e) {}
        }
    }

    static {
        TexturePackChangeHandler.register(new TexturePackChangeHandler("HD Font", 1){

            @Override
            public void initialize() {
            }

            @Override
            public void beforeChange() {
            }

            @Override
            public void afterChange() {
                for (FontRenderer renderer : allRenderers) {
                    renderer.readFontData();
                }
            }
        });
    }
}

