/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.TexturePackChangeHandler;
import com.prupe.mcpatcher.hd.FancyDial;
import com.prupe.mcpatcher.hd.MipmapHelper;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.src.ResourceAddress;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class CustomAnimation
implements Comparable<CustomAnimation> {
    private static final MCLogger logger = MCLogger.getLogger("Custom Animations", "Animation");
    private static final boolean enable = Config.getBoolean("Extended HD", "animations", true);
    private static final Map<ResourceAddress, Properties> pending = new HashMap<ResourceAddress, Properties>();
    private static final List<CustomAnimation> animations = new ArrayList<CustomAnimation>();
    private final ResourceAddress propertiesName;
    private final ResourceAddress dstName;
    private final ResourceAddress srcName;
    private final int mipmapLevel;
    private final ByteBuffer imageData;
    private final int x;
    private final int y;
    private final int w;
    private final int h;
    private int currentFrame;
    private int currentDelay;
    private int numFrames;
    private int[] tileOrder;
    private int[] tileDelay;
    private final int numTiles;
    private boolean error;

    public static void updateAll() {
        FancyDial.updateAll();
        if (!pending.isEmpty()) {
            try {
                CustomAnimation.checkPendingAnimations();
            }
            catch (Throwable e) {
                e.printStackTrace();
                logger.error("%d remaining animations cleared", pending.size());
                pending.clear();
            }
        }
        for (CustomAnimation animation : animations) {
            animation.update();
        }
        FancyDial.postUpdateAll();
    }

    private static void checkPendingAnimations() {
        ArrayList<ResourceAddress> done = new ArrayList<ResourceAddress>();
        for (Map.Entry<ResourceAddress, Properties> entry : pending.entrySet()) {
            Properties properties;
            ResourceAddress name = entry.getKey();
            ResourceAddress textureName = TexturePackAPI.parseResourceAddress(name, MCPatcherUtils.getStringProperty(properties = entry.getValue(), "to", ""));
            if (!TexturePackAPI.isTextureLoaded(textureName)) continue;
            CustomAnimation.addStrip(name, properties);
            done.add(name);
        }
        if (!done.isEmpty()) {
            for (ResourceAddress name : done) {
                pending.remove(name);
            }
            Collections.sort(animations);
        }
    }

    private static void addStrip(ResourceAddress propertiesName, Properties properties) {
        ResourceAddress dstName = TexturePackAPI.parseResourceAddress(propertiesName, properties.getProperty("to", ""));
        if (dstName == null) {
            logger.error("%s: missing to= property", new Object[0]);
            return;
        }
        ResourceAddress srcName = TexturePackAPI.parseResourceAddress(propertiesName, properties.getProperty("from", ""));
        if (srcName == null) {
            logger.error("%s: missing from= property", new Object[0]);
            return;
        }
        BufferedImage srcImage = TexturePackAPI.getImage(srcName);
        if (srcImage == null) {
            logger.error("%s: image %s not found in texture pack", propertiesName, srcName);
            return;
        }
        int x = MCPatcherUtils.getIntProperty(properties, "x", 0);
        int y = MCPatcherUtils.getIntProperty(properties, "y", 0);
        int w = MCPatcherUtils.getIntProperty(properties, "w", 0);
        int h = MCPatcherUtils.getIntProperty(properties, "h", 0);
        if (dstName.getPath().startsWith("textures/atlas/")) {
            logger.error("%s: animations cannot have a target of %s", dstName);
            return;
        }
        if (x < 0 || y < 0 || w <= 0 || h <= 0) {
            logger.error("%s: %s has invalid dimensions x=%d,y=%d,w=%d,h=%d", propertiesName, srcName, x, y, w, h);
            return;
        }
        TexturePackAPI.bindTexture(dstName);
        int dstWidth = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int dstHeight = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        int levels = MipmapHelper.getMipmapLevelsForCurrentTexture();
        if (x + w > dstWidth || y + h > dstHeight) {
            logger.error("%s: %s dimensions x=%d,y=%d,w=%d,h=%d exceed %s size %dx%d", propertiesName, srcName, x, y, w, h, dstName, dstWidth, dstHeight);
            return;
        }
        int width = srcImage.getWidth();
        int height = srcImage.getHeight();
        if (width != w) {
            srcImage = CustomAnimation.resizeImage(srcImage, w);
            width = srcImage.getWidth();
            height = srcImage.getHeight();
        }
        if (width != w || height < h) {
            logger.error("%s: %s dimensions %dx%d do not match %dx%d", propertiesName, srcName, width, height, w, h);
            return;
        }
        ByteBuffer imageData = ByteBuffer.allocateDirect(4 * width * height);
        int[] argb = new int[width * height];
        byte[] rgba = new byte[4 * width * height];
        srcImage.getRGB(0, 0, width, height, argb, 0, width);
        CustomAnimation.ARGBtoRGBA(argb, rgba);
        imageData.put(rgba).flip();
        for (int mipmapLevel = 0; mipmapLevel <= levels; ++mipmapLevel) {
            CustomAnimation.add(new CustomAnimation(propertiesName, srcName, dstName, mipmapLevel, x, y, w, h, imageData, height / h, properties));
            if (((x | y | w | h) & 1) != 0 || w <= 0 || h <= 0) break;
            ByteBuffer newImage = ByteBuffer.allocateDirect(width * height);
            MipmapHelper.scaleHalf(imageData.asIntBuffer(), width, height, newImage.asIntBuffer(), 0);
            imageData = newImage;
            width >>= 1;
            height >>= 1;
            x >>= 1;
            y >>= 1;
            w >>= 1;
            h >>= 1;
        }
    }

    private static void add(CustomAnimation animation) {
        if (animation != null) {
            animations.add(animation);
            if (animation.mipmapLevel == 0) {
                logger.fine("new %s", animation);
            }
        }
    }

    private CustomAnimation(ResourceAddress propertiesName, ResourceAddress srcName, ResourceAddress dstName, int mipmapLevel, int x, int y, int w, int h, ByteBuffer imageData, int numFrames, Properties properties) {
        this.propertiesName = propertiesName;
        this.srcName = srcName;
        this.dstName = dstName;
        this.mipmapLevel = mipmapLevel;
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
        this.imageData = imageData;
        this.numFrames = numFrames;
        this.currentFrame = -1;
        this.numTiles = numFrames;
        this.loadProperties(properties);
    }

    void update() {
        if (this.error) {
            return;
        }
        int texture = TexturePackAPI.getTextureIfLoaded(this.dstName);
        if (texture < 0) {
            return;
        }
        if (--this.currentDelay > 0) {
            return;
        }
        if (++this.currentFrame >= this.numFrames) {
            this.currentFrame = 0;
        }
        TexturePackAPI.bindTexture(texture);
        this.update(texture, 0, 0);
        int glError = GL11.glGetError();
        if (glError != 0) {
            logger.severe("%s: %s", this, GLU.gluErrorString((int)glError));
            this.error = true;
            return;
        }
        this.currentDelay = this.getDelay();
    }

    @Override
    public int compareTo(CustomAnimation o) {
        return this.dstName.getPath().compareTo(o.dstName.getPath());
    }

    public String toString() {
        return String.format("CustomAnimation{%s %s %dx%d -> %s%s @ %d,%d (%d frames)}", this.propertiesName, this.srcName, this.w, this.h, this.dstName, this.mipmapLevel > 0 ? "#" + this.mipmapLevel : "", this.x, this.y, this.numFrames);
    }

    private static void ARGBtoRGBA(int[] src, byte[] dest) {
        for (int i = 0; i < src.length; ++i) {
            int v = src[i];
            dest[i * 4 + 3] = (byte)(v >> 24 & 0xFF);
            dest[i * 4 + 0] = (byte)(v >> 16 & 0xFF);
            dest[i * 4 + 1] = (byte)(v >> 8 & 0xFF);
            dest[i * 4 + 2] = (byte)(v >> 0 & 0xFF);
        }
    }

    private static BufferedImage resizeImage(BufferedImage image, int width) {
        if (width == image.getWidth()) {
            return image;
        }
        int height = image.getHeight() * width / image.getWidth();
        logger.finer("resizing to %dx%d", width, height);
        BufferedImage newImage = new BufferedImage(width, height, 2);
        Graphics2D graphics2D = newImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, width, height, null);
        return newImage;
    }

    private void loadProperties(Properties properties) {
        int i;
        this.loadTileOrder(properties);
        if (this.tileOrder == null) {
            this.tileOrder = new int[this.numFrames];
            for (i = 0; i < this.numFrames; ++i) {
                this.tileOrder[i] = i % this.numTiles;
            }
        }
        this.tileDelay = new int[this.numFrames];
        this.loadTileDelay(properties);
        for (i = 0; i < this.numFrames; ++i) {
            this.tileDelay[i] = Math.max(this.tileDelay[i], 1);
        }
    }

    private void loadTileOrder(Properties properties) {
        if (properties == null) {
            return;
        }
        int i = 0;
        while (CustomAnimation.getIntValue(properties, "tile.", i) != null) {
            ++i;
        }
        if (i > 0) {
            this.numFrames = i;
            this.tileOrder = new int[this.numFrames];
            for (i = 0; i < this.numFrames; ++i) {
                this.tileOrder[i] = Math.abs(CustomAnimation.getIntValue(properties, "tile.", i)) % this.numTiles;
            }
        }
    }

    private void loadTileDelay(Properties properties) {
        if (properties == null) {
            return;
        }
        Integer defaultValue = CustomAnimation.getIntValue(properties, "duration");
        for (int i = 0; i < this.numFrames; ++i) {
            Integer value = CustomAnimation.getIntValue(properties, "duration.", i);
            if (value != null) {
                this.tileDelay[i] = value;
                continue;
            }
            if (defaultValue == null) continue;
            this.tileDelay[i] = defaultValue;
        }
    }

    private static Integer getIntValue(Properties properties, String key) {
        try {
            String value = properties.getProperty(key);
            if (value != null && value.matches("^\\d+$")) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    private static Integer getIntValue(Properties properties, String prefix, int index) {
        return CustomAnimation.getIntValue(properties, prefix + index);
    }

    private void update(int texture, int dx, int dy) {
        GL11.glTexSubImage2D((int)3553, (int)this.mipmapLevel, (int)(this.x + dx), (int)(this.y + dy), (int)this.w, (int)this.h, (int)6408, (int)5121, (ByteBuffer)((ByteBuffer)this.imageData.position(4 * this.w * this.h * this.tileOrder[this.currentFrame])));
    }

    private int getDelay() {
        return this.tileDelay[this.currentFrame];
    }

    static {
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Extended HD", 1){

            @Override
            public void beforeChange() {
                if (!pending.isEmpty()) {
                    logger.fine("%d animations were never registered:", pending.size());
                    for (ResourceAddress resource : pending.keySet()) {
                        logger.fine("  %s", resource);
                    }
                    pending.clear();
                }
                animations.clear();
                MipmapHelper.reset();
                FancyDial.refresh();
            }

            @Override
            public void afterChange() {
                if (enable) {
                    for (ResourceAddress resource : TexturePackAPI.listResources("mcpatcher/anim", ".properties", true, false, false)) {
                        Properties properties = TexturePackAPI.getProperties(resource);
                        if (properties == null) continue;
                        pending.put(resource, properties);
                    }
                }
            }
        });
    }
}

