/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.hd;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.hd.BorderedTexture;
import com.prupe.mcpatcher.hd.MipmapHelper;
import java.awt.image.BufferedImage;
import java.lang.reflect.Field;
import net.minecraft.src.IResource;
import net.minecraft.src.ResourceAddress;
import net.minecraft.src.StreamedResource;
import net.minecraft.src.TextureStitched;
import org.lwjgl.opengl.PixelFormat;

public class AAHelper {
    private static final MCLogger logger = MCLogger.getLogger("Mipmap");
    private static final int debugColor = Config.getBoolean("Extended HD", "debugBorder", false) ? -16776961 : 0;
    private static final int aaSamples = Config.getInt("Extended HD", "antiAliasing", 1);
    private static Field addressField;

    public static PixelFormat setupPixelFormat(PixelFormat pixelFormat) {
        if (aaSamples > 1) {
            logger.config("setting AA samples to %d", aaSamples);
            return pixelFormat.withSamples(aaSamples);
        }
        return pixelFormat;
    }

    public static BufferedImage addBorder(TextureStitched stitched, IResource resource, BufferedImage input) {
        ResourceAddress name;
        if (input == null || !(resource instanceof StreamedResource) || addressField == null) {
            return input;
        }
        try {
            name = (ResourceAddress)addressField.get(resource);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            addressField = null;
            return input;
        }
        input = MipmapHelper.fixTransparency(name, input);
        if (!(stitched instanceof BorderedTexture)) {
            return input;
        }
        int width = input.getWidth();
        int height = input.getHeight();
        int numFrames = height / width;
        height = width;
        int border = AAHelper.getBorderWidth(width);
        ((BorderedTexture)stitched).setBorderWidth(border);
        if (border <= 0) {
            return input;
        }
        int newWidth = width + 2 * border;
        int newHeight = height + 2 * border;
        BufferedImage output = new BufferedImage(newWidth, numFrames * newHeight, 2);
        for (int frame = 0; frame < numFrames; ++frame) {
            int sy = frame * height;
            int dy = frame * newHeight;
            AAHelper.copyRegion(input, 0, sy, output, 0, dy, border, border, true, true);
            AAHelper.copyRegion(input, 0, sy, output, border, dy, width, border, false, true);
            AAHelper.copyRegion(input, width - border, sy, output, width + border, dy, border, border, true, true);
            AAHelper.copyRegion(input, 0, sy, output, 0, dy + border, border, width, true, false);
            AAHelper.copyRegion(input, 0, sy, output, border, dy + border, width, height, false, false);
            AAHelper.copyRegion(input, width - border, sy, output, width + border, dy + border, border, width, true, false);
            AAHelper.copyRegion(input, 0, sy + height - border, output, 0, dy + height + border, border, border, true, true);
            AAHelper.copyRegion(input, 0, sy + height - border, output, border, dy + height + border, width, border, false, true);
            AAHelper.copyRegion(input, width - border, sy + height - border, output, width + border, dy + height + border, border, border, true, true);
            AAHelper.addDebugOutline(output, dy, width, height, border);
        }
        return output;
    }

    static boolean useAAForTexture(String texture) {
        return (aaSamples > 1 || MipmapHelper.anisoLevel > 1) && MipmapHelper.useMipmapsForTexture(texture);
    }

    private static int getBorderWidth(int size) {
        int border = aaSamples <= 1 && MipmapHelper.anisoLevel <= 1 ? 0 : (MipmapHelper.mipmapEnabled && MipmapHelper.maxMipmapLevel > 0 ? 1 << Math.max(Math.min(MipmapHelper.maxMipmapLevel, 4), 0) : 2);
        return Math.min(border, size);
    }

    private static void copyRegion(BufferedImage input, int sx, int sy, BufferedImage output, int dx, int dy, int w, int h, boolean flipX, boolean flipY) {
        int[] rgb = new int[w * h];
        input.getRGB(sx, sy, w, h, rgb, 0, w);
        if (flipX || flipY) {
            int[] rgbFlipped = new int[w * h];
            for (int i = 0; i < w; ++i) {
                for (int j = 0; j < h; ++j) {
                    rgbFlipped[w * j + i] = rgb[w * (flipY ? h - 1 - j : j) + (flipX ? w - 1 - i : i)];
                }
            }
            output.setRGB(dx, dy, w, h, rgbFlipped, 0, w);
        } else {
            output.setRGB(dx, dy, w, h, rgb, 0, w);
        }
    }

    private static void addDebugOutline(BufferedImage output, int dy, int width, int height, int border) {
        if (debugColor != 0) {
            int i;
            for (i = 0; i < width; ++i) {
                output.setRGB(i + border, dy + border, debugColor);
                output.setRGB(i + border, dy + height + border, debugColor);
            }
            for (i = 0; i < height; ++i) {
                output.setRGB(border, dy + i + border, debugColor);
                output.setRGB(height + border, dy + i + border, debugColor);
            }
        }
    }

    static {
        for (Field f : StreamedResource.class.getDeclaredFields()) {
            if (!ResourceAddress.class.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            addressField = f;
            break;
        }
    }
}

