/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TileLoader;
import com.prupe.mcpatcher.WeightedIndex;
import com.prupe.mcpatcher.ctm.ITileOverride;
import com.prupe.mcpatcher.ctm.TileOverride;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Icon;
import net.minecraft.src.ResourceAddress;

class TileOverrideImpl {
    TileOverrideImpl() {
    }

    static final class BetterGrass
    implements ITileOverride {
        private static final int[][] OFFSET_MATRIX = new int[][]{{0, -1}, {0, 1}, {-1, 0}, {1, 0}};
        private final int blockID;
        private final String tileName;
        private final Icon fullTile;
        private final Icon fullSnowTile;

        BetterGrass(TileLoader tileLoader, int blockID, String tileName) {
            this.blockID = blockID;
            this.tileName = tileName;
            this.fullSnowTile = tileLoader.getIcon("snow");
            this.fullTile = tileLoader.getIcon(tileName + "_top");
        }

        public String toString() {
            return "BetterGrass{" + this.tileName + "}";
        }

        @Override
        public boolean isDisabled() {
            return false;
        }

        @Override
        public void registerIcons() {
        }

        @Override
        public Set<Integer> getMatchingBlocks() {
            HashSet<Integer> ids = new HashSet<Integer>();
            ids.add(this.blockID);
            return ids;
        }

        @Override
        public Set<String> getMatchingTiles() {
            return null;
        }

        @Override
        public int getRenderPass() {
            return 0;
        }

        @Override
        public int getWeight() {
            return -1;
        }

        @Override
        public int compareTo(ITileOverride o) {
            return o.getWeight() - this.getWeight();
        }

        @Override
        public Icon getTile(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
            if (face < 2 || face > 5) {
                return null;
            }
            int[] offset = OFFSET_MATRIX[face - 2];
            if (blockAccess.getBlockId(i + offset[0], j - 1, k + offset[1]) == this.blockID) {
                int neighborBlock = blockAccess.getBlockId(i, j + 1, k);
                if (neighborBlock == 78 || neighborBlock == 80) {
                    neighborBlock = blockAccess.getBlockId(i + offset[0], j, k + offset[1]);
                    if (neighborBlock == 78 || neighborBlock == 80) {
                        return this.fullSnowTile;
                    }
                    return null;
                }
                return this.fullTile;
            }
            return null;
        }

        boolean isBetterGrass(IBlockAccess blockAccess, Block block, int i, int j, int k, int face) {
            return block.blockID == this.blockID && this.getTile(blockAccess, block, null, i, j, k, face) == this.fullTile;
        }

        @Override
        public Icon getTile(Block block, Icon origIcon, int face, int metadata) {
            return null;
        }
    }

    static final class Fixed
    extends TileOverride {
        Fixed(ResourceAddress filePrefix, Properties properties, TileLoader tileLoader) {
            super(filePrefix, properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "fixed";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 1) {
                return null;
            }
            return "requires exactly 1 tile";
        }

        @Override
        Icon getTileImpl(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
            return this.icons[0];
        }

        @Override
        Icon getTileImpl(Block block, Icon origIcon, int face, int metadata) {
            return this.icons[0];
        }
    }

    static final class Repeat
    extends TileOverride {
        private final int width;
        private final int height;
        private final int symmetry;

        Repeat(ResourceAddress filePrefix, Properties properties, TileLoader tileLoader) {
            super(filePrefix, properties, tileLoader);
            String sym;
            this.width = MCPatcherUtils.getIntProperty(properties, "width", 0);
            this.height = MCPatcherUtils.getIntProperty(properties, "height", 0);
            if (this.width <= 0 || this.height <= 0) {
                this.error("invalid width and height (%dx%d)", this.width, this.height);
            }
            this.symmetry = (sym = properties.getProperty("symmetry", "none")).equals("opposite") ? -2 : -1;
        }

        @Override
        String getMethod() {
            return "repeat";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == this.width * this.height) {
                return null;
            }
            return String.format("requires exactly %dx%d tiles", this.width, this.height);
        }

        @Override
        Icon getTileImpl(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
            int y;
            int x;
            if (face < 0) {
                face = 0;
            }
            switch (face &= this.symmetry) {
                case 0: 
                case 1: {
                    if (this.rotateTop) {
                        x = k;
                        y = i;
                        break;
                    }
                    x = i;
                    y = k;
                    break;
                }
                case 2: {
                    x = -i - 1;
                    y = -j;
                    break;
                }
                case 3: {
                    x = i;
                    y = -j;
                    break;
                }
                case 4: {
                    x = k;
                    y = -j;
                    break;
                }
                case 5: {
                    x = -k - 1;
                    y = -j;
                    break;
                }
                default: {
                    return null;
                }
            }
            if ((x %= this.width) < 0) {
                x += this.width;
            }
            if ((y %= this.height) < 0) {
                y += this.height;
            }
            return this.icons[this.width * y + x];
        }

        @Override
        Icon getTileImpl(Block block, Icon origIcon, int face, int metadata) {
            return this.icons[0];
        }
    }

    static final class Random1
    extends TileOverride {
        private final int symmetry;
        private final WeightedIndex chooser;

        Random1(ResourceAddress filePrefix, Properties properties, TileLoader tileLoader) {
            super(filePrefix, properties, tileLoader);
            String sym = properties.getProperty("symmetry", "none");
            this.symmetry = sym.equals("all") ? 6 : (sym.equals("opposite") ? 2 : 1);
            this.chooser = WeightedIndex.create(this.getNumberOfTiles(), properties.getProperty("weights", ""));
            if (this.chooser == null) {
                this.error("invalid weights", new Object[0]);
            }
        }

        @Override
        String getMethod() {
            return "random";
        }

        @Override
        Icon getTileImpl(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
            if (face < 0) {
                face = 0;
            }
            long hash = WeightedIndex.hash128To64(i, j, k, this.reorient(face) / this.symmetry);
            int index = this.chooser.choose(hash);
            return this.icons[index];
        }

        @Override
        Icon getTileImpl(Block block, Icon origIcon, int face, int metadata) {
            return this.icons[0];
        }
    }

    static final class Top
    extends TileOverride {
        Top(ResourceAddress filePrefix, Properties properties, TileLoader tileLoader) {
            super(filePrefix, properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "top";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 1) {
                return null;
            }
            return "requires exactly 1 tile";
        }

        @Override
        Icon getTileImpl(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
            if (face < 0) {
                face = 2;
            } else if (this.reorient(face) <= 1) {
                return null;
            }
            int[][] offsets = NEIGHBOR_OFFSET[face];
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(6)])) {
                return this.icons[0];
            }
            return null;
        }

        @Override
        Icon getTileImpl(Block block, Icon origIcon, int face, int metadata) {
            return null;
        }
    }

    static final class VerticalHorizontal
    extends Vertical {
        private static final int[] neighborMap = new int[]{3, 6, 3, 3, 3, 6, 3, 3, 4, 5, 4, 4, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3};

        VerticalHorizontal(ResourceAddress filePrefix, Properties properties, TileLoader tileLoader) {
            super(filePrefix, properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "vertical+horizontal";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 7) {
                return null;
            }
            return "requires exactly 7 tiles";
        }

        @Override
        Icon getTileImpl(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
            Icon icon = super.getTileImpl(blockAccess, block, origIcon, i, j, k, face);
            if (icon != this.icons[3]) {
                return icon;
            }
            int[][] offsets = NEIGHBOR_OFFSET[face];
            int neighborBits = 0;
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(0)])) {
                neighborBits |= 1;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(1)])) {
                neighborBits |= 2;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(3)])) {
                neighborBits |= 4;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(4)])) {
                neighborBits |= 8;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(5)])) {
                neighborBits |= 0x10;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(7)])) {
                neighborBits |= 0x20;
            }
            return this.icons[neighborMap[neighborBits]];
        }
    }

    static class Vertical
    extends TileOverride {
        private static final int[] neighborMap = new int[]{3, 2, 0, 1};

        Vertical(ResourceAddress filePrefix, Properties properties, TileLoader tileLoader) {
            super(filePrefix, properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "vertical";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 4) {
                return null;
            }
            return "requires exactly 4 tiles";
        }

        @Override
        Icon getTileImpl(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
            if (face < 0) {
                face = 2;
            } else if (this.reorient(face) <= 1) {
                return null;
            }
            int[][] offsets = NEIGHBOR_OFFSET[face];
            int neighborBits = 0;
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(2)])) {
                neighborBits |= 1;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(6)])) {
                neighborBits |= 2;
            }
            return this.icons[neighborMap[neighborBits]];
        }

        @Override
        Icon getTileImpl(Block block, Icon origIcon, int face, int metadata) {
            return this.icons[3];
        }
    }

    static final class HorizontalVertical
    extends Horizontal {
        private static final int[] neighborMap = new int[]{3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 4, 4, 5, 4, 4, 4, 4, 4, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3, 3, 3, 6, 3, 3, 3, 3, 3};

        HorizontalVertical(ResourceAddress filePrefix, Properties properties, TileLoader tileLoader) {
            super(filePrefix, properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "horizontal+vertical";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 7) {
                return null;
            }
            return "requires exactly 7 tiles";
        }

        @Override
        Icon getTileImpl(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
            Icon icon = super.getTileImpl(blockAccess, block, origIcon, i, j, k, face);
            if (icon != this.icons[3]) {
                return icon;
            }
            int[][] offsets = NEIGHBOR_OFFSET[face];
            int neighborBits = 0;
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(1)])) {
                neighborBits |= 1;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(2)])) {
                neighborBits |= 2;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(3)])) {
                neighborBits |= 4;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(5)])) {
                neighborBits |= 8;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(6)])) {
                neighborBits |= 0x10;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(7)])) {
                neighborBits |= 0x20;
            }
            return this.icons[neighborMap[neighborBits]];
        }
    }

    static class Horizontal
    extends TileOverride {
        private static final int[] neighborMap = new int[]{3, 2, 0, 1};

        Horizontal(ResourceAddress filePrefix, Properties properties, TileLoader tileLoader) {
            super(filePrefix, properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "horizontal";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() == 4) {
                return null;
            }
            return "requires exactly 4 tiles";
        }

        @Override
        Icon getTileImpl(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
            if (face < 0) {
                face = 2;
            } else if (this.reorient(face) <= 1) {
                return null;
            }
            int[][] offsets = NEIGHBOR_OFFSET[face];
            int neighborBits = 0;
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(0)])) {
                neighborBits |= 1;
            }
            if (this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[this.rotateUV(4)])) {
                neighborBits |= 2;
            }
            return this.icons[neighborMap[neighborBits]];
        }

        @Override
        Icon getTileImpl(Block block, Icon origIcon, int face, int metadata) {
            return this.icons[3];
        }
    }

    static final class CTM
    extends TileOverride {
        private static final int[] neighborMap = new int[]{0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 36, 17, 36, 17, 24, 19, 24, 43, 36, 17, 36, 17, 24, 19, 24, 43, 16, 18, 16, 18, 6, 46, 6, 21, 16, 18, 16, 18, 28, 9, 28, 22, 36, 17, 36, 17, 24, 19, 24, 43, 36, 17, 36, 17, 24, 19, 24, 43, 37, 40, 37, 40, 30, 8, 30, 34, 37, 40, 37, 40, 25, 23, 25, 45, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 0, 3, 0, 3, 12, 5, 12, 15, 0, 3, 0, 3, 12, 5, 12, 15, 1, 2, 1, 2, 4, 7, 4, 29, 1, 2, 1, 2, 13, 31, 13, 14, 36, 39, 36, 39, 24, 41, 24, 27, 36, 39, 36, 39, 24, 41, 24, 27, 16, 42, 16, 42, 6, 20, 6, 10, 16, 42, 16, 42, 28, 35, 28, 44, 36, 39, 36, 39, 24, 41, 24, 27, 36, 39, 36, 39, 24, 41, 24, 27, 37, 38, 37, 38, 30, 11, 30, 32, 37, 38, 37, 38, 25, 33, 25, 26};

        CTM(ResourceAddress filePrefix, Properties properties, TileLoader tileLoader) {
            super(filePrefix, properties, tileLoader);
        }

        @Override
        String getMethod() {
            return "ctm";
        }

        @Override
        String checkTileMap() {
            if (this.getNumberOfTiles() >= 47) {
                return null;
            }
            return "requires at least 47 tiles";
        }

        @Override
        boolean requiresFace() {
            return true;
        }

        @Override
        Icon getTileImpl(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
            int[][] offsets = NEIGHBOR_OFFSET[face];
            int neighborBits = 0;
            for (int bit = 0; bit < 8; ++bit) {
                if (!this.shouldConnect(blockAccess, block, origIcon, i, j, k, face, offsets[bit])) continue;
                neighborBits |= 1 << bit;
            }
            return this.icons[neighborMap[neighborBits]];
        }

        @Override
        Icon getTileImpl(Block block, Icon origIcon, int face, int metadata) {
            return this.icons[0];
        }
    }
}

