/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.TileLoader;
import com.prupe.mcpatcher.ctm.ITileOverride;
import com.prupe.mcpatcher.ctm.RenderPassAPI;
import com.prupe.mcpatcher.ctm.TileOverrideImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Icon;
import net.minecraft.src.ResourceAddress;

abstract class TileOverride
implements ITileOverride {
    private static final MCLogger logger = MCLogger.getLogger("Connected Textures", "CTM");
    static final int BOTTOM_FACE = 0;
    static final int TOP_FACE = 1;
    static final int NORTH_FACE = 2;
    static final int SOUTH_FACE = 3;
    static final int WEST_FACE = 4;
    static final int EAST_FACE = 5;
    static final int REL_L = 0;
    static final int REL_DL = 1;
    static final int REL_D = 2;
    static final int REL_DR = 3;
    static final int REL_R = 4;
    static final int REL_UR = 5;
    static final int REL_U = 6;
    static final int REL_UL = 7;
    private static final int META_MASK = 65535;
    private static final int ORIENTATION_U_D = 0;
    private static final int ORIENTATION_E_W = 65536;
    private static final int ORIENTATION_N_S = 131072;
    private static final int ORIENTATION_E_W_2 = 196608;
    private static final int ORIENTATION_N_S_2 = 262144;
    private static final int[][] ROTATE_UV_MAP = new int[][]{{4, 5, 2, 3, 1, 0, 2, -2, 2, -2, 0, 0}, {2, 3, 1, 0, 4, 5, 0, 0, 0, 0, -2, 2}, {4, 5, 2, 3, 1, 0, 2, -2, -2, -2, 0, 0}, {2, 3, 1, 0, 4, 5, 0, 0, 0, 0, -2, -2}};
    private static final int[] GO_DOWN = new int[]{0, -1, 0};
    private static final int[] GO_UP = new int[]{0, 1, 0};
    private static final int[] GO_NORTH = new int[]{0, 0, -1};
    private static final int[] GO_SOUTH = new int[]{0, 0, 1};
    private static final int[] GO_WEST = new int[]{-1, 0, 0};
    private static final int[] GO_EAST = new int[]{1, 0, 0};
    private static final int[][] NORMALS = new int[][]{GO_DOWN, GO_UP, GO_NORTH, GO_SOUTH, GO_WEST, GO_EAST};
    protected static final int[][][] NEIGHBOR_OFFSET = new int[][][]{new int[][]{GO_WEST, TileOverride.add(GO_WEST, GO_SOUTH), GO_SOUTH, TileOverride.add(GO_EAST, GO_SOUTH), GO_EAST, TileOverride.add(GO_EAST, GO_NORTH), GO_NORTH, TileOverride.add(GO_WEST, GO_NORTH)}, new int[][]{GO_WEST, TileOverride.add(GO_WEST, GO_SOUTH), GO_SOUTH, TileOverride.add(GO_EAST, GO_SOUTH), GO_EAST, TileOverride.add(GO_EAST, GO_NORTH), GO_NORTH, TileOverride.add(GO_WEST, GO_NORTH)}, new int[][]{GO_EAST, TileOverride.add(GO_EAST, GO_DOWN), GO_DOWN, TileOverride.add(GO_WEST, GO_DOWN), GO_WEST, TileOverride.add(GO_WEST, GO_UP), GO_UP, TileOverride.add(GO_EAST, GO_UP)}, new int[][]{GO_WEST, TileOverride.add(GO_WEST, GO_DOWN), GO_DOWN, TileOverride.add(GO_EAST, GO_DOWN), GO_EAST, TileOverride.add(GO_EAST, GO_UP), GO_UP, TileOverride.add(GO_WEST, GO_UP)}, new int[][]{GO_NORTH, TileOverride.add(GO_NORTH, GO_DOWN), GO_DOWN, TileOverride.add(GO_SOUTH, GO_DOWN), GO_SOUTH, TileOverride.add(GO_SOUTH, GO_UP), GO_UP, TileOverride.add(GO_NORTH, GO_UP)}, new int[][]{GO_SOUTH, TileOverride.add(GO_SOUTH, GO_DOWN), GO_DOWN, TileOverride.add(GO_NORTH, GO_DOWN), GO_NORTH, TileOverride.add(GO_NORTH, GO_UP), GO_UP, TileOverride.add(GO_SOUTH, GO_UP)}};
    private static final int CONNECT_BY_BLOCK = 0;
    private static final int CONNECT_BY_TILE = 1;
    private static final int CONNECT_BY_MATERIAL = 2;
    private static Method getBiomeNameAt;
    private final ResourceAddress propertiesFile;
    private final String texturesDirectory;
    private final String propertiesName;
    private final TileLoader tileLoader;
    private final int renderPass;
    private final int weight;
    private final Set<Integer> matchBlocks;
    private final Set<String> matchTiles;
    private final int faces;
    private final int metadata;
    private final int connectType;
    private final boolean innerSeams;
    private final Set<String> biomes;
    private final int minHeight;
    private final int maxHeight;
    private final List<String> tileNames = new ArrayList<String>();
    protected Icon[] icons;
    private boolean disabled;
    private int[] reorient;
    private int rotateUV;
    protected boolean rotateTop;

    static TileOverride create(ResourceAddress propertiesFile, TileLoader tileLoader) {
        String status;
        if (propertiesFile == null) {
            return null;
        }
        Properties properties = TexturePackAPI.getProperties(propertiesFile);
        if (properties == null) {
            return null;
        }
        String method = properties.getProperty("method", "default").trim().toLowerCase();
        TileOverride override = null;
        if (method.equals("default") || method.equals("glass") || method.equals("ctm")) {
            override = new TileOverrideImpl.CTM(propertiesFile, properties, tileLoader);
        } else if (method.equals("random")) {
            override = new TileOverrideImpl.Random1(propertiesFile, properties, tileLoader);
            if (override.getNumberOfTiles() == 1) {
                override = new TileOverrideImpl.Fixed(propertiesFile, properties, tileLoader);
            }
        } else if (method.equals("fixed") || method.equals("static")) {
            override = new TileOverrideImpl.Fixed(propertiesFile, properties, tileLoader);
        } else if (method.equals("bookshelf") || method.equals("horizontal")) {
            override = new TileOverrideImpl.Horizontal(propertiesFile, properties, tileLoader);
        } else if (method.equals("horizontal+vertical") || method.equals("h+v")) {
            override = new TileOverrideImpl.HorizontalVertical(propertiesFile, properties, tileLoader);
        } else if (method.equals("vertical")) {
            override = new TileOverrideImpl.Vertical(propertiesFile, properties, tileLoader);
        } else if (method.equals("vertical+horizontal") || method.equals("v+h")) {
            override = new TileOverrideImpl.VerticalHorizontal(propertiesFile, properties, tileLoader);
        } else if (method.equals("sandstone") || method.equals("top")) {
            override = new TileOverrideImpl.Top(propertiesFile, properties, tileLoader);
        } else if (method.equals("repeat") || method.equals("pattern")) {
            override = new TileOverrideImpl.Repeat(propertiesFile, properties, tileLoader);
        } else {
            logger.error("%s: unknown method \"%s\"", propertiesFile, method);
        }
        if (override != null && !override.disabled && (status = override.checkTileMap()) != null) {
            override.error("invalid %s tile map: %s", override.getMethod(), status);
        }
        return override == null || override.disabled ? null : override;
    }

    protected TileOverride(ResourceAddress propertiesFile, Properties properties, TileLoader tileLoader) {
        this.propertiesFile = propertiesFile;
        this.texturesDirectory = propertiesFile.getPath().replaceFirst("/[^/]*$", "");
        this.propertiesName = propertiesFile.getPath().replaceFirst(".*/", "").replaceFirst("\\.properties$", "");
        this.tileLoader = tileLoader;
        this.loadIcons(properties);
        if (this.tileNames.isEmpty()) {
            this.error("no images found in %s/", this.texturesDirectory);
        }
        String[] mappings = new String[Block.blocksList.length];
        for (int i = 0; i < Block.blocksList.length; ++i) {
            Block block = Block.blocksList[i];
            if (block == null) continue;
            mappings[i] = block.getShortName();
        }
        this.matchBlocks = this.getIDList(properties, "matchBlocks", "block", mappings);
        this.matchTiles = this.getIDList(properties, "matchTiles");
        if (this.matchBlocks.isEmpty() && this.matchTiles.isEmpty()) {
            this.matchTiles.add(this.propertiesName);
        }
        int flags = 0;
        for (String val : properties.getProperty("faces", "all").trim().toLowerCase().split("\\s+")) {
            if (val.equals("bottom")) {
                flags |= 1;
                continue;
            }
            if (val.equals("top")) {
                flags |= 2;
                continue;
            }
            if (val.equals("north")) {
                flags |= 4;
                continue;
            }
            if (val.equals("south")) {
                flags |= 8;
                continue;
            }
            if (val.equals("east")) {
                flags |= 0x20;
                continue;
            }
            if (val.equals("west")) {
                flags |= 0x10;
                continue;
            }
            if (val.equals("side") || val.equals("sides")) {
                flags |= 0x3C;
                continue;
            }
            if (!val.equals("all")) continue;
            flags = -1;
        }
        this.faces = flags;
        int meta = 0;
        for (int i : MCPatcherUtils.parseIntegerList(properties.getProperty("metadata", "0-31"), 0, 31)) {
            meta |= 1 << i;
        }
        this.metadata = meta;
        String connectType1 = properties.getProperty("connect", "").trim().toLowerCase();
        if (connectType1.equals("")) {
            this.connectType = this.matchTiles.isEmpty() ? 0 : 1;
        } else if (connectType1.equals("block")) {
            this.connectType = 0;
        } else if (connectType1.equals("tile")) {
            this.connectType = 1;
        } else if (connectType1.equals("material")) {
            this.connectType = 2;
        } else {
            this.error("invalid connect type %s", connectType1);
            this.connectType = 0;
        }
        this.innerSeams = MCPatcherUtils.getBooleanProperty(properties, "innerSeams", false);
        HashSet<String> biomes = new HashSet<String>();
        String biomeList = properties.getProperty("biomes", "").trim().toLowerCase();
        if (!biomeList.equals("")) {
            Collections.addAll(biomes, biomeList.split("\\s+"));
        }
        if (biomes.isEmpty()) {
            biomes = null;
        }
        this.biomes = biomes;
        this.minHeight = MCPatcherUtils.getIntProperty(properties, "minHeight", -1);
        this.maxHeight = MCPatcherUtils.getIntProperty(properties, "maxHeight", Integer.MAX_VALUE);
        this.renderPass = MCPatcherUtils.getIntProperty(properties, "renderPass", -1);
        if (this.renderPass > 3) {
            this.error("renderPass must be 0-3", new Object[0]);
        } else if (this.renderPass >= 0 && !this.matchTiles.isEmpty()) {
            this.error("renderPass=%d must be block-based not tile-based", this.renderPass);
        }
        this.weight = MCPatcherUtils.getIntProperty(properties, "weight", 0);
    }

    private boolean addIcon(ResourceAddress resource) {
        this.tileNames.add(resource.getPath());
        return this.tileLoader.preloadTile(resource, this.renderPass > 2);
    }

    private void loadIcons(Properties properties) {
        this.tileNames.clear();
        String tileList = properties.getProperty("tiles", "").trim();
        if (tileList.equals("")) {
            ResourceAddress resource;
            int i = 0;
            while (TexturePackAPI.hasResource(resource = TileLoader.parseTileAddress(this.propertiesFile, String.valueOf(i))) && this.addIcon(resource)) {
                ++i;
            }
        } else {
            Pattern range = Pattern.compile("(\\d+)-(\\d+)");
            for (String token : tileList.split("\\s+")) {
                Matcher matcher = range.matcher(token);
                if (token.equals("")) continue;
                if (matcher.matches()) {
                    try {
                        int from = Integer.parseInt(matcher.group(1));
                        int to = Integer.parseInt(matcher.group(2));
                        for (int i = from; i <= to; ++i) {
                            ResourceAddress resource = TileLoader.parseTileAddress(this.propertiesFile, String.valueOf(i));
                            if (TexturePackAPI.hasResource(resource)) {
                                this.addIcon(resource);
                                continue;
                            }
                            this.warn("could not find image %s", resource);
                        }
                        continue;
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                ResourceAddress resource = TileLoader.parseTileAddress(this.propertiesFile, token);
                if (resource == null) {
                    this.tileNames.add(null);
                    continue;
                }
                if (TexturePackAPI.hasResource(resource)) {
                    this.addIcon(resource);
                    continue;
                }
                this.warn("could not find image %s", resource);
            }
        }
    }

    private Set<Integer> getIDList(Properties properties, String key, String type, String[] mappings) {
        Matcher m;
        HashSet<Integer> list = new HashSet<Integer>();
        String property = properties.getProperty(key, "");
        block4: for (String token : property.split("\\s+")) {
            if (token.equals("")) continue;
            if (token.matches("\\d+")) {
                try {
                    int id = Integer.parseInt(token);
                    if (id >= 0 && id < mappings.length) {
                        list.add(id);
                        continue;
                    }
                    this.warn("%s value %d is out of range", key, id);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                continue;
            }
            for (int i = 0; i < mappings.length; ++i) {
                if (!token.equals(mappings[i])) continue;
                list.add(i);
                continue block4;
            }
            this.warn("unknown %s value %s", key, token);
        }
        if (list.isEmpty() && (m = Pattern.compile(type + "(\\d+)").matcher(this.propertiesName)).find()) {
            try {
                list.add(Integer.parseInt(m.group(1)));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    private Set<String> getIDList(Properties properties, String key) {
        HashSet<String> list = new HashSet<String>();
        String property = properties.getProperty(key, "");
        for (String token : property.split("\\s+")) {
            if (token.equals("")) continue;
            list.add(token);
        }
        return list;
    }

    private static int[] add(int[] a, int[] b) {
        if (a.length != b.length) {
            throw new RuntimeException("arrays to add are not same length");
        }
        int[] c = new int[a.length];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a[i] + b[i];
        }
        return c;
    }

    protected int getNumberOfTiles() {
        return this.tileNames.size();
    }

    String checkTileMap() {
        return null;
    }

    boolean requiresFace() {
        return false;
    }

    public String toString() {
        return String.format("%s[%s]", this.getMethod(), this.propertiesFile);
    }

    @Override
    public final void registerIcons() {
        this.icons = new Icon[this.tileNames.size()];
        for (int i = 0; i < this.icons.length; ++i) {
            this.icons[i] = this.tileLoader.getIcon(this.tileNames.get(i));
        }
    }

    final void error(String format, Object ... params) {
        if (this.propertiesFile != null) {
            logger.error(this.propertiesFile + ": " + format, params);
        }
        this.disabled = true;
    }

    final void warn(String format, Object ... params) {
        if (this.propertiesFile != null) {
            logger.warning(this.propertiesFile + ": " + format, params);
        }
    }

    @Override
    public final boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public final Set<Integer> getMatchingBlocks() {
        return this.matchBlocks;
    }

    @Override
    public final Set<String> getMatchingTiles() {
        return this.matchTiles;
    }

    @Override
    public final int getRenderPass() {
        return this.renderPass;
    }

    @Override
    public final int getWeight() {
        return this.weight;
    }

    @Override
    public int compareTo(ITileOverride o) {
        int result = o.getWeight() - this.getWeight();
        if (result != 0) {
            return result;
        }
        if (o instanceof TileOverride) {
            return this.propertiesName.compareTo(((TileOverride)o).propertiesName);
        }
        return -1;
    }

    final boolean shouldConnect(IBlockAccess blockAccess, Block block, Icon icon, int i, int j, int k, int face, int[] offset) {
        int[] normal;
        int neighborOrientation;
        int neighborMeta;
        int blockID = block.blockID;
        int metadata = blockAccess.getBlockMetadata(i, j, k);
        int neighborID = blockAccess.getBlockId(i += offset[0], j += offset[1], k += offset[2]);
        Block neighbor = Block.blocksList[neighborID];
        if (this.exclude(neighbor, face, neighborMeta = blockAccess.getBlockMetadata(i, j, k))) {
            return false;
        }
        int orientation = TileOverride.getOrientationFromMetadata(blockID, metadata);
        if ((orientation & 0xFFFF0000) != ((neighborOrientation = TileOverride.getOrientationFromMetadata(neighborID, neighborMeta)) & 0xFFFF0000)) {
            return false;
        }
        if (this.metadata != -1 && (orientation & 0xFFFF) != (neighborOrientation & 0xFFFF)) {
            return false;
        }
        if (face >= 0 && this.innerSeams && !neighbor.shouldSideBeRendered(blockAccess, i + (normal = NORMALS[face])[0], j + normal[1], k + normal[2], face)) {
            return false;
        }
        switch (this.connectType) {
            case 0: {
                return neighborID == blockID;
            }
            case 1: {
                return neighbor.getBlockIcon(blockAccess, i, j, k, face) == icon;
            }
            case 2: {
                return block.blockMaterial == neighbor.blockMaterial;
            }
        }
        return false;
    }

    final int reorient(int face) {
        if (face < 0 || face > 5 || this.reorient == null) {
            return face;
        }
        return this.reorient[face];
    }

    final int rotateUV(int neighbor) {
        return neighbor + this.rotateUV & 7;
    }

    final boolean exclude(Block block, int face, int metadata) {
        int altMetadata;
        if (block == null) {
            return true;
        }
        if ((this.faces & 1 << this.reorient(face)) == 0) {
            return true;
        }
        return this.metadata != -1 && metadata >= 0 && metadata < 32 && (this.metadata & (1 << metadata | 1 << (altMetadata = TileOverride.getOrientationFromMetadata(block.blockID, metadata) & 0xFFFF))) == 0;
    }

    private static int getOrientationFromMetadata(int blockID, int metadata) {
        int newMeta = metadata;
        int orientation = 0;
        block0 : switch (blockID) {
            case 17: {
                newMeta = metadata & 0xFFFFFFF3;
                switch (metadata & 0xC) {
                    case 4: {
                        orientation = 65536;
                        break block0;
                    }
                    case 8: {
                        orientation = 131072;
                        break block0;
                    }
                }
                break;
            }
            case 155: {
                switch (metadata) {
                    case 3: {
                        newMeta = 2;
                        orientation = 196608;
                        break block0;
                    }
                    case 4: {
                        newMeta = 2;
                        orientation = 262144;
                        break block0;
                    }
                }
                break;
            }
        }
        return orientation | newMeta;
    }

    private void setupOrientation(int orientation, int face) {
        switch (orientation & 0xFFFF0000) {
            case 65536: {
                this.reorient = ROTATE_UV_MAP[0];
                this.rotateUV = ROTATE_UV_MAP[0][face + 6];
                this.rotateTop = true;
                break;
            }
            case 131072: {
                this.reorient = ROTATE_UV_MAP[1];
                this.rotateUV = ROTATE_UV_MAP[1][face + 6];
                this.rotateTop = false;
                break;
            }
            case 196608: {
                this.reorient = ROTATE_UV_MAP[2];
                this.rotateUV = ROTATE_UV_MAP[2][face + 6];
                this.rotateTop = true;
                break;
            }
            case 262144: {
                this.reorient = ROTATE_UV_MAP[3];
                this.rotateUV = ROTATE_UV_MAP[3][face + 6];
                this.rotateTop = false;
                break;
            }
            default: {
                this.reorient = null;
                this.rotateUV = 0;
                this.rotateTop = false;
            }
        }
    }

    @Override
    public final Icon getTile(IBlockAccess blockAccess, Block block, Icon origIcon, int i, int j, int k, int face) {
        if (this.icons == null) {
            this.error("no images loaded, disabling", new Object[0]);
            return null;
        }
        if (face < 0 && this.requiresFace()) {
            this.error("method=%s is not supported for non-standard blocks", this.getMethod());
            return null;
        }
        if (block == null || RenderPassAPI.instance.skipThisRenderPass(block, this.renderPass)) {
            return null;
        }
        int metadata = blockAccess.getBlockMetadata(i, j, k);
        this.setupOrientation(TileOverride.getOrientationFromMetadata(block.blockID, metadata), face);
        if (this.exclude(block, face, metadata)) {
            return null;
        }
        if (j < this.minHeight || j > this.maxHeight) {
            return null;
        }
        if (this.biomes != null && getBiomeNameAt != null) {
            try {
                if (!this.biomes.contains(getBiomeNameAt.invoke(null, i, j, k))) {
                    return null;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                getBiomeNameAt = null;
            }
        }
        return this.getTileImpl(blockAccess, block, origIcon, i, j, k, face);
    }

    @Override
    public final Icon getTile(Block block, Icon origIcon, int face, int metadata) {
        if (this.icons == null) {
            this.error("no images loaded, disabling", new Object[0]);
            return null;
        }
        if (face < 0 && this.requiresFace()) {
            this.error("method=%s is not supported for non-standard blocks", this.getMethod());
            return null;
        }
        if (this.minHeight >= 0 || this.maxHeight < Integer.MAX_VALUE || this.biomes != null) {
            return null;
        }
        this.setupOrientation(TileOverride.getOrientationFromMetadata(block.blockID, metadata), face);
        if (this.exclude(block, face, metadata)) {
            return null;
        }
        return this.getTileImpl(block, origIcon, face, metadata);
    }

    abstract String getMethod();

    abstract Icon getTileImpl(IBlockAccess var1, Block var2, Icon var3, int var4, int var5, int var6, int var7);

    abstract Icon getTileImpl(Block var1, Icon var2, int var3, int var4);

    static {
        try {
            Class<?> biomeHelperClass = Class.forName("com.prupe.mcpatcher.cc.BiomeHelper");
            getBiomeNameAt = biomeHelperClass.getDeclaredMethod("getBiomeNameAt", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            getBiomeNameAt.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (getBiomeNameAt == null) {
            logger.warning("biome integration failed", new Object[0]);
        } else {
            logger.fine("biome integration active", new Object[0]);
        }
    }
}

