/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.TessellatorUtils;
import com.prupe.mcpatcher.ctm.CTMUtils;
import com.prupe.mcpatcher.ctm.RenderPassAPI;
import java.util.Arrays;
import net.minecraft.src.Block;
import net.minecraft.src.Icon;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.Tessellator;

public class GlassPaneRenderer {
    private static final boolean enable = Config.getBoolean("Connected Textures", "glassPane", true);
    public static boolean active;
    private static final Icon[] icons;
    private static Tessellator tessellator;
    private static double u0;
    private static double uM;
    private static double u1;
    private static double v0;
    private static double v1;

    public static void render(RenderBlocks renderBlocks, Block blockPane, Icon origIcon, int i, int j, int k, boolean connectNorth, boolean connectSouth, boolean connectWest, boolean connectEast) {
        boolean connectAny;
        if (!enable) {
            active = false;
            return;
        }
        active = true;
        for (int face = 2; face <= 5; ++face) {
            GlassPaneRenderer.icons[face] = CTMUtils.getTile(renderBlocks, blockPane, i, j, k, face, origIcon, Tessellator.instance);
            if (icons[face] != null) continue;
            active = RenderPassAPI.instance.skipDefaultRendering(blockPane);
            return;
        }
        double i0 = i;
        double iM = i0 + 0.5;
        double i1 = i0 + 1.0;
        double j0 = j;
        double j1 = j0 + 1.0;
        double k0 = k;
        double kM = k0 + 0.5;
        double k1 = k0 + 1.0;
        boolean bl = connectAny = connectWest || connectEast || connectNorth || connectSouth;
        if (connectEast && connectWest || !connectAny) {
            GlassPaneRenderer.setupTileCoords(3);
            tessellator.addVertexWithUV(i0, j1, kM, u0, v0);
            tessellator.addVertexWithUV(i0, j0, kM, u0, v1);
            tessellator.addVertexWithUV(i1, j0, kM, u1, v1);
            tessellator.addVertexWithUV(i1, j1, kM, u1, v0);
            GlassPaneRenderer.setupTileCoords(2);
            tessellator.addVertexWithUV(i1, j1, kM, u0, v0);
            tessellator.addVertexWithUV(i1, j0, kM, u0, v1);
            tessellator.addVertexWithUV(i0, j0, kM, u1, v1);
            tessellator.addVertexWithUV(i0, j1, kM, u1, v0);
        } else if (connectWest && !connectEast) {
            GlassPaneRenderer.setupTileCoords(3);
            tessellator.addVertexWithUV(i0, j1, kM, uM, v0);
            tessellator.addVertexWithUV(i0, j0, kM, uM, v1);
            tessellator.addVertexWithUV(iM, j0, kM, u1, v1);
            tessellator.addVertexWithUV(iM, j1, kM, u1, v0);
            GlassPaneRenderer.setupTileCoords(2);
            tessellator.addVertexWithUV(iM, j1, kM, u0, v0);
            tessellator.addVertexWithUV(iM, j0, kM, u0, v1);
            tessellator.addVertexWithUV(i0, j0, kM, uM, v1);
            tessellator.addVertexWithUV(i0, j1, kM, uM, v0);
        } else if (!connectWest && connectEast) {
            GlassPaneRenderer.setupTileCoords(3);
            tessellator.addVertexWithUV(iM, j1, kM, u0, v0);
            tessellator.addVertexWithUV(iM, j0, kM, u0, v1);
            tessellator.addVertexWithUV(i1, j0, kM, uM, v1);
            tessellator.addVertexWithUV(i1, j1, kM, uM, v0);
            GlassPaneRenderer.setupTileCoords(2);
            tessellator.addVertexWithUV(i1, j1, kM, uM, v0);
            tessellator.addVertexWithUV(i1, j0, kM, uM, v1);
            tessellator.addVertexWithUV(iM, j0, kM, u1, v1);
            tessellator.addVertexWithUV(iM, j1, kM, u1, v0);
        }
        if (connectNorth && connectSouth || !connectAny) {
            GlassPaneRenderer.setupTileCoords(4);
            tessellator.addVertexWithUV(iM, j1, k0, u0, v0);
            tessellator.addVertexWithUV(iM, j0, k0, u0, v1);
            tessellator.addVertexWithUV(iM, j0, k1, u1, v1);
            tessellator.addVertexWithUV(iM, j1, k1, u1, v0);
            GlassPaneRenderer.setupTileCoords(5);
            tessellator.addVertexWithUV(iM, j1, k1, u0, v0);
            tessellator.addVertexWithUV(iM, j0, k1, u0, v1);
            tessellator.addVertexWithUV(iM, j0, k0, u1, v1);
            tessellator.addVertexWithUV(iM, j1, k0, u1, v0);
        } else if (connectNorth && !connectSouth) {
            GlassPaneRenderer.setupTileCoords(4);
            tessellator.addVertexWithUV(iM, j1, k0, uM, v0);
            tessellator.addVertexWithUV(iM, j0, k0, uM, v1);
            tessellator.addVertexWithUV(iM, j0, kM, u1, v1);
            tessellator.addVertexWithUV(iM, j1, kM, u1, v0);
            GlassPaneRenderer.setupTileCoords(5);
            tessellator.addVertexWithUV(iM, j1, kM, u0, v0);
            tessellator.addVertexWithUV(iM, j0, kM, u0, v1);
            tessellator.addVertexWithUV(iM, j0, k0, uM, v1);
            tessellator.addVertexWithUV(iM, j1, k0, uM, v0);
        } else if (!connectNorth && connectSouth) {
            GlassPaneRenderer.setupTileCoords(4);
            tessellator.addVertexWithUV(iM, j1, kM, u0, v0);
            tessellator.addVertexWithUV(iM, j0, kM, u0, v1);
            tessellator.addVertexWithUV(iM, j0, k1, uM, v1);
            tessellator.addVertexWithUV(iM, j1, k1, uM, v0);
            GlassPaneRenderer.setupTileCoords(5);
            tessellator.addVertexWithUV(iM, j1, k1, uM, v0);
            tessellator.addVertexWithUV(iM, j0, k1, uM, v1);
            tessellator.addVertexWithUV(iM, j0, kM, u1, v1);
            tessellator.addVertexWithUV(iM, j1, kM, u1, v0);
        }
        Arrays.fill(icons, null);
        tessellator = null;
    }

    private static void setupTileCoords(int face) {
        Icon icon = icons[face];
        tessellator = TessellatorUtils.getTessellator(Tessellator.instance, icons[face]);
        u0 = icon.getMinU();
        uM = icon.getInterpolatedU(8.0);
        u1 = icon.getMaxU();
        v0 = icon.getMinV();
        v1 = icon.getMaxV();
    }

    static {
        icons = new Icon[6];
    }
}

