/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.ctm;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.TessellatorUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.TexturePackChangeHandler;
import com.prupe.mcpatcher.TileLoader;
import com.prupe.mcpatcher.ctm.ITileOverride;
import com.prupe.mcpatcher.ctm.RenderPassAPI;
import com.prupe.mcpatcher.ctm.TileOverride;
import com.prupe.mcpatcher.ctm.TileOverrideImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.src.Block;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.Icon;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.ResourceAddress;
import net.minecraft.src.Tessellator;

public class CTMUtils {
    private static final MCLogger logger = MCLogger.getLogger("Connected Textures", "CTM");
    private static final boolean enableStandard = Config.getBoolean("Connected Textures", "standard", true);
    private static final boolean enableNonStandard = Config.getBoolean("Connected Textures", "nonStandard", true);
    private static final boolean enableGrass = Config.getBoolean("Connected Textures", "grass", false);
    private static final int maxRecursion = Config.getInt("Connected Textures", "maxRecursion", 4);
    static final int BLOCK_ID_LOG = 17;
    static final int BLOCK_ID_QUARTZ = 155;
    static final int BLOCK_ID_GLASS = 20;
    static final int BLOCK_ID_GLASS_PANE = 102;
    static final int BLOCK_ID_BOOKSHELF = 47;
    static final int BLOCK_ID_GRASS = 2;
    static final int BLOCK_ID_MYCELIUM = 110;
    static final int BLOCK_ID_SNOW = 78;
    static final int BLOCK_ID_CRAFTED_SNOW = 80;
    private static final List<ITileOverride> allOverrides = new ArrayList<ITileOverride>();
    private static final ITileOverride[][] blockOverrides = new ITileOverride[Block.blocksList.length][];
    private static final Map<String, ITileOverride[]> tileOverrides = new HashMap<String, ITileOverride[]>();
    private static TileLoader tileLoader;
    private static TileOverrideImpl.BetterGrass betterGrass;
    static boolean active;
    static ITileOverride lastOverride;

    public static void start() {
        lastOverride = null;
        active = tileLoader.setDefaultTextureMap(Tessellator.instance);
    }

    public static Icon getTile(RenderBlocks renderBlocks, Block block, int i, int j, int k, Icon origIcon, Tessellator tessellator) {
        return CTMUtils.getTile(renderBlocks, block, i, j, k, -1, origIcon, tessellator);
    }

    public static Icon getTile(RenderBlocks renderBlocks, Block block, int i, int j, int k, int face, Icon icon, Tessellator tessellator) {
        IBlockAccess blockAccess;
        TileOverrideIterator iterator;
        lastOverride = null;
        if (CTMUtils.checkFace(face) && CTMUtils.checkBlock(renderBlocks, block) && (lastOverride = (iterator = new TileOverrideIterator(block, icon, blockAccess = renderBlocks.blockAccess, i, j, k, face){
            final /* synthetic */ IBlockAccess val$blockAccess;
            final /* synthetic */ int val$i;
            final /* synthetic */ int val$j;
            final /* synthetic */ int val$k;
            final /* synthetic */ int val$face;
            {
                this.val$blockAccess = iBlockAccess;
                this.val$i = n;
                this.val$j = n2;
                this.val$k = n3;
                this.val$face = n4;
                super(x0, x1);
            }

            @Override
            Icon getTile(ITileOverride override, Block block, Icon currentIcon) {
                return override.getTile(this.val$blockAccess, block, currentIcon, this.val$i, this.val$j, this.val$k, this.val$face);
            }
        }).go()) != null) {
            icon = iterator.getIcon();
        }
        return lastOverride == null && CTMUtils.skipDefaultRendering(block) ? null : icon;
    }

    public static Icon getTile(RenderBlocks renderBlocks, Block block, int face, int metadata, Tessellator tessellator) {
        return CTMUtils.getTile(renderBlocks, block, face, metadata, renderBlocks.getIconBySideAndMetadata(block, face, metadata), tessellator);
    }

    public static Icon getTile(RenderBlocks renderBlocks, Block block, int face, Tessellator tessellator) {
        return CTMUtils.getTile(renderBlocks, block, face, 0, renderBlocks.getIconBySide(block, face), tessellator);
    }

    private static Icon getTile(RenderBlocks renderBlocks, Block block, final int face, final int metadata, Icon icon, Tessellator tessellator) {
        TileOverrideIterator iterator;
        lastOverride = null;
        if (CTMUtils.checkFace(face) && CTMUtils.checkRenderType(block) && (lastOverride = (iterator = new TileOverrideIterator(block, icon){

            @Override
            Icon getTile(ITileOverride override, Block block, Icon currentIcon) {
                return override.getTile(block, currentIcon, face, metadata);
            }
        }).go()) != null) {
            icon = iterator.getIcon();
        }
        return icon;
    }

    public static void reset() {
    }

    public static void finish() {
        CTMUtils.reset();
        RenderPassAPI.instance.finish();
        TessellatorUtils.clearDefaultTextureMap(Tessellator.instance);
        lastOverride = null;
        active = false;
    }

    public static boolean isBetterGrass(IBlockAccess blockAccess, Block block, int i, int j, int k, int face) {
        return betterGrass != null && betterGrass.isBetterGrass(blockAccess, block, i, j, k, face);
    }

    private static boolean checkBlock(RenderBlocks renderBlocks, Block block) {
        return active && renderBlocks.blockAccess != null;
    }

    private static boolean checkFace(int face) {
        return active && (face < 0 ? enableNonStandard : enableStandard);
    }

    private static boolean checkRenderType(Block block) {
        switch (block.getRenderType()) {
            case 11: 
            case 21: {
                return false;
            }
        }
        return true;
    }

    private static boolean skipDefaultRendering(Block block) {
        return RenderPassAPI.instance.skipDefaultRendering(block);
    }

    private static void registerOverride(ITileOverride override) {
        if (override != null && !override.isDisabled()) {
            boolean registered = false;
            if (override.getMatchingBlocks() != null) {
                Iterator<Object> i$ = override.getMatchingBlocks().iterator();
                while (i$.hasNext()) {
                    int index = (Integer)i$.next();
                    String blockName = "";
                    if (index >= 0 && index < Block.blocksList.length && Block.blocksList[index] != null) {
                        blockName = Block.blocksList[index].getShortName();
                        blockName = blockName == null ? "" : " (" + blockName.replaceFirst("^tile\\.", "") + ")";
                    }
                    CTMUtils.blockOverrides[index] = CTMUtils.registerOverride(blockOverrides[index], override, "block " + index + blockName);
                    registered = true;
                }
            }
            if (override.getMatchingTiles() != null) {
                for (String name : override.getMatchingTiles()) {
                    tileOverrides.put(name, CTMUtils.registerOverride(tileOverrides.get(name), override, "tile " + name));
                    registered = true;
                }
            }
            if (registered) {
                allOverrides.add(override);
            }
        }
    }

    private static ITileOverride[] registerOverride(ITileOverride[] overrides, ITileOverride override, String description) {
        logger.fine("using %s for %s", override, description);
        if (overrides == null) {
            return new ITileOverride[]{override};
        }
        ITileOverride[] newList = new ITileOverride[overrides.length + 1];
        System.arraycopy(overrides, 0, newList, 0, overrides.length);
        newList[overrides.length] = override;
        return newList;
    }

    static {
        try {
            Class.forName("com.prupe.mcpatcher.ctm.RenderPass").getMethod("finish", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Connected Textures", 3){

            @Override
            public void initialize() {
            }

            @Override
            public void beforeChange() {
                RenderPassAPI.instance.clear();
                allOverrides.clear();
                Arrays.fill((Object[])blockOverrides, null);
                tileOverrides.clear();
                tileLoader = new TileLoader("textures/blocks/", true, logger);
                betterGrass = null;
                if (enableStandard || enableNonStandard) {
                    for (ResourceAddress resource : TexturePackAPI.listResources("mcpatcher/ctm", ".properties", true, false, true)) {
                        CTMUtils.registerOverride(TileOverride.create(resource, tileLoader));
                    }
                }
            }

            @Override
            public void afterChange() {
                if (enableGrass) {
                    CTMUtils.registerOverride(betterGrass = new TileOverrideImpl.BetterGrass(tileLoader, 2, "grass"));
                    CTMUtils.registerOverride(new TileOverrideImpl.BetterGrass(tileLoader, 110, "mycel"));
                }
                for (ITileOverride override : allOverrides) {
                    override.registerIcons();
                }
                for (int i = 0; i < blockOverrides.length; ++i) {
                    if (blockOverrides[i] == null || Block.blocksList[i] == null) continue;
                    for (ITileOverride override : blockOverrides[i]) {
                        if (override == null || override.isDisabled() || override.getRenderPass() < 0) continue;
                        RenderPassAPI.instance.setRenderPassForBlock(Block.blocksList[i], override.getRenderPass());
                    }
                }
                for (ITileOverride[] overrides : blockOverrides) {
                    this.sortOverrides(overrides);
                }
                for (ITileOverride[] overrides : tileOverrides.values()) {
                    this.sortOverrides(overrides);
                }
            }

            private void sortOverrides(ITileOverride[] overrides) {
                if (overrides != null) {
                    Arrays.sort(overrides);
                }
            }
        });
    }

    private static abstract class TileOverrideIterator
    implements Iterator<ITileOverride> {
        private final Block block;
        private Icon currentIcon;
        private ITileOverride[] blockOverrides;
        private ITileOverride[] iconOverrides;
        private final Set<ITileOverride> skipOverrides = new HashSet<ITileOverride>();
        private int blockPos;
        private int iconPos;
        private boolean foundNext;
        private ITileOverride nextOverride;
        private ITileOverride lastMatchedOverride;

        TileOverrideIterator(Block block, Icon icon) {
            this.block = block;
            this.currentIcon = icon;
            this.blockOverrides = blockOverrides[block.blockID];
            this.iconOverrides = (ITileOverride[])tileOverrides.get(this.currentIcon.getIconName());
        }

        private void resetForNextPass() {
            this.blockOverrides = null;
            this.iconOverrides = (ITileOverride[])tileOverrides.get(this.currentIcon.getIconName());
            this.blockPos = 0;
            this.iconPos = 0;
            this.foundNext = false;
        }

        @Override
        public boolean hasNext() {
            if (this.foundNext) {
                return true;
            }
            if (this.iconOverrides != null) {
                while (this.iconPos < this.iconOverrides.length) {
                    if (!this.checkOverride(this.iconOverrides[this.iconPos++])) continue;
                    return true;
                }
            }
            if (this.blockOverrides != null) {
                while (this.blockPos < this.blockOverrides.length) {
                    if (!this.checkOverride(this.blockOverrides[this.blockPos++])) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public ITileOverride next() {
            if (!this.foundNext) {
                throw new IllegalStateException("next called before hasNext() == true");
            }
            this.foundNext = false;
            return this.nextOverride;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove not supported");
        }

        private boolean checkOverride(ITileOverride override) {
            if (override != null && !override.isDisabled() && !this.skipOverrides.contains(override)) {
                this.foundNext = true;
                this.nextOverride = override;
                return true;
            }
            return false;
        }

        ITileOverride go() {
            block0: for (int pass = 0; pass < maxRecursion; ++pass) {
                while (this.hasNext()) {
                    ITileOverride override = this.next();
                    Icon newIcon = this.getTile(override, this.block, this.currentIcon);
                    if (newIcon == null) continue;
                    this.lastMatchedOverride = override;
                    this.skipOverrides.add(override);
                    this.currentIcon = newIcon;
                    this.resetForNextPass();
                    continue block0;
                }
                break block0;
            }
            return this.lastMatchedOverride;
        }

        Icon getIcon() {
            return this.currentIcon;
        }

        abstract Icon getTile(ITileOverride var1, Block var2, Icon var3);
    }
}

