/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.TileLoader;
import com.prupe.mcpatcher.cit.ArmorOverride;
import com.prupe.mcpatcher.cit.CITUtils;
import com.prupe.mcpatcher.cit.Enchantment;
import com.prupe.mcpatcher.cit.ItemOverride;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTBase;
import net.minecraft.src.NBTTagByte;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagDouble;
import net.minecraft.src.NBTTagFloat;
import net.minecraft.src.NBTTagInteger;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.NBTTagLong;
import net.minecraft.src.NBTTagShort;
import net.minecraft.src.NBTTagString;
import net.minecraft.src.ResourceAddress;

abstract class OverrideBase
implements Comparable<OverrideBase> {
    static final MCLogger logger = MCLogger.getLogger("Custom Item Textures", "CIT");
    private static final int MAX_DAMAGE = 65535;
    private static final int MAX_STACK_SIZE = 65535;
    final ResourceAddress propertiesName;
    final ResourceAddress textureName;
    final Map<String, ResourceAddress> alternateTextures;
    final int weight;
    final BitSet itemsIDs;
    final BitSet damage;
    final int damageMask;
    final BitSet stackSize;
    final BitSet enchantmentIDs;
    final BitSet enchantmentLevels;
    final List<String[]> nbtRules = new ArrayList<String[]>();
    boolean error;
    int lastEnchantmentLevel;

    static OverrideBase create(ResourceAddress filename) {
        OverrideBase override;
        if (new File(filename.getPath()).getName().equals("cit.properties")) {
            return null;
        }
        Properties properties = TexturePackAPI.getProperties(filename);
        if (properties == null) {
            return null;
        }
        String type = MCPatcherUtils.getStringProperty(properties, "type", "item").toLowerCase();
        if (type.equals("item")) {
            if (!CITUtils.enableItems) {
                return null;
            }
            override = new ItemOverride(filename, properties);
        } else if (type.equals("enchantment") || type.equals("overlay")) {
            if (!CITUtils.enableEnchantments) {
                return null;
            }
            override = new Enchantment(filename, properties);
        } else if (type.equals("armor")) {
            if (!CITUtils.enableArmor) {
                return null;
            }
            override = new ArmorOverride(filename, properties);
        } else {
            logger.error("%s: unknown type '%s'", filename, type);
            return null;
        }
        return override.error ? null : override;
    }

    OverrideBase(ResourceAddress propertiesName, Properties properties) {
        ResourceAddress resource;
        this.propertiesName = propertiesName;
        String value = MCPatcherUtils.getStringProperty(properties, "source", "");
        if (value.equals("")) {
            value = MCPatcherUtils.getStringProperty(properties, "texture", "");
        }
        if (value.equals("")) {
            value = MCPatcherUtils.getStringProperty(properties, "tile", "");
        }
        if (value.equals("")) {
            resource = TileLoader.getDefaultAddress(propertiesName);
            if (!TexturePackAPI.hasResource(resource)) {
                resource = null;
            }
        } else {
            resource = TileLoader.parseTileAddress(propertiesName, value);
            if (!TexturePackAPI.hasResource(resource)) {
                this.error("source texture %s not found", value);
                resource = null;
            }
        }
        this.textureName = resource;
        this.alternateTextures = this.getAlternateTextures(properties);
        this.weight = MCPatcherUtils.getIntProperty(properties, "weight", 0);
        value = MCPatcherUtils.getStringProperty(properties, "items", "");
        if (value.equals("")) {
            value = MCPatcherUtils.getStringProperty(properties, "matchItems", "");
        }
        if (value.equals("")) {
            this.itemsIDs = null;
        } else {
            BitSet ids = OverrideBase.parseBitSet(value, CITUtils.LOWEST_ITEM_ID, CITUtils.HIGHEST_ITEM_ID);
            boolean all = true;
            for (int i = CITUtils.LOWEST_ITEM_ID; i <= CITUtils.HIGHEST_ITEM_ID; ++i) {
                if (Item.itemsList[i] == null || ids.get(i)) continue;
                all = false;
                break;
            }
            this.itemsIDs = all ? null : ids;
        }
        this.damage = OverrideBase.parseBitSet(properties, "damage", 0, 65535);
        this.damageMask = MCPatcherUtils.getIntProperty(properties, "damageMask", 65535);
        this.stackSize = OverrideBase.parseBitSet(properties, "stackSize", 0, 65535);
        this.enchantmentIDs = OverrideBase.parseBitSet(properties, "enchantmentIDs", 0, 255);
        this.enchantmentLevels = OverrideBase.parseBitSet(properties, "enchantmentLevels", 0, 255);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String[] rule;
            String name = (String)entry.getKey();
            value = (String)entry.getValue();
            if (!name.startsWith("nbt.") || (rule = name.split("\\.")).length <= 1) continue;
            rule[0] = value;
            for (int i = 1; i < rule.length; ++i) {
                if (!"*".equals(rule[i])) continue;
                rule[i] = null;
            }
            this.nbtRules.add(rule);
        }
    }

    @Override
    public int compareTo(OverrideBase o) {
        int result = o.weight - this.weight;
        if (result != 0) {
            return result;
        }
        return this.propertiesName.getPath().compareTo(o.propertiesName.getPath());
    }

    boolean match(ItemStack itemStack, int[] itemEnchantmentLevels, boolean hasEffect) {
        return this.matchDamage(itemStack) && this.matchStackSize(itemStack) && this.matchEnchantment(itemEnchantmentLevels, hasEffect) && this.matchNBT(itemStack);
    }

    private Map<String, ResourceAddress> getAlternateTextures(Properties properties) {
        HashMap<String, ResourceAddress> tmpMap = new HashMap<String, ResourceAddress>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            ResourceAddress resource;
            String name;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (key.startsWith("source.")) {
                name = key.substring(7);
            } else if (key.startsWith("texture.")) {
                name = key.substring(8);
            } else {
                if (!key.startsWith("tile.")) continue;
                name = key.substring(5);
            }
            if ((resource = TileLoader.parseTileAddress(this.propertiesName, value)) == null) continue;
            tmpMap.put(name, resource);
        }
        return tmpMap.isEmpty() ? null : tmpMap;
    }

    private boolean matchDamage(ItemStack itemStack) {
        return this.damage == null || this.damage.get(itemStack.getItemDamage() & this.damageMask);
    }

    private boolean matchStackSize(ItemStack itemStack) {
        return this.stackSize == null || this.stackSize.get(itemStack.stackSize);
    }

    private boolean matchEnchantment(int[] itemEnchantmentLevels, boolean hasEffect) {
        if (this.enchantmentLevels == null && this.enchantmentIDs == null) {
            return true;
        }
        if (itemEnchantmentLevels == null) {
            this.lastEnchantmentLevel = this.getEnchantmentLevelMatch(hasEffect);
            return this.lastEnchantmentLevel >= 0;
        }
        this.lastEnchantmentLevel = this.getEnchantmentLevelMatch(itemEnchantmentLevels);
        return this.lastEnchantmentLevel >= 0;
    }

    private int getEnchantmentLevelMatch(boolean hasEffect) {
        if (hasEffect && this.enchantmentIDs == null && this.enchantmentLevels.get(1)) {
            return 1;
        }
        return -1;
    }

    private int getEnchantmentLevelMatch(int[] itemEnchantmentLevels) {
        int matchLevel = -1;
        if (this.enchantmentIDs == null) {
            int sum = 0;
            for (int level : itemEnchantmentLevels) {
                sum += level;
            }
            if (this.enchantmentLevels.get(sum)) {
                return sum;
            }
        } else if (this.enchantmentLevels == null) {
            int id = this.enchantmentIDs.nextSetBit(0);
            while (id >= 0) {
                if (itemEnchantmentLevels[id] > 0) {
                    matchLevel = Math.max(matchLevel, itemEnchantmentLevels[id]);
                }
                id = this.enchantmentIDs.nextSetBit(id + 1);
            }
        } else {
            int id = this.enchantmentIDs.nextSetBit(0);
            while (id >= 0) {
                if (this.enchantmentLevels.get(itemEnchantmentLevels[id])) {
                    matchLevel = Math.max(matchLevel, itemEnchantmentLevels[id]);
                }
                id = this.enchantmentIDs.nextSetBit(id + 1);
            }
        }
        return matchLevel;
    }

    private boolean matchNBT(ItemStack itemStack) {
        for (String[] rule : this.nbtRules) {
            if (OverrideBase.matchNBTTagCompound(rule, 1, rule[0], itemStack.stackTagCompound)) continue;
            return false;
        }
        return true;
    }

    abstract String getType();

    public String toString() {
        return String.format("ItemOverride{%s, %s, %s}", this.getType(), this.propertiesName, this.textureName);
    }

    void error(String format, Object ... o) {
        this.error = true;
        logger.error(this.propertiesName + ": " + format, o);
    }

    private static BitSet parseBitSet(Properties properties, String tag, int min, int max) {
        String value = MCPatcherUtils.getStringProperty(properties, tag, "");
        return OverrideBase.parseBitSet(value, min, max);
    }

    private static BitSet parseBitSet(String value, int min, int max) {
        if (value.equals("")) {
            return null;
        }
        BitSet bits = new BitSet();
        for (int i : MCPatcherUtils.parseIntegerList(value, min, max)) {
            bits.set(i);
        }
        return bits;
    }

    private static boolean matchNBT(String[] rule, int index, String value, NBTBase nbt) {
        if (nbt instanceof NBTTagByte) {
            return OverrideBase.matchNBTTagByte(rule, index, value, (NBTTagByte)nbt);
        }
        if (nbt instanceof NBTTagCompound) {
            return OverrideBase.matchNBTTagCompound(rule, index, value, (NBTTagCompound)nbt);
        }
        if (nbt instanceof NBTTagList) {
            return OverrideBase.matchNBTTagList(rule, index, value, (NBTTagList)nbt);
        }
        if (nbt instanceof NBTTagDouble) {
            return OverrideBase.matchNBTTagDouble(rule, index, value, (NBTTagDouble)nbt);
        }
        if (nbt instanceof NBTTagFloat) {
            return OverrideBase.matchNBTTagFloat(rule, index, value, (NBTTagFloat)nbt);
        }
        if (nbt instanceof NBTTagInteger) {
            return OverrideBase.matchNBTTagInteger(rule, index, value, (NBTTagInteger)nbt);
        }
        if (nbt instanceof NBTTagLong) {
            return OverrideBase.matchNBTTagLong(rule, index, value, (NBTTagLong)nbt);
        }
        if (nbt instanceof NBTTagShort) {
            return OverrideBase.matchNBTTagShort(rule, index, value, (NBTTagShort)nbt);
        }
        if (nbt instanceof NBTTagString) {
            return OverrideBase.matchNBTTagString(rule, index, value, (NBTTagString)nbt);
        }
        return false;
    }

    private static boolean matchNBTTagCompound(String[] rule, int index, String value, NBTTagCompound nbt) {
        if (nbt == null || index >= rule.length) {
            return false;
        }
        if (rule[index] == null) {
            for (NBTBase nbtBase : nbt.getTags()) {
                if (!OverrideBase.matchNBT(rule, index + 1, value, nbtBase)) continue;
                return true;
            }
        } else {
            return OverrideBase.matchNBT(rule, index + 1, value, nbt.getTag(rule[index]));
        }
        return false;
    }

    private static boolean matchNBTTagList(String[] rule, int index, String value, NBTTagList nbt) {
        if (index >= rule.length) {
            return false;
        }
        if (rule[index] == null) {
            for (int i = 0; i < nbt.tagCount(); ++i) {
                if (!OverrideBase.matchNBT(rule, index + 1, value, nbt.tagAt(i))) continue;
                return true;
            }
        } else {
            try {
                int tagNum = Integer.parseInt(rule[index]);
                return tagNum >= 0 && tagNum < nbt.tagCount() && OverrideBase.matchNBT(rule, index + 1, value, nbt.tagAt(tagNum));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean matchNBTTagByte(String[] rule, int index, String value, NBTTagByte nbt) {
        try {
            return nbt.data == Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean matchNBTTagDouble(String[] rule, int index, String value, NBTTagDouble nbt) {
        try {
            return nbt.data == Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean matchNBTTagFloat(String[] rule, int index, String value, NBTTagFloat nbt) {
        try {
            return nbt.data == Float.parseFloat(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean matchNBTTagInteger(String[] rule, int index, String value, NBTTagInteger nbt) {
        try {
            return nbt.data == Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean matchNBTTagLong(String[] rule, int index, String value, NBTTagLong nbt) {
        try {
            return nbt.data == Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean matchNBTTagShort(String[] rule, int index, String value, NBTTagShort nbt) {
        try {
            return nbt.data == Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean matchNBTTagString(String[] rule, int index, String value, NBTTagString nbt) {
        return value.equals(nbt.data);
    }
}

