/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.TexturePackChangeHandler;
import com.prupe.mcpatcher.TileLoader;
import com.prupe.mcpatcher.cit.ArmorOverride;
import com.prupe.mcpatcher.cit.Enchantment;
import com.prupe.mcpatcher.cit.EnchantmentList;
import com.prupe.mcpatcher.cit.ItemOverride;
import com.prupe.mcpatcher.cit.OverrideBase;
import com.prupe.mcpatcher.cit.PotionReplacer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityLivingSub;
import net.minecraft.src.EntityPotion;
import net.minecraft.src.Icon;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTBase;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.ResourceAddress;
import net.minecraft.src.Tessellator;

public class CITUtils {
    private static final MCLogger logger = MCLogger.getLogger("Custom Item Textures", "CIT");
    static final String CIT_PROPERTIES = "cit.properties";
    private static final ResourceAddress CIT_PROPERTIES1 = TexturePackAPI.newMCPatcherResourceAddress("cit.properties");
    private static final ResourceAddress CIT_PROPERTIES2 = TexturePackAPI.newMCPatcherResourceAddress("cit/cit.properties");
    private static final int MAX_ITEMS = Item.itemsList.length;
    static final int MAX_ENCHANTMENTS = 256;
    static int LOWEST_ITEM_ID;
    static int HIGHEST_ITEM_ID;
    static final Map<String, Integer> itemNameMap;
    private static final int ITEM_ID_ENCHANTED_BOOK = 403;
    static final boolean enableItems;
    static final boolean enableEnchantments;
    static final boolean enableArmor;
    private static TileLoader tileLoader;
    private static final ItemOverride[][] items;
    private static final Enchantment[][] enchantments;
    private static final ArmorOverride[][] armors;
    private static boolean useGlint;
    private static EnchantmentList armorMatches;
    private static int armorMatchIndex;
    private static int lastRenderPass;
    private static Icon lastIcon;
    private static Field potionItemStackField;

    public static void init() {
    }

    public static Icon getIcon(Icon icon, ItemStack itemStack, int renderPass) {
        Icon newIcon;
        ItemOverride override;
        lastRenderPass = renderPass;
        lastIcon = icon;
        if (enableItems && (override = (ItemOverride)CITUtils.findMatch((OverrideBase[][])items, (ItemStack)itemStack)) != null && (newIcon = override.getReplacementIcon(icon)) != null) {
            lastIcon = newIcon;
        }
        return lastIcon;
    }

    public static Icon getEntityIcon(Icon icon, Entity entity) {
        if (entity instanceof EntityPotion && potionItemStackField != null) {
            try {
                return CITUtils.getIcon(icon, (ItemStack)potionItemStackField.get(entity), 1);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                potionItemStackField = null;
            }
        }
        return icon;
    }

    public static ResourceAddress getArmorTexture(ResourceAddress texture, EntityLiving entity, ItemStack itemStack) {
        ResourceAddress newTexture;
        ArmorOverride override;
        if (enableArmor && (override = (ArmorOverride)CITUtils.findMatch((OverrideBase[][])armors, (ItemStack)itemStack)) != null && (newTexture = override.getReplacementTexture(texture)) != null) {
            return newTexture;
        }
        return texture;
    }

    private static <T extends OverrideBase> T findMatch(T[][] overrides, ItemStack itemStack) {
        int itemID = itemStack.itemID;
        if (itemID >= 0 && itemID < overrides.length && overrides[itemID] != null) {
            int[] enchantmentLevels = CITUtils.getEnchantmentLevels(itemID, itemStack.stackTagCompound);
            boolean hasEffect = itemStack.hasEffect();
            for (T override : overrides[itemID]) {
                if (!((OverrideBase)override).match(itemStack, enchantmentLevels, hasEffect)) continue;
                return override;
            }
        }
        return null;
    }

    public static boolean renderEnchantmentHeld(ItemStack itemStack, int renderPass) {
        int width;
        int height;
        if (itemStack == null || renderPass != 0) {
            return true;
        }
        if (!enableEnchantments) {
            return false;
        }
        EnchantmentList matches = new EnchantmentList(enchantments, itemStack);
        if (matches.isEmpty()) {
            return !useGlint;
        }
        if (lastIcon == null) {
            height = 256;
            width = 256;
        } else {
            width = lastIcon.getWidth();
            height = lastIcon.getHeight();
        }
        Enchantment.beginOuter3D();
        for (int i = 0; i < matches.size(); ++i) {
            matches.getEnchantment(i).render3D(Tessellator.instance, matches.getIntensity(i), width, height);
        }
        Enchantment.endOuter3D();
        return !useGlint;
    }

    public static boolean renderEnchantmentDropped(ItemStack itemStack) {
        return CITUtils.renderEnchantmentHeld(itemStack, lastRenderPass);
    }

    public static boolean renderEnchantmentGUI(ItemStack itemStack, int x, int y, float z) {
        if (!enableEnchantments || itemStack == null) {
            return false;
        }
        EnchantmentList matches = new EnchantmentList(enchantments, itemStack);
        if (matches.isEmpty()) {
            return !useGlint;
        }
        Enchantment.beginOuter2D();
        for (int i = 0; i < matches.size(); ++i) {
            matches.getEnchantment(i).render2D(Tessellator.instance, matches.getIntensity(i), x - 2, y - 2, x + 18, y + 18, z - 50.0f);
        }
        Enchantment.endOuter2D();
        return !useGlint;
    }

    public static boolean setupArmorEnchantments(EntityLiving entity, int pass) {
        if (!enableEnchantments || !(entity instanceof EntityLivingSub)) {
            return false;
        }
        ItemStack itemStack = ((EntityLivingSub)entity).getCurrentArmor(3 - pass);
        if (itemStack == null) {
            return false;
        }
        armorMatches = new EnchantmentList(enchantments, itemStack);
        armorMatchIndex = 0;
        return !armorMatches.isEmpty();
    }

    public static boolean preRenderArmorEnchantment() {
        if (armorMatchIndex < armorMatches.size()) {
            Enchantment enchantment = armorMatches.getEnchantment(armorMatchIndex);
            enchantment.beginArmor(armorMatches.getIntensity(armorMatchIndex));
            return true;
        }
        armorMatches = null;
        armorMatchIndex = 0;
        return false;
    }

    public static void postRenderArmorEnchantment() {
        armorMatches.getEnchantment(armorMatchIndex).endArmor();
        ++armorMatchIndex;
    }

    static String getItemName(int itemID) {
        String name;
        Item item;
        if (itemID >= 0 && itemID < Item.itemsList.length && (item = Item.itemsList[itemID]) != null && (name = item.getItemName()) != null) {
            return name;
        }
        return "unknown item " + itemID;
    }

    static int[] getEnchantmentLevels(int itemID, NBTTagCompound nbt) {
        NBTBase base;
        int[] levels = null;
        if (nbt != null && (base = itemID == 403 ? nbt.getTag("StoredEnchantments") : nbt.getTag("ench")) instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)base;
            for (int i = 0; i < list.tagCount(); ++i) {
                base = list.tagAt(i);
                if (!(base instanceof NBTTagCompound)) continue;
                short id = ((NBTTagCompound)base).getShort("id");
                short level = ((NBTTagCompound)base).getShort("lvl");
                if (id < 0 || id >= 256 || level <= 0) continue;
                if (levels == null) {
                    levels = new int[256];
                }
                short s = id;
                levels[s] = levels[s] + level;
            }
        }
        return levels;
    }

    static {
        itemNameMap = new HashMap<String, Integer>();
        enableItems = Config.getBoolean("Custom Item Textures", "items", true);
        enableEnchantments = Config.getBoolean("Custom Item Textures", "enchantments", true);
        enableArmor = Config.getBoolean("Custom Item Textures", "armor", true);
        items = new ItemOverride[MAX_ITEMS][];
        enchantments = new Enchantment[MAX_ITEMS][];
        armors = new ArmorOverride[MAX_ITEMS][];
        for (Field f : EntityPotion.class.getDeclaredFields()) {
            if (!ItemStack.class.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            potionItemStackField = f;
            break;
        }
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Custom Item Textures", 3){

            @Override
            public void beforeChange() {
                Properties properties;
                tileLoader = new TileLoader("textures/items/", false, logger);
                Arrays.fill((Object[])items, null);
                Arrays.fill((Object[])enchantments, null);
                Arrays.fill((Object[])armors, null);
                lastIcon = null;
                itemNameMap.clear();
                for (LOWEST_ITEM_ID = 256; LOWEST_ITEM_ID < MAX_ITEMS && Item.itemsList[LOWEST_ITEM_ID] == null; ++LOWEST_ITEM_ID) {
                }
                for (HIGHEST_ITEM_ID = MAX_ITEMS - 1; HIGHEST_ITEM_ID >= 0 && Item.itemsList[HIGHEST_ITEM_ID] == null; --HIGHEST_ITEM_ID) {
                }
                if (LOWEST_ITEM_ID <= HIGHEST_ITEM_ID) {
                    for (int i = LOWEST_ITEM_ID; i <= HIGHEST_ITEM_ID; ++i) {
                        String name;
                        Item item = Item.itemsList[i];
                        if (item == null || (name = item.getItemName()) == null) continue;
                        itemNameMap.put(name, i);
                    }
                    logger.fine("%d items, lowest used item id is %d (%s), highest is %d (%s)", itemNameMap.size(), LOWEST_ITEM_ID, CITUtils.getItemName(LOWEST_ITEM_ID), HIGHEST_ITEM_ID, CITUtils.getItemName(HIGHEST_ITEM_ID));
                }
                if ((properties = TexturePackAPI.getProperties(CIT_PROPERTIES1)) == null) {
                    properties = TexturePackAPI.getProperties(CIT_PROPERTIES2);
                }
                useGlint = MCPatcherUtils.getBooleanProperty(properties, "useGlint", true);
                EnchantmentList.setProperties(properties);
                if (enableItems || enableEnchantments || enableArmor) {
                    for (ResourceAddress resource : TexturePackAPI.listResources("mcpatcher/cit", ".properties", true, false, true)) {
                        this.registerOverride(OverrideBase.create(resource));
                    }
                    if (enableItems) {
                        PotionReplacer replacer = new PotionReplacer();
                        for (ItemOverride override : replacer.overrides) {
                            this.registerOverride(override);
                        }
                    }
                }
            }

            @Override
            public void afterChange() {
                for (ItemOverride[] overrides1 : items) {
                    if (overrides1 == null) continue;
                    for (ItemOverride override : overrides1) {
                        override.registerIcon(tileLoader);
                    }
                }
                this.sortOverrides(items);
                this.sortOverrides(enchantments);
                this.sortOverrides(armors);
            }

            private void registerOverride(OverrideBase override) {
                block13: {
                    OverrideBase[][] list;
                    if (override == null || override.error) break block13;
                    if (override instanceof ItemOverride) {
                        ((ItemOverride)override).preload(tileLoader);
                        list = items;
                    } else if (override instanceof Enchantment) {
                        list = enchantments;
                    } else if (override instanceof ArmorOverride) {
                        list = armors;
                    } else {
                        logger.severe("unknown ItemOverride type %d", override.getClass().getName());
                        return;
                    }
                    if (override.itemsIDs == null) {
                        logger.fine("registered %s to all items", override);
                        for (int i = LOWEST_ITEM_ID; i <= HIGHEST_ITEM_ID; ++i) {
                            this.registerOverride(list, i, override);
                        }
                    } else {
                        int j = 0;
                        int i = override.itemsIDs.nextSetBit(0);
                        while (i >= 0) {
                            this.registerOverride(list, i, override);
                            if (j < 10) {
                                logger.fine("registered %s to item %d (%s)", override, i, CITUtils.getItemName(i));
                            } else if (j == 10) {
                                logger.fine("... %d total", override.itemsIDs.cardinality());
                            }
                            ++j;
                            i = override.itemsIDs.nextSetBit(i + 1);
                        }
                    }
                }
            }

            private void registerOverride(OverrideBase[][] list, int itemID, OverrideBase override) {
                if (Item.itemsList[itemID] != null) {
                    Class<OverrideBase> overrideClass = list.getClass().getComponentType().getComponentType().asSubclass(OverrideBase.class);
                    list[itemID] = this.registerOverride(list[itemID], override, overrideClass);
                }
            }

            private OverrideBase[] registerOverride(OverrideBase[] list, OverrideBase override, Class<? extends OverrideBase> overrideClass) {
                if (override != null) {
                    if (!overrideClass.isAssignableFrom(override.getClass())) {
                        logger.severe("unexpected class %s in %s array", override.getClass().getName(), overrideClass.getSimpleName());
                    } else if (list == null) {
                        list = (OverrideBase[])Array.newInstance(overrideClass, 1);
                        list[0] = override;
                    } else {
                        OverrideBase[] newList = (OverrideBase[])Array.newInstance(overrideClass, list.length + 1);
                        System.arraycopy(list, 0, newList, 0, list.length);
                        newList[list.length] = override;
                        list = newList;
                    }
                }
                return list;
            }

            private void sortOverrides(OverrideBase[][] overrides) {
                for (Object[] objectArray : overrides) {
                    if (objectArray == null) continue;
                    Arrays.sort(objectArray);
                }
            }
        });
    }
}

