/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.TexturePackChangeHandler;
import com.prupe.mcpatcher.cc.ColorMap;
import com.prupe.mcpatcher.cc.ColorizeBlock;
import com.prupe.mcpatcher.cc.ColorizeEntity;
import com.prupe.mcpatcher.cc.ColorizeItem;
import com.prupe.mcpatcher.cc.ColorizeWorld;
import com.prupe.mcpatcher.cc.Lightmap;
import java.util.Properties;
import net.minecraft.src.Potion;
import net.minecraft.src.ResourceAddress;

public class Colorizer {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    static final ResourceAddress COLOR_PROPERTIES = TexturePackAPI.newMCPatcherResourceAddress("color.properties");
    private static Properties properties;
    static final boolean useWaterColors;
    static final boolean useSwampColors;
    static final boolean useTreeColors;
    static final boolean usePotionColors;
    static final boolean useParticleColors;
    static final boolean useFogColors;
    static final boolean useCloudType;
    static final boolean useRedstoneColors;
    static final boolean useStemColors;
    static final boolean useMapColors;
    static final boolean useDyeColors;
    static final boolean useBlockColors;
    static final boolean useTextColors;
    static final boolean useXPOrbColors;
    static final boolean useEggColors;
    public static final int COLOR_MAP_SWAMP_GRASS = 0;
    public static final int COLOR_MAP_SWAMP_FOLIAGE = 1;
    public static final int COLOR_MAP_PINE = 2;
    public static final int COLOR_MAP_BIRCH = 3;
    public static final int COLOR_MAP_FOLIAGE = 4;
    public static final int COLOR_MAP_WATER = 5;
    public static final int COLOR_MAP_UNDERWATER = 6;
    public static final int COLOR_MAP_FOG0 = 7;
    public static final int COLOR_MAP_SKY0 = 8;
    public static final int NUM_FIXED_COLOR_MAPS = 9;
    static final ColorMap[] fixedColorMaps;
    public static final float[] setColor;

    public static void setColorF(int color) {
        Colorizer.intToFloat3(color, setColor);
    }

    private static void reset() {
        properties = new Properties();
        ColorizeBlock.reset();
        Lightmap.reset();
        ColorizeItem.reset();
        ColorizeWorld.reset();
        ColorizeEntity.reset();
    }

    private static void reloadColorProperties() {
        if (TexturePackAPI.getProperties(COLOR_PROPERTIES, properties)) {
            logger.finer("reloading %s", COLOR_PROPERTIES);
        }
    }

    static String getStringKey(String[] keys, int index) {
        if (keys != null && index >= 0 && index < keys.length && keys[index] != null) {
            return keys[index];
        }
        return "" + index;
    }

    static void loadIntColor(String key, Potion potion) {
        potion.color = Colorizer.loadIntColor(key, potion.color);
    }

    static boolean loadIntColor(String key, int[] color, int index) {
        logger.config("%s=%06x", key, color[index]);
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                color[index] = Integer.parseInt(value, 16);
                return true;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return false;
    }

    static int loadIntColor(String key, int color) {
        logger.config("%s=%06x", key, color);
        String value = properties.getProperty(key, "");
        if (!value.equals("")) {
            try {
                return Integer.parseInt(value, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    static void loadFloatColor(String key, float[] color) {
        int intColor = Colorizer.float3ToInt(color);
        Colorizer.intToFloat3(Colorizer.loadIntColor(key, intColor), color);
    }

    static void intToFloat3(int rgb, float[] f, int offset) {
        if ((rgb & 0xFFFFFF) == 0xFFFFFF) {
            f[offset + 2] = 1.0f;
            f[offset + 1] = 1.0f;
            f[offset] = 1.0f;
        } else {
            f[offset] = (float)(rgb & 0xFF0000) / 1.671168E7f;
            f[offset + 1] = (float)(rgb & 0xFF00) / 65280.0f;
            f[offset + 2] = (float)(rgb & 0xFF) / 255.0f;
        }
    }

    static void intToFloat3(int rgb, float[] f) {
        Colorizer.intToFloat3(rgb, f, 0);
    }

    static int float3ToInt(float[] f, int offset) {
        return (int)(255.0f * f[offset]) << 16 | (int)(255.0f * f[offset + 1]) << 8 | (int)(255.0f * f[offset + 2]);
    }

    static int float3ToInt(float[] f) {
        return Colorizer.float3ToInt(f, 0);
    }

    static float clamp(float f) {
        if (f < 0.0f) {
            return 0.0f;
        }
        if (f > 1.0f) {
            return 1.0f;
        }
        return f;
    }

    static double clamp(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        if (d > 1.0) {
            return 1.0;
        }
        return d;
    }

    static void clamp(float[] f) {
        for (int i = 0; i < f.length; ++i) {
            f[i] = Colorizer.clamp(f[i]);
        }
    }

    static {
        useWaterColors = Config.getBoolean("Custom Colors", "water", true);
        useSwampColors = Config.getBoolean("Custom Colors", "swamp", true);
        useTreeColors = Config.getBoolean("Custom Colors", "tree", true);
        usePotionColors = Config.getBoolean("Custom Colors", "potion", true);
        useParticleColors = Config.getBoolean("Custom Colors", "particle", true);
        useFogColors = Config.getBoolean("Custom Colors", "fog", true);
        useCloudType = Config.getBoolean("Custom Colors", "clouds", true);
        useRedstoneColors = Config.getBoolean("Custom Colors", "redstone", true);
        useStemColors = Config.getBoolean("Custom Colors", "stem", true);
        useMapColors = Config.getBoolean("Custom Colors", "map", true);
        useDyeColors = Config.getBoolean("Custom Colors", "dye", true);
        useBlockColors = Config.getBoolean("Custom Colors", "otherBlocks", true);
        useTextColors = Config.getBoolean("Custom Colors", "text", true);
        useXPOrbColors = Config.getBoolean("Custom Colors", "xporb", true);
        useEggColors = Config.getBoolean("Custom Colors", "egg", true);
        fixedColorMaps = new ColorMap[9];
        setColor = new float[3];
        try {
            Colorizer.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Custom Colors", 2){

            @Override
            public void beforeChange() {
                Colorizer.reset();
            }

            @Override
            public void afterChange() {
                Colorizer.reloadColorProperties();
                ColorizeBlock.reloadColorMaps(properties);
                if (useFogColors) {
                    ColorizeWorld.reloadFogColors(properties);
                }
                if (usePotionColors) {
                    ColorizeItem.reloadPotionColors(properties);
                }
                if (useSwampColors) {
                    ColorizeBlock.reloadSwampColors(properties);
                }
                if (useBlockColors) {
                    ColorizeBlock.reloadBlockColors(properties);
                }
                if (useParticleColors) {
                    ColorizeEntity.reloadParticleColors(properties);
                }
                if (useRedstoneColors) {
                    ColorizeBlock.reloadRedstoneColors(properties);
                }
                if (useStemColors) {
                    ColorizeBlock.reloadStemColors(properties);
                }
                if (useCloudType) {
                    ColorizeWorld.reloadCloudType(properties);
                }
                if (useMapColors) {
                    ColorizeItem.reloadMapColors(properties);
                }
                if (useDyeColors) {
                    ColorizeEntity.reloadDyeColors(properties);
                }
                if (useTextColors) {
                    ColorizeWorld.reloadTextColors(properties);
                }
                if (useXPOrbColors) {
                    ColorizeEntity.reloadXPOrbColors(properties);
                }
            }
        });
    }
}

