/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cc;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.cc.ColorMap;
import com.prupe.mcpatcher.cc.ColorizeBlock;
import com.prupe.mcpatcher.cc.Colorizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Entity;
import net.minecraft.src.World;

public class ColorizeWorld {
    private static final MCLogger logger = MCLogger.getLogger("Custom Colors");
    private static final int fogBlendRadius = Config.getInt("Custom Colors", "fogBlendRadius", 7);
    private static final float fogBlendScale = (float)Math.pow(2 * fogBlendRadius + 1, -2.0);
    private static final String TEXT_KEY = "text.";
    private static final String TEXT_CODE_KEY = "text.code.";
    private static final int CLOUDS_DEFAULT = 0;
    private static final int CLOUDS_FAST = 1;
    private static final int CLOUDS_FANCY = 2;
    private static int cloudType = 0;
    private static final List<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();
    private static boolean biomesLogged;
    private static Entity fogCamera;
    private static final Map<Integer, Integer> textColorMap;
    private static final int[] textCodeColors;
    private static final boolean[] textCodeColorSet;
    private static int signTextColor;
    public static float[] netherFogColor;
    public static float[] endFogColor;
    public static int endSkyColor;

    static void reset() {
        netherFogColor = new float[]{0.2f, 0.03f, 0.03f};
        endFogColor = new float[]{0.075f, 0.075f, 0.094f};
        endSkyColor = 0x181818;
        cloudType = 0;
        textColorMap.clear();
        for (int i = 0; i < textCodeColorSet.length; ++i) {
            ColorizeWorld.textCodeColorSet[i] = false;
        }
        signTextColor = 0;
    }

    static void reloadFogColors(Properties properties) {
        Colorizer.loadFloatColor("fog.nether", netherFogColor);
        Colorizer.loadFloatColor("fog.end", endFogColor);
        endSkyColor = Colorizer.loadIntColor("sky.end", endSkyColor);
    }

    static void reloadCloudType(Properties properties) {
        String value = properties.getProperty("clouds", "").trim().toLowerCase();
        if (value.equals("fast")) {
            cloudType = 1;
        } else if (value.equals("fancy")) {
            cloudType = 2;
        }
    }

    static void reloadTextColors(Properties properties) {
        for (int i = 0; i < textCodeColors.length; ++i) {
            ColorizeWorld.textCodeColorSet[i] = Colorizer.loadIntColor(TEXT_CODE_KEY + i, textCodeColors, i);
            if (!textCodeColorSet[i] || i + 16 >= textCodeColors.length) continue;
            ColorizeWorld.textCodeColors[i + 16] = (textCodeColors[i] & 0xFCFCFC) >> 2;
            ColorizeWorld.textCodeColorSet[i + 16] = true;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!key.startsWith(TEXT_KEY) || key.startsWith(TEXT_CODE_KEY)) continue;
            key = key.substring(TEXT_KEY.length()).trim();
            try {
                int oldColor = key.equals("xpbar") ? 8453920 : (key.equals("boss") ? 0xFF00FF : Integer.parseInt(key, 16));
                int newColor = Integer.parseInt(value, 16);
                textColorMap.put(oldColor, newColor);
            }
            catch (NumberFormatException e) {}
        }
        signTextColor = Colorizer.loadIntColor("text.sign", 0);
    }

    public static void setupBiome(BiomeGenBase biome) {
        biomes.add(biome);
    }

    public static void setupForFog(Entity entity) {
        fogCamera = entity;
        if (!biomesLogged) {
            biomesLogged = true;
            for (BiomeGenBase biome : biomes) {
                int x = ColorMap.getX(biome.temperature, biome.rainfall);
                int y = ColorMap.getY(biome.temperature, biome.rainfall);
                logger.finer("setupBiome #%d \"%s\" %06x (%d,%d)", biome.biomeID, biome.biomeName, biome.waterColorMultiplier, x, y);
            }
        }
    }

    public static boolean computeFogColor(int index) {
        if (index < 0 || index >= Colorizer.fixedColorMaps.length || fogCamera == null || !Colorizer.fixedColorMaps[index].isCustom()) {
            return false;
        }
        float[] f = new float[3];
        int x = (int)ColorizeWorld.fogCamera.posX;
        int y = (int)ColorizeWorld.fogCamera.posY;
        int z = (int)ColorizeWorld.fogCamera.posZ;
        Colorizer.setColor[0] = 0.0f;
        Colorizer.setColor[1] = 0.0f;
        Colorizer.setColor[2] = 0.0f;
        for (int i = -fogBlendRadius; i <= fogBlendRadius; ++i) {
            for (int j = -fogBlendRadius; j <= fogBlendRadius; ++j) {
                int rgb = ColorizeBlock.colorizeBiome(0xFFFFFF, index, x + i, y, z + j);
                Colorizer.intToFloat3(rgb, f);
                Colorizer.setColor[0] = Colorizer.setColor[0] + f[0];
                Colorizer.setColor[1] = Colorizer.setColor[1] + f[1];
                Colorizer.setColor[2] = Colorizer.setColor[2] + f[2];
            }
        }
        Colorizer.setColor[0] = Colorizer.setColor[0] * fogBlendScale;
        Colorizer.setColor[1] = Colorizer.setColor[1] * fogBlendScale;
        Colorizer.setColor[2] = Colorizer.setColor[2] * fogBlendScale;
        return true;
    }

    public static boolean computeFogColor(World world, float f) {
        if (world.worldProvider.worldType == 0 && ColorizeWorld.computeFogColor(7)) {
            ColorizeWorld.computeLightningFlash(world, f);
            return true;
        }
        return false;
    }

    public static boolean computeSkyColor(World world, float f) {
        if (world.worldProvider.worldType == 0 && ColorizeWorld.computeFogColor(8)) {
            ColorizeWorld.computeLightningFlash(world, f);
            return true;
        }
        return false;
    }

    private static void computeLightningFlash(World world, float f) {
        if (world.lightningFlash > 0) {
            f = 0.45f * Colorizer.clamp((float)world.lightningFlash - f);
            Colorizer.setColor[0] = Colorizer.setColor[0] * (1.0f - f) + 0.8f * f;
            Colorizer.setColor[1] = Colorizer.setColor[1] * (1.0f - f) + 0.8f * f;
            Colorizer.setColor[2] = Colorizer.setColor[2] * (1.0f - f) + 0.8f * f;
        }
    }

    public static boolean drawFancyClouds(boolean fancyGraphics) {
        switch (cloudType) {
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return fancyGraphics;
    }

    public static int colorizeText(int defaultColor) {
        int high = defaultColor & 0xFF000000;
        Integer newColor = textColorMap.get(defaultColor &= 0xFFFFFF);
        if (newColor == null) {
            return high | defaultColor;
        }
        return high | newColor;
    }

    public static int colorizeText(int defaultColor, int index) {
        if (index < 0 || index >= textCodeColors.length || !textCodeColorSet[index]) {
            return defaultColor;
        }
        return defaultColor & 0xFF000000 | textCodeColors[index];
    }

    public static int colorizeSignText() {
        return signTextColor;
    }

    static {
        textColorMap = new HashMap<Integer, Integer>();
        textCodeColors = new int[32];
        textCodeColorSet = new boolean[32];
        try {
            ColorizeWorld.reset();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

