/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;

class Util {
    static int bits;

    Util() {
    }

    static byte b(int value, int index) {
        return (byte)(value >> index * 8 & 0xFF);
    }

    static byte[] marshal16(int value) {
        return new byte[]{Util.b(value, 1), Util.b(value, 0)};
    }

    static byte[] marshalString(String value) {
        byte[] bytes = value.getBytes();
        int len = bytes.length;
        ByteArrayOutputStream bos = new ByteArrayOutputStream(len + 2);
        try {
            bos.write(Util.marshal16(len));
            bos.write(bytes);
        }
        catch (IOException e) {
            Logger.log(e);
        }
        return bos.toByteArray();
    }

    static int demarshal(byte[] data, int offset, int length) {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result <<= 8;
            result |= data[i + offset] & 0xFF;
        }
        return result;
    }

    static int demarshal(byte[] data) {
        return Util.demarshal(data, 0, data.length);
    }

    static void copyStream(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] buffer = new byte[1024];
        while ((count = input.read(buffer)) >= 0) {
            output.write(buffer, 0, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyFile(File input, File output) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(input);
            os = new FileOutputStream(output);
            Util.copyStream(is, os);
        }
        catch (Throwable throwable) {
            MCPatcherUtils.close(is);
            MCPatcherUtils.close(os);
            throw throwable;
        }
        MCPatcherUtils.close(is);
        MCPatcherUtils.close(os);
    }

    static boolean contains(byte[] array, int item) {
        byte itemb = (byte)item;
        for (byte b : array) {
            if (itemb != b) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String computeMD5(File file) {
        String md5;
        block5: {
            md5 = null;
            FileInputStream input = null;
            ByteArrayOutputStream output = null;
            DigestOutputStream dos = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                input = new FileInputStream(file);
                output = new ByteArrayOutputStream();
                dos = new DigestOutputStream(output, md);
                Util.copyStream(input, dos);
                MCPatcherUtils.close(dos);
                md5 = BinaryRegex.binToStr(md.digest()).replaceAll(" ", "");
                MCPatcherUtils.close(input);
            }
            catch (Exception e) {
                Logger.log(e);
                break block5;
            }
            finally {
                MCPatcherUtils.close(input);
                MCPatcherUtils.close(dos);
                MCPatcherUtils.close(output);
            }
            MCPatcherUtils.close(dos);
            MCPatcherUtils.close(output);
        }
        return md5;
    }

    static void logOSInfo() {
        String bitString;
        Logger.log(0, "MCPatcher version is %s", MCPatcher.VERSION_STRING);
        Logger.log(0, "OS: %s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        try {
            bits = Integer.parseInt(System.getProperty("sun.arch.data.model"));
            bitString = String.format(" (%d bit)", bits);
        }
        catch (Throwable e) {
            bits = 0;
            bitString = "";
        }
        Logger.log(0, "JVM: %s %s%s", System.getProperty("java.vendor"), System.getProperty("java.version"), bitString);
        Logger.log(0, "Classpath: %s", System.getProperty("java.class.path"));
    }
}

