/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.TessellatorUtils;
import com.prupe.mcpatcher.TexturePackAPI;
import com.prupe.mcpatcher.TexturePackChangeHandler;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.src.Icon;
import net.minecraft.src.ResourceAddress;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TextureMap;
import net.minecraft.src.TextureStitched;

public class TileLoader {
    private static final MCLogger logger = MCLogger.getLogger("Tilesheet");
    private static final List<TileLoader> loaders = new ArrayList<TileLoader>();
    private static final ResourceAddress BLANK_RESOURCE = new ResourceAddress("mcpatcher/blank.png");
    private static final boolean debugTextures = Config.getBoolean("Connected Textures", "debugTextures", false);
    private static final int splitTextures = Config.getInt("Connected Textures", "splitTextures", 1);
    private static final Map<String, String> specialTextures = new HashMap<String, String>();
    private static final TexturePackChangeHandler changeHandler;
    private static boolean changeHandlerCalled;
    private static boolean registerIconsCalled;
    private static final Set<TextureMap> overflowMaps;
    private static final int OVERFLOW_TEXTURE_MAP_INDEX = 2;
    private static final long MAX_TILESHEET_SIZE;
    protected final String mapName;
    protected final boolean allowOverflow;
    protected final MCLogger subLogger;
    private int overflowIndex;
    private TextureMap baseTextureMap;
    private Map<String, TextureStitched> baseTexturesByName;
    private final Set<ResourceAddress> tilesToRegister = new HashSet<ResourceAddress>();
    private final Map<ResourceAddress, BufferedImage> tileImages = new HashMap<ResourceAddress, BufferedImage>();
    private final Map<String, Icon> iconMap = new HashMap<String, Icon>();

    public static void registerIcons(TextureMap textureMap, String mapName, Map<String, TextureStitched> map) {
        logger.fine("before registerIcons(%s) %d icons", mapName, map.size());
        registerIconsCalled = true;
        if (!changeHandlerCalled) {
            logger.severe("beforeChange was not called, invoking directly", new Object[0]);
            changeHandler.beforeChange();
        }
        TessellatorUtils.registerTextureMap(textureMap, mapName);
        for (TileLoader loader : loaders) {
            if (loader.baseTextureMap == null && mapName.equals(loader.mapName)) {
                loader.baseTextureMap = textureMap;
                loader.baseTexturesByName = map;
            }
            if (!loader.isForThisMap(mapName) || loader.tilesToRegister.isEmpty()) continue;
            loader.subLogger.fine("adding icons to %s (%d remaining)", mapName, loader.tilesToRegister.size(), mapName);
            while (!loader.tilesToRegister.isEmpty() && loader.registerOneIcon(textureMap, mapName, map)) {
            }
            loader.subLogger.fine("done adding icons to %s (%d remaining)", mapName, loader.tilesToRegister.size(), mapName);
        }
        logger.fine("after registerIcons(%s) %d icons", mapName, map.size());
    }

    public static String getOverridePath(String prefix, String name, String ext) {
        String path = name.endsWith(".png") ? name.replaceFirst("\\.[^.]+$", "") + ext : prefix + name + ext;
        logger.finer("getOverridePath(%s, %s, %s) -> %s", prefix, name, ext, path);
        return path;
    }

    public static boolean isSpecialTexture(TextureMap map, String texture, String special) {
        return special.equals(texture) || special.equals(specialTextures.get(texture));
    }

    public static BufferedImage getOverrideImage(ResourceAddress resource) throws IOException {
        BufferedImage image;
        for (TileLoader loader : loaders) {
            image = loader.tileImages.get(resource);
            if (image == null) continue;
            return image;
        }
        image = TexturePackAPI.getImage(resource);
        if (image == null) {
            throw new FileNotFoundException(resource + " not found");
        }
        return image;
    }

    public static void updateAnimations() {
        for (TextureMap textureMap : overflowMaps) {
            textureMap.updateAnimations();
        }
    }

    public static BufferedImage generateDebugTexture(String text, int width, int height, boolean alternate) {
        int charsPerRow;
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics graphics = image.getGraphics();
        graphics.setColor(alternate ? new Color(0, 255, 255, 128) : Color.WHITE);
        graphics.fillRect(0, 0, width, height);
        graphics.setColor(alternate ? Color.RED : Color.BLACK);
        int ypos = 10;
        if (alternate) {
            ypos += height / 2;
        }
        if ((charsPerRow = width / 8) <= 0) {
            return image;
        }
        while (text.length() % charsPerRow != 0) {
            text = text + " ";
        }
        while (ypos < height && !text.equals("")) {
            graphics.drawString(text.substring(0, charsPerRow), 1, ypos);
            ypos += graphics.getFont().getSize();
            text = text.substring(charsPerRow);
        }
        return image;
    }

    static void init() {
    }

    public static ResourceAddress getBlocksAtlas() {
        return TextureMap.blocksAtlas;
    }

    public static ResourceAddress getItemsAtlas() {
        return TextureMap.itemsAtlas;
    }

    public TileLoader(String mapName, boolean allowOverflow, MCLogger logger) {
        this.mapName = mapName;
        this.allowOverflow = allowOverflow;
        this.subLogger = logger;
        loaders.add(this);
    }

    private static long getTextureSize(TextureStitched texture) {
        return texture == null ? 0L : (long)(4 * texture.getWidth() * texture.getHeight());
    }

    private static long getTextureSize(Collection<TextureStitched> textures) {
        long size = 0L;
        for (TextureStitched texture : textures) {
            size += TileLoader.getTextureSize(texture);
        }
        return size;
    }

    public static ResourceAddress getDefaultAddress(ResourceAddress propertiesAddress) {
        return TexturePackAPI.transformResourceAddress(propertiesAddress, ".properties", ".png");
    }

    public static ResourceAddress parseTileAddress(ResourceAddress propertiesAddress, String value) {
        if (value == null) {
            return null;
        }
        if (value.equals("blank")) {
            return BLANK_RESOURCE;
        }
        if (value.equals("null") || value.equals("none") || value.equals("default") || value.equals("")) {
            return null;
        }
        if (!value.endsWith(".png")) {
            value = value + ".png";
        }
        if (!value.contains("/")) {
            value = propertiesAddress.getPath().replaceFirst("[^/]+$", "") + value;
        }
        return TexturePackAPI.parseResourceAddress(propertiesAddress, value);
    }

    public boolean preloadTile(ResourceAddress resource, boolean alternate, String special) {
        if (this.tileImages.containsKey(resource)) {
            return true;
        }
        BufferedImage image = null;
        if (!debugTextures && (image = TexturePackAPI.getImage(resource)) == null) {
            this.subLogger.warning("missing %s", resource);
        }
        if (image == null) {
            image = TileLoader.generateDebugTexture(resource.getPath(), 64, 64, alternate);
        }
        this.tilesToRegister.add(resource);
        this.tileImages.put(resource, image);
        if (special != null) {
            specialTextures.put(resource.getPath(), special);
        }
        return true;
    }

    public boolean preloadTile(ResourceAddress resource, boolean alternate) {
        return this.preloadTile(resource, alternate, null);
    }

    protected boolean isForThisMap(String mapName) {
        if (this.allowOverflow && splitTextures > 1) {
            return mapName.startsWith(this.mapName + "_overflow");
        }
        return mapName.startsWith(this.mapName);
    }

    private boolean registerDefaultIcon(String name) {
        String defaultName;
        TextureStitched texture;
        if (name.startsWith(this.mapName) && name.endsWith(".png") && this.baseTextureMap != null && (texture = this.baseTexturesByName.get(defaultName = name.substring(this.mapName.length()).replaceFirst("\\.png$", ""))) != null) {
            this.subLogger.finer("%s -> existing icon %s", name, defaultName);
            this.iconMap.put(name, (Icon)texture);
            return true;
        }
        return false;
    }

    private boolean registerOneIcon(TextureMap textureMap, String mapName, Map<String, TextureStitched> map) {
        ResourceAddress resource = this.tilesToRegister.iterator().next();
        String name = resource.getPath();
        if (this.registerDefaultIcon(name)) {
            this.tilesToRegister.remove(resource);
            return true;
        }
        BufferedImage image = this.tileImages.get(resource);
        if (image == null) {
            this.subLogger.error("tile for %s unexpectedly missing", resource);
            this.tilesToRegister.remove(resource);
            return true;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        long newSize = 4 * width * width;
        long currentSize = TileLoader.getTextureSize(map.values());
        if (newSize + currentSize > MAX_TILESHEET_SIZE) {
            float sizeMB = (float)currentSize / 1048576.0f;
            if (currentSize <= 0L) {
                this.subLogger.error("%s too big for any tilesheet (%.1fMB), dropping", name, Float.valueOf(sizeMB));
                this.tilesToRegister.remove(resource);
                return true;
            }
            this.subLogger.warning("%s nearly full (%.1fMB), will start a new tilesheet", mapName, Float.valueOf(sizeMB));
            return false;
        }
        Icon icon = textureMap.registerIcon(name);
        map.put(name, (TextureStitched)icon);
        if (mapName.contains("_overflow")) {
            TessellatorUtils.registerIcon(textureMap, icon);
        }
        this.iconMap.put(name, icon);
        String extra = width == height ? "" : ", " + height / width + " frames";
        this.subLogger.finer("%s -> %s icon %dx%d%s", name, mapName, width, width, extra);
        this.tilesToRegister.remove(resource);
        return true;
    }

    public void finish() {
        this.tilesToRegister.clear();
        this.tileImages.clear();
    }

    public Icon getIcon(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        Icon icon = this.iconMap.get(name);
        if (icon == null && this.baseTexturesByName != null) {
            icon = (Icon)this.baseTexturesByName.get(name);
        }
        return icon;
    }

    public boolean setDefaultTextureMap(Tessellator tessellator) {
        tessellator.textureMap = this.baseTextureMap;
        return this.baseTextureMap != null;
    }

    static {
        overflowMaps = new HashSet<TextureMap>();
        long maxSize = 4096L;
        try {
            maxSize = Minecraft.getMaxTextureSize();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        MAX_TILESHEET_SIZE = maxSize * maxSize * 4L * 7L / 8L;
        logger.config("max texture size is %dx%d (%.1fMB)", maxSize, maxSize, Float.valueOf((float)MAX_TILESHEET_SIZE / 1048576.0f));
        changeHandler = new TexturePackChangeHandler("Tilesheet API", 2){

            @Override
            public void initialize() {
            }

            @Override
            public void beforeChange() {
                changeHandlerCalled = true;
                TessellatorUtils.clear(Tessellator.instance);
                for (TextureMap textureMap : overflowMaps) {
                    try {
                        textureMap.unloadGLTexture();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                overflowMaps.clear();
                loaders.clear();
                specialTextures.clear();
            }

            @Override
            public void afterChange() {
                block0: while (true) {
                    for (TileLoader loader : loaders) {
                        if (loader.tilesToRegister.isEmpty()) continue;
                        if (loader.allowOverflow && splitTextures > 0) {
                            registerIconsCalled = false;
                            String mapName = loader.mapName + "_overflow" + ++loader.overflowIndex;
                            logger.fine("new TextureMap(%s)", mapName);
                            TextureMap map = new TextureMap(2, mapName);
                            map.refreshTextures1(TexturePackAPI.getResourceBundle());
                            if (!registerIconsCalled) {
                                logger.severe("TileLoader.registerIcons was never called!  Possible conflict in TextureMap.class", new Object[0]);
                                break block0;
                            }
                            overflowMaps.add(map);
                            continue;
                        }
                        loader.subLogger.warning("could not load all %s tiles (%d remaining)", loader.mapName, loader.tilesToRegister.size());
                        loader.tilesToRegister.clear();
                        continue block0;
                    }
                    break;
                }
                changeHandlerCalled = false;
            }

            @Override
            public void afterChange2() {
                for (TileLoader loader : loaders) {
                    loader.finish();
                }
            }
        };
        TexturePackChangeHandler.register(changeHandler);
    }
}

