/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.MCPatcherUtils;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.src.IResourceBundle;
import net.minecraft.src.IResourcePack;
import net.minecraft.src.ITexture;
import net.minecraft.src.ResourceAddress;
import net.minecraft.src.ResourceBundle;
import net.minecraft.src.ResourcePackBase;
import net.minecraft.src.ResourcePackDefault;
import net.minecraft.src.ResourcePackZip;
import net.minecraft.src.TextureBase;
import net.minecraft.src.TextureManager;
import net.minecraft.src.TextureMap;
import net.minecraft.src.TextureResourceBundle;
import net.minecraft.src.TextureWithData;
import org.lwjgl.opengl.GL11;

public class TexturePackAPI {
    private static final MCLogger logger = MCLogger.getLogger("Texture Pack");
    public static final String DEFAULT_NAMESPACE = "minecraft";
    public static final String MCPATCHER_SUBDIR = "mcpatcher/";
    public static TexturePackAPI instance = new TexturePackAPI();

    public static List<IResourcePack> getResourcePacks(String namespace) {
        ArrayList<IResourcePack> list = new ArrayList<IResourcePack>();
        IResourceBundle resourceBundle = TexturePackAPI.getResourceBundle();
        if (resourceBundle instanceof TextureResourceBundle) {
            for (Map.Entry entry : ((TextureResourceBundle)resourceBundle).namespaceMap.entrySet()) {
                if (namespace != null && !namespace.equals(entry.getKey())) continue;
                ResourceBundle bundle = (ResourceBundle)entry.getValue();
                list.addAll(bundle.resourcePacks);
            }
        }
        Collections.reverse(list);
        return list;
    }

    public static IResourceBundle getResourceBundle() {
        return Minecraft.getInstance().getResourceBundle();
    }

    public static boolean isDefaultTexturePack() {
        return TexturePackAPI.getResourcePacks(DEFAULT_NAMESPACE).size() <= 1;
    }

    public static InputStream getInputStream(ResourceAddress resource) {
        return resource == null ? null : instance.getInputStreamImpl(resource);
    }

    public static boolean hasResource(ResourceAddress resource) {
        if (resource == null) {
            return false;
        }
        if (resource.getPath().endsWith(".png")) {
            return TexturePackAPI.getImage(resource) != null;
        }
        if (resource.getPath().endsWith(".properties")) {
            return TexturePackAPI.getProperties(resource) != null;
        }
        InputStream is = TexturePackAPI.getInputStream(resource);
        MCPatcherUtils.close(is);
        return is != null;
    }

    public static BufferedImage getImage(ResourceAddress resource) {
        return resource == null ? null : instance.getImageImpl(resource);
    }

    public static Properties getProperties(ResourceAddress resource) {
        Properties properties = new Properties();
        if (TexturePackAPI.getProperties(resource, properties)) {
            return properties;
        }
        return null;
    }

    public static boolean getProperties(ResourceAddress resource, Properties properties) {
        return resource != null && instance.getPropertiesImpl(resource, properties);
    }

    public static ResourceAddress transformResourceAddress(ResourceAddress resource, String oldExt, String newExt) {
        return new ResourceAddress(resource.getNamespace(), resource.getPath().replaceFirst(Pattern.quote(oldExt) + "$", newExt));
    }

    public static ResourceAddress parseResourceAddress(ResourceAddress baseResource, String path) {
        int colon;
        if (path == null || path.equals("")) {
            return null;
        }
        if (path.startsWith("%blur%")) {
            path = path.substring(6);
        }
        if (path.startsWith("%clamp%")) {
            path = path.substring(7);
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((colon = path.indexOf(58)) >= 0) {
            return new ResourceAddress(path.substring(0, colon), path.substring(colon + 1));
        }
        if (path.startsWith("~/")) {
            return new ResourceAddress(baseResource.getNamespace(), MCPATCHER_SUBDIR + path.substring(2));
        }
        if (path.startsWith("./")) {
            return new ResourceAddress(baseResource.getNamespace(), baseResource.getPath().replaceFirst("[^/]+$", "") + path.substring(2));
        }
        return new ResourceAddress(baseResource.getNamespace(), path);
    }

    public static ResourceAddress newMCPatcherResourceAddress(String path) {
        return new ResourceAddress(MCPATCHER_SUBDIR + path);
    }

    public static List<ResourceAddress> listResources(String directory, String suffix, boolean recursive, boolean directories, boolean sortByFilename) {
        if (suffix == null) {
            suffix = "";
        }
        ArrayList<ResourceAddress> resources = new ArrayList<ResourceAddress>();
        TexturePackAPI.findResources(DEFAULT_NAMESPACE, directory, suffix, recursive, directories, resources);
        if (sortByFilename) {
            Collections.sort(resources, new Comparator<ResourceAddress>(){

                @Override
                public int compare(ResourceAddress o1, ResourceAddress o2) {
                    String f2;
                    String f1 = o1.getPath().replaceAll(".*/", "").replaceFirst("\\.properties", "");
                    int result = f1.compareTo(f2 = o2.getPath().replaceAll(".*/", "").replaceFirst("\\.properties", ""));
                    if (result != 0) {
                        return result;
                    }
                    return o1.getPath().compareTo(o2.getPath());
                }
            });
        } else {
            Collections.sort(resources, new Comparator<ResourceAddress>(){

                @Override
                public int compare(ResourceAddress o1, ResourceAddress o2) {
                    return o1.getPath().compareTo(o2.getPath());
                }
            });
        }
        return resources;
    }

    private static void findResources(String namespace, String directory, String suffix, boolean recursive, boolean directories, Collection<ResourceAddress> resources) {
        for (IResourcePack resourcePack : TexturePackAPI.getResourcePacks(namespace)) {
            File base;
            if (resourcePack instanceof ResourcePackZip) {
                ZipFile zipFile = ((ResourcePackZip)resourcePack).zipFile;
                if (zipFile == null) continue;
                TexturePackAPI.findResources(zipFile, namespace, "assets/" + namespace, directory, suffix, recursive, directories, resources);
                continue;
            }
            if (resourcePack instanceof ResourcePackDefault) {
                if (!DEFAULT_NAMESPACE.equals(namespace) || (base = ((ResourcePackDefault)resourcePack).file) == null || !base.isDirectory()) continue;
                TexturePackAPI.findResources(base, namespace, directory, suffix, recursive, directories, resources);
                continue;
            }
            if (!(resourcePack instanceof ResourcePackBase) || (base = ((ResourcePackBase)resourcePack).file) == null || !base.isDirectory() || !(base = new File(base, "assets/" + namespace)).isDirectory()) continue;
            TexturePackAPI.findResources(base, namespace, directory, suffix, recursive, directories, resources);
        }
    }

    private static void findResources(ZipFile zipFile, String namespace, String root, String directory, String suffix, boolean recursive, boolean directories, Collection<ResourceAddress> resources) {
        String base = root + "/" + directory;
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String name;
            if (zipEntry.isDirectory() != directories || !(name = zipEntry.getName().replaceFirst("^/", "")).startsWith(base) || !name.endsWith(suffix)) continue;
            if (directory.equals("")) {
                if (!recursive && name.contains("/")) continue;
                resources.add(new ResourceAddress(namespace, name));
                continue;
            }
            String subpath = name.substring(base.length());
            if (!subpath.equals("") && !subpath.startsWith("/") || !recursive && !subpath.equals("") && subpath.substring(1).contains("/")) continue;
            resources.add(new ResourceAddress(namespace, name.substring(root.length() + 1)));
        }
    }

    private static void findResources(File base, String namespace, String directory, String suffix, boolean recursive, boolean directories, Collection<ResourceAddress> resources) {
        File subdirectory = new File(base, directory);
        String[] list = subdirectory.list();
        if (list != null) {
            String pathComponent = directory.equals("") ? "" : directory + "/";
            for (String s : list) {
                File entry = new File(subdirectory, s);
                String resourceName = pathComponent + s;
                if (entry.isDirectory()) {
                    if (directories && s.endsWith(suffix)) {
                        resources.add(new ResourceAddress(namespace, resourceName));
                    }
                    if (!recursive) continue;
                    TexturePackAPI.findResources(base, namespace, pathComponent + s, suffix, recursive, directories, resources);
                    continue;
                }
                if (!s.endsWith(suffix) || directories) continue;
                resources.add(new ResourceAddress(namespace, resourceName));
            }
        }
    }

    public static int getTextureIfLoaded(ResourceAddress resource) {
        if (resource == null) {
            return -1;
        }
        ITexture texture = MCPatcherUtils.getMinecraft().getTextureManager().getTexture(resource);
        return texture instanceof TextureBase ? ((TextureBase)texture).glTextureId : -1;
    }

    public static boolean isTextureLoaded(ResourceAddress resource) {
        return TexturePackAPI.getTextureIfLoaded(resource) >= 0;
    }

    public static void bindTexture(ResourceAddress resource) {
        MCPatcherUtils.getMinecraft().getTextureManager().bindTexture(resource);
    }

    public static void bindTexture(int texture) {
        if (texture >= 0) {
            GL11.glBindTexture((int)3553, (int)texture);
        }
    }

    public static void unloadTexture(ResourceAddress resource) {
        TextureManager textureManager = MCPatcherUtils.getMinecraft().getTextureManager();
        ITexture texture = textureManager.getTexture(resource);
        if (texture != null && !(texture instanceof TextureMap) && !(texture instanceof TextureWithData)) {
            if (texture instanceof TextureBase) {
                ((TextureBase)texture).unloadGLTexture();
            }
            logger.finer("unloading texture %s", resource);
            textureManager.texturesByName.remove(resource);
        }
    }

    public static void deleteTexture(int texture) {
        if (texture >= 0) {
            GL11.glDeleteTextures((int)texture);
        }
    }

    protected InputStream getInputStreamImpl(ResourceAddress resource) {
        try {
            return Minecraft.getInstance().getResourceBundle().getResource(resource).getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BufferedImage getImageImpl(ResourceAddress resource) {
        InputStream input = TexturePackAPI.getInputStream(resource);
        BufferedImage image = null;
        if (input != null) {
            try {
                image = ImageIO.read(input);
            }
            catch (IOException e) {
                logger.error("could not read %s", resource);
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean getPropertiesImpl(ResourceAddress resource, Properties properties) {
        if (properties != null) {
            InputStream input = TexturePackAPI.getInputStream(resource);
            try {
                if (input != null) {
                    properties.load(input);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (IOException e) {
                logger.error("could not read %s", resource);
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return false;
    }
}

