/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.BaseMod;
import com.prupe.mcpatcher.BaseTexturePackMod;
import com.prupe.mcpatcher.BaseTilesheetMod;
import com.prupe.mcpatcher.ClassMap;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.ExternalMod;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MinecraftInstallation;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.mod.BetterGlass;
import com.prupe.mcpatcher.mod.BetterSkies;
import com.prupe.mcpatcher.mod.ConnectedTextures;
import com.prupe.mcpatcher.mod.CustomColors;
import com.prupe.mcpatcher.mod.CustomItemTextures;
import com.prupe.mcpatcher.mod.ExtendedHD;
import com.prupe.mcpatcher.mod.GLSLShader;
import com.prupe.mcpatcher.mod.RandomMobs;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class ModList {
    private final MinecraftVersion version;
    private final Map<String, BuiltInMod> builtInMods = new LinkedHashMap<String, BuiltInMod>();
    private final List<Mod> modsByIndex = new ArrayList<Mod>();
    private final Map<String, Mod> modsByName = new HashMap<String, Mod>();
    private boolean applied;

    ModList(MinecraftVersion version) {
        this.version = version;
        BaseTexturePackMod.clearEarlyInitializeMethods();
        this.register(new BuiltInMod("__Base", BaseMod.class).setInternal(true));
        this.register(new BuiltInMod("__TexturePackBase", BaseTexturePackMod.class).setInternal(true));
        this.register(new BuiltInMod("__TilesheetBase", BaseTilesheetMod.class).setInternal(true));
        this.register(new BuiltInMod("Extended HD", ExtendedHD.class));
        this.register(new BuiltInMod("Random Mobs", RandomMobs.class));
        this.register(new BuiltInMod("Custom Colors", CustomColors.class));
        this.register(new BuiltInMod("Connected Textures", ConnectedTextures.class));
        this.register(new BuiltInMod("Better Glass", BetterGlass.class));
        this.register(new BuiltInMod("Better Skies", BetterSkies.class));
        this.register(new BuiltInMod("Custom Item Textures", CustomItemTextures.class));
        this.register(new BuiltInMod("GLSL Shaders", GLSLShader.class).setExperimental(true));
        this.loadBuiltInMods(true);
    }

    private void register(BuiltInMod builtInMod) {
        this.builtInMods.put(builtInMod.name, builtInMod);
    }

    void close() {
        for (Mod mod : this.modsByIndex) {
            mod.close();
        }
    }

    void loadBuiltInMods(boolean internal) {
        for (BuiltInMod builtInMod : this.builtInMods.values()) {
            if (this.modsByName.containsKey(builtInMod.name) || !MCPatcher.experimentalMods && builtInMod.experimental || internal != builtInMod.internal) continue;
            this.addNoReplace(this.newModInstance(builtInMod));
        }
    }

    void loadCustomMods(File directory) {
        if (directory.isDirectory()) {
            for (File f : directory.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".jar");
                }
            })) {
                try {
                    this.loadCustomModsFromJar(f);
                }
                catch (Throwable e) {
                    Logger.log(0, "Error loading mods from %s", f.getPath());
                    Logger.log(e);
                }
            }
        }
    }

    private void loadCustomModsFromJar(File file) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Logger.log(0, "Opening %s", file.getPath());
        JarFile jar = new JarFile(file);
        URLClassLoader loader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
        for (JarEntry entry : Collections.list(jar.entries())) {
            Mod mod;
            if (entry.isDirectory() || !MinecraftInstallation.isClassFile(entry.getName()) || !this.addNoReplace(mod = this.loadCustomMod(loader, ClassMap.filenameToClassName(entry.getName())))) continue;
            Logger.log(1, "new %s()", mod.getClass().getName());
            mod.customJar = file;
        }
    }

    private Mod loadCustomMod(File file, String className) {
        try {
            URLClassLoader loader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
            return this.loadCustomMod(loader, className);
        }
        catch (Throwable e) {
            Logger.log(e);
            return null;
        }
    }

    private Mod loadCustomMod(URLClassLoader loader, String className) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        int flags;
        Class<?> cl = null;
        try {
            cl = loader.loadClass(className);
        }
        catch (NoClassDefFoundError e) {
            Logger.log(1, "WARNING: skipping %s: %s", className, e.toString());
        }
        if (cl != null && !cl.isInterface() && Mod.class.isAssignableFrom(cl) && !Modifier.isAbstract(flags = cl.getModifiers()) && Modifier.isPublic(flags)) {
            return this.newModInstance(cl.asSubclass(Mod.class));
        }
        return null;
    }

    List<Mod> getAll() {
        return this.modsByIndex;
    }

    List<Mod> getVisible() {
        ArrayList<Mod> visibleMods = new ArrayList<Mod>();
        for (Mod mod : this.modsByIndex) {
            if (mod.internal && !MCPatcher.showInternal) continue;
            visibleMods.add(mod);
        }
        return visibleMods;
    }

    ArrayList<Mod> getSelected() {
        ArrayList<Mod> list = new ArrayList<Mod>();
        for (Mod mod : this.modsByIndex) {
            if (!mod.okToApply() || !mod.isEnabled()) continue;
            list.add(mod);
        }
        return list;
    }

    HashMap<String, String> getReverseMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Mod mod : this.modsByIndex) {
            for (Map.Entry<String, String> entry : mod.getClassMap().getReverseClassMap().entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
        }
        return map;
    }

    Mod get(String name) {
        return this.modsByName.get(name);
    }

    Mod get(int index) {
        return this.modsByIndex.get(index);
    }

    int size() {
        return this.modsByIndex.size();
    }

    void enableValidMods(boolean enableAll) {
        for (int i = this.modsByIndex.size() - 1; i >= 0; --i) {
            Mod mod = this.modsByIndex.get(i);
            boolean enabled = mod.okToApply();
            if (enabled) {
                if (!enableAll) continue;
                this.selectMod(mod, true);
                continue;
            }
            this.selectMod(mod, false);
        }
    }

    void disableAll() {
        for (int i = this.modsByIndex.size() - 1; i >= 0; --i) {
            Mod mod = this.modsByIndex.get(i);
            this.selectMod(mod, false);
        }
    }

    boolean isApplied() {
        return this.applied;
    }

    void setApplied(boolean applied) {
        this.applied = applied;
    }

    void remove(Mod mod) {
        String name = mod.getName();
        for (int i = 0; i < this.modsByIndex.size(); ++i) {
            if (this.modsByIndex.get(i) != mod) continue;
            this.modsByIndex.remove(i);
            this.modsByName.remove(name);
        }
        mod.close();
    }

    int addFirst(Mod mod) {
        String name = mod.getName();
        Mod oldMod = this.modsByName.get(name);
        if (oldMod != null) {
            this.remove(oldMod);
        }
        this.modsByIndex.add(0, mod);
        this.modsByName.put(name, mod);
        return this.indexOfVisible(mod);
    }

    int addFirstBuiltin(Mod mod) {
        int i;
        String name = mod.getName();
        Mod oldMod = this.modsByName.get(name);
        if (oldMod != null) {
            this.remove(oldMod);
        }
        for (i = 0; i < this.modsByIndex.size() && ((oldMod = this.modsByIndex.get(i)) instanceof ExternalMod || this.indexOfVisible(oldMod) < 0); ++i) {
        }
        this.modsByIndex.add(i, mod);
        this.modsByName.put(name, mod);
        return this.indexOfVisible(mod);
    }

    int addLast(Mod mod) {
        String name = mod.getName();
        Mod oldMod = this.modsByName.get(name);
        if (oldMod != null) {
            this.remove(oldMod);
        }
        this.modsByIndex.add(mod);
        this.modsByName.put(name, mod);
        return this.indexOfVisible(mod);
    }

    int moveUp(int index, boolean toTop) {
        return this.move(index, -1, toTop);
    }

    int moveDown(int index, boolean toBottom) {
        return this.move(index, 1, toBottom);
    }

    private int move(int index, int direction, boolean allTheWay) {
        List<Mod> visibleMods = this.getVisible();
        int newIndex = !allTheWay ? index + direction : (direction < 0 ? 0 : visibleMods.size() - 1);
        if (index >= 0 && index < visibleMods.size() && newIndex >= 0 && newIndex < visibleMods.size() && newIndex != index) {
            List<Mod> mods = visibleMods.subList(Math.min(index, newIndex), Math.max(index, newIndex) + 1);
            block0: for (int i = 0; i < this.modsByIndex.size(); ++i) {
                for (int j = 0; j < mods.size(); ++j) {
                    if (this.modsByIndex.get(i) != mods.get(j)) continue;
                    this.modsByIndex.set(i, mods.get((j + direction + mods.size()) % mods.size()));
                    continue block0;
                }
            }
            index = newIndex;
        }
        return index;
    }

    int replace(Mod oldMod, Mod newMod) {
        int index = this.indexOf(oldMod);
        if (index >= 0 && oldMod.getName().equals(newMod.getName())) {
            this.modsByIndex.set(index, newMod);
            this.modsByName.put(newMod.getName(), newMod);
            oldMod.close();
            return this.indexOfVisible(newMod);
        }
        this.remove(oldMod);
        return this.addFirst(newMod);
    }

    private boolean addNoReplace(Mod mod) {
        if (mod == null) {
            return false;
        }
        String name = mod.getName();
        if (this.modsByName.containsKey(name)) {
            Logger.log(1, "WARNING: duplicate mod %s ignored", name);
            return false;
        }
        this.modsByName.put(name, mod);
        this.modsByIndex.add(mod);
        mod.setEnabled(mod.defaultEnabled);
        mod.loadOptions();
        return true;
    }

    int indexOf(Mod mod) {
        for (int i = 0; i < this.modsByIndex.size(); ++i) {
            if (mod != this.modsByIndex.get(i)) continue;
            return i;
        }
        return -1;
    }

    int indexOfVisible(Mod mod) {
        List<Mod> visible = this.getVisible();
        for (int i = 0; i < visible.size(); ++i) {
            if (mod != visible.get(i)) continue;
            return i;
        }
        return -1;
    }

    void selectMod(Mod mod, boolean enable) {
        HashMap<Mod, Boolean> changes = new HashMap<Mod, Boolean>();
        try {
            if (enable) {
                this.enableMod(changes, mod, false);
            } else {
                this.disableMod(changes, mod, false);
            }
        }
        catch (ModDependencyException e) {
            Logger.log(e);
        }
        for (Map.Entry entry : changes.entrySet()) {
            mod = (Mod)entry.getKey();
            mod.setEnabled((Boolean)entry.getValue());
        }
        this.refreshInternalMods();
    }

    void refreshInternalMods() {
        while (true) {
            for (int i = 0; i < this.modsByIndex.size() - 1; ++i) {
                Mod mod1 = this.modsByIndex.get(i);
                Mod mod = this.modsByIndex.get(i + 1);
                if (!mod1.internal || this.dependsOn(mod, mod1)) continue;
                this.modsByIndex.set(i, mod);
                this.modsByIndex.set(i + 1, mod1);
            }
            break;
        }
        if (!MCPatcher.showInternal) {
            for (Mod mod : this.modsByIndex) {
                if (!mod.internal) continue;
                mod.setEnabled(false);
            }
        }
        HashMap<Mod, Boolean> changes = new HashMap<Mod, Boolean>();
        for (Mod mod : this.modsByIndex) {
            try {
                if (mod.internal) continue;
                if (mod.isEnabled()) {
                    this.enableMod(changes, mod, false);
                    continue;
                }
                this.disableMod(changes, mod, false);
            }
            catch (ModDependencyException e) {
                Logger.log(e);
            }
        }
        for (Map.Entry entry : changes.entrySet()) {
            Mod mod = (Mod)entry.getKey();
            mod.setEnabled((Boolean)entry.getValue());
        }
    }

    private boolean dependsOn(Mod mod1, Mod mod2) {
        if (mod1 == null || mod2 == null) {
            return false;
        }
        if (mod1 == mod2) {
            return true;
        }
        for (Mod.Dependency dep : mod1.dependencies) {
            if (!dep.required || dep.name.equals(mod1.getName()) || !this.dependsOn(this.modsByName.get(dep.name), mod2)) continue;
            return true;
        }
        return false;
    }

    private void enableMod(HashMap<Mod, Boolean> inst, Mod mod, boolean recursive) throws ModDependencyException {
        if (mod == null) {
            return;
        }
        if (!mod.okToApply()) {
            throw new ModDependencyException(mod.getName() + " cannot be applied");
        }
        if (inst.containsKey(mod)) {
            if (!inst.get(mod).booleanValue()) {
                throw new ModDependencyException(mod.getName() + " is both conflicting and required");
            }
            return;
        }
        inst.put(mod, true);
        for (Mod.Dependency dep : mod.dependencies) {
            Mod dmod = this.modsByName.get(dep.name);
            if (dep.required) {
                if (dmod == null) {
                    throw new ModDependencyException("dependent mod " + dep.name + " not available");
                }
                this.enableMod(inst, dmod, true);
                continue;
            }
            this.disableMod(inst, dmod, true);
        }
        for (Mod dmod : this.modsByIndex) {
            if (dmod == mod) continue;
            for (Mod.Dependency dep : dmod.dependencies) {
                if (!dep.name.equals(mod.getName()) || dep.required) continue;
                this.disableMod(inst, dmod, true);
            }
        }
    }

    private void disableMod(HashMap<Mod, Boolean> inst, Mod mod, boolean recursive) throws ModDependencyException {
        if (mod == null) {
            return;
        }
        if (inst.containsKey(mod)) {
            if (inst.get(mod).booleanValue()) {
                throw new ModDependencyException(mod.getName() + " is both conflicting and required");
            }
            return;
        }
        inst.put(mod, false);
        for (Mod dmod : this.modsByIndex) {
            if (dmod == mod) continue;
            for (Mod.Dependency dep : dmod.dependencies) {
                if (!dep.name.equals(mod.getName()) || !dep.required) continue;
                this.disableMod(inst, dmod, true);
            }
        }
    }

    void loadSavedMods() {
        Config config = Config.instance;
        Element mods = config.getMods();
        if (mods == null) {
            return;
        }
        NodeList list = mods.getElementsByTagName("mod");
        ArrayList<Element> invalidEntries = new ArrayList<Element>();
        for (int i = 0; i < list.getLength(); ++i) {
            File file;
            String path;
            Element element = (Element)list.item(i);
            String name = config.getText(element, "name");
            String type = config.getText(element, "type");
            String enabled = config.getText(element, "enabled");
            Mod mod = null;
            if (name == null || type == null) {
                invalidEntries.add(element);
            } else if (type.equals("builtIn")) {
                BuiltInMod builtInMod = this.builtInMods.get(name);
                if (builtInMod != null && (MCPatcher.experimentalMods || !builtInMod.experimental)) {
                    mod = this.newModInstance(builtInMod);
                }
                if (mod == null) {
                    invalidEntries.add(element);
                }
            } else if (type.equals("externalZip")) {
                path = config.getText(element, "path");
                Element files = config.getElement(element, "files");
                if (path != null && files != null) {
                    file = new File(path);
                    if (file.isFile()) {
                        HashMap<String, String> fileMap = new HashMap<String, String>();
                        NodeList fileNodes = files.getElementsByTagName("file");
                        for (int j = 0; j < fileNodes.getLength(); ++j) {
                            Element fileElem = (Element)fileNodes.item(j);
                            String from = config.getText(fileElem, "from");
                            String to = config.getText(fileElem, "to");
                            if (from == null || to == null) continue;
                            fileMap.put(to, from);
                        }
                        try {
                            mod = new ExternalMod(new ZipFile(file), fileMap);
                        }
                        catch (IOException e) {
                            Logger.log(e);
                        }
                    }
                } else {
                    invalidEntries.add(element);
                }
            } else if (type.equals("externalJar")) {
                path = config.getText(element, "path");
                String className = config.getText(element, "class");
                if (path != null && className != null) {
                    file = new File(path);
                    if (file.exists() && (mod = this.loadCustomMod(file, className)) != null) {
                        mod.customJar = file;
                    }
                } else {
                    invalidEntries.add(element);
                }
            } else {
                invalidEntries.add(element);
            }
            if (mod == null || !this.addNoReplace(mod) || enabled == null) continue;
            mod.setEnabled(Boolean.parseBoolean(enabled));
        }
        for (Element element : invalidEntries) {
            mods.removeChild(element);
        }
        this.refreshInternalMods();
    }

    private void updateModElement(Mod mod, Element element) {
        Config config = Config.instance;
        if (mod instanceof ExternalMod) {
            ExternalMod extmod = (ExternalMod)mod;
            config.setText(element, "type", "externalZip");
            config.setText(element, "path", extmod.zipFile.getName());
            Element files = config.getElement(element, "files");
            while (files.hasChildNodes()) {
                files.removeChild(files.getFirstChild());
            }
            for (Map.Entry<String, String> entry : extmod.fileMap.entrySet()) {
                Element fileElem = config.xml.createElement("file");
                Element pathElem = config.xml.createElement("from");
                pathElem.appendChild(config.xml.createTextNode(entry.getValue()));
                fileElem.appendChild(pathElem);
                pathElem = config.xml.createElement("to");
                pathElem.appendChild(config.xml.createTextNode(entry.getKey()));
                fileElem.appendChild(pathElem);
                files.appendChild(fileElem);
            }
        } else if (mod.customJar == null) {
            config.setText(element, "type", "builtIn");
        } else {
            config.setText(element, "type", "externalJar");
            config.setText(element, "path", mod.customJar.getPath());
            config.setText(element, "class", mod.getClass().getCanonicalName());
        }
    }

    private Element defaultModElement(Mod mod) {
        Config config = Config.instance;
        Element mods = config.getMods();
        if (mods == null) {
            return null;
        }
        Element element = config.getMod(mod.getName());
        config.setText(element, "enabled", Boolean.toString(mod.defaultEnabled));
        this.updateModElement(mod, element);
        return element;
    }

    void updateProperties() {
        Config config = Config.instance;
        Element mods = config.getMods();
        if (mods == null) {
            return;
        }
        HashMap<String, Element> oldElements = new HashMap<String, Element>();
        while (mods.hasChildNodes()) {
            Element element;
            String name;
            Node node = mods.getFirstChild();
            if (node instanceof Element && (name = config.getText(element = (Element)node, "name")) != null) {
                oldElements.put(name, element);
            }
            mods.removeChild(node);
        }
        for (Mod mod : this.modsByIndex) {
            if (mod.internal) continue;
            Element element = (Element)oldElements.get(mod.getName());
            if (element == null) {
                this.defaultModElement(mod);
                continue;
            }
            config.setText(element, "enabled", Boolean.toString(mod.isEnabled() && mod.okToApply()));
            this.updateModElement(mod, element);
            mods.appendChild(element);
            oldElements.remove(mod.getName());
        }
    }

    private Mod newModInstance(Class<? extends Mod> modClass) {
        Mod mod;
        try {
            mod = modClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        try {
            boolean b;
            Method supportsVersion = modClass.getDeclaredMethod("supportsVersion", MinecraftVersion.class);
            if (supportsVersion.getReturnType() == Boolean.TYPE && Modifier.isStatic(supportsVersion.getModifiers()) && !(b = ((Boolean)supportsVersion.invoke(null, this.version)).booleanValue())) {
                return null;
            }
        }
        catch (NoSuchMethodException e) {
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        return mod;
    }

    private Mod newModInstance(BuiltInMod builtInMod) {
        Mod mod = this.newModInstance(builtInMod.modClass);
        if (mod != null) {
            mod.internal = builtInMod.internal;
            mod.experimental = builtInMod.experimental;
        }
        return mod;
    }

    private static class BuiltInMod {
        final String name;
        final Class<? extends Mod> modClass;
        boolean internal;
        boolean experimental;

        BuiltInMod(String name, Class<? extends Mod> modClass) {
            this.name = name;
            this.modClass = modClass;
        }

        BuiltInMod setInternal(boolean internal) {
            this.internal = internal;
            return this;
        }

        BuiltInMod setExperimental(boolean experimental) {
            this.experimental = experimental;
            return this;
        }
    }

    private class ModDependencyException
    extends Exception {
        ModDependencyException(String s) {
            super(s);
        }
    }
}

