/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MinecraftInstallation;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.Util;
import java.io.File;
import java.io.IOException;
import java.util.List;

class MinecraftInstallationV1
extends MinecraftInstallation {
    private final File binDir;

    MinecraftInstallationV1(File baseDir) {
        super(baseDir);
        this.binDir = new File(baseDir, "bin");
    }

    @Override
    boolean isPresent() {
        return false;
    }

    @Override
    boolean canHaveThisFile(File file) {
        try {
            return file.getParentFile().getName().equals("bin");
        }
        catch (Throwable e) {
            return false;
        }
    }

    @Override
    boolean prefersThisVersion(MinecraftVersion version) {
        return version.compareTo("1.5.2") <= 0;
    }

    @Override
    File getDefaultJarPathImpl() {
        return new File(this.binDir, "minecraft.jar");
    }

    @Override
    File getPatchedInstallation(MinecraftVersion version) {
        return this.getJarPathForVersionImpl(version);
    }

    @Override
    boolean deletePatchedInstallation(MinecraftVersion version) {
        return this.getPatchedInstallation(version).delete();
    }

    @Override
    MinecraftVersion getVersionFromFilename(File file) {
        MinecraftInstallation.Info info = new MinecraftInstallation.Info(file, null);
        return info.isOk() ? info.version : null;
    }

    @Override
    File getJarPathForVersionImpl(MinecraftVersion version) {
        return new File(this.binDir, "minecraft-" + version.getVersionString() + ".jar");
    }

    @Override
    MinecraftInstallation.MinecraftJar openMinecraftJarImpl(File file) throws IOException {
        return new MinecraftJarV1(file);
    }

    class MinecraftJarV1
    extends MinecraftInstallation.MinecraftJar {
        MinecraftJarV1(File file) throws IOException {
            MinecraftInstallation.Info outputInfo;
            super(MinecraftInstallationV1.this);
            MinecraftVersion version = MinecraftInstallationV1.this.getVersionFromFilename(file);
            MinecraftInstallation.Info tmpInfo = new MinecraftInstallation.Info(file, version);
            if (!tmpInfo.isOk()) {
                throw tmpInfo.exception;
            }
            version = tmpInfo.version;
            this.outputFile = this.getOutputJarPath(version);
            this.origFile = this.getInputJarPath(version);
            if (!this.origFile.exists()) {
                this.createBackup();
            }
            MinecraftInstallation.Info info = this.info = file.equals(this.origFile) ? tmpInfo : new MinecraftInstallation.Info(this.origFile, version);
            if (!this.info.isOk()) {
                throw this.info.exception;
            }
            MinecraftInstallation.Info info2 = outputInfo = file.equals(this.outputFile) ? tmpInfo : new MinecraftInstallation.Info(this.outputFile, version);
            if (!outputInfo.isOk()) {
                throw outputInfo.exception;
            }
            if (this.info.result == 3 && outputInfo.result == 5) {
                Logger.log(0, "copying unmodded %s over %s", this.outputFile.getName(), this.origFile.getName());
                this.origFile.delete();
                this.createBackup();
                this.info = outputInfo;
            }
        }

        @Override
        File getInputJarDirectory() {
            return MinecraftInstallationV1.this.binDir;
        }

        @Override
        File getOutputJarDirectory() {
            return MinecraftInstallationV1.this.binDir;
        }

        @Override
        File getInputJarPath(MinecraftVersion version) {
            return new File(MinecraftInstallationV1.this.binDir, "minecraft-" + version.getVersionString() + ".jar");
        }

        @Override
        File getOutputJarPath(MinecraftVersion version) {
            return new File(MinecraftInstallationV1.this.binDir, "minecraft.jar");
        }

        @Override
        File getNativesDirectory() {
            return new File(MinecraftInstallationV1.this.binDir, "natives");
        }

        @Override
        void addToClassPath(List<File> classPath) {
            classPath.add(new File(this.getInputJarDirectory(), "lwjgl.jar"));
            classPath.add(new File(this.getInputJarDirectory(), "lwjgl_util.jar"));
            classPath.add(new File(this.getInputJarDirectory(), "jinput.jar"));
        }

        @Override
        void addGameParams(List<String> params) {
        }

        @Override
        void createBackup() throws IOException {
            super.createBackup();
            if (this.outputFile.exists() && !this.origFile.exists()) {
                Util.copyFile(this.outputFile, this.origFile);
            }
        }
    }
}

