/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.MinecraftInstallationV1;
import com.prupe.mcpatcher.MinecraftInstallationV2;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.Util;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;

abstract class MinecraftInstallation {
    static MinecraftInstallation v1;
    static MinecraftInstallation v2;
    protected final File baseDir;

    static void setBaseDir(File baseDir) {
        v1 = new MinecraftInstallationV1(baseDir);
        v2 = new MinecraftInstallationV2(baseDir);
    }

    static MinecraftJar openMinecraftJar(File file) throws IOException {
        boolean haveV2;
        boolean v1Present = v1.isPresent();
        boolean v2Present = v2.isPresent();
        boolean haveV1 = v1Present && v1.canHaveThisFile(file);
        boolean bl = haveV2 = v2Present && v2.canHaveThisFile(file);
        if (haveV1 && !haveV2) {
            return v1.openMinecraftJarImpl(file);
        }
        if (!haveV1 && haveV2) {
            return v2.openMinecraftJarImpl(file);
        }
        if (v1Present || v2Present) {
            MinecraftVersion version = null;
            if (v1Present) {
                version = v1.getVersionFromFilename(file);
            }
            if (version == null && v2Present) {
                version = v2.getVersionFromFilename(file);
            }
            if (version != null) {
                if (v1Present && v1.prefersThisVersion(version)) {
                    return v1.openMinecraftJarImpl(file);
                }
                if (v2Present && v2.prefersThisVersion(version)) {
                    return v2.openMinecraftJarImpl(file);
                }
            }
        }
        return null;
    }

    static File getJarPathForVersion(String versionString) {
        File jar2;
        MinecraftVersion version = MinecraftVersion.parseVersion(versionString);
        if (version == null) {
            version = MinecraftVersion.parseShortVersion(versionString);
        }
        if (version == null) {
            return null;
        }
        File jar1 = v1.isPresent() ? v1.getJarPathForVersionImpl(version) : null;
        File file = jar2 = v2.isPresent() ? v2.getJarPathForVersionImpl(version) : null;
        if (jar1 != null && jar1.isFile() && jar2 != null && jar2.isFile()) {
            return v1.prefersThisVersion(version) ? jar1 : jar2;
        }
        if (jar1 != null && jar1.isFile()) {
            return jar1;
        }
        if (jar2 != null && jar2.isFile()) {
            return jar2;
        }
        return null;
    }

    static File getDefaultJarPath() {
        File jar;
        if (v2.isPresent() && (jar = v2.getDefaultJarPathImpl()) != null && jar.isFile()) {
            return jar;
        }
        if (v1.isPresent() && (jar = v1.getDefaultJarPathImpl()) != null && jar.isFile()) {
            return jar;
        }
        return MinecraftInstallation.v2.baseDir;
    }

    static File getDefaultJarDirectory() {
        File dir = MinecraftInstallation.getDefaultJarPath();
        return dir.isDirectory() ? dir : dir.getParentFile();
    }

    static boolean isGarbageFile(String filename) {
        return filename.startsWith("META-INF") || filename.startsWith("__MACOSX") || filename.endsWith(".DS_Store") || filename.equals("mod.properties");
    }

    static boolean isClassFile(String filename) {
        return filename.endsWith(".class") && !MinecraftInstallation.isGarbageFile(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDefaultTexturePack() {
        File output;
        File input;
        block10: {
            input = MCPatcherUtils.getMinecraftPath("options.txt");
            if (!input.exists()) {
                return;
            }
            output = MCPatcherUtils.getMinecraftPath("options.txt.tmp");
            BufferedReader br = null;
            PrintWriter pw = null;
            try {
                String line;
                br = new BufferedReader(new FileReader(input));
                pw = new PrintWriter(new FileWriter(output));
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("skin:")) {
                        line = "skin:Default";
                    }
                    pw.println(line);
                }
                MCPatcherUtils.close(br);
            }
            catch (IOException e) {
                Logger.log(e);
                break block10;
            }
            finally {
                MCPatcherUtils.close(br);
                MCPatcherUtils.close(pw);
            }
            MCPatcherUtils.close(pw);
        }
        try {
            Util.copyFile(output, input);
            output.delete();
        }
        catch (IOException e) {
            Logger.log(e);
        }
    }

    protected MinecraftInstallation(File baseDir) {
        this.baseDir = baseDir.getAbsoluteFile();
    }

    abstract boolean isPresent();

    abstract boolean canHaveThisFile(File var1);

    abstract boolean prefersThisVersion(MinecraftVersion var1);

    abstract File getDefaultJarPathImpl();

    abstract File getPatchedInstallation(MinecraftVersion var1);

    abstract boolean deletePatchedInstallation(MinecraftVersion var1);

    abstract MinecraftVersion getVersionFromFilename(File var1);

    abstract File getJarPathForVersionImpl(MinecraftVersion var1);

    abstract MinecraftJar openMinecraftJarImpl(File var1) throws IOException;

    abstract class MinecraftJar {
        protected File origFile;
        protected File outputFile;
        protected Info info;
        private JarFile origJar;
        private JarOutputStream outputJar;

        MinecraftJar() {
        }

        abstract File getInputJarDirectory();

        abstract File getOutputJarDirectory();

        abstract File getInputJarPath(MinecraftVersion var1);

        abstract File getOutputJarPath(MinecraftVersion var1);

        abstract File getNativesDirectory();

        abstract void addToClassPath(List<File> var1);

        abstract void addGameParams(List<String> var1);

        protected void finalize() throws Throwable {
            this.closeStreams();
            super.finalize();
        }

        MinecraftVersion getVersion() {
            return this.info.version;
        }

        boolean isModded() {
            return this.info.result == 3;
        }

        void logVersion() {
            Logger.log(0, "Minecraft version is %s (md5 %s)", this.info.version, this.info.md5);
            if (this.info.origMD5 == null) {
                Logger.log(0, "WARNING: could not determine original md5 sum", new Object[0]);
            } else if (this.info.result == 3) {
                Logger.log(0, "WARNING: possibly modded minecraft.jar (orig md5 %s)", this.info.origMD5);
            }
        }

        String getMainClass() {
            return this.getVersion().compareTo("13w16a") < 0 ? "net.minecraft.client.Minecraft" : "net.minecraft.client.main.Main";
        }

        void createBackup() throws IOException {
            this.closeStreams();
        }

        void restoreBackup() throws IOException {
            this.closeStreams();
            if (this.origFile.exists()) {
                Util.copyFile(this.origFile, this.outputFile);
            }
        }

        void setOutputFile(File file) {
            this.outputFile = file;
            this.closeStreams();
        }

        JarFile getInputJar() throws IOException {
            if (this.origJar == null) {
                this.origJar = new JarFile(this.origFile, false);
            }
            return this.origJar;
        }

        JarOutputStream getOutputJar() throws IOException {
            if (this.outputJar == null) {
                this.outputJar = new JarOutputStream(new FileOutputStream(this.outputFile));
            }
            return this.outputJar;
        }

        File getInputFile() {
            return this.origFile;
        }

        File getOutputFile() {
            return this.outputFile;
        }

        void writeProperties(Properties properties) throws IOException {
            block6: {
                switch (this.info.result) {
                    case 5: {
                        properties.setProperty("prePatchState", "unmodded");
                        break;
                    }
                    case 3: {
                        properties.setProperty("prePatchState", "modded");
                        break;
                    }
                }
                try {
                    this.outputJar.putNextEntry(new ZipEntry("mcpatcher.properties"));
                    properties.store(this.outputJar, null);
                }
                catch (IOException e) {
                    if (e.toString().contains("duplicate entry")) break block6;
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void checkOutput() throws Exception {
            this.closeStreams();
            JarFile jar = null;
            try {
                jar = new JarFile(this.outputFile);
            }
            catch (Throwable throwable) {
                MCPatcherUtils.close(jar);
                throw throwable;
            }
            MCPatcherUtils.close(jar);
        }

        void closeStreams() {
            MCPatcherUtils.close(this.origJar);
            MCPatcherUtils.close(this.outputJar);
            this.origJar = null;
            this.outputJar = null;
        }

        void run() {
            int directSize;
            File file = this.getOutputFile();
            StringBuilder sb = new StringBuilder();
            ArrayList<File> classPath = new ArrayList<File>();
            this.addToClassPath(classPath);
            classPath.add(this.outputFile);
            for (File f : classPath) {
                sb.append(f.getPath()).append(File.pathSeparatorChar);
            }
            ArrayList<String> params = new ArrayList<String>();
            params.add("java");
            params.add("-cp");
            params.add(sb.toString());
            params.add("-Djava.library.path=" + this.getNativesDirectory().getPath());
            int heapSize = Config.getInt("javaHeapSize", 1024);
            if (heapSize > 0) {
                params.add("-Xmx" + heapSize + "M");
                params.add("-Xms" + Math.min(heapSize, 512) + "M");
            }
            if ((directSize = Config.getInt("directMemorySize", 0)) > 0) {
                params.add("-XX:MaxDirectMemorySize=" + directSize + "M");
            }
            params.add(this.getMainClass());
            this.addGameParams(params);
            ProcessBuilder pb = new ProcessBuilder(params.toArray(new String[params.size()]));
            pb.redirectErrorStream(true);
            pb.directory(MCPatcherUtils.getMinecraftPath(new String[0]));
            Logger.log(0);
            Logger.log(0, "Launching %s", file.getPath());
            sb = new StringBuilder();
            for (String s : pb.command()) {
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                if (s.contains(" ")) {
                    sb.append('\"');
                    sb.append(s);
                    sb.append('\"');
                    continue;
                }
                sb.append(s);
            }
            Logger.log(0, "%s", sb.toString());
            try {
                Process p = pb.start();
                if (p != null) {
                    String line;
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    Pattern stackDump = Pattern.compile("^\tat ([a-z]+)\\.\\w+\\(\\S+:\\d+\\)$");
                    HashMap<String, String> reverseMap = MCPatcher.modList.getReverseMap();
                    while ((line = input.readLine()) != null) {
                        String obfName;
                        String deobfName;
                        MCPatcher.checkInterrupt();
                        Matcher matcher = stackDump.matcher(line);
                        if (matcher.find() && (deobfName = reverseMap.get(obfName = matcher.group(1))) != null && !deobfName.equals(obfName)) {
                            line = line + " [" + deobfName + "]";
                        }
                        Logger.log(0, "%s", line);
                    }
                    p.waitFor();
                    if (p.exitValue() != 0) {
                        Logger.log(0, "Minecraft exited with status %d", p.exitValue());
                    }
                }
            }
            catch (InterruptedException e) {
            }
            catch (IOException e) {
                Logger.log(e);
            }
        }
    }

    static class Info {
        static final int MISSING_JAR = 0;
        static final int IO_ERROR = 1;
        static final int CORRUPT_JAR = 2;
        static final int MODDED_JAR = 3;
        static final int MODDED_OR_UNMODDED_JAR = 4;
        static final int UNMODDED_JAR = 5;
        MinecraftVersion version;
        String md5;
        String origMD5;
        final int result;
        IOException exception;

        Info(File minecraftJar, MinecraftVersion version) {
            this.version = version;
            this.result = this.initialize(minecraftJar);
            if (!this.isOk() && this.exception == null) {
                this.exception = new IOException("unexpected error opening " + minecraftJar.getPath());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int initialize(File minecraftJar) {
            int n;
            JarFile jar;
            block19: {
                boolean havePatcherProperties;
                boolean haveMetaInf;
                block21: {
                    block20: {
                        if (!minecraftJar.exists()) {
                            this.exception = new FileNotFoundException(minecraftJar.getPath() + " does not exist");
                            return 0;
                        }
                        this.md5 = Util.computeMD5(minecraftJar);
                        if (this.md5 == null) {
                            this.exception = new IOException("could not open " + minecraftJar.getPath());
                            return 1;
                        }
                        haveMetaInf = false;
                        havePatcherProperties = false;
                        jar = null;
                        try {
                            HashSet<String> entries = new HashSet<String>();
                            jar = new JarFile(minecraftJar);
                            for (JarEntry entry : Collections.list(jar.entries())) {
                                String name = entry.getName();
                                if (entries.contains(name)) {
                                    this.exception = new ZipException("duplicate zip entry " + name);
                                    n = 2;
                                    break block19;
                                }
                                if (name.startsWith("META-INF")) {
                                    haveMetaInf = true;
                                } else if (name.equals("mcpatcher.properties")) {
                                    havePatcherProperties = true;
                                }
                                entries.add(name);
                            }
                            if (this.version != null) break block20;
                            this.version = Info.extractVersion(jar, this.md5);
                        }
                        catch (ZipException e) {
                            this.exception = e;
                            int n2 = 2;
                            {
                                catch (Throwable throwable) {
                                    MCPatcherUtils.close(jar);
                                    throw throwable;
                                }
                            }
                            MCPatcherUtils.close(jar);
                            return n2;
                            catch (IOException e2) {
                                this.exception = e2;
                                int n3 = 1;
                                MCPatcherUtils.close(jar);
                                return n3;
                            }
                        }
                    }
                    MCPatcherUtils.close(jar);
                    if (this.version != null) break block21;
                    this.exception = new JarException("Could not determine version of " + minecraftJar.getPath());
                    return 2;
                }
                this.origMD5 = Info.getOrigMD5(minecraftJar.getParentFile(), this.version);
                if (!haveMetaInf || havePatcherProperties) {
                    return 3;
                }
                if (this.origMD5 == null) {
                    return 4;
                }
                if (MinecraftVersion.isKnownMD5(this.md5)) {
                    return 5;
                }
                if (this.version.isNewerThanAnyKnownVersion()) {
                    return 4;
                }
                if (this.origMD5.equals(this.md5)) {
                    return 5;
                }
                return 4;
            }
            MCPatcherUtils.close(jar);
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static MinecraftVersion extractVersion(File file, String md5) {
            MinecraftVersion minecraftVersion;
            if (!file.exists()) {
                return null;
            }
            JarFile jar = null;
            try {
                jar = new JarFile(file);
                minecraftVersion = Info.extractVersion(jar, md5);
            }
            catch (Exception e) {
                try {
                    Logger.log(e);
                }
                catch (Throwable throwable) {
                    MCPatcherUtils.close(jar);
                    throw throwable;
                }
                MCPatcherUtils.close(jar);
                return null;
            }
            MCPatcherUtils.close(jar);
            return minecraftVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MinecraftVersion extractVersion(JarFile jar, String md5) {
            MinecraftVersion version = Info.extractVersion(jar);
            if (version != null) {
                return version;
            }
            InputStream inputStream = null;
            try {
                ZipEntry entry = jar.getEntry("net/minecraft/client/Minecraft.class");
                if (entry == null) {
                    MinecraftVersion minecraftVersion = null;
                    return minecraftVersion;
                }
                inputStream = jar.getInputStream(entry);
                ClassFile classFile = new ClassFile(new DataInputStream(inputStream));
                ConstPool constPool = classFile.getConstPool();
                for (int i = 1; i < constPool.getSize(); ++i) {
                    String value;
                    if (constPool.getTag(i) != 8 || (version = MinecraftVersion.parseVersion(value = constPool.getStringInfo(i))) == null) continue;
                    version = version.getOverrideVersion(md5);
                    break;
                }
                MCPatcherUtils.close(inputStream);
            }
            catch (IOException e) {
                Logger.log(e);
            }
            finally {
                MCPatcherUtils.close(inputStream);
            }
            return version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static MinecraftVersion extractVersion(JarFile jar) {
            MinecraftVersion version = null;
            InputStream inputStream = null;
            try {
                ZipEntry entry = jar.getEntry("mcpatcher.properties");
                if (entry != null) {
                    inputStream = jar.getInputStream(entry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String value = properties.getProperty("minecraftVersion", "");
                    if (!value.equals("")) {
                        MinecraftVersion minecraftVersion = MinecraftVersion.parseShortVersion(value);
                        MCPatcherUtils.close(inputStream);
                        return minecraftVersion;
                    }
                }
                MCPatcherUtils.close(inputStream);
            }
            catch (IOException e) {
                Logger.log(e);
            }
            finally {
                MCPatcherUtils.close(inputStream);
            }
            return version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static String getOrigMD5(File binDir, MinecraftVersion version) {
            String md5 = MinecraftVersion.knownMD5s.get(version.getVersionString());
            if (md5 != null) {
                return md5;
            }
            File md5File = new File(binDir, "md5s");
            if (!version.isPrerelease() && md5File.exists()) {
                FileInputStream inputStream = null;
                try {
                    Properties properties = new Properties();
                    inputStream = new FileInputStream(md5File);
                    properties.load(inputStream);
                    String string = properties.getProperty("minecraft.jar");
                    MCPatcherUtils.close(inputStream);
                    return string;
                }
                catch (IOException e) {
                    Logger.log(e);
                }
                finally {
                    MCPatcherUtils.close(inputStream);
                }
            }
            return null;
        }

        boolean isOk() {
            return this.result > 2;
        }
    }
}

