/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.ClassMap;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.JavaRef;
import com.prupe.mcpatcher.Logger;
import java.util.List;
import javassist.bytecode.ClassFile;

public abstract class MemberMapper {
    protected final JavaRef[] refs;
    protected String descriptor;
    private int mapSuperclass;
    int mapInterface = -1;
    private int setAccessFlags;
    private int clearAccessFlags;
    private int count;
    protected final ClassMod classMod;

    MemberMapper(ClassMod classMod, JavaRef ... refs) {
        this.classMod = classMod;
        this.refs = (JavaRef[])refs.clone();
        for (JavaRef ref : refs) {
            if (ref == null || ref.getType() == null) continue;
            return;
        }
        throw new RuntimeException("refs list has no descriptor");
    }

    public MemberMapper accessFlag(int flags, boolean set) {
        if (set) {
            this.setAccessFlags |= flags;
        } else {
            this.clearAccessFlags |= flags;
        }
        return this;
    }

    public MemberMapper mapToSuperclass(int ancestry) {
        if (ancestry > 1) {
            throw new IllegalArgumentException("ancestry " + ancestry + " is not supported");
        }
        this.mapSuperclass = ancestry;
        return this;
    }

    void mapDescriptor(ClassMap classMap) {
        this.count = 0;
        for (JavaRef ref : this.refs) {
            if (ref == null || ref.getType() == null) continue;
            this.descriptor = classMap.mapTypeString(ref.getType());
            return;
        }
    }

    boolean matchInfo(String descriptor, int flags) {
        return descriptor.equals(this.descriptor) && (flags & this.setAccessFlags) == this.setAccessFlags && (flags & this.clearAccessFlags) == 0;
    }

    JavaRef getRef() {
        return this.count < this.refs.length ? this.refs[this.count] : null;
    }

    String getClassName() {
        JavaRef ref = this.getRef();
        if (ref == null) {
            return null;
        }
        if (ref.getClassName() == null || ref.getClassName().equals("")) {
            return this.classMod.getDeobfClass();
        }
        return ref.getClassName();
    }

    String getName() {
        JavaRef ref = this.getRef();
        return ref == null ? null : ref.getName();
    }

    void afterMatch() {
        ++this.count;
    }

    boolean allMatched() {
        return this.count >= this.refs.length;
    }

    protected abstract String getMapperType();

    protected abstract List getMatchingObjects(ClassFile var1);

    protected abstract boolean match(Object var1);

    protected abstract JavaRef getObfRef(String var1, Object var2);

    protected abstract String[] describeMatch(Object var1);

    protected void updateClassMap(ClassMap classMap, ClassFile classFile, Object o) {
        JavaRef ref = this.getRef();
        if (ref != null) {
            String prefix;
            String obfClassName;
            if (this.mapSuperclass == 1) {
                obfClassName = classFile.getSuperclass();
                prefix = this.getClassName() + '.';
            } else if (this.mapInterface >= 0) {
                obfClassName = classFile.getInterfaces()[this.mapInterface];
                prefix = this.getClassName() + '.';
            } else {
                obfClassName = classFile.getName();
                prefix = "";
            }
            JavaRef obfRef = this.getObfRef(obfClassName, o);
            String[] s = this.describeMatch(o);
            Logger.log(3, "%s %s matches %s%s %s", this.getMapperType(), ref.getName(), prefix, s[0], s[1]);
            classMap.addMap(ref, obfRef);
        }
    }
}

